/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.CE_StdPane;
import com.sun.javatest.tool.FileChooser;
import com.sun.javatest.tool.TestTreeSelectionPane;
import com.sun.javatest.tool.UIFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class CE_TestsPane
extends CE_StdPane {
    private Parameters.TestsParameters testsParameters;
    private Parameters.MutableTestsParameters mutableTestsParameters;
    private ButtonGroup btnGrp;
    private JRadioButton allTestsBtn;
    private JRadioButton selectTestsBtn;
    private TestTreeSelectionPane testsField;
    private JButton loadBtn;
    private FileChooser chooser;

    CE_TestsPane(UIFactory uIFactory, InterviewParameters interviewParameters) {
        super(uIFactory, interviewParameters, "tests");
        this.updateConfig();
        this.initGUI();
    }

    boolean isOKToClose() {
        if (this.mutableTestsParameters == null) {
            return true;
        }
        if (this.selectTestsBtn.isSelected() && this.testsField.isSelectionEmpty()) {
            this.uif.showError("ce.tests.noTests");
            return false;
        }
        return true;
    }

    void updateConfig() {
        this.testsParameters = this.config.getTestsParameters();
        this.mutableTestsParameters = this.testsParameters instanceof Parameters.MutableTestsParameters ? (Parameters.MutableTestsParameters)this.testsParameters : null;
    }

    void load() {
        this.updateConfig();
        if (this.mutableTestsParameters != null) {
            int n = this.mutableTestsParameters.getTestsMode();
            if (n == 1) {
                this.allTestsBtn.setSelected(true);
            } else {
                this.selectTestsBtn.setSelected(true);
            }
            this.testsField.setSelection(this.mutableTestsParameters.getSpecifiedTests());
            this.testsField.setEnabled(this.selectTestsBtn.isSelected());
        } else {
            this.mutableTestsParameters = null;
            String[] stringArray = this.testsParameters.getTests();
            if (stringArray == null || stringArray.length == 0) {
                this.allTestsBtn.setSelected(true);
                this.testsField.clear();
            } else {
                this.selectTestsBtn.setSelected(true);
                this.testsField.setSelection(stringArray);
            }
            this.allTestsBtn.setEnabled(false);
            this.selectTestsBtn.setEnabled(false);
            this.testsField.setEnabled(false);
        }
    }

    void save() {
        if (this.mutableTestsParameters != null) {
            if (this.allTestsBtn.isSelected()) {
                this.mutableTestsParameters.setTestsMode(1);
            } else if (this.selectTestsBtn.isSelected()) {
                this.mutableTestsParameters.setTestsMode(2);
            }
            this.mutableTestsParameters.setSpecifiedTests(this.testsField.getSelection());
        }
    }

    private void initGUI() {
        CSH.setHelpIDString(this, "confEdit.testsTab.csh");
        JPanel jPanel = this.uif.createPanel("ce.tests", new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.btnGrp = new ButtonGroup();
        this.allTestsBtn = this.uif.createRadioButton("ce.tests.all", this.btnGrp);
        jPanel.add((Component)this.allTestsBtn, gridBagConstraints);
        this.selectTestsBtn = this.uif.createRadioButton("ce.tests.select", this.btnGrp);
        this.selectTestsBtn.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = CE_TestsPane.this.selectTestsBtn.isSelected();
                CE_TestsPane.this.testsField.setEnabled(bl);
                CE_TestsPane.this.loadBtn.setEnabled(bl);
            }
        });
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.selectTestsBtn, gridBagConstraints);
        this.testsField = new TestTreeSelectionPane(this.config.getWorkDirectory().getTestResultTable());
        this.testsField.setEnabled(this.selectTestsBtn.isSelected());
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.testsField, gridBagConstraints);
        this.loadBtn = this.uif.createButton("ce.tests.load", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CE_TestsPane.this.selectFromFile();
            }
        });
        this.loadBtn.setEnabled(this.selectTestsBtn.isSelected());
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.loadBtn, gridBagConstraints);
        this.addBody(jPanel);
    }

    private void selectFromFile() {
        int n;
        CharSequence charSequence;
        int n2;
        if (this.chooser == null) {
            this.chooser = new FileChooser();
        }
        if ((n2 = this.chooser.showDialog(this, this.chooser.getApproveButtonText())) != 0) {
            return;
        }
        WorkDirectory workDirectory = this.config.getWorkDirectory();
        TestResultTable testResultTable = workDirectory.getTestResultTable();
        File file = this.chooser.getSelectedFile();
        Vector<CharSequence> vector = new Vector<CharSequence>();
        Vector<CharSequence> vector2 = new Vector<CharSequence>();
        HashSet<CharSequence> hashSet = new HashSet<CharSequence>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((charSequence = bufferedReader.readLine()) != null) {
                CharSequence charSequence2;
                if (((String)(charSequence = ((String)charSequence).trim())).length() == 0 || ((String)charSequence).startsWith("#") || hashSet.contains(charSequence2 = (n = ((String)charSequence).indexOf(32)) == -1 ? charSequence : ((String)charSequence).substring(0, n))) continue;
                if (testResultTable.validatePath((String)charSequence2)) {
                    vector.add(charSequence2);
                } else {
                    vector2.add(charSequence2);
                }
                hashSet.add(charSequence2);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.uif.showError("ce.tests.cantFindFile", file.toString());
            return;
        }
        catch (IOException iOException) {
            this.uif.showError("ce.tests.cantReadFile", new Object[]{file, iOException.toString()});
            return;
        }
        if (vector2.size() > 0) {
            if (vector2.size() == 1) {
                this.uif.showError("ce.tests.badPath", vector2.get(0));
            } else {
                charSequence = new StringBuffer();
                for (n = 0; n < Math.min(vector2.size(), 10); ++n) {
                    if (((StringBuffer)charSequence).length() > 0) {
                        ((StringBuffer)charSequence).append('\n');
                    }
                    ((StringBuffer)charSequence).append(vector2.get(n));
                }
                n = vector2.size() > 10 ? 1 : 0;
                this.uif.showError("ce.tests.badPaths", new Object[]{((StringBuffer)charSequence).toString(), new Integer(n != 0 ? 1 : 0)});
            }
        }
        this.testsField.setSelection(vector.toArray(new String[vector.size()]));
    }
}

