/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.exec.BranchPanel;
import com.sun.javatest.exec.ElapsedTimeMonitor;
import com.sun.javatest.exec.Monitor;
import com.sun.javatest.exec.MonitorState;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.EventQueue;
import javax.accessibility.AccessibleContext;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextField;

class ElapsedTimeMonitor
extends Monitor
implements MonitorState.Observer {
    private SmallTimer smTimer;
    private ThreadGroup activeThreads = new ThreadGroup("elapsed time monitors");
    private boolean isRunning;
    private static I18NResourceBundle i18n;
    static /* synthetic */ Class class$com$sun$javatest$exec$ElapsedTimeMonitor;

    ElapsedTimeMonitor(MonitorState monitorState, UIFactory uIFactory) {
        super(monitorState, uIFactory);
        monitorState.addObserver(this);
    }

    public String getSmallMonitorName() {
        return this.uif.getI18NString("et.sm.Name");
    }

    public Icon getSmallMonitorIcon() {
        return null;
    }

    public JComponent getSmallMonitor() {
        if (this.smTimer == null) {
            this.smTimer = new SmallTimer(this.uif, this.state);
        }
        if (this.isRunning) {
            this.smTimer.start();
        } else {
            this.smTimer.update();
        }
        return this.smTimer;
    }

    public String getLargeMonitorName() {
        return this.uif.getI18NString("et.lg.Name");
    }

    public Icon getLargeMonitorIcon() {
        return null;
    }

    public JComponent getLargeMonitor() {
        return null;
    }

    public void starting() {
        this.isRunning = true;
        if (this.smTimer != null) {
            this.smTimer.start();
        }
    }

    public void postProcessing() {
        if (this.smTimer != null) {
            this.smTimer.stop();
        }
    }

    public void stopping() {
    }

    public void finished(boolean bl) {
        this.isRunning = false;
        this.stopAll();
    }

    private void stopAll() {
        if (this.smTimer != null) {
            this.smTimer.stop();
        }
    }

    static final String millisToString(long l) {
        if (i18n == null) {
            i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$exec$ElapsedTimeMonitor == null ? (class$com$sun$javatest$exec$ElapsedTimeMonitor = ElapsedTimeMonitor.class$("com.sun.javatest.exec.ElapsedTimeMonitor")) : class$com$sun$javatest$exec$ElapsedTimeMonitor);
        }
        int n = (int)(l / 1000L % 60L);
        int n2 = (int)(l / 60000L % 60L);
        int n3 = (int)(l / 3600000L);
        String string = n3 < 10 ? "0" + Integer.toString(n3) : Integer.toString(n3);
        String string2 = n2 < 10 ? "0" + Integer.toString(n2) : Integer.toString(n2);
        String string3 = n < 10 ? "0" + Integer.toString(n) : Integer.toString(n);
        Object[] objectArray = new String[]{string, string2, string3};
        return i18n.getString("etm.hms", objectArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class SmallTimer
    extends JTextField {
        private String prefix;
        private MonitorState state;
        private UIFactory uif;
        private volatile Thread myThread;

        SmallTimer(UIFactory uIFactory, MonitorState monitorState) {
            super("et.sm");
            this.state = monitorState;
            this.uif = uIFactory;
            this.setHorizontalAlignment(2);
            this.setOpaque(false);
            this.setEnabled(true);
            this.setVisible(true);
            this.setEditable(false);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setText("00:00:00");
            uIFactory.setToolTip(this, "et.sm");
            AccessibleContext accessibleContext = this.getAccessibleContext();
            accessibleContext.setAccessibleName(uIFactory.getI18NString("et.sm.name"));
            CSH.setHelpIDString(this, "run.testProgress");
            this.update();
        }

        public void start() {
            this.myThread = new Thread(this){
                private final /* synthetic */ SmallTimer this$0;
                {
                    this.this$0 = smallTimer;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (SmallTimer.access$100(this.this$0) == 1.currentThread()) {
                        try {
                            Thread thread = SmallTimer.access$100(this.this$0);
                            synchronized (thread) {
                                SmallTimer.access$100(this.this$0).wait(1000L);
                                SmallTimer.access$000(this.this$0);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    SmallTimer.access$000(this.this$0);
                }
            };
            this.myThread.setPriority(4);
            this.myThread.start();
        }

        public void stop() {
            this.myThread = null;
        }

        private void update() {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new BranchPanel.TextUpdater(this, ElapsedTimeMonitor.millisToString(this.state.getElapsedTime()), this.uif));
            } else {
                this.setText(ElapsedTimeMonitor.millisToString(this.state.getElapsedTime()));
            }
        }

        static /* synthetic */ Thread access$100(SmallTimer smallTimer) {
            return smallTimer.myThread;
        }
    }
}

