/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.javatest.ExcludeList;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

class ExcludeListBrowser
extends ToolDialog {
    private InterviewParameters params;
    private File[] files;
    private ExcludeList list;
    private ExcludeListTableModel model;
    private JTable table;
    private JTextField synopsisField;
    private JTextField kwField;
    private JTextField bugIdsField;
    private Listener listener;
    private static final int TEST_NAME_COL = 0;
    private static final int TEST_CASE_COL = 1;
    private static final int BUG_COL = 2;
    private static final int KEYWORDS_COL = 3;
    private static final int SYNOPSIS_COL = 4;
    private static final int COLUMN_COUNT = 5;
    private String[] columnNames;
    static /* synthetic */ Class class$java$lang$String;

    ExcludeListBrowser(Container container, UIFactory uIFactory) {
        super(container, uIFactory, "elb");
        this.params = this.params;
        this.listener = new Listener();
    }

    public void show(InterviewParameters interviewParameters) {
        this.params = interviewParameters;
        this.setVisible(true);
    }

    private void updateContent() {
        ExcludeList excludeList = this.params.getExcludeList();
        Parameters.ExcludeListParameters excludeListParameters = this.params.getExcludeListParameters();
        File[] fileArray = excludeListParameters instanceof Parameters.MutableExcludeListParameters ? ((Parameters.MutableExcludeListParameters)excludeListParameters).getExcludeFiles() : null;
        if (this.list != excludeList || this.files != fileArray) {
            this.setTable(fileArray, excludeList);
        }
    }

    private void setTable(File[] fileArray, ExcludeList excludeList) {
        this.list = excludeList;
        this.files = fileArray;
        this.model = new ExcludeListTableModel(excludeList);
        this.table.setModel(this.model);
        if (fileArray == null || fileArray.length == 0) {
            this.setI18NTitle("elb.title0");
        } else if (fileArray.length == 1) {
            this.setI18NTitle("elb.title1", fileArray[0].getPath());
        } else {
            this.setI18NTitle("elb.titlen", new Integer(fileArray.length));
        }
    }

    protected void initGUI() {
        this.setHelp("exclList.window.csh");
        JPanel jPanel = this.uif.createPanel("elb.body", new GridBagLayout(), false);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        int n = this.uif.getDotsPerInch();
        jPanel.setPreferredSize(new Dimension(5 * n, 2 * n));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.bottom = 5;
        this.table = new JTable();
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ExcludeListBrowser.this.showSelectedEntry();
            }
        });
        this.uif.setAccessibleInfo(this.table, "elb.tbl");
        this.uif.setToolTip(this.table, "elb.tbl");
        jPanel.add((Component)new JScrollPane(this.table), gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets.top = 2;
        gridBagConstraints2.insets.right = 5;
        gridBagConstraints2.anchor = 13;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.insets.top = 2;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.fill = 2;
        JLabel jLabel = this.uif.createLabel("elb.synopsis", true);
        jPanel.add((Component)jLabel, gridBagConstraints2);
        this.synopsisField = this.uif.createOutputField("elb.synopsis", jLabel);
        jPanel.add((Component)this.synopsisField, gridBagConstraints3);
        JLabel jLabel2 = this.uif.createLabel("elb.kws", true);
        jPanel.add((Component)jLabel2, gridBagConstraints2);
        this.kwField = this.uif.createOutputField("elb.kws", jLabel2);
        jPanel.add((Component)this.kwField, gridBagConstraints3);
        JLabel jLabel3 = this.uif.createLabel("elb.bugids", true);
        jPanel.add((Component)jLabel3, gridBagConstraints2);
        this.bugIdsField = this.uif.createOutputField("elb.bugids", jLabel3);
        jPanel.add((Component)this.bugIdsField, gridBagConstraints3);
        this.setBody(jPanel);
        JButton jButton = this.uif.createHelpButton("elb.help", "exclList.window.csh");
        JButton jButton2 = this.uif.createCloseButton("elb.close");
        this.setButtons(new JButton[]{jButton, jButton2}, jButton2);
        this.setComponentListener(this.listener);
    }

    private void showSelectedEntry() {
        ExcludeList.Entry entry = this.model.getEntry(this.table.getSelectedRow());
        if (entry == null) {
            this.synopsisField.setText("");
            this.kwField.setText("");
            this.bugIdsField.setText("");
        } else {
            this.synopsisField.setText(entry.getSynopsis());
            this.kwField.setText(this.getKeywords(entry));
            this.bugIdsField.setText(this.getBugIds(entry));
        }
    }

    private String entryToString(ExcludeList.Entry entry) {
        String string = entry.getRelativeURL();
        String string2 = entry.getTestCases();
        return string2 == null ? string : string + "[" + string2 + "]";
    }

    private String getBugIds(ExcludeList.Entry entry) {
        String[] stringArray = entry.getBugIdStrings();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    private String getKeywords(ExcludeList.Entry entry) {
        String[] stringArray = entry.getPlatforms();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ String[] access$402(ExcludeListBrowser excludeListBrowser, String[] stringArray) {
        excludeListBrowser.columnNames = stringArray;
        return stringArray;
    }

    static /* synthetic */ String access$1100(ExcludeListBrowser excludeListBrowser, ExcludeList.Entry entry) {
        return excludeListBrowser.entryToString(entry);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ExcludeListTableModel
    implements TableModel {
        private ExcludeList.Entry[] entries;

        ExcludeListTableModel(ExcludeList excludeList) {
            if (ExcludeListBrowser.this.columnNames == null) {
                ExcludeListBrowser.access$402(ExcludeListBrowser.this, new String[5]);
                ((ExcludeListBrowser)ExcludeListBrowser.this).columnNames[0] = ExcludeListBrowser.this.uif.getI18NString("elb.col.testName");
                ((ExcludeListBrowser)ExcludeListBrowser.this).columnNames[1] = ExcludeListBrowser.this.uif.getI18NString("elb.col.testCase");
                ((ExcludeListBrowser)ExcludeListBrowser.this).columnNames[2] = ExcludeListBrowser.this.uif.getI18NString("elb.col.bugId");
                ((ExcludeListBrowser)ExcludeListBrowser.this).columnNames[3] = ExcludeListBrowser.this.uif.getI18NString("elb.col.keywords");
                ((ExcludeListBrowser)ExcludeListBrowser.this).columnNames[4] = ExcludeListBrowser.this.uif.getI18NString("elb.col.synopsis");
            }
            TreeSet<ExcludeList.Entry> treeSet = new TreeSet<ExcludeList.Entry>(new Comparator(this){
                private final /* synthetic */ ExcludeListTableModel this$1;
                {
                    this.this$1 = excludeListTableModel;
                }

                public int compare(Object object, Object object2) {
                    String string = ExcludeListBrowser.access$1100(ExcludeListTableModel.access$1000(this.this$1), (ExcludeList.Entry)object);
                    String string2 = ExcludeListBrowser.access$1100(ExcludeListTableModel.access$1000(this.this$1), (ExcludeList.Entry)object2);
                    return string.compareTo(string2);
                }
            });
            if (excludeList != null) {
                Iterator iterator = excludeList.getIterator(false);
                while (iterator.hasNext()) {
                    ExcludeList.Entry entry = (ExcludeList.Entry)iterator.next();
                    treeSet.add(entry);
                }
            }
            this.entries = new ExcludeList.Entry[treeSet.size()];
            treeSet.toArray(this.entries);
        }

        ExcludeList.Entry getEntry(int n) {
            return n < 0 || n >= this.entries.length ? null : this.entries[n];
        }

        public void addTableModelListener(TableModelListener tableModelListener) {
        }

        public Class getColumnClass(int n) {
            return class$java$lang$String == null ? (class$java$lang$String = ExcludeListBrowser.class$("java.lang.String")) : class$java$lang$String;
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int n) {
            return ExcludeListBrowser.this.columnNames[n];
        }

        public int getRowCount() {
            return this.entries.length;
        }

        public Object getValueAt(int n, int n2) {
            ExcludeList.Entry entry = this.entries[n];
            switch (n2) {
                case 0: {
                    return entry.getRelativeURL();
                }
                case 1: {
                    return entry.getTestCases();
                }
                case 2: {
                    return ExcludeListBrowser.this.getBugIds(entry);
                }
                case 3: {
                    return ExcludeListBrowser.this.getKeywords(entry);
                }
                case 4: {
                    return entry.getSynopsis();
                }
            }
            throw new IllegalArgumentException();
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void removeTableModelListener(TableModelListener tableModelListener) {
        }

        public void setValueAt(Object object, int n, int n2) {
            throw new UnsupportedOperationException();
        }

        static /* synthetic */ ExcludeListBrowser access$1000(ExcludeListTableModel excludeListTableModel) {
            return excludeListTableModel.ExcludeListBrowser.this;
        }
    }

    private class Listener
    extends ComponentAdapter
    implements Interview.Observer {
        private Listener() {
        }

        public void componentShown(ComponentEvent componentEvent) {
            ExcludeListBrowser.this.params.addObserver(this);
            ExcludeListBrowser.this.updateContent();
        }

        public void componentHidden(ComponentEvent componentEvent) {
            ExcludeListBrowser.this.params.removeObserver(this);
        }

        public void currentQuestionChanged(Question question) {
        }

        public void pathUpdated() {
            ExcludeListBrowser.this.updateContent();
        }
    }
}

