/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.JavaTestError;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.ExecTool;
import com.sun.javatest.exec.PrefsPane;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.FileHistory;
import com.sun.javatest.tool.FileOpener;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.TestSuiteChooser;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.ToolManager;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.tool.WorkDirChooser;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class ExecToolManager
extends ToolManager {
    private Action openQuickStartAction;
    private Action openTestSuiteAction;
    private Action openWorkDirAction;
    private Action newWorkDirAction;
    private FileOpener testSuiteOpener;
    private FileOpener workDirOpener;
    private TestSuiteChooser testSuiteChooser;
    private WorkDirChooser workDirChooser;
    private PrefsPane prefsPane;
    private boolean doneQuickStart;
    private static final String EXEC = "exec";
    private static final File userDir = new File(System.getProperty("user.dir"));
    private FileOpener[] fileOpeners;
    private Action[] fileMenuActions;
    static /* synthetic */ Class class$javax$swing$JFrame;

    public ExecToolManager(Desktop desktop) {
        super(desktop);
        this.openQuickStartAction = new ToolAction(this.i18n, "mgr.openQuickStart"){

            public void actionPerformed(ActionEvent actionEvent) {
                Desktop desktop = ExecToolManager.this.getDesktop();
                ExecTool execTool = new ExecTool(ExecToolManager.this);
                desktop.addTool(execTool);
                desktop.setSelectedTool(execTool);
                execTool.showQuickStartWizard();
            }
        };
        this.openTestSuiteAction = new ToolAction(this.i18n, "mgr.openTestSuite"){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    TestSuiteChooser testSuiteChooser = ExecToolManager.this.getTestSuiteChooser();
                    JComponent jComponent = (JComponent)actionEvent.getSource();
                    JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = ExecToolManager.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, jComponent);
                    int n = testSuiteChooser.showDialog(jFrame);
                    if (n != 0) {
                        return;
                    }
                    ExecToolManager.this.showTestSuite(testSuiteChooser.getSelectedTestSuite());
                    testSuiteChooser.setSelectedTestSuite(null);
                }
                catch (Interview.Fault fault) {
                    ExecToolManager.this.showError("tmgr.cantOpenTestSuite", fault.getMessage());
                }
                catch (TestSuite.Fault fault) {
                    ExecToolManager.this.showError("tmgr.cantOpenTestSuite", fault.getMessage());
                }
            }
        };
        this.openWorkDirAction = new ToolAction(this.i18n, "mgr.openWorkDir"){

            public void actionPerformed(ActionEvent actionEvent) {
                WeakReference weakReference = (WeakReference)this.getValue("testSuite");
                TestSuite testSuite = weakReference == null ? null : (TestSuite)weakReference.get();
                File file = (File)this.getValue("testSuitePath");
                File file2 = (File)this.getValue("workDirPath");
                try {
                    TestSuite testSuite2 = null;
                    try {
                        if (testSuite != null) {
                            testSuite2 = testSuite;
                        } else if (file != null) {
                            testSuite2 = TestSuite.open(file);
                        } else if (file2 != null) {
                            testSuite2 = WorkDirectory.open(file2).getTestSuite();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    WorkDirChooser workDirChooser = ExecToolManager.this.getWorkDirChooser();
                    workDirChooser.setMode(1);
                    workDirChooser.setTestSuite(testSuite2);
                    JComponent jComponent = (JComponent)actionEvent.getSource();
                    JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = ExecToolManager.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, jComponent);
                    int n = workDirChooser.showDialog(jFrame);
                    if (n != 0) {
                        return;
                    }
                    WorkDirectory workDirectory = workDirChooser.getSelectedWorkDirectory();
                    ExecToolManager.this.showWorkDirectory(workDirectory);
                    workDirChooser.setSelectedWorkDirectory(null);
                    workDirChooser.setTestSuite(null);
                }
                catch (Interview.Fault fault) {
                    ExecToolManager.this.showError("tmgr.cantOpenWorkDir", fault.getMessage());
                }
                catch (TestSuite.Fault fault) {
                    ExecToolManager.this.showError("tmgr.cantOpenWorkDir", fault.getMessage());
                }
            }
        };
        this.newWorkDirAction = new ToolAction(this.i18n, "mgr.newWorkDir"){

            public void actionPerformed(ActionEvent actionEvent) {
                WeakReference weakReference = (WeakReference)this.getValue("testSuite");
                TestSuite testSuite = weakReference == null ? null : weakReference.get();
                File file = (File)this.getValue("testSuitePath");
                File file2 = (File)this.getValue("workDirPath");
                try {
                    TestSuite testSuite2;
                    if (testSuite != null) {
                        testSuite2 = testSuite;
                    } else if (file != null) {
                        testSuite2 = TestSuite.open(file);
                    } else if (file2 != null) {
                        testSuite2 = WorkDirectory.open(file2).getTestSuite();
                    } else {
                        throw new JavaTestError("ExecManager.newWorkDirAction");
                    }
                    WorkDirChooser workDirChooser = ExecToolManager.this.getWorkDirChooser();
                    workDirChooser.setMode(0);
                    workDirChooser.setTestSuite(testSuite2);
                    JComponent jComponent = (JComponent)actionEvent.getSource();
                    JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = ExecToolManager.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, jComponent);
                    int n = workDirChooser.showDialog(jFrame);
                    if (n != 0) {
                        return;
                    }
                    WorkDirectory workDirectory = workDirChooser.getSelectedWorkDirectory();
                    ExecToolManager.this.showWorkDirectory(workDirectory);
                    workDirChooser.setSelectedWorkDirectory(null);
                    workDirChooser.setTestSuite(null);
                }
                catch (Interview.Fault fault) {
                    ExecToolManager.this.showError("tmgr.cantCreateWorkDir", fault.getMessage());
                }
                catch (TestSuite.Fault fault) {
                    ExecToolManager.this.showError("tmgr.cantCreateWorkDir", fault.getMessage());
                }
                catch (WorkDirectory.Fault fault) {
                    ExecToolManager.this.showError("tmgr.cantCreateWorkDir", fault.getMessage());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    JavaTestError.unexpectedException(fileNotFoundException);
                }
            }
        };
        this.testSuiteOpener = new FileOpener(){

            public String getFileType() {
                return "testSuite";
            }

            public void open(File file) throws FileNotFoundException, FileOpener.Fault {
                try {
                    ExecToolManager.this.showTestSuite(TestSuite.open(file));
                }
                catch (Interview.Fault fault) {
                    throw new FileOpener.Fault(ExecToolManager.this.i18n, "mgr.errorOpeningTestSuite", new Object[]{file, fault});
                }
                catch (TestSuite.Fault fault) {
                    throw new FileOpener.Fault(ExecToolManager.this.i18n, "mgr.errorOpeningTestSuite", new Object[]{file, fault});
                }
            }
        };
        this.workDirOpener = new FileOpener(){

            public String getFileType() {
                return "workDirectory";
            }

            public void open(File file) throws FileNotFoundException, FileOpener.Fault {
                try {
                    ExecToolManager.this.showWorkDirectory(WorkDirectory.open(file));
                }
                catch (Interview.Fault fault) {
                    throw new FileOpener.Fault(ExecToolManager.this.i18n, "mgr.errorOpeningWorkDirectory", new Object[]{file, fault.getMessage()});
                }
                catch (TestSuite.Fault fault) {
                    throw new FileOpener.Fault(ExecToolManager.this.i18n, "mgr.errorOpeningWorkDirectory", new Object[]{file, fault.getMessage()});
                }
                catch (WorkDirectory.Fault fault) {
                    throw new FileOpener.Fault(ExecToolManager.this.i18n, "mgr.errorOpeningWorkDirectory", new Object[]{file, fault.getMessage()});
                }
            }
        };
        this.fileOpeners = new FileOpener[]{this.testSuiteOpener, this.workDirOpener};
        this.fileMenuActions = new Action[]{this.openQuickStartAction, this.newWorkDirAction, this.openWorkDirAction, this.openTestSuiteAction};
    }

    public FileOpener[] getFileOpeners() {
        return this.fileOpeners;
    }

    public Action[] getFileMenuActions() {
        Serializable serializable;
        Object object;
        boolean bl = false;
        Object var2_2 = null;
        Desktop desktop = this.getDesktop();
        Tool tool = desktop.getSelectedTool();
        if (tool != null && tool instanceof ExecTool && (object = ((ExecTool)tool).getTestSuite()) != null) {
            this.newWorkDirAction.setEnabled(true);
            this.newWorkDirAction.putValue("testSuite", new WeakReference<Object>(object));
            this.openWorkDirAction.putValue("testSuite", new WeakReference<Object>(object));
            bl = true;
        }
        if (!bl) {
            object = desktop.getTools();
            serializable = new HashSet();
            for (int i = 0; i < ((Tool[])object).length; ++i) {
                TestSuite[] testSuiteArray = ((Tool)object[i]).getLoadedTestSuites();
                if (testSuiteArray == null) continue;
                serializable.addAll(Arrays.asList(testSuiteArray));
            }
            if (serializable.size() == 1) {
                TestSuite testSuite = (TestSuite)serializable.toArray()[0];
                this.newWorkDirAction.setEnabled(true);
                this.newWorkDirAction.putValue("testSuite", new WeakReference<TestSuite>(testSuite));
                this.openWorkDirAction.putValue("testSuite", new WeakReference<TestSuite>(testSuite));
            } else {
                this.newWorkDirAction.setEnabled(false);
            }
            boolean bl2 = bl = serializable.size() > 0;
        }
        if (!bl) {
            try {
                if (TestSuite.isTestSuite(userDir)) {
                    this.newWorkDirAction.setEnabled(true);
                    this.newWorkDirAction.putValue("testSuitePath", userDir);
                    this.openWorkDirAction.putValue("testSuitePath", userDir);
                    bl = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            try {
                if (WorkDirectory.isWorkDirectory(userDir)) {
                    this.newWorkDirAction.setEnabled(true);
                    this.newWorkDirAction.putValue("workDirPath", userDir);
                    this.openWorkDirAction.putValue("workDirPath", userDir);
                    bl = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            try {
                File file;
                object = Harness.getClassDir();
                serializable = object == null ? null : ((File)object).getParentFile();
                File file2 = file = serializable == null ? null : ((File)serializable).getParentFile();
                if (serializable != null && TestSuite.isTestSuite((File)serializable)) {
                    this.newWorkDirAction.setEnabled(true);
                    this.newWorkDirAction.putValue("testSuitePath", serializable);
                    this.openWorkDirAction.putValue("testSuitePath", serializable);
                    bl = true;
                } else if (file != null && TestSuite.isTestSuite(file)) {
                    this.newWorkDirAction.setEnabled(true);
                    this.newWorkDirAction.putValue("testSuitePath", file);
                    this.openWorkDirAction.putValue("testSuitePath", file);
                    bl = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            this.newWorkDirAction.setEnabled(false);
        }
        return this.fileMenuActions;
    }

    public Action[] getTaskMenuActions() {
        return null;
    }

    public Preferences.Pane getPrefsPane() {
        if (this.prefsPane == null) {
            this.prefsPane = new PrefsPane(this.getDesktop().getHelpBroker());
        }
        return this.prefsPane;
    }

    public Tool startTool() {
        Desktop desktop = this.getDesktop();
        ExecTool execTool = new ExecTool(this);
        desktop.addTool(execTool);
        if (desktop.isFirstTime() && !this.doneQuickStart) {
            execTool.showQuickStartWizard();
            this.doneQuickStart = true;
        }
        return execTool;
    }

    public Tool startTool(InterviewParameters interviewParameters) {
        Desktop desktop = this.getDesktop();
        ExecTool execTool = new ExecTool(this, interviewParameters);
        desktop.addTool(execTool);
        desktop.setSelectedTool(execTool);
        return execTool;
    }

    public Tool restoreTool(Map map) throws ToolManager.Fault {
        try {
            return new ExecTool(this, map);
        }
        catch (InterviewParameters.WorkDirFault workDirFault) {
            throw new ToolManager.Fault(this.i18n, "mgr.restoreFaultWD", workDirFault.getMessage());
        }
        catch (InterviewParameters.TestSuiteFault testSuiteFault) {
            throw new ToolManager.Fault(this.i18n, "mgr.restoreFaultTS", testSuiteFault.getMessage());
        }
        catch (InterviewParameters.JTIFault jTIFault) {
            throw new ToolManager.Fault(this.i18n, "mgr.restoreFaultJTI", jTIFault.getMessage());
        }
        catch (Interview.Fault fault) {
            throw new ToolManager.Fault(this.i18n, "mgr.restoreFault", fault.getMessage());
        }
    }

    public ExecTool showTestSuite(TestSuite testSuite) throws Interview.Fault, TestSuite.Fault {
        ExecTool execTool;
        Desktop desktop = this.getDesktop();
        ExecTool execTool2 = null;
        Tool[] toolArray = desktop.getTools();
        if (toolArray != null) {
            for (int i = 0; i < toolArray.length && execTool2 == null; ++i) {
                ExecTool execTool3;
                if (!(toolArray[i] instanceof ExecTool) || !(execTool3 = (ExecTool)toolArray[i]).isEmpty() || execTool3.isQuickStartWizardShowing()) continue;
                execTool2 = execTool3;
            }
        }
        if (execTool2 != null) {
            execTool = execTool2;
            execTool.setTestSuite(testSuite);
        } else {
            execTool = new ExecTool(this, testSuite);
            desktop.addTool(execTool);
        }
        desktop.setSelectedTool(execTool);
        desktop.addToFileHistory(testSuite.getRoot(), this.testSuiteOpener);
        return execTool;
    }

    private TestSuiteChooser getTestSuiteChooser() {
        if (this.testSuiteChooser == null) {
            this.testSuiteChooser = new TestSuiteChooser();
        }
        return this.testSuiteChooser;
    }

    void addToFileHistory(TestSuite testSuite) {
        this.getDesktop().addToFileHistory(testSuite.getRoot(), this.testSuiteOpener);
    }

    public ExecTool showWorkDirectory(WorkDirectory workDirectory) throws Interview.Fault, TestSuite.Fault {
        ExecTool execTool;
        Object object;
        Desktop desktop = this.getDesktop();
        Object object2 = null;
        Tool[] toolArray = desktop.getTools();
        if (toolArray != null) {
            for (int i = 0; i < toolArray.length; ++i) {
                if (!(toolArray[i] instanceof ExecTool)) continue;
                object = (ExecTool)toolArray[i];
                if (object2 == null && ((ExecTool)object).isEmpty() && !((ExecTool)object).isQuickStartWizardShowing()) {
                    object2 = object;
                    continue;
                }
                if (((ExecTool)object).getWorkDirectory() != null || !((ExecTool)object).containsTestSuite(workDirectory.getTestSuite())) continue;
                object2 = object;
                break;
            }
        }
        if (object2 != null) {
            execTool = object2;
            execTool.setWorkDirectory(workDirectory);
        } else {
            object = workDirectory.getTestSuite();
            InterviewParameters interviewParameters = ((TestSuite)object).createInterview();
            interviewParameters.setWorkDirectory(workDirectory);
            FileHistory fileHistory = FileHistory.getFileHistory(workDirectory, "configHistory.jtl");
            File file = fileHistory.getLatestEntry();
            if (file != null) {
                try {
                    interviewParameters.load(file);
                }
                catch (IOException iOException) {
                    this.showError("tmgr.cantLoadDefaultConfig", new Object[]{file, iOException});
                }
                catch (Interview.Fault fault) {
                    this.showError("tmgr.cantLoadDefaultConfig", new Object[]{file, fault.getMessage()});
                }
            }
            execTool = new ExecTool(this, interviewParameters);
            desktop.addTool(execTool);
        }
        desktop.setSelectedTool(execTool);
        desktop.addToFileHistory(workDirectory.getRoot(), this.workDirOpener);
        return execTool;
    }

    private WorkDirChooser getWorkDirChooser() {
        if (this.workDirChooser == null) {
            this.workDirChooser = new WorkDirChooser();
            this.workDirChooser.setTestSuiteChooser(this.getTestSuiteChooser());
        }
        return this.workDirChooser;
    }

    void addToFileHistory(WorkDirectory workDirectory) {
        this.getDesktop().addToFileHistory(workDirectory.getRoot(), this.workDirOpener);
    }

    void showError(String string) {
        this.showError(string, null);
    }

    void showError(String string, Object object) {
        this.showError(string, new Object[]{object});
    }

    void showError(String string, Object[] objectArray) {
        Desktop desktop = this.getDesktop();
        UIFactory uIFactory = new UIFactory(this.getClass(), desktop.getDialogParent(), desktop.getHelpBroker());
        uIFactory.showError(string, objectArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

