/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.LastRunInfo;
import com.sun.javatest.ObservableTestFilter;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.IOException;

class LastRunFilter
extends ObservableTestFilter {
    private long lastStart;
    private TestResultTable trt;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$exec$LastRunFilter == null ? (class$com$sun$javatest$exec$LastRunFilter = LastRunFilter.class$("com.sun.javatest.exec.LastRunFilter")) : class$com$sun$javatest$exec$LastRunFilter);
    static /* synthetic */ Class class$com$sun$javatest$exec$LastRunFilter;

    LastRunFilter() {
    }

    LastRunFilter(WorkDirectory workDirectory) {
        this();
        this.setWorkDirectory(workDirectory);
    }

    void setWorkDirectory(WorkDirectory workDirectory) {
        if (workDirectory == null) {
            return;
        }
        try {
            LastRunInfo lastRunInfo = LastRunInfo.readInfo(workDirectory);
            this.lastStart = lastRunInfo.getStartTime() - lastRunInfo.getStartTime() % 1000L;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.trt = workDirectory.getTestResultTable();
        this.notifyUpdated(this);
    }

    void setLastStartTime(long l) {
        this.lastStart = l - l % 1000L;
        this.notifyUpdated(this);
    }

    boolean isWorkDirectorySet() {
        return this.trt != null;
    }

    public String getName() {
        return i18n.getString("ltr.name");
    }

    public String getDescription() {
        return i18n.getString("ltr.desc");
    }

    public String getReason() {
        return i18n.getString("ltr.reason");
    }

    public boolean accepts(TestDescription testDescription) throws TestFilter.Fault {
        return this.accepts(testDescription, null);
    }

    public boolean accepts(TestDescription testDescription, TestFilter.Observer observer) throws TestFilter.Fault {
        if (this.trt == null) {
            return true;
        }
        TestResult testResult = this.trt.lookup(testDescription);
        if (testResult != null) {
            long l = testResult.getEndTime();
            if (l >= this.lastStart) {
                return true;
            }
            if (observer != null) {
                observer.rejected(testDescription, this);
            }
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

