/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.exec.FilterConfig;
import com.sun.javatest.exec.FilterSelectionHandler;
import com.sun.javatest.exec.ReportBrowser;
import com.sun.javatest.report.Report;
import com.sun.javatest.report.ReportDirChooser;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.DynamicArray;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Keymap;

class NewReportDialog
extends ToolDialog {
    private ActionListener cbListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == NewReportDialog.this.cbHtml || object == NewReportDialog.this.cbConfig) {
                NewReportDialog.this.updateCheckboxStates();
            } else if (object == NewReportDialog.this.cbBak) {
                NewReportDialog.this.numBak.setEnabled(NewReportDialog.this.cbBak.isSelected());
            }
        }
    };
    private ActionListener listener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == NewReportDialog.this.browseBtn) {
                NewReportDialog.this.showReportChooserDialog();
            } else if (object == NewReportDialog.this.cancelBtn) {
                NewReportDialog.this.setState(NewReportDialog.this.lastSettings);
                NewReportDialog.this.setVisible(false);
            } else if (object == NewReportDialog.this.okBtn) {
                String string = (String)NewReportDialog.this.dirBox.getSelectedItem();
                if (string == null || string.length() == 0) {
                    NewReportDialog.this.uif.showError("nrd.emptyInput");
                    return;
                }
                if (NewReportDialog.this.cbBak.isSelected() && NewReportDialog.this.numBak.getText().equals("")) {
                    NewReportDialog.this.uif.showError("nrd.emptyBak");
                    NewReportDialog.this.tabs.setSelectedIndex(NewReportDialog.this.tabs.getTabCount() - 1);
                    return;
                }
                NewReportDialog.this.reportDir = new File(string);
                try {
                    if (!NewReportDialog.this.reportDir.isDirectory()) {
                        NewReportDialog.this.reportDir.mkdirs();
                    } else if (!Report.isReportDirectory(NewReportDialog.this.reportDir) && !NewReportDialog.this.isEmptyDirectory(NewReportDialog.this.reportDir)) {
                        NewReportDialog.this.uif.showError("nrd.cantUse", NewReportDialog.this.reportDir);
                        return;
                    }
                    NewReportDialog.this.setVisible(false);
                    NewReportDialog.this.lastSettings = NewReportDialog.this.captureState();
                    this.doBgReport(NewReportDialog.this.lastSettings);
                }
                catch (SecurityException securityException) {
                    NewReportDialog.this.uif.showError("nrd.cantCreate", securityException.getMessage());
                }
            }
        }

        private void doBgReport(Report.Settings settings) {
            JDialog jDialog = NewReportDialog.this.uif.createWaitDialog("nrd.wait", SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = NewReportDialog.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, NewReportDialog.this.parent));
            Thread thread = new Thread(this, settings, jDialog){
                private final /* synthetic */ Report.Settings val$snap;
                private final /* synthetic */ JDialog val$d;
                private final /* synthetic */ 5 this$1;
                {
                    this.this$1 = var1_1;
                    this.val$snap = settings;
                    this.val$d = jDialog;
                }

                public void run() {
                    try {
                        NewReportDialog.access$2400(5.access$2300(this.this$1), this.val$snap);
                        5.access$2500(this.this$1, this.val$d, this.val$snap);
                    }
                    catch (IOException iOException) {
                        5.access$2600(this.this$1, "nrd.cantWrite", iOException.getMessage(), this.val$d);
                    }
                    catch (SecurityException securityException) {
                        5.access$2600(this.this$1, "nrd.cantCreate", securityException.getMessage(), this.val$d);
                    }
                }
            };
            ActionListener actionListener = new ActionListener(this, thread, jDialog){
                private final /* synthetic */ Thread val$t;
                private final /* synthetic */ JDialog val$d;
                private final /* synthetic */ 5 this$1;
                {
                    this.this$1 = var1_1;
                    this.val$t = thread;
                    this.val$d = jDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.val$t.isAlive()) {
                        this.val$d.show();
                    }
                }
            };
            Timer timer = new Timer(3000, actionListener);
            timer.setRepeats(false);
            timer.start();
            thread.start();
        }

        private void finishReport(JDialog jDialog, Report.Settings settings) {
            EventQueue.invokeLater(new Runnable(this, jDialog, settings){
                private final /* synthetic */ JDialog val$waitDialog;
                private final /* synthetic */ Report.Settings val$snap;
                private final /* synthetic */ 5 this$1;
                {
                    this.this$1 = var1_1;
                    this.val$waitDialog = jDialog;
                    this.val$snap = settings;
                }

                public void run() {
                    this.val$waitDialog.hide();
                    int n = NewReportDialog.access$2700(5.access$2300(this.this$1)).showYesNoDialog("nrd.showReport");
                    switch (n) {
                        case 0: {
                            5.access$2300(this.this$1).showReportBrowser(5.access$2800(this.this$1, this.val$snap));
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    5.access$2300(this.this$1).notifyUpdate(5.access$2300(this.this$1).getLastState());
                }
            });
        }

        private void showError(String string, String string2, JDialog jDialog) {
            EventQueue.invokeLater(new Runnable(this, jDialog, string, string2){
                private final /* synthetic */ JDialog val$waitDialog;
                private final /* synthetic */ String val$uiKey;
                private final /* synthetic */ String val$msg;
                private final /* synthetic */ 5 this$1;
                {
                    this.this$1 = var1_1;
                    this.val$waitDialog = jDialog;
                    this.val$uiKey = string;
                    this.val$msg = string2;
                }

                public void run() {
                    this.val$waitDialog.hide();
                    NewReportDialog.access$2900(5.access$2300(this.this$1)).showError(this.val$uiKey, this.val$msg);
                }
            });
        }

        private File selectFileToShow(Report.Settings settings) {
            File file;
            if (settings.isHtmlEnabled()) {
                file = this.searchForFile(NewReportDialog.this.reportDir, Report.getHtmlReportFilenames());
                if (file == null) {
                    file = NewReportDialog.this.reportDir;
                }
            } else if (settings.isPlainEnabled()) {
                file = this.searchForFile(NewReportDialog.this.reportDir, Report.getPlainReportFilenames());
                if (file == null) {
                    file = NewReportDialog.this.reportDir;
                }
            } else {
                file = settings.isXmlEnabled() ? NewReportDialog.this.reportDir : NewReportDialog.this.reportDir;
            }
            return file;
        }

        private File searchForFile(File file, String[] stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(NewReportDialog.this.reportDir, stringArray[i]);
                if (!file2.exists()) continue;
                return file2;
            }
            return null;
        }

        static /* synthetic */ NewReportDialog access$2300(5 var0) {
            return var0.NewReportDialog.this;
        }

        static /* synthetic */ void access$2500(5 var0, JDialog jDialog, Report.Settings settings) {
            var0.finishReport(jDialog, settings);
        }

        static /* synthetic */ void access$2600(5 var0, String string, String string2, JDialog jDialog) {
            var0.showError(string, string2, jDialog);
        }

        static /* synthetic */ File access$2800(5 var0, Report.Settings settings) {
            return var0.selectFileToShow(settings);
        }
    };
    private Observer[] obs = new Observer[0];
    private ReportDirChooser reportDirChooser;
    private JCheckBox cbHtml;
    private JCheckBox cbPlain;
    private JCheckBox cbXml;
    private JCheckBox cbConfig;
    private JCheckBox cbQl;
    private JCheckBox cbEnv;
    private JCheckBox cbStd;
    private JCheckBox cbResults;
    private JCheckBox cbKws;
    private JCheckBox cbPass;
    private JCheckBox cbFail;
    private JCheckBox cbErr;
    private JCheckBox cbNr;
    private JCheckBox cbHtmlRpt;
    private JCheckBox cbHtmlInd;
    private JCheckBox cbBak;
    private JTextField numBak;
    private Vector htmlGroup = new Vector();
    private Vector configGroup = new Vector();
    private File reportDir;
    private JButton browseBtn;
    private JButton okBtn;
    private JButton cancelBtn;
    private JComboBox dirBox;
    private JTabbedPane tabs;
    private Report.Settings lastSettings;
    private ReportBrowser reportBrowser;
    private InterviewParameters interviewParams;
    private FilterSelectionHandler filterHandler;
    static final String REPORT_DIR = "reportDir";
    private static final String FILTER = "filter";
    private static final int WAIT_DIALOG_DELAY = 3000;
    static /* synthetic */ Class class$javax$swing$JFrame;

    NewReportDialog(Component component, UIFactory uIFactory, FilterConfig filterConfig, ReportBrowser reportBrowser) {
        super(component, uIFactory, "nrd");
        this.filterHandler = filterConfig.createFilterSelectionHandler();
        this.reportBrowser = reportBrowser;
    }

    public void setInterviewParameters(InterviewParameters interviewParameters) {
        this.interviewParams = interviewParameters;
    }

    void setLastState(Map map) {
        String string = (String)map.get(REPORT_DIR);
        String string2 = (String)map.get(FILTER);
        if (this.dirBox == null) {
            this.initGUI();
        }
        this.dirBox.removeAllItems();
        if (string != null && string.length() > 0) {
            this.dirBox.addItem(string);
        } else {
            this.dirBox.addItem("");
        }
        if (string2 != null && string2.length() > 0) {
            this.filterHandler.setFilter(string2);
        }
    }

    Map getLastState() {
        String string = (String)this.dirBox.getSelectedItem();
        String string2 = this.filterHandler.getActiveFilter().getName();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string != null && string.length() > 0) {
            hashMap.put(REPORT_DIR, string);
        }
        if (string2 != null && string2.length() > 0) {
            hashMap.put(FILTER, string2);
        }
        return hashMap;
    }

    void addObserver(Observer observer) {
        this.obs = (Observer[])DynamicArray.append(this.obs, observer);
    }

    void removeObserver(Observer observer) {
        this.obs = (Observer[])DynamicArray.remove((Object[])this.obs, observer);
    }

    void notifyUpdate(Map map) {
        for (int i = 0; i < this.obs.length; ++i) {
            this.obs[i].update(map);
        }
    }

    protected void initGUI() {
        JComponent jComponent;
        JComponent[] jComponentArray;
        this.setHelp("report.newReport.csh");
        this.setI18NTitle("nrd.title");
        JPanel jPanel = new JPanel(){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                int n = NewReportDialog.this.uif.getDotsPerInch();
                return new Dimension(Math.max(dimension.width, 5 * n), dimension.height);
            }
        };
        jPanel.setName("nrd.body");
        jPanel.setFocusable(false);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        int n = this.uif.getDotsPerInch();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.insets.bottom = 11;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        JLabel jLabel = this.uif.createLabel("nrd.dir", true);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.dirBox = this.uif.createChoice("nrd.dir.choice", true, jLabel);
        this.dirBox.setMaximumRowCount(1);
        gridBagConstraints.weightx = 3.0;
        jPanel.add((Component)this.dirBox, gridBagConstraints);
        this.browseBtn = this.uif.createButton("nrd.browse", this.listener);
        this.browseBtn.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 11;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.browseBtn, gridBagConstraints);
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.gridwidth = 1;
        if (this.filterHandler != null) {
            jComponentArray = this.uif.createLabel("nrd.filter", true);
            jPanel.add((Component)jComponentArray, gridBagConstraints);
            jComponent = this.filterHandler.getFilterSelector();
            jComponentArray.setLabelFor(jComponent);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 4.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            jPanel.add((Component)jComponent, gridBagConstraints);
        }
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.bottom = 12;
        gridBagConstraints.weighty = 4.0;
        gridBagConstraints.weighty = 1.0;
        jComponentArray = new JComponent[]{this.createTypeBlock(), this.createHtmlBlock(), this.createFilesBlock(), this.createOpsBlock()};
        this.tabs = this.uif.createTabbedPane("nrd.tabs", jComponentArray);
        this.tabs.setTabPlacement(1);
        this.tabs.setBorder(BorderFactory.createEmptyBorder());
        jPanel.add((Component)this.tabs, gridBagConstraints);
        this.setBody(jPanel);
        this.okBtn = this.uif.createButton("nrd.ok", this.listener);
        this.cancelBtn = this.uif.createCancelButton("nrd.cancel", this.listener);
        jComponent = this.uif.createHelpButton("nrd.help", "report.newReport.csh");
        this.setButtons(new JButton[]{this.okBtn, this.cancelBtn, jComponent}, this.cancelBtn);
        this.setState(Report.getSettingsPrefs());
    }

    private JComponent createTypeBlock() {
        JCheckBox jCheckBox;
        JPanel jPanel = this.uif.createPanel("nrd.typeBlk", new GridBagLayout(), false);
        jPanel.setName("typeBlk");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        JTextArea jTextArea = this.uif.createMessageArea("nrd.typeBlk");
        jPanel.add((Component)jTextArea, gridBagConstraints);
        this.cbHtml = jCheckBox = this.uif.createCheckBox("nrd.type.html", true);
        this.cbHtml.addActionListener(this.cbListener);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        jCheckBox = this.cbPlain = this.uif.createCheckBox("nrd.type.pt", true);
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        jCheckBox = this.cbXml = this.uif.createCheckBox("nrd.type.xml", false);
        gridBagConstraints.gridy = 3;
        this.cbXml.setEnabled(false);
        this.cbXml.setVisible(false);
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        JScrollPane jScrollPane = this.uif.createScrollPane(jPanel, 20, 30);
        jScrollPane.setViewportBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5), this.uif.createTitledBorder("nrd.type")));
        return jScrollPane;
    }

    private JComponent createHtmlBlock() {
        JCheckBox jCheckBox;
        JPanel jPanel = this.uif.createPanel("nrd.htmlops", new GridBagLayout(), false);
        jPanel.setName("htmlops");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridy = 0;
        JTextArea jTextArea = this.uif.createMessageArea("nrd.htmlops");
        jPanel.add((Component)jTextArea, gridBagConstraints);
        this.cbConfig = jCheckBox = this.uif.createCheckBox("nrd.htmlops.config", true);
        this.cbConfig.addActionListener(this.cbListener);
        this.htmlGroup.addElement(jCheckBox);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 2;
        jCheckBox = this.cbQl = this.uif.createCheckBox("nrd.htmlops.ql", true);
        this.configGroup.addElement(jCheckBox);
        this.htmlGroup.addElement(jCheckBox);
        jPanel.add(this.uif.createHorizontalStrut(25), gridBagConstraints);
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jCheckBox = this.cbEnv = this.uif.createCheckBox("nrd.htmlops.env", false);
        this.configGroup.addElement(jCheckBox);
        this.htmlGroup.addElement(jCheckBox);
        jPanel.add(this.uif.createHorizontalStrut(25), gridBagConstraints);
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        jCheckBox = this.cbStd = this.uif.createCheckBox("nrd.htmlops.std", false);
        this.configGroup.addElement(jCheckBox);
        this.htmlGroup.addElement(jCheckBox);
        jPanel.add(this.uif.createHorizontalStrut(25), gridBagConstraints);
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        jCheckBox = this.cbResults = this.uif.createCheckBox("nrd.htmlops.res", true);
        this.htmlGroup.addElement(jCheckBox);
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        jCheckBox = this.cbKws = this.uif.createCheckBox("nrd.htmlops.kw", true);
        this.htmlGroup.addElement(jCheckBox);
        gridBagConstraints.gridy = 6;
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        JScrollPane jScrollPane = this.uif.createScrollPane(jPanel, 20, 30);
        jScrollPane.setViewportBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5), this.uif.createTitledBorder("nrd.htmlops")));
        return jScrollPane;
    }

    private JComponent createFilesBlock() {
        JPanel jPanel = this.uif.createPanel("nrd.htmlf", new GridBagLayout(), false);
        jPanel.setName("htmlf");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridy = 0;
        JTextArea jTextArea = this.uif.createMessageArea("nrd.htmlf");
        jPanel.add((Component)jTextArea, gridBagConstraints);
        JLabel jLabel = this.uif.createLabel("nrd.htmlf.main", false);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 2;
        JCheckBox jCheckBox = this.cbHtmlRpt = this.uif.createCheckBox("nrd.htmlf.rpt", true);
        this.cbHtmlRpt.addActionListener(this.cbListener);
        this.htmlGroup.addElement(jCheckBox);
        jPanel.add(this.uif.createHorizontalStrut(25), gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        jCheckBox = this.cbHtmlInd = this.uif.createCheckBox("nrd.htmlf.idx", false);
        this.cbHtmlInd.addActionListener(this.cbListener);
        this.htmlGroup.addElement(jCheckBox);
        jPanel.add(this.uif.createHorizontalStrut(25), gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        jLabel = this.uif.createLabel("nrd.htmlf.xtra", false);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        jCheckBox = this.uif.createCheckBox("nrd.htmlf.pass", true);
        this.htmlGroup.addElement(jCheckBox);
        this.cbPass = jCheckBox;
        gridBagConstraints.gridwidth = 1;
        jPanel.add(this.uif.createHorizontalStrut(25), gridBagConstraints);
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        jCheckBox = this.cbErr = this.uif.createCheckBox("nrd.htmlf.err", true);
        this.htmlGroup.addElement(jCheckBox);
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        jCheckBox = this.cbFail = this.uif.createCheckBox("nrd.htmlf.fail", true);
        this.htmlGroup.addElement(jCheckBox);
        jPanel.add(this.uif.createHorizontalStrut(25), gridBagConstraints);
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        jCheckBox = this.cbNr = this.uif.createCheckBox("nrd.htmlf.nr", true);
        this.htmlGroup.addElement(jCheckBox);
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        JScrollPane jScrollPane = this.uif.createScrollPane(jPanel, 20, 30);
        jScrollPane.setViewportBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5), this.uif.createTitledBorder("nrd.htmlf")));
        return jScrollPane;
    }

    private JComponent createOpsBlock() {
        JPanel jPanel = this.uif.createPanel("nrd.ops", new GridBagLayout(), false);
        jPanel.setName("ops");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        JTextArea jTextArea = this.uif.createMessageArea("nrd.ops");
        jPanel.add((Component)jTextArea, gridBagConstraints);
        JCheckBox jCheckBox = this.cbBak = this.uif.createCheckBox("nrd.ops.bak", true);
        this.cbBak.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (NewReportDialog.this.numBak != null) {
                    NewReportDialog.this.numBak.setEnabled(NewReportDialog.this.cbBak.isSelected());
                }
            }
        });
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = -1;
        jPanel.add(this.uif.createHorizontalStrut(25), gridBagConstraints);
        JLabel jLabel = this.uif.createLabel("nrd.ops.bak.level", true);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.numBak = this.uif.createInputField("nrd.ops.bak.level", 2);
        gridBagConstraints.insets.left = 12;
        this.numBak.setText("1");
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTextField jTextField = (JTextField)actionEvent.getSource();
                String string = actionEvent.getActionCommand();
                char c = string.charAt(0);
                int n = jTextField.getCaret().getDot();
                int n2 = jTextField.getCaret().getMark();
                String string2 = jTextField.getText();
                if (Character.isDigit(c) && c != '0') {
                    DefaultEditorKit.InsertContentAction insertContentAction = new DefaultEditorKit.InsertContentAction();
                    insertContentAction.actionPerformed(actionEvent);
                    String string3 = jTextField.getText();
                    if (string3.length() > 1) {
                        jTextField.setText(string2);
                    }
                }
            }
        };
        Keymap keymap = JTextField.addKeymap("intField", this.numBak.getKeymap());
        keymap.setDefaultAction(abstractAction);
        this.numBak.setKeymap(keymap);
        jPanel.add((Component)this.numBak, gridBagConstraints);
        jPanel.setMaximumSize(jPanel.getPreferredSize());
        jLabel.setLabelFor(this.numBak);
        JScrollPane jScrollPane = this.uif.createScrollPane(jPanel, 20, 30);
        jScrollPane.setViewportBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5), this.uif.createTitledBorder("nrd.ops")));
        return jScrollPane;
    }

    private void showReportChooserDialog() {
        ReportDirChooser reportDirChooser = this.getReportDirChooser();
        reportDirChooser.setMode(0);
        int n = reportDirChooser.showDialog(this.dirBox);
        if (n != 0) {
            return;
        }
        this.dirBox.setSelectedItem(reportDirChooser.getSelectedFile().getAbsolutePath());
    }

    private ReportDirChooser getReportDirChooser() {
        if (this.reportDirChooser == null) {
            this.reportDirChooser = new ReportDirChooser();
        }
        return this.reportDirChooser;
    }

    void showReportBrowser(File file) {
        File file2;
        String[] stringArray = Report.getHtmlReportFilenames();
        Vector<File> vector = new Vector<File>();
        for (int i = 0; i < stringArray.length; ++i) {
            file2 = new File(this.reportDir, stringArray[i]);
            if (file2.exists() && file2.canRead()) {
                vector.add(file2);
                continue;
            }
            file2 = null;
        }
        if (vector.size() > 0) {
            Object var4_5 = null;
            file2 = null;
            long l = 0L;
            for (int i = 0; i < vector.size(); ++i) {
                File file3 = (File)vector.elementAt(i);
                if (file3.lastModified() <= l) continue;
                file2 = file3;
                l = file3.lastModified();
            }
            this.reportBrowser.show(file2);
        } else {
            this.reportBrowser.show(this.reportDir);
        }
    }

    private void runReport(Report.Settings settings) throws IOException {
        Report report;
        if (this.interviewParams != null) {
            report = new Report();
            if (this.interviewParams.getWorkDirectory() == null) {
                throw new IOException(this.uif.getI18NString("nrd.noWorkDir.err"));
            }
        } else {
            throw new IOException(this.uif.getI18NString("nrd.nullParams.err"));
        }
        report.writeReport(settings, this.reportDir);
    }

    private boolean isEmptyDirectory(File file) {
        return file.isDirectory() && file.list().length == 0;
    }

    private void updateCheckboxStates() {
        if (!this.cbHtml.isSelected()) {
            for (int i = 0; i < this.htmlGroup.size(); ++i) {
                ((JCheckBox)this.htmlGroup.elementAt(i)).setEnabled(this.cbHtml.isSelected());
            }
        } else {
            int n;
            for (n = 0; n < this.htmlGroup.size(); ++n) {
                ((JCheckBox)this.htmlGroup.elementAt(n)).setEnabled(this.cbHtml.isSelected());
            }
            for (n = 0; n < this.configGroup.size(); ++n) {
                ((JCheckBox)this.configGroup.elementAt(n)).setEnabled(this.cbConfig.isSelected());
            }
        }
    }

    private Report.Settings captureState() {
        Report.Settings settings = new Report.Settings(this.interviewParams);
        settings.setEnableHtmlReport(this.cbHtml.isSelected());
        settings.setEnableXmlReport(this.cbXml.isSelected());
        settings.setEnablePlainReport(this.cbPlain.isSelected());
        settings.setShowConfigSection(this.cbConfig.isSelected());
        settings.setShowEnvLog(this.cbEnv.isSelected());
        settings.setShowQuestionLog(this.cbQl.isSelected());
        settings.setShowStdValues(this.cbStd.isSelected());
        settings.setShowResults(this.cbResults.isSelected());
        settings.setShowKeywordSummary(this.cbKws.isSelected());
        settings.setHtmlMainReport(this.cbHtmlRpt.isSelected(), this.cbHtmlInd.isSelected());
        settings.setEnableHtmlStateFile(0, this.cbPass.isSelected());
        settings.setEnableHtmlStateFile(1, this.cbFail.isSelected());
        settings.setEnableHtmlStateFile(2, this.cbErr.isSelected());
        settings.setEnableHtmlStateFile(3, this.cbNr.isSelected());
        settings.setEnableBackups(this.cbBak.isSelected());
        try {
            int n = Integer.parseInt(this.numBak.getText());
            settings.setBackupLevels(n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        settings.setFilter(this.filterHandler.getActiveFilter());
        return settings;
    }

    private void setState(Report.Settings settings) {
        if (settings == null) {
            return;
        }
        this.lastSettings = settings;
        this.cbHtml.setSelected(settings.isHtmlEnabled());
        this.cbXml.setSelected(settings.isXmlEnabled());
        this.cbPlain.setSelected(settings.isPlainEnabled());
        boolean bl = settings.isConfigSectionEnabled();
        this.cbConfig.setSelected(bl);
        this.cbEnv.setSelected(settings.isEnvEnabled());
        this.cbQl.setSelected(settings.isQuestionLogEnabled());
        this.cbStd.setSelected(settings.isStdEnabled());
        this.cbEnv.setEnabled(bl);
        this.cbQl.setEnabled(bl);
        this.cbStd.setEnabled(bl);
        this.cbResults.setSelected(settings.isResultsEnabled());
        this.cbKws.setSelected(settings.isKeywordSummaryEnabled());
        this.cbHtmlRpt.setSelected(settings.isReportHtmlEnabled());
        this.cbHtmlInd.setSelected(settings.isIndexHtmlEnabled());
        this.cbPass.setSelected(settings.isStateFileEnabled(0));
        this.cbFail.setSelected(settings.isStateFileEnabled(1));
        this.cbErr.setSelected(settings.isStateFileEnabled(2));
        this.cbNr.setSelected(settings.isStateFileEnabled(3));
        this.cbBak.setSelected(settings.isBackupsEnabled());
        this.numBak.setText(Integer.toString(settings.getBackupLevel()));
        this.filterHandler.setFilter(settings.getTestFilter());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ void access$2400(NewReportDialog newReportDialog, Report.Settings settings) throws IOException {
        newReportDialog.runReport(settings);
    }

    static /* synthetic */ UIFactory access$2700(NewReportDialog newReportDialog) {
        return newReportDialog.uif;
    }

    static /* synthetic */ UIFactory access$2900(NewReportDialog newReportDialog) {
        return newReportDialog.uif;
    }

    static interface Observer {
        public void update(Map var1);
    }
}

