/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.tool.I18NUtils;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.plaf.metal.MetalLookAndFeel;

class RenderingUtilities {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$exec$RenderingUtilities == null ? (class$com$sun$javatest$exec$RenderingUtilities = RenderingUtilities.class$("com.sun.javatest.exec.RenderingUtilities")) : class$com$sun$javatest$exec$RenderingUtilities);
    private static TestCellRenderer tlRend;
    private static FilterCellRenderer flRend;
    static /* synthetic */ Class class$com$sun$javatest$exec$RenderingUtilities;

    RenderingUtilities() {
    }

    static ListCellRenderer createTestListRenderer() {
        return new TestCellRenderer(i18n);
    }

    static ListCellRenderer createTRTNodeRenderer() {
        return new TestCellRenderer(i18n);
    }

    static ListCellRenderer createFilterListRenderer() {
        return new FilterCellRenderer(i18n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class FilterCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private I18NResourceBundle i18n;

        public FilterCellRenderer(I18NResourceBundle i18NResourceBundle) {
            this.setOpaque(false);
            this.i18n = i18NResourceBundle;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = null;
            TestFilter testFilter = (TestFilter)object;
            string = testFilter.getName();
            if (string != null && string.length() > 0) {
                this.setText(string);
            } else {
                this.setText(this.i18n.getString("rendUtil.noFilterName"));
            }
            this.setColors(bl);
            this.setFont(false);
            return this;
        }

        private void setColors(boolean bl) {
            if (bl) {
                this.setOpaque(true);
                this.setForeground(Color.white);
                this.setBackground(MetalLookAndFeel.getPrimaryControlDarkShadow());
            } else {
                this.setForeground(Color.black);
                this.setOpaque(false);
            }
        }

        private void setFont(boolean bl) {
            if (bl) {
                this.setFont(this.getFont().deriveFont(1));
            } else {
                this.setFont(this.getFont().deriveFont(0));
            }
        }
    }

    static class TestCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private I18NResourceBundle i18n;
        private Border spacerBorder = BorderFactory.createEmptyBorder(0, 3, 0, 3);

        public TestCellRenderer(I18NResourceBundle i18NResourceBundle) {
            this.setOpaque(false);
            this.i18n = i18NResourceBundle;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object == null) {
                return this;
            }
            if (object instanceof TestResult) {
                TestResult testResult = (TestResult)object;
                this.setText(testResult.getTestName());
                this.setToolTipText(I18NUtils.getStatusMessage(testResult.getStatus()));
                this.setBasicAttribs(bl);
            } else if (object instanceof TestResultTable.TreeNode) {
                TestResultTable.TreeNode treeNode = (TestResultTable.TreeNode)object;
                if (treeNode.getName() != null) {
                    this.setText(TestResultTable.getRootRelativePath(treeNode));
                } else {
                    this.setText(this.i18n.getString("rendUtil.rootName"));
                }
                this.setBasicAttribs(bl);
            } else {
                this.setText(object.toString());
                if (bl) {
                    this.setOpaque(true);
                    this.setBackground(MetalLookAndFeel.getTextHighlightColor());
                } else {
                    this.setForeground(Color.black);
                    this.setOpaque(false);
                }
            }
            this.setFont(this.getFont().deriveFont(0));
            return this;
        }

        private void setBasicAttribs(boolean bl) {
            this.setBorder(this.spacerBorder);
            if (bl) {
                this.setOpaque(true);
                this.setBackground(MetalLookAndFeel.getTextHighlightColor());
            } else {
                this.setForeground(Color.black);
                this.setOpaque(false);
            }
        }
    }
}

