/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.Harness;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.BranchPanel;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.exec.FilterSelectionHandler;
import com.sun.javatest.exec.MultiSelectPanel;
import com.sun.javatest.exec.TT_Renderer;
import com.sun.javatest.exec.TestPanel;
import com.sun.javatest.exec.TestTree;
import com.sun.javatest.exec.TestTreeModel;
import com.sun.javatest.exec.TreePanelModel;
import com.sun.javatest.tool.Deck;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.Timer;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

class TestTreePanel
extends JPanel {
    private UIFactory uif;
    private Harness harness;
    private FilterSelectionHandler filterHandler;
    private ExecModel execModel;
    private JComponent parent;
    private Thread bgThread;
    private Map stateMap;
    private boolean disposed;
    private PanelModel pm;
    private TestTree tree;
    private TT_Renderer treeRend;
    private TestPanel testPanel;
    private BranchPanel brPanel;
    private MultiSelectPanel msPanel;
    private JPopupMenu popup;
    private TreePath lastPopupPath;
    private JMenuItem refreshMI;
    private JMenuItem purgeMI;
    private JMenuItem runMI;
    private String activeTest;
    private TestTreeModel treeModel;
    private Deck deck;
    private JPanel deckPanel;
    private JTextField titleField;
    private Listener listener;
    private TestSuite lastTs;
    private Parameters params;
    private static final int WAIT_DIALOG_DELAY = 3000;
    private static final String OPEN_PATHS_PREF = "openpaths";
    protected static boolean debug = Boolean.getBoolean("debug." + (class$com$sun$javatest$exec$TestTreePanel == null ? (class$com$sun$javatest$exec$TestTreePanel = TestTreePanel.class$("com.sun.javatest.exec.TestTreePanel")) : class$com$sun$javatest$exec$TestTreePanel).getName());
    static /* synthetic */ Class class$com$sun$javatest$exec$TestTreePanel;

    public TestTreePanel(UIFactory uIFactory, Harness harness, ExecModel execModel, FilterSelectionHandler filterSelectionHandler, JComponent jComponent, Map map) {
        this.uif = uIFactory;
        this.harness = harness;
        this.filterHandler = filterSelectionHandler;
        this.execModel = execModel;
        this.parent = jComponent;
        this.stateMap = map;
        this.pm = new PanelModel();
        this.harness.addObserver(this.pm);
        this.initGUI();
        uIFactory.setAccessibleInfo(this, "treep");
    }

    public TestResultTable getTestResultTable() {
        return this.treeModel.getTestResultTable();
    }

    public Parameters getParameters() {
        return this.params;
    }

    public TreePanelModel getTreePanelModel() {
        return this.pm;
    }

    public void dispose() {
        this.disposed = true;
        if (this.treeModel != null) {
            this.treeModel.dispose();
            this.treeModel = null;
        }
        if (this.brPanel != null) {
            this.brPanel.dispose();
            this.brPanel = null;
        }
        if (this.bgThread != null && this.bgThread.isAlive()) {
            this.bgThread.interrupt();
        }
        this.popup = null;
        this.lastPopupPath = null;
    }

    void setParameters(Parameters parameters) {
        Object object;
        if (parameters == null) {
            return;
        }
        String[] stringArray = null;
        if (this.params == null && this.stateMap != null) {
            object = (String)this.stateMap.get(OPEN_PATHS_PREF);
            if (object != null) {
                stringArray = StringArray.split((String)object);
            }
        } else {
            stringArray = this.getOpenPaths();
        }
        this.params = parameters;
        if (this.treeModel != null) {
            this.treeModel.setParameters(this.params);
        }
        if (this.tree != null) {
            this.tree.setParameters(this.params);
            this.treeRend.setParameters(this.params);
        }
        if (this.testPanel != null) {
            this.testPanel.setTestSuite(this.params.getTestSuite());
        }
        if (this.brPanel != null) {
            this.brPanel.setParameters(this.params);
        }
        object = this.getTestResultTable();
        if (stringArray != null && object != null) {
            Object[] objectArray = new TreePath[]{};
            for (int i = 0; i < stringArray.length; ++i) {
                Object object2 = ((TestResultTable)object).resolveUrl(stringArray[i]);
                TreePath treePath = this.nodeToPath(object2, (TestResultTable)object);
                if (treePath == null) continue;
                objectArray = (TreePath[])DynamicArray.append(objectArray, treePath);
            }
            TestTreePanel.restore((TreePath[])objectArray, this.tree);
        }
    }

    void save(Map map) {
        String[] stringArray = this.getOpenPaths();
        Preferences preferences = Preferences.access();
        map.put(OPEN_PATHS_PREF, StringArray.join(stringArray));
    }

    private String[] getOpenPaths() {
        if (this.tree == null) {
            return null;
        }
        TreePath[] treePathArray = this.tree.snapshotOpenPaths();
        TestResultTable testResultTable = this.getTestResultTable();
        Vector<String> vector = new Vector<String>();
        if (treePathArray != null && testResultTable != null) {
            for (int i = 0; i < treePathArray.length; ++i) {
                Object object = treePathArray[i].getLastPathComponent();
                String string = object instanceof TestResult ? ((TestResult)object).getTestName() : TestResultTable.getRootRelativePath((TestResultTable.TreeNode)object);
                vector.addElement(string);
            }
        }
        if (vector == null || vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private TreePath nodeToPath(Object object, TestResultTable testResultTable) {
        if (object instanceof TestResult) {
            TestResult testResult = (TestResult)object;
            TestResultTable.TreeNode[] treeNodeArray = TestResultTable.getObjectPath(testResult);
            Object[] objectArray = new Object[treeNodeArray.length + 1];
            System.arraycopy(treeNodeArray, 0, objectArray, 0, treeNodeArray.length);
            objectArray[objectArray.length - 1] = testResult;
            return new TreePath(objectArray);
        }
        Object[] objectArray = TestResultTable.getObjectPath((TestResultTable.TreeNode)object);
        if (objectArray != null && objectArray.length > 0) {
            return new TreePath(objectArray);
        }
        return null;
    }

    private void setPopupItemsEnabled(boolean bl) {
        if (bl) {
            boolean bl2 = this.params != null && this.params.getWorkDirectory() != null;
            this.purgeMI.setEnabled(bl2);
            this.refreshMI.setEnabled(this.params != null && this.params.getTestSuite() != null);
            this.runMI.setEnabled(bl2);
        } else {
            this.purgeMI.setEnabled(false);
            this.refreshMI.setEnabled(false);
            this.runMI.setEnabled(false);
        }
    }

    private void clearNodes(final TreePath[] treePathArray) {
        Object object;
        Object object2;
        int n;
        final WorkDirectory workDirectory = this.execModel.getWorkDirectory();
        if (workDirectory == null) {
            JOptionPane.showMessageDialog(this.parent, this.uif.getI18NString("treep.cantPurgeNoWd.msg"), this.uif.getI18NString("treep.cantPurgeNoWd.title"), 2);
            return;
        }
        if (this.harness.isRunning()) {
            JOptionPane.showMessageDialog(this.parent, this.uif.getI18NString("treep.cantPurgeRunning.msg"), this.uif.getI18NString("treep.cantPurgeRunning.title"), 2);
            return;
        }
        boolean bl = false;
        Object[] objectArray = new Object[treePathArray.length];
        if (treePathArray.length > 1) {
            int n2 = this.uif.showYesNoDialog("treep.purgeItemsSure", TestTreePanel.createNodeListString(TestTreePanel.createNodeList(treePathArray)));
            if (n2 == 1) {
                return;
            }
            bl = true;
            for (n = 0; n < treePathArray.length; ++n) {
                object2 = treePathArray[n].getLastPathComponent();
                if (object2 instanceof TestResult) {
                    objectArray[n] = ((TestResult)object2).getWorkRelativePath();
                    continue;
                }
                if (!(object2 instanceof TestResultTable.TreeNode)) continue;
                object = (TestResultTable.TreeNode)object2;
                if (object.isRoot()) {
                    objectArray = new Object[]{""};
                    break;
                }
                objectArray[n] = TestResultTable.getRootRelativePath((TestResultTable.TreeNode)object);
            }
        } else if (treePathArray[0].getLastPathComponent() instanceof TestResult) {
            TestResult testResult = (TestResult)treePathArray[0].getLastPathComponent();
            n = this.uif.showYesNoDialog("treep.purgeTestSure", testResult.getTestName());
            if (n == 1) {
                return;
            }
            bl = true;
            objectArray[0] = testResult.getWorkRelativePath();
        } else {
            TestResultTable.TreeNode treeNode = (TestResultTable.TreeNode)treePathArray[0].getLastPathComponent();
            n = 0;
            n = treeNode.isRoot() ? this.uif.showYesNoDialog("treep.purgeRootSure", TestResultTable.getRootRelativePath(treeNode)) : this.uif.showYesNoDialog("treep.purgeNodeSure", TestResultTable.getRootRelativePath(treeNode));
            if (n == 1) {
                return;
            }
            bl = true;
            objectArray[0] = TestResultTable.getRootRelativePath(treeNode);
        }
        if (bl) {
            final JDialog jDialog = this.uif.createWaitDialog("treep.waitPurge", this);
            final String[] stringArray = TestTreePanel.createNodeList(objectArray);
            this.setPopupItemsEnabled(false);
            object2 = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    for (int i = 0; i < treePathArray.length; ++i) {
                        for (int j = 0; j < stringArray.length; ++j) {
                            workDirectory.purge(stringArray[j]);
                        }
                        try {
                            EventQueue.invokeAndWait(new Runnable(this){
                                private final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                public void run() {
                                    if (1.access$100(this.this$1).isShowing()) {
                                        1.access$100(this.this$1).hide();
                                    }
                                    TestTreePanel.access$300(1.access$200(this.this$1), true);
                                }
                            });
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {}
                        continue;
                        catch (WorkDirectory.PurgeFault purgeFault) {
                            try {
                                I18NResourceBundle i18NResourceBundle = TestTreePanel.this.uif.getI18NResourceBundle();
                                workDirectory.log(i18NResourceBundle, "treep.purgeFail.err", purgeFault);
                            }
                            catch (Throwable throwable) {
                                try {
                                    EventQueue.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                                }
                                catch (InterruptedException interruptedException) {
                                }
                                catch (InvocationTargetException invocationTargetException) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                            try {
                                EventQueue.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            catch (InvocationTargetException invocationTargetException) {}
                            continue;
                        }
                    }
                }

                static /* synthetic */ JDialog access$100(1 var0) {
                    return var0.jDialog;
                }

                static /* synthetic */ TestTreePanel access$200(1 var0) {
                    return var0.TestTreePanel.this;
                }
            };
            object = new ActionListener((Thread)object2, jDialog){
                private final /* synthetic */ Thread val$t;
                private final /* synthetic */ JDialog val$d;
                {
                    this.val$t = thread;
                    this.val$d = jDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.val$t == null) {
                        return;
                    }
                    if (this.val$t.isAlive() && !this.val$d.isVisible()) {
                        this.val$d.show();
                    } else if (!this.val$t.isAlive() && this.val$d.isVisible()) {
                        this.val$d.hide();
                    }
                }
            };
            this.bgThread = object2;
            Timer timer = new Timer(3000, (ActionListener)object);
            timer.setRepeats(false);
            timer.start();
            ((Thread)object2).start();
        }
    }

    static String createNodeListString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("      ");
            stringBuffer.append(stringArray[i]);
            if (i + 1 >= stringArray.length) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    static String[] createNodeList(Object[] objectArray) {
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            Object object2 = objectArray[i];
            if (object2 instanceof TreePath) {
                object2 = ((TreePath)object2).getLastPathComponent();
            }
            if (object2 instanceof TestResult) {
                object = (TestResult)object2;
                stringArray[i] = ((TestResult)object).getTestName();
                continue;
            }
            if (object2 instanceof TestResultTable.TreeNode) {
                object = (TestResultTable.TreeNode)object2;
                stringArray[i] = TestResultTable.getRootRelativePath((TestResultTable.TreeNode)object);
                continue;
            }
            stringArray[i] = objectArray[i].toString();
        }
        return stringArray;
    }

    private void showNodeInfoDialog(TreePath treePath) {
        if (treePath.getLastPathComponent() instanceof TestResultTable.TreeNode) {
            TestResultTable.TreeNode treeNode = (TestResultTable.TreeNode)treePath.getLastPathComponent();
            Debug.println("info for this node not implemented" + treeNode.getName() + " (" + treeNode + ")");
        }
    }

    private void runNodes(TreePath[] treePathArray) {
        if (this.harness.isRunning()) {
            JOptionPane.showMessageDialog(this.parent, this.uif.getI18NString("treep.cantRunRunning.msg"), this.uif.getI18NString("treep.cantRunRunning.title"), 2);
            return;
        }
        this.execModel.runTests(TestTreePanel.createNodeList(treePathArray));
    }

    private static void restore(final TreePath[] treePathArray, final TestTree testTree) {
        if (treePathArray == null || testTree == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                testTree.restorePaths(treePathArray);
            }
        };
        EventQueue.invokeLater(runnable);
    }

    private void refreshNodes(TreePath[] treePathArray) {
        Object object;
        Object object2;
        int n;
        if (this.harness.isRunning()) {
            JOptionPane.showMessageDialog(this.parent, this.uif.getI18NString("treep.cantRefreshRunning.msg"), this.uif.getI18NString("treep.cantRefreshRunning.title"), 2);
            return;
        }
        final TestResultTable testResultTable = this.treeModel.getTestResultTable();
        boolean bl = false;
        Object[] objectArray = new Object[treePathArray.length];
        if (treePathArray.length > 1) {
            int n2 = this.uif.showYesNoDialog("treep.refreshNodeSure", TestTreePanel.createNodeListString(TestTreePanel.createNodeList(treePathArray)));
            if (n2 == 1) {
                return;
            }
            for (n = 0; n < treePathArray.length; ++n) {
                object2 = treePathArray[n].getLastPathComponent();
                if (object2 instanceof TestResult) {
                    objectArray[n] = ((TestResult)object2).getTestName();
                    continue;
                }
                if (!(object2 instanceof TestResultTable.TreeNode)) continue;
                object = (TestResultTable.TreeNode)object2;
                if (object.isRoot()) {
                    objectArray = new Object[]{null};
                    continue;
                }
                objectArray[n] = TestResultTable.getRootRelativePath((TestResultTable.TreeNode)object);
            }
        } else if (treePathArray[0].getLastPathComponent() instanceof TestResult) {
            TestResult testResult = (TestResult)treePathArray[0].getLastPathComponent();
            n = this.uif.showYesNoDialog("treep.refreshTestSure", testResult.getTestName());
            if (n == 1) {
                return;
            }
            bl = true;
            objectArray[0] = testResult.getTestName();
        } else {
            TestResultTable.TreeNode treeNode = (TestResultTable.TreeNode)treePathArray[0].getLastPathComponent();
            n = 1;
            n = treeNode.isRoot() ? this.uif.showYesNoDialog("treep.refreshRootSure") : this.uif.showYesNoDialog("treep.refreshNodeSure", TestResultTable.getRootRelativePath(treeNode));
            if (n == 1) {
                return;
            }
            bl = true;
            objectArray[0] = treeNode;
        }
        if (bl) {
            final JDialog jDialog = this.uif.createWaitDialog("treep.waitRef", this);
            final Object[] objectArray2 = objectArray;
            this.setPopupItemsEnabled(false);
            object2 = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        for (int i = 0; i < objectArray2.length; ++i) {
                            try {
                                if (objectArray2[i] instanceof String) {
                                    testResultTable.refreshIfNeeded((String)objectArray2[i]);
                                    continue;
                                }
                                testResultTable.refreshIfNeeded((TestResultTable.TreeNode)objectArray2[i]);
                                continue;
                            }
                            catch (TestResultTable.Fault fault) {
                                WorkDirectory workDirectory = TestTreePanel.this.execModel.getWorkDirectory();
                                if (workDirectory == null) continue;
                                I18NResourceBundle i18NResourceBundle = TestTreePanel.this.uif.getI18NResourceBundle();
                                workDirectory.log(i18NResourceBundle, "treep.refFail", new Object[]{objectArray2[i] instanceof String ? objectArray2[i] : TestResultTable.getRootRelativePath((TestResultTable.TreeNode)objectArray2[i]), fault.getMessage()});
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            EventQueue.invokeAndWait(new Runnable(this){
                                private final /* synthetic */ 5 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                public void run() {
                                    if (5.access$500(this.this$1).isShowing()) {
                                        5.access$500(this.this$1).hide();
                                    }
                                    TestTreePanel.access$300(5.access$600(this.this$1), true);
                                }
                            });
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        EventQueue.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {}
                }

                static /* synthetic */ JDialog access$500(5 var0) {
                    return var0.jDialog;
                }

                static /* synthetic */ TestTreePanel access$600(5 var0) {
                    return var0.TestTreePanel.this;
                }
            };
            object = new ActionListener((Thread)object2, jDialog){
                private final /* synthetic */ Thread val$t;
                private final /* synthetic */ JDialog val$d;
                {
                    this.val$t = thread;
                    this.val$d = jDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.val$t == null) {
                        return;
                    }
                    if (this.val$t.isAlive() && !this.val$d.isVisible()) {
                        this.val$d.show();
                    } else if (!this.val$t.isAlive() && this.val$d.isVisible()) {
                        this.val$d.hide();
                    }
                }
            };
            this.bgThread = object2;
            Timer timer = new Timer(3000, (ActionListener)object);
            timer.setRepeats(true);
            timer.start();
            ((Thread)object2).start();
        }
    }

    void updateGUI() {
        MenuElement[] menuElementArray;
        if (debug) {
            Debug.println("TTP.updateGUI()");
        }
        if (this.disposed) {
            return;
        }
        if (this.popup != null && this.params != null && (menuElementArray = this.popup.getSubElements()) != null) {
            boolean bl = this.params.getWorkDirectory() != null;
            this.purgeMI.setEnabled(bl);
            this.refreshMI.setEnabled(this.params.getTestSuite() != null);
            this.runMI.setEnabled(bl);
        }
        this.tree.updateGUI();
        this.brPanel.updateGUI();
    }

    private void initGUI() {
        JSplitPane jSplitPane;
        block3: {
            this.setName("treeAndDetails");
            jSplitPane = this.uif.createSplitPane(1);
            this.listener = new Listener();
            this.treeModel = new TestTreeModel(this.params, this.filterHandler, this.uif);
            this.treeRend = new TT_Renderer(this.uif, this.filterHandler, this.pm);
            this.tree = new TestTree(this.uif, this.pm, this.filterHandler, this.treeModel);
            this.tree.setTreeModel(this.treeModel);
            this.tree.setCellRenderer(this.treeRend);
            this.tree.addTreeSelectionListener(this.listener);
            this.tree.addTreeExpansionListener(this.listener);
            this.tree.addMouseListener(this.listener);
            this.tree.getSelectionModel().setSelectionMode(4);
            this.tree.getInputMap(1).put(KeyStroke.getKeyStroke(121, 1, false), "triggerPopup");
            this.tree.getActionMap().put("triggerPopup", new TreePopupAction(this.uif.getI18NResourceBundle(), "treep.popup"));
            this.uif.setAccessibleInfo(this.tree, "treep.tree");
            JPanel jPanel = this.uif.createPanel("tree", new BorderLayout(), false);
            jPanel.add((Component)this.uif.createScrollPane(this.tree, 20, 30), "Center");
            jSplitPane.setLeftComponent(jPanel);
            this.deck = new Deck(){

                public Dimension getPreferredSize() {
                    int n = TestTreePanel.this.uif.getDotsPerInch();
                    return new Dimension(6 * n, 4 * n);
                }
            };
            this.testPanel = new TestPanel(this.uif, this.harness);
            this.brPanel = new BranchPanel(this.uif, this.pm, this.harness, this.filterHandler, this.treeModel);
            this.msPanel = new MultiSelectPanel(this.uif, this.pm, this.treeModel);
            this.deck.add(this.testPanel);
            this.deck.add(this.brPanel);
            this.deck.add(this.msPanel);
            this.deckPanel = this.uif.createPanel("main", false);
            this.deckPanel.setLayout(new BorderLayout());
            this.deckPanel.add((Component)this.deck, "Center");
            this.titleField = this.uif.createOutputField("treep.title");
            this.titleField.setBorder(null);
            this.titleField.setText(this.uif.getI18NString("treep.title.noSelection.txt"));
            this.titleField.setBackground(MetalLookAndFeel.getPrimaryControlDarkShadow());
            this.titleField.setForeground(MetalLookAndFeel.getWindowBackground());
            FontUIResource fontUIResource = MetalLookAndFeel.getSystemTextFont();
            this.titleField.setFont(new Font(fontUIResource.getName(), fontUIResource.getStyle(), fontUIResource.getSize() * 5 / 4));
            this.titleField.setEnabled(true);
            this.titleField.setEditable(false);
            this.deckPanel.add((Component)this.titleField, "North");
            jSplitPane.setRightComponent(this.deckPanel);
            this.testPanel.setVisible(false);
            this.brPanel.setVisible(false);
            this.deck.setVisible(true);
            this.deckPanel.setVisible(true);
            jSplitPane.setDividerLocation(0.3);
            jSplitPane.setResizeWeight(0.3);
            if (this.tree.getSelectionPath() == null) {
                TreeModel treeModel = this.tree.getModel();
                try {
                    TestResultTable.TreeNode treeNode = (TestResultTable.TreeNode)treeModel.getRoot();
                    this.tree.setRootVisible(true);
                    EventQueue.invokeLater(new Selector(treeNode, new TreePath(treeNode)));
                }
                catch (ClassCastException classCastException) {
                    if (!debug) break block3;
                    classCastException.printStackTrace(Debug.getWriter());
                }
            }
        }
        this.popup = this.uif.createPopupMenu("treep.popup.mnu");
        this.runMI = this.uif.createMenuItem("treep.popup", "run", this.listener);
        this.popup.add(this.runMI);
        this.popup.addSeparator();
        this.refreshMI = this.uif.createMenuItem("treep.popup", "refresh", this.listener);
        this.popup.add(this.refreshMI);
        this.purgeMI = this.uif.createMenuItem("treep.popup", "clear", this.listener);
        this.popup.add(this.purgeMI);
        this.runMI.setEnabled(false);
        this.refreshMI.setEnabled(false);
        this.purgeMI.setEnabled(false);
        this.setLayout(new BorderLayout());
        this.add((Component)jSplitPane, "Center");
    }

    private void selectTest(TestResult testResult, TreePath treePath) {
        if (debug) {
            Debug.println("TTP showing: " + testResult);
            Debug.println("   -> path provided is " + treePath.getPathCount() + " components long.");
        }
        if (this.disposed) {
            if (debug) {
                Debug.println("TTP - selectTest() not running, panel is disposed.");
            }
            return;
        }
        if (!this.isPopulated()) {
            if (debug) {
                Debug.println("TTP - no data, cannot display a leaf. No action.");
            }
            return;
        }
        this.brPanel.setVisible(false);
        this.deck.show(this.testPanel);
        if (!this.tree.isPathSelected(treePath)) {
            this.tree.clearSelection();
            this.tree.setSelectionPath(treePath);
        }
        if (!this.tree.isVisible(treePath)) {
            this.tree.scrollPathToVisible(treePath);
        }
        if (testResult != this.testPanel.getTest()) {
            this.testPanel.setTest(testResult);
            this.activeTest = testResult.getTestName();
        }
        this.titleField.setText(this.uif.getI18NString("treep.test", testResult.getTestName()));
        this.testPanel.setVisible(true);
        this.tree.repaint();
        this.deckPanel.repaint();
    }

    private void selectBranch(TestResultTable.TreeNode treeNode, TreePath treePath) {
        if (debug) {
            Debug.println("TTP showing: " + treeNode.getName());
            Debug.println("   -> " + treeNode);
            Debug.println("   -> path provided is " + treePath.getPathCount() + " components long.");
        }
        if (this.disposed) {
            if (debug) {
                Debug.println("TTP - selectBranch() not running, panel is disposed.");
            }
            return;
        }
        if (!this.isPopulated()) {
            if (debug) {
                Debug.println("TTP - no data, cannot display a branch. No action.");
            }
            return;
        }
        if (this.deck.getCurrentCard() != this.brPanel) {
            this.deck.show(this.brPanel);
            this.testPanel.setVisible(false);
            this.activeTest = null;
        }
        if (!this.tree.isPathSelected(treePath)) {
            this.tree.clearSelection();
            this.tree.setSelectionPath(treePath);
        }
        if (!this.tree.isVisible(treePath)) {
            this.tree.scrollPathToVisible(treePath);
        }
        if (treeNode != this.brPanel.getNode()) {
            this.brPanel.setNode(treeNode);
            this.treeModel.setActiveNode(treeNode);
        }
        if (treeNode.isRoot()) {
            TestSuite testSuite = this.params.getTestSuite();
            String string = testSuite.getName();
            if (string != null) {
                this.titleField.setText(this.uif.getI18NString("treep.ts", string));
            } else {
                this.titleField.setText(this.uif.getI18NString("treep.ts", testSuite.getPath()));
            }
        } else {
            String string = TestResultTable.getRootRelativePath(treeNode);
            this.titleField.setText(this.uif.getI18NString("treep.node", string));
        }
        if (!this.brPanel.isVisible()) {
            this.brPanel.setVisible(true);
        }
        this.deckPanel.repaint();
        this.tree.repaint();
    }

    private void selectNodes(TreePath[] treePathArray) {
        if (!this.isPopulated()) {
            if (debug) {
                Debug.println("TTP - no data, cannot display selections. No action.");
            }
            return;
        }
        Object[] objectArray = new Object[treePathArray.length];
        for (int i = 0; i < treePathArray.length; ++i) {
            objectArray[i] = treePathArray[i].getLastPathComponent();
        }
        this.msPanel.setNodes(objectArray);
        if (this.deck.getCurrentCard() != this.msPanel) {
            this.deck.show(this.msPanel);
            this.activeTest = null;
        }
        this.titleField.setText(this.uif.getI18NString("treep.ms"));
        this.msPanel.setVisible(true);
        this.deckPanel.repaint();
    }

    private boolean isPopulated() {
        return this.params != null && this.params.getTestSuite() != null;
    }

    static /* synthetic */ void access$300(TestTreePanel testTreePanel, boolean bl) {
        testTreePanel.setPopupItemsEnabled(bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PanelModel
    implements TreePanelModel,
    Harness.Observer {
        private Hashtable runningTests;
        private Hashtable activeNodes;
        private Integer ONE = new Integer(1);

        PanelModel() {
            this.runningTests = new Hashtable();
            this.activeNodes = new Hashtable();
        }

        public void nodeSelected(Object object, TreePath treePath) {
        }

        public void testSelected(TestResult testResult, TreePath treePath) {
        }

        public void nodeUnSelected(Object object, TreePath treePath) {
        }

        public void testUnSelected(TestResult testResult, TreePath treePath) {
        }

        public void showNode(Object object, TreePath treePath) {
            TestTreePanel.this.selectBranch((TestResultTable.TreeNode)object, treePath);
        }

        public void showNode(String string) {
            TestResultTable testResultTable = this.getTestResultTable();
            if (testResultTable == null) {
                return;
            }
            TestResultTable.TreeNode treeNode = TestResultTable.findNode(testResultTable.getRoot(), string);
            if (treeNode != null) {
                TestTreePanel.this.selectBranch(treeNode, new TreePath(TestResultTable.getObjectPath(treeNode)));
            }
        }

        public void showTest(TestResult testResult, TreePath treePath) {
            TestTreePanel.this.selectTest(testResult, treePath);
        }

        public void showTest(TestResult testResult) {
            TestResultTable.TreeNode[] treeNodeArray = TestResultTable.getObjectPath(testResult);
            Object[] objectArray = new Object[treeNodeArray.length + 1];
            System.arraycopy(treeNodeArray, 0, objectArray, 0, treeNodeArray.length);
            objectArray[objectArray.length - 1] = testResult;
            this.showTest(testResult, new TreePath(objectArray));
        }

        public void showTest(String string) {
            TestResultTable testResultTable = this.getTestResultTable();
            if (testResultTable == null) {
                return;
            }
            TestResult testResult = testResultTable.lookup(TestResult.getWorkRelativePath(string));
            if (testResult != null) {
                this.showTest(testResult);
            }
        }

        public void hideNode(Object object, TreePath treePath) {
        }

        public void hideTest(TestResult testResult, TreePath treePath) {
        }

        public TestResultTable getTestResultTable() {
            return TestTreePanel.this.treeModel.getTestResultTable();
        }

        public String getSelectedTest() {
            return TestTreePanel.this.activeTest;
        }

        public boolean isActive(TestResult testResult) {
            return this.runningTests.containsKey(testResult.getTestName());
        }

        public boolean isActive(TestResultTable.TreeNode treeNode) {
            return this.activeNodes.containsKey(treeNode);
        }

        public void startingTestRun(Parameters parameters) {
            TestTreePanel.this.runMI.setEnabled(false);
            TestTreePanel.this.purgeMI.setEnabled(false);
            TestTreePanel.this.refreshMI.setEnabled(false);
        }

        public void startingTest(TestResult testResult) {
            if (TestTreePanel.this.treeModel == null) {
                return;
            }
            this.runningTests.put(testResult.getTestName(), testResult);
            TestResult testResult2 = TestTreePanel.this.treeModel.getTestResultTable().lookup(testResult.getWorkRelativePath());
            TestResultTable.TreeNode[] treeNodeArray = TestResultTable.getObjectPath(testResult2);
            for (int i = 0; i < treeNodeArray.length; ++i) {
                Object v = this.activeNodes.get(treeNodeArray[i]);
                if (v == null) {
                    this.activeNodes.put(treeNodeArray[i], this.ONE);
                    continue;
                }
                this.activeNodes.put(treeNodeArray[i], new Integer(1 + (Integer)v));
            }
            TestTreePanel.this.tree.repaint();
        }

        public void finishedTest(TestResult testResult) {
            if (TestTreePanel.this.treeModel == null) {
                return;
            }
            this.runningTests.remove(testResult.getTestName());
            TestResult testResult2 = TestTreePanel.this.treeModel.getTestResultTable().lookup(testResult.getWorkRelativePath());
            TestResultTable.TreeNode[] treeNodeArray = TestResultTable.getObjectPath(testResult2);
            if (testResult.getTestName().equals(TestTreePanel.this.activeTest)) {
                Object[] objectArray = new Object[treeNodeArray.length + 1];
                System.arraycopy(treeNodeArray, 0, objectArray, 0, treeNodeArray.length);
                objectArray[objectArray.length - 1] = testResult;
                TestTreePanel.this.selectTest(testResult, new TreePath(objectArray));
            }
            if (treeNodeArray != null) {
                for (int i = 0; i < treeNodeArray.length; ++i) {
                    Integer n;
                    Object v = this.activeNodes.get(treeNodeArray[i]);
                    if (v == null) continue;
                    if (v == this.ONE) {
                        this.activeNodes.remove(treeNodeArray[i]);
                        continue;
                    }
                    int n2 = (Integer)v;
                    TestResultTable.TreeNode treeNode = treeNodeArray[i];
                    if (n2 == 2) {
                        n = this.ONE;
                    } else {
                        Integer n3 = new Integer(--n2);
                        n = n3;
                    }
                    this.activeNodes.put(treeNode, n);
                }
            }
            TestTreePanel.this.tree.repaint();
        }

        public void stoppingTestRun() {
        }

        public void finishedTesting() {
        }

        public void finishedTestRun(boolean bl) {
            this.runningTests.clear();
            this.activeNodes.clear();
            TestTreePanel.this.runMI.setEnabled(true);
            TestTreePanel.this.purgeMI.setEnabled(true);
            TestTreePanel.this.refreshMI.setEnabled(true);
            TestTreePanel.this.tree.repaint();
        }

        public void error(String string) {
        }
    }

    private class TreePopupAction
    extends AbstractAction {
        private String name;
        private String desc;

        TreePopupAction(I18NResourceBundle i18NResourceBundle, String string) {
            this.desc = i18NResourceBundle.getString(string + ".desc");
            this.name = i18NResourceBundle.getString(string + ".act");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (TestTreePanel.this.disposed) {
                return;
            }
            TestTreePanel.this.lastPopupPath = TestTreePanel.this.tree.getSelectionPath();
            Rectangle rectangle = TestTreePanel.this.tree.getPathBounds(TestTreePanel.this.lastPopupPath);
            if (rectangle == null) {
                return;
            }
            TestTreePanel.this.popup.show(TestTreePanel.this.tree, rectangle.x + (int)rectangle.getWidth(), rectangle.y + (int)rectangle.getHeight());
        }

        public Object getValue(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            if (string.equals("Name")) {
                return this.name;
            }
            if (string.equals("ShortDescription")) {
                return this.desc;
            }
            return null;
        }
    }

    class Selector
    implements Runnable {
        private TreePath tp;
        private TestResult tr;
        private TestResultTable.TreeNode tn;

        Selector(TestResult testResult, TreePath treePath) {
            this.tr = testResult;
            this.tp = treePath;
        }

        Selector(TestResultTable.TreeNode treeNode, TreePath treePath) {
            this.tn = treeNode;
            this.tp = treePath;
        }

        public void run() {
            if (this.tr != null) {
                TestTreePanel.this.selectTest(this.tr, this.tp);
            } else {
                TestTreePanel.this.selectBranch(this.tn, this.tp);
            }
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    TreeSelectionListener,
    TreeExpansionListener {
        private int lastX;
        private int lastY;

        private Listener() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (treeSelectionEvent.getSource() == TestTreePanel.this.tree) {
                TreePath[] treePathArray = treeSelectionEvent.getPaths();
                TestTree testTree = (TestTree)treeSelectionEvent.getSource();
                this.dispatchSelection(testTree);
            }
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            TestResult[] testResultArray;
            if (TestTreePanel.this.disposed) {
                return;
            }
            TreePath treePath = treeExpansionEvent.getPath();
            TestResultTable.TreeNode treeNode = (TestResultTable.TreeNode)treePath.getLastPathComponent();
            TestResultTable.TreeNode[] treeNodeArray = treeNode.getTreeNodes();
            if (treeNodeArray != null) {
                for (int i = 0; i < treeNodeArray.length; ++i) {
                    TestTreePanel.this.treeModel.removeRelevantNode(treeNodeArray[i]);
                }
            }
            if ((testResultArray = treeNode.getTestResults()) != null) {
                for (int i = 0; i < testResultArray.length; ++i) {
                    TestTreePanel.this.treeModel.removeRelevantTest(testResultArray[i]);
                }
            }
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            TestResult[] testResultArray;
            if (TestTreePanel.this.disposed) {
                return;
            }
            TreePath treePath = treeExpansionEvent.getPath();
            TestResultTable.TreeNode treeNode = (TestResultTable.TreeNode)treePath.getLastPathComponent();
            TestResultTable.TreeNode[] treeNodeArray = treeNode.getTreeNodes();
            if (treeNodeArray != null) {
                for (int i = 0; i < treeNodeArray.length; ++i) {
                    TestTreePanel.this.treeModel.addRelevantNode(treeNodeArray[i]);
                }
            }
            if ((testResultArray = treeNode.getTestResults()) != null) {
                for (int i = 0; i < testResultArray.length; ++i) {
                    TestTreePanel.this.treeModel.addRelevantTest(testResultArray[i]);
                }
            }
        }

        private void dispatchSelection(TestTree testTree) {
            TreePath[] treePathArray = testTree.getSelectionPaths();
            if (treePathArray == null || treePathArray.length == 0) {
                return;
            }
            if (treePathArray.length == 1) {
                Object object = treePathArray[0].getLastPathComponent();
                if (object instanceof TestResult) {
                    TestTreePanel.this.selectTest((TestResult)object, treePathArray[0]);
                } else if (object instanceof TestResultTable.TreeNode) {
                    TestTreePanel.this.selectBranch((TestResultTable.TreeNode)object, treePathArray[0]);
                } else if (debug) {
                    Debug.println("Unknown node click target in TestTreePanel: ");
                    Debug.println("   => " + object);
                }
            } else {
                TestTreePanel.this.selectNodes(treePathArray);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && mouseEvent.getComponent() == TestTreePanel.this.tree) {
                this.lastX = mouseEvent.getX();
                this.lastY = mouseEvent.getY();
                TestTreePanel.this.popup.show(mouseEvent.getComponent(), this.lastX, this.lastY);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TreePath[] treePathArray = TestTreePanel.this.tree.getSelectionPaths();
            if (actionEvent.getActionCommand().equals("clear")) {
                if (treePathArray != null && treePathArray.length > 0) {
                    TestTreePanel.this.clearNodes(TestTreePanel.this.tree.getSelectionPaths());
                }
            } else if (actionEvent.getActionCommand().equals("run")) {
                if (treePathArray != null && treePathArray.length > 0) {
                    for (int i = 0; i < treePathArray.length; ++i) {
                        Object object;
                        if (treePathArray[i].getPathCount() > 1 || !((object = treePathArray[i].getPathComponent(0)) instanceof TestResultTable.TreeNode) || !((TestResultTable.TreeNode)object).isRoot()) continue;
                        treePathArray = new TreePath[]{new TreePath(object)};
                        break;
                    }
                    TestTreePanel.this.runNodes(treePathArray);
                }
            } else if (actionEvent.getActionCommand().equals("refresh") && treePathArray != null && treePathArray.length > 0) {
                TestTreePanel.this.refreshNodes(TestTreePanel.this.tree.getSelectionPaths());
            }
        }
    }
}

