/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.finder;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFinder;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.TreeSet;

public class ChameleonTestFinder
extends TestFinder {
    private File entryFile;
    private Entry[] entries;
    private boolean ignoreCase;
    private Entry currEntry;
    private ClassLoader loader;
    private Hashtable excludeList = new Hashtable();
    private static final String[] excludeNames = new String[]{"SCCS", "deleted_files"};
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$finder$ChameleonTestFinder == null ? (class$com$sun$javatest$finder$ChameleonTestFinder = ChameleonTestFinder.class$("com.sun.javatest.finder.ChameleonTestFinder")) : class$com$sun$javatest$finder$ChameleonTestFinder);
    static /* synthetic */ Class class$com$sun$javatest$finder$ChameleonTestFinder;

    public ChameleonTestFinder() {
        String string = System.getProperty("javatest.chameleon.ignoreCase");
        if (string != null) {
            this.ignoreCase = string.equals("true");
        } else {
            String string2 = System.getProperty("os.name");
            this.ignoreCase = string2.startsWith("Windows");
        }
        this.exclude(excludeNames);
    }

    public void exclude(String string) {
        this.excludeList.put(string, string);
    }

    public void exclude(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.excludeList.put(string, string);
        }
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public void init(String[] stringArray, File file, TestEnvironment testEnvironment) throws TestFinder.Fault {
        super.init(stringArray, file, testEnvironment);
        if (this.entryFile == null) {
            throw new TestFinder.Fault(i18n, "cham.noConfigFile");
        }
        if (!this.entryFile.isAbsolute()) {
            this.entryFile = new File(this.getRootDir(), this.entryFile.getPath());
        }
        this.readEntries(this.entryFile);
    }

    public void readEntries(File file) throws TestFinder.Fault {
        TreeSet<Entry> treeSet = new TreeSet<Entry>(new Comparator(){

            public int compare(Object object, Object object2) {
                int n = ((Entry)object).compareTo((Entry)object2);
                return -n;
            }
        });
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            int n = 0;
            while ((string = bufferedReader.readLine()) != null) {
                string = string.trim();
                ++n;
                if (string.startsWith("#") || string.length() == 0) continue;
                String[] stringArray = StringArray.split(string);
                if (stringArray.length < 2) {
                    throw new TestFinder.Fault(i18n, "cham.missingData", new Object[]{new Integer(n), string});
                }
                String string2 = stringArray[0];
                String string3 = stringArray[1];
                String[] stringArray2 = new String[stringArray.length - 2];
                System.arraycopy(stringArray, 2, stringArray2, 0, stringArray2.length);
                Entry entry = new Entry(string2, string3, stringArray2);
                treeSet.add(entry);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new TestFinder.Fault(i18n, "cham.cantFindFile", file);
        }
        catch (IOException iOException) {
            throw new TestFinder.Fault(i18n, "cham.ioError", new Object[]{file, iOException});
        }
        this.entryFile = file;
        this.entries = treeSet.toArray(new Entry[treeSet.size()]);
    }

    protected int decodeArg(String[] stringArray, int n) throws TestFinder.Fault {
        if (stringArray[n].equals("-f") && n + 1 < stringArray.length) {
            this.entryFile = new File(stringArray[n + 1]);
            return 2;
        }
        if (stringArray[n].equalsIgnoreCase("-ignoreCase")) {
            this.ignoreCase = true;
            return 1;
        }
        if (stringArray[n].equalsIgnoreCase("-dontIgnoreCase")) {
            this.ignoreCase = false;
            return 1;
        }
        return super.decodeArg(stringArray, n);
    }

    protected void scan(File file) {
        if (file.isDirectory()) {
            this.scanDirectory(file);
        } else {
            this.scanFile(file);
        }
    }

    public File[] getFiles() {
        if (this.currEntry == null) {
            return super.getFiles();
        }
        if (this.currEntry.finder == null) {
            return new File[0];
        }
        return this.currEntry.finder.getFiles();
    }

    public TestDescription[] getTests() {
        if (this.currEntry == null) {
            return super.getTests();
        }
        if (this.currEntry.finder == null) {
            return new TestDescription[0];
        }
        return this.currEntry.finder.getTests();
    }

    private void scanDirectory(File file) {
        this.currEntry = null;
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (this.excludeList.containsKey(string)) continue;
            this.foundFile(new File(file, string));
        }
    }

    private void scanFile(File file) {
        for (int i = 0; i < this.entries.length; ++i) {
            if (!this.entries[i].matches(file)) continue;
            this.currEntry = this.entries[i];
            this.currEntry.scanFile(file);
            return;
        }
        this.currEntry = null;
    }

    private Object newInstance(Class clazz) throws TestFinder.Fault {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new TestFinder.Fault(i18n, "cham.cantCreateClass", new Object[]{clazz.getName(), instantiationException});
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new TestFinder.Fault(i18n, "cham.cantAccessClass", new Object[]{clazz.getName(), illegalAccessException});
        }
    }

    private Class loadClass(String string) throws TestFinder.Fault {
        try {
            if (this.loader == null) {
                return Class.forName(string);
            }
            return this.loader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TestFinder.Fault(i18n, "cham.cantFindClass", new Object[]{string, classNotFoundException});
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TestFinder.Fault(i18n, "cham.badClassName", string);
        }
    }

    private TestEnvironment getEnv() {
        return this.env;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Entry {
        private String prefix;
        private String suffix;
        private String finderClassName;
        private String[] finderArgs;
        private TestFinder finder;
        private boolean initialized;

        Entry(String string, String string2, String[] stringArray) {
            int n = string.indexOf(42);
            if (n == -1) {
                this.prefix = string;
                this.suffix = null;
            } else {
                this.prefix = string.substring(0, n);
                this.suffix = string.substring(n + 1);
            }
            this.prefix = new File(ChameleonTestFinder.this.getRootDir(), this.prefix.replace('/', File.separatorChar)).getPath();
            if (this.suffix != null) {
                this.suffix = this.suffix.replace('/', File.separatorChar);
            }
            this.finderClassName = string2;
            this.finderArgs = stringArray;
        }

        boolean matches(File file) {
            String string = file.getPath();
            int n = string.length();
            int n2 = this.prefix.length();
            if (!string.regionMatches(ChameleonTestFinder.this.ignoreCase, 0, this.prefix, 0, n2)) {
                return false;
            }
            if (this.suffix != null) {
                int n3 = this.suffix.length();
                if (n3 > n) {
                    return false;
                }
                if (!string.regionMatches(ChameleonTestFinder.this.ignoreCase, n - n3, this.suffix, 0, n3)) {
                    return false;
                }
            }
            return true;
        }

        void scanFile(File file) {
            if (!this.initialized) {
                this.init();
            }
            if (this.finder != null) {
                this.finder.read(file);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init() {
            try {
                if (!this.finderClassName.equals("-")) {
                    this.finder = (TestFinder)ChameleonTestFinder.this.newInstance(ChameleonTestFinder.this.loadClass(this.finderClassName));
                    this.finder.init(this.finderArgs, ChameleonTestFinder.this.getRoot(), ChameleonTestFinder.this.getEnv());
                }
            }
            catch (TestFinder.Fault fault) {
                ChameleonTestFinder.this.error(i18n, "cham.cantInitClass", fault.getMessage());
            }
            finally {
                this.initialized = true;
            }
        }

        int compareTo(Entry entry) {
            int n;
            Entry entry2 = this;
            Entry entry3 = entry;
            int n2 = entry2.prefix.length();
            if (n2 < (n = entry3.prefix.length())) {
                return -1;
            }
            if (n2 == n) {
                int n3 = entry2.prefix.compareTo(entry3.prefix);
                if (n3 != 0) {
                    return n3;
                }
                String string = entry2.suffix;
                String string2 = entry3.suffix;
                if (string == null && string2 == null) {
                    return 0;
                }
                if (string == null) {
                    return -1;
                }
                if (string2 == null) {
                    return 1;
                }
                return string.compareTo(string2);
            }
            return 1;
        }
    }
}

