/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.finder;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFinder;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;

public class ShowTests {
    private TestFinder testFinder;
    private PrintStream out;
    private boolean nodes;
    private boolean fullTests;
    static /* synthetic */ Class class$com$sun$javatest$finder$ShowTests;

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                ShowTests.usage(System.out);
            } else {
                ShowTests showTests = new ShowTests();
                showTests.run(stringArray);
            }
        }
        catch (BadArgs badArgs) {
            System.err.println("Bad Arguments: " + badArgs.getMessage());
            ShowTests.usage(System.err);
            System.exit(1);
        }
        catch (Fault fault) {
            System.err.println("Error: " + fault.getMessage());
            System.exit(2);
        }
        catch (IOException iOException) {
            System.err.println("Error: " + iOException);
            System.exit(3);
        }
    }

    private static void usage(PrintStream printStream) {
        String string = System.getProperty("program", "java " + (class$com$sun$javatest$finder$ShowTests == null ? (class$com$sun$javatest$finder$ShowTests = ShowTests.class$("com.sun.javatest.finder.ShowTests")) : class$com$sun$javatest$finder$ShowTests).getName());
        printStream.println("Usage:");
        printStream.println("  " + string + " [options]  test-suite");
        printStream.println("Options:");
        printStream.println("  -finder finderClass finderArgs... -end");
        printStream.println("                          specify the test finder to be used");
        printStream.println("  -initial initial-file   specify a starting point (optional)");
        printStream.println("  -o output-file          output file (default is standard output)");
        printStream.println("  -nodes                  show nodes in the tree");
        printStream.println("  -fulltests              show contents of tests");
    }

    public void run(String[] stringArray) throws BadArgs, Fault, IOException {
        File file = null;
        String string = null;
        String[] stringArray2 = null;
        File file2 = null;
        File file3 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("-finder") && i + 1 < stringArray.length) {
                string = stringArray[++i];
                int n = ++i;
                while (i < stringArray.length - 1 && !stringArray[i].equalsIgnoreCase("-end")) {
                    ++i;
                }
                stringArray2 = new String[i - n];
                System.arraycopy(stringArray, n, stringArray2, 0, stringArray2.length);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-initial") && i + 1 < stringArray.length) {
                file3 = new File(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-o") && i + 1 < stringArray.length) {
                file2 = new File(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-nodes")) {
                this.nodes = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-fulltests")) {
                this.fullTests = true;
                continue;
            }
            if (stringArray[i].startsWith("-")) {
                throw new BadArgs(stringArray[i]);
            }
            file = new File(stringArray[i]);
        }
        if (string == null) {
            throw new BadArgs("no test finder specified");
        }
        if (file == null) {
            throw new BadArgs("testsuite.html file not specified");
        }
        this.testFinder = this.initializeTestFinder(string, stringArray2, file);
        if (file3 == null) {
            file3 = this.testFinder.getRoot();
        }
        this.out = file2 == null ? System.out : new PrintStream(new BufferedOutputStream(new FileOutputStream(file2)));
        this.list(file3);
    }

    private TestFinder initializeTestFinder(String string, String[] stringArray, File file) throws Fault {
        TestFinder testFinder;
        try {
            Class<?> clazz = Class.forName(string);
            testFinder = (TestFinder)clazz.newInstance();
            testFinder.init(stringArray, file, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Fault("Error: Can't find class for TestFinder specified");
        }
        catch (InstantiationException instantiationException) {
            throw new Fault("Error: Can't create new instance of TestFinder");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Fault("Error: Illegal Access Exception");
        }
        catch (TestFinder.Fault fault) {
            throw new Fault("Error: Can't initialize test-finder: " + fault.getMessage());
        }
        return testFinder;
    }

    private void list(File file) {
        int n;
        if (this.nodes) {
            this.out.println(file);
        }
        this.testFinder.read(file);
        TestDescription[] testDescriptionArray = this.testFinder.getTests();
        File[] fileArray = this.testFinder.getFiles();
        if (testDescriptionArray != null) {
            for (n = 0; n < testDescriptionArray.length; ++n) {
                TestDescription testDescription = testDescriptionArray[n];
                this.out.println("    " + testDescription.getRootRelativeURL());
                if (!this.fullTests) continue;
                Iterator iterator = testDescription.getParameterKeys();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    String string2 = testDescription.getParameter(string);
                    this.out.print("        ");
                    this.out.print(string);
                    this.pad(string, 15);
                    this.out.print(string2);
                    this.out.println();
                }
            }
        }
        if (fileArray != null) {
            for (n = 0; n < fileArray.length; ++n) {
                this.list(fileArray[n]);
            }
        }
    }

    void pad(String string, int n) {
        for (int i = string.length(); i < n; ++i) {
            this.out.write(32);
        }
        this.out.write(32);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class Fault
    extends Exception {
        Fault(String string) {
            super(string);
        }
    }

    public class BadArgs
    extends Exception {
        BadArgs(String string) {
            super(string);
        }
    }
}

