/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.httpd;

import com.sun.javatest.httpd.JThttpProvider;
import com.sun.javatest.httpd.PageGenerator;
import com.sun.javatest.httpd.RequestHandler;
import com.sun.javatest.httpd.RootRegistry;
import com.sun.javatest.httpd.httpURL;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class HttpdServer
implements Runnable {
    private static ServerSocket socket;
    private static String baseURL;
    private static final int MAX_PORT_SEARCH = 10;
    private static boolean active;
    protected static boolean debug;
    private static I18NResourceBundle i18n;
    static /* synthetic */ Class class$com$sun$javatest$httpd$HttpdServer;

    public HttpdServer() {
        try {
            this.init();
            active = true;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(i18n.getString("server.cantInit"));
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Socket socket = HttpdServer.socket.accept();
                    if (debug) {
                        System.out.println("httpd-New connection " + socket);
                    }
                    RequestHandler requestHandler = new RequestHandler(socket);
                    Thread thread = new Thread(requestHandler);
                    if (debug) {
                        System.out.println("httpd-Starting thread for connection ");
                    }
                    thread.start();
                }
            }
            catch (IOException iOException) {
                System.out.println(i18n.getString("server.errorInAccept"));
                iOException.printStackTrace(System.out);
                continue;
            }
            break;
        }
    }

    public static int getLocalPort() {
        if (socket == null) {
            throw new IllegalStateException();
        }
        return socket.getLocalPort();
    }

    public static boolean isActive() {
        return active;
    }

    private static String getBaseUrl() {
        return baseURL;
    }

    private void init() throws IOException {
        int n;
        if (debug) {
            System.out.println("Initializing JavaTest HTTP Server");
        }
        for (int i = n = Integer.getInteger("jt.httpd.port", 1903).intValue(); i < n + 10; ++i) {
            try {
                socket = new ServerSocket(i, 25);
                System.out.println(i18n.getString("server.port", String.valueOf(socket.getLocalPort())));
                StringBuffer stringBuffer = new StringBuffer("http://");
                stringBuffer.append(InetAddress.getLocalHost().getHostAddress());
                stringBuffer.append(":");
                stringBuffer.append(socket.getLocalPort());
                stringBuffer.append("/");
                baseURL = stringBuffer.toString();
                stringBuffer = null;
                System.out.println(i18n.getString("server.url", baseURL));
                break;
            }
            catch (BindException bindException) {
                if (i + 1 >= n + 10) {
                    throw bindException;
                }
                System.out.println(i18n.getString("server.portBusy", new Integer(i)));
                continue;
            }
            catch (IOException iOException) {
                System.out.println(i18n.getString("server.errorInInit"));
                throw iOException;
            }
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("Starting JavaTest httpd in debug mode.");
        JThttpProvider jThttpProvider = new JThttpProvider(){

            public void serviceRequest(httpURL httpURL2, PrintWriter printWriter) {
                PageGenerator.generateDocType(printWriter, 0);
                printWriter.println("<html>");
                printWriter.println("<Body>");
                printWriter.println("<h2>Hello, this is the JavaTest web server.</h2>");
                printWriter.println("Running in test mode, no harness.");
                printWriter.println("</Body>");
                printWriter.println("</html>");
                printWriter.close();
            }
        };
        RootRegistry.getInstance().addHandler("/", "Root JavaTest URL", jThttpProvider);
        HttpdServer httpdServer = new HttpdServer();
        debug = true;
        Thread thread = new Thread(httpdServer);
        thread.start();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        debug = Boolean.getBoolean("debug." + (class$com$sun$javatest$httpd$HttpdServer == null ? (class$com$sun$javatest$httpd$HttpdServer = HttpdServer.class$("com.sun.javatest.httpd.HttpdServer")) : class$com$sun$javatest$httpd$HttpdServer).getName());
        i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$httpd$HttpdServer == null ? (class$com$sun$javatest$httpd$HttpdServer = HttpdServer.class$("com.sun.javatest.httpd.HttpdServer")) : class$com$sun$javatest$httpd$HttpdServer);
    }
}

