/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.httpd;

import com.sun.javatest.httpd.JThttpProvider;
import com.sun.javatest.httpd.PageGenerator;
import com.sun.javatest.httpd.httpURL;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class ProviderRegistry {
    protected Hashtable url2prov = new Hashtable();
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$httpd$ProviderRegistry == null ? (class$com$sun$javatest$httpd$ProviderRegistry = ProviderRegistry.class$("com.sun.javatest.httpd.ProviderRegistry")) : class$com$sun$javatest$httpd$ProviderRegistry);
    protected static boolean debug = Boolean.getBoolean("debug." + (class$com$sun$javatest$httpd$ProviderRegistry == null ? (class$com$sun$javatest$httpd$ProviderRegistry = ProviderRegistry.class$("com.sun.javatest.httpd.ProviderRegistry")) : class$com$sun$javatest$httpd$ProviderRegistry).getName());
    protected JThttpProvider myProvider;
    static /* synthetic */ Class class$com$sun$javatest$httpd$ProviderRegistry;

    public void addHandler(String string, String string2, JThttpProvider jThttpProvider) {
        block4: {
            if (debug) {
                System.out.println("PR-Adding Handler: " + string2);
                System.out.println("   PR-Adding URL: " + string);
                System.out.println("   PR-Adding OBJ: " + jThttpProvider);
            }
            try {
                boolean bl = this.insertHandler(this.disassembleURL(string), string2, jThttpProvider, false);
                if (bl) {
                    jThttpProvider.addRegistredURL(string);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!debug) break block4;
                System.out.println("   PR-Error while inserting " + jThttpProvider);
                System.out.println("   PR-Ignoring insert of URL " + string);
                illegalArgumentException.printStackTrace();
            }
        }
    }

    public void addPrivateHandler(String string, String string2, JThttpProvider jThttpProvider) {
        block4: {
            if (debug) {
                System.out.println("PR-Adding Private Handler: " + string2);
                System.out.println("   PR-Adding URL: " + string);
                System.out.println("   PR-Adding OBJ: " + jThttpProvider);
            }
            try {
                boolean bl = this.insertHandler(this.disassembleURL(string), string2, jThttpProvider, true);
                if (bl) {
                    jThttpProvider.addRegistredURL(string);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!debug) break block4;
                System.out.println("   PR-Error while inserting " + jThttpProvider);
                System.out.println("   PR-Ignoring insert of URL " + string);
                illegalArgumentException.printStackTrace();
            }
        }
    }

    public boolean removeHandler(String string, JThttpProvider jThttpProvider) {
        if (debug) {
            System.out.println("PR-Removing Handler by URL: " + string);
            System.out.println("   PR-Removing OBJ : " + jThttpProvider);
        }
        return this.deleteHandler(this.disassembleURL(string), jThttpProvider);
    }

    public void removeHandler(JThttpProvider jThttpProvider) {
        if (debug) {
            System.out.println("PR-Removing Handler by Object: " + jThttpProvider);
        }
        String[] stringArray = jThttpProvider.getRegisteredURLs();
        for (int i = 0; i < stringArray.length; ++i) {
            this.deleteHandler(this.disassembleURL(stringArray[i]), jThttpProvider);
        }
    }

    public JThttpProvider getHandler(httpURL httpURL2) {
        JThttpProvider jThttpProvider;
        if (httpURL2 == null) {
            return null;
        }
        String string = httpURL2.getNextFile();
        if (string == null) {
            if (debug) {
                System.out.println("PR-End of URL, no handler, using default.");
            }
            jThttpProvider = null;
        } else {
            Object v;
            if (debug) {
                System.out.println("PR-Looking up: " + string);
            }
            if ((v = this.url2prov.get(string)) == null) {
                jThttpProvider = null;
            } else if (v instanceof HandlerEntry) {
                HandlerEntry handlerEntry = (HandlerEntry)v;
                jThttpProvider = handlerEntry.getProvider();
            } else {
                jThttpProvider = ((ProviderRegistry)v).getHandler(httpURL2);
            }
        }
        if (debug) {
            System.out.println("PR-URL resolved to: " + jThttpProvider);
        }
        return jThttpProvider == null ? this.getIndexProvider() : jThttpProvider;
    }

    public JThttpProvider getIndexProvider() {
        if (this.myProvider == null) {
            this.myProvider = new IndexHandler(this.url2prov);
        }
        return this.myProvider;
    }

    public int getSize() {
        return this.url2prov.size();
    }

    public boolean isEmpty() {
        return this.url2prov.size() == 0;
    }

    protected Object lookupByName(String string) {
        Object v = this.url2prov.get(string);
        if (debug) {
            System.out.println("PR-lookupName(" + string + "): " + v);
        }
        return v;
    }

    protected void deleteByName(String string) {
        Object v = this.url2prov.remove(string);
        if (debug) {
            System.out.println("PR-Removed " + string + " from hashtable." + v);
        }
    }

    static String stripDirName(String string) {
        if (string == null) {
            return null;
        }
        int n = 0;
        if (string.charAt(0) == '/') {
            n = 1;
        }
        int n2 = string.indexOf(47, n);
        String string2 = null;
        string2 = n2 != -1 ? string.substring(n, n2) : string.substring(n, string.length());
        return string2;
    }

    protected final boolean insertHandler(String[] stringArray, String string, JThttpProvider jThttpProvider, boolean bl) throws IllegalArgumentException {
        boolean bl2;
        Object object;
        String string2 = stringArray[0];
        stringArray = (String[])DynamicArray.remove((Object[])stringArray, 0);
        if (debug) {
            System.out.println("    PR-Partial insert of " + string2);
        }
        if ((object = this.lookupByName(string2)) == null) {
            if (stringArray == null || stringArray.length == 0) {
                this.url2prov.put(string2, new HandlerEntry(string2, string, jThttpProvider));
                if (debug) {
                    System.out.println("    Inserted " + string2 + " into " + this);
                }
                bl2 = true;
            } else {
                ProviderRegistry providerRegistry = new ProviderRegistry();
                this.url2prov.put(string2, providerRegistry);
                bl2 = providerRegistry.insertHandler(stringArray, string, jThttpProvider, bl);
                if (debug) {
                    System.out.println("    Created new registry and recursed, " + string2);
                }
            }
        } else if (object instanceof ProviderRegistry) {
            if (debug) {
                System.out.println("    Found existing registry and recursed, " + string2);
            }
            bl2 = ((ProviderRegistry)object).insertHandler(stringArray, string, jThttpProvider, bl);
        } else {
            throw new IllegalArgumentException("Supplied URL collides with another registred handler.  Ignoring new handler.");
        }
        return bl2;
    }

    protected final boolean deleteHandler(String[] stringArray, JThttpProvider jThttpProvider) {
        Object object;
        if (stringArray.length == 0) {
            if (debug) {
                System.out.println("    PR-(del) Reached end of URL before done.");
            }
            return false;
        }
        String string = stringArray[0];
        stringArray = (String[])DynamicArray.remove((Object[])stringArray, 0);
        if (debug) {
            System.out.println("    PR-(del)Partial remove of " + string);
        }
        if ((object = this.lookupByName(string)) == null) {
            if (debug) {
                System.out.println("    PR-(del) Unable to match URL at: " + string);
            }
            return false;
        }
        if (object instanceof HandlerEntry) {
            HandlerEntry handlerEntry = (HandlerEntry)object;
            if (handlerEntry.getProvider() == jThttpProvider) {
                this.deleteByName(string);
                return true;
            }
            throw new IllegalArgumentException("Given Provider ref. does not match URL Provider.  Unable to complete handler removal.");
        }
        if (object instanceof ProviderRegistry) {
            ProviderRegistry providerRegistry;
            boolean bl;
            if (debug) {
                System.out.println("    PR-(del) Found existing registry and recursed, " + string);
            }
            if ((bl = (providerRegistry = (ProviderRegistry)object).deleteHandler(stringArray, jThttpProvider)) && providerRegistry.isEmpty()) {
                this.deleteByName(string);
                return true;
            }
            return false;
        }
        throw new IllegalArgumentException("Unknown object found in registry.  Unable to complete handler removal.");
    }

    final String[] disassembleURL(String string) {
        int n;
        Object[] objectArray = new String[]{};
        if (string == null || string.length() == 0) {
            return objectArray;
        }
        int n2 = string.length();
        int n3 = string.charAt(0) == '/' ? 1 : 0;
        boolean bl = false;
        block4: for (n = n3 + 1; n < n2 && !bl; ++n) {
            char c = string.charAt(n);
            switch (c) {
                case '/': {
                    if (n > n3 + 1) {
                        objectArray = (String[])DynamicArray.append(objectArray, string.substring(n3, n));
                    }
                    n3 = n + 1;
                    ++n;
                    continue block4;
                }
                case ' ': 
                case '?': {
                    bl = true;
                }
            }
        }
        if (!bl && n >= n2 && n - n3 >= 1) {
            objectArray = (String[])DynamicArray.append(objectArray, string.substring(n3, n));
        }
        if (debug) {
            System.out.println("PR-Dissolved url " + string + " into " + objectArray.length + " files.");
        }
        return objectArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class IndexHandler
    extends JThttpProvider {
        private Hashtable urlMap;

        IndexHandler(Hashtable hashtable) {
            this.urlMap = hashtable;
        }

        public void serviceRequest(httpURL httpURL2, PrintWriter printWriter) {
            PageGenerator.generateDocType(printWriter, 0);
            PageGenerator.writeBeginDoc(printWriter);
            PageGenerator.writeHeader(printWriter, "JavaTest Webserver Root Page");
            PageGenerator.startBody(printWriter);
            printWriter.print("<h2>JavaTest");
            printWriter.print("&#8482; ");
            IndexHandler.print(printWriter, i18n.getString("provider.index.hdr"));
            printWriter.println("</h2>");
            IndexHandler.println(printWriter, i18n.getString("provider.index.note"));
            printWriter.println("<br>");
            this.writeWebAvailPages(printWriter);
            printWriter.println("<hr>");
            PageGenerator.writeFooter(printWriter);
            PageGenerator.endBody(printWriter);
            PageGenerator.writeEndDoc(printWriter);
            printWriter.close();
        }

        private void writeWebAvailPages(PrintWriter printWriter) {
            printWriter.println("<h3>Available Web Pages</h3>");
            printWriter.println("<ul>");
            Enumeration enumeration = this.urlMap.elements();
            while (enumeration.hasMoreElements()) {
                Object v = enumeration.nextElement();
                if (!(v instanceof HandlerEntry)) continue;
                HandlerEntry handlerEntry = (HandlerEntry)v;
                printWriter.print("<li><a href=\"");
                printWriter.print(handlerEntry.getURL());
                printWriter.print("\">");
                printWriter.print(handlerEntry.getDescription());
                printWriter.println("</a>");
            }
            printWriter.println("</ul>");
            printWriter.println();
        }
    }

    private static class HandlerEntry {
        private String url;
        private String descrip;
        private JThttpProvider obj;
        private boolean hidden;

        HandlerEntry(String string, String string2, JThttpProvider jThttpProvider) {
            this.url = string;
            this.descrip = string2;
            this.obj = jThttpProvider;
        }

        public void setPrivate(boolean bl) {
            this.hidden = bl;
        }

        public String getURL() {
            return this.url;
        }

        public String getDescription() {
            return this.descrip;
        }

        public JThttpProvider getProvider() {
            return this.obj;
        }
    }
}

