/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.lib;

import com.sun.javatest.Command;
import com.sun.javatest.Status;
import com.sun.javatest.util.PathClassLoader;
import com.sun.javatest.util.WriterStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class JavaCompileCommand
extends Command {
    public static boolean defaultVerbose = Boolean.getBoolean("javatest.JavaCompileCommand.verbose");
    private boolean verbose = defaultVerbose;
    private PrintWriter log;
    private static final Status passed = Status.passed("Compilation successful");
    private static final Status failed = Status.failed("Compilation failed");
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$io$PrintWriter;
    static /* synthetic */ Class class$java$io$OutputStream;
    static /* synthetic */ Class class$java$lang$String;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Status status;
        PrintWriter printWriter = new PrintWriter(System.out);
        PrintWriter printWriter2 = new PrintWriter(System.err);
        try {
            JavaCompileCommand javaCompileCommand = new JavaCompileCommand();
            status = javaCompileCommand.run(stringArray, printWriter, printWriter2);
        }
        finally {
            printWriter.flush();
            printWriter2.flush();
        }
        status.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status run(String[] stringArray, PrintWriter printWriter, PrintWriter printWriter2) {
        Object object;
        int n;
        if (stringArray.length == 0) {
            return Status.error("No args supplied");
        }
        Object object2 = null;
        String string = null;
        String string2 = null;
        String[] stringArray2 = null;
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equals("-")) continue;
            stringArray2 = new String[n];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
            stringArray = JavaCompileCommand.shift(stringArray, n + 1);
            break;
        }
        if (stringArray2 != null) {
            for (n = 0; n < stringArray2.length; ++n) {
                if (stringArray2[n].equals("-compiler")) {
                    int n2;
                    if (n + 1 == stringArray2.length) {
                        return Status.error("No compiler specified after -compiler option");
                    }
                    if ((n2 = ((String)(object = stringArray2[++n])).indexOf(":")) == -1) {
                        object2 = object;
                        string = "java " + (String)object;
                        continue;
                    }
                    object2 = ((String)object).substring(n2 + 1);
                    string = ((String)object).substring(0, n2);
                    continue;
                }
                if (stringArray2[n].equals("-cp") || stringArray2[n].equals("-classpath")) {
                    if (n + 1 == stringArray2.length) {
                        return Status.error("No path specified after -cp or -classpath option");
                    }
                    string2 = stringArray2[++n];
                    continue;
                }
                if (stringArray2[n].equals("-verbose")) {
                    this.verbose = true;
                    continue;
                }
                return Status.error("Unrecognized option: " + stringArray2[n]);
            }
        }
        this.log = printWriter;
        try {
            Object[] objectArray;
            Object object3;
            Object var12_17;
            Object[] objectArray2;
            PathClassLoader pathClassLoader = string2 == null ? null : new PathClassLoader(string2);
            if (object2 != null) {
                object = this.getClass(pathClassLoader, (String)object2);
                if (object == null) {
                    Status status = Status.error("Cannot find compiler: " + object2);
                    return status;
                }
            } else {
                string = "javac";
                object = this.getClass(pathClassLoader, "com.sun.tools.javac.Main");
                if (object == null) {
                    object = this.getClass(pathClassLoader, "sun.tools.javac.Main");
                }
                if (object == null) {
                    Status status = Status.error("Cannot find compiler");
                    return status;
                }
            }
            pathClassLoader = null;
            Method method = this.getMethod((Class)object, "compile", new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = JavaCompileCommand.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, class$java$io$PrintWriter == null ? (class$java$io$PrintWriter = JavaCompileCommand.class$("java.io.PrintWriter")) : class$java$io$PrintWriter});
            if (method != null) {
                objectArray2 = new Object[]{stringArray, printWriter2};
            } else {
                method = this.getMethod((Class)object, "compile", new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = JavaCompileCommand.class$("[Ljava.lang.String;")) : array$Ljava$lang$String});
                if (method != null) {
                    objectArray2 = new Object[]{stringArray};
                } else {
                    Status status = Status.error("Cannot find compile method for " + ((Class)object).getName());
                    return status;
                }
            }
            if (Modifier.isStatic(method.getModifiers())) {
                var12_17 = null;
            } else {
                object3 = this.getConstructor((Class)object, new Class[]{class$java$io$OutputStream == null ? (class$java$io$OutputStream = JavaCompileCommand.class$("java.io.OutputStream")) : class$java$io$OutputStream, class$java$lang$String == null ? (class$java$lang$String = JavaCompileCommand.class$("java.lang.String")) : class$java$lang$String});
                if (object3 != null) {
                    objectArray = new Object[]{new WriterStream(printWriter2), string};
                } else {
                    object3 = this.getConstructor((Class)object, new Class[0]);
                    if (object3 != null) {
                        objectArray = new Object[]{};
                    } else {
                        Status status = Status.error("Cannot find suitable constructor for " + ((Class)object).getName());
                        return status;
                    }
                }
                try {
                    var12_17 = ((Constructor)object3).newInstance(objectArray);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(printWriter);
                    Status status = Status.error("Cannot instantiate compiler");
                    printWriter.flush();
                    printWriter2.flush();
                    return status;
                }
            }
            try {
                objectArray = method.invoke(var12_17, objectArray2);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(printWriter);
                Status status = Status.error("Error invoking compiler");
                printWriter.flush();
                printWriter2.flush();
                return status;
            }
            if (objectArray instanceof Boolean) {
                boolean bl = (Boolean)objectArray;
                Status status = bl ? passed : failed;
                return status;
            }
            if (objectArray instanceof Integer) {
                int n3 = (Integer)objectArray;
                Status status = n3 == 0 ? passed : failed;
                return status;
            }
            object3 = Status.error("Unexpected return value from compiler: " + objectArray);
            return object3;
        }
        finally {
            printWriter.flush();
            printWriter2.flush();
        }
    }

    private Class getClass(ClassLoader classLoader, String string) {
        try {
            return classLoader == null ? Class.forName(string) : classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private Constructor getConstructor(Class clazz, Class[] classArray) {
        try {
            return clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (Throwable throwable) {
            if (this.verbose) {
                throwable.printStackTrace(this.log);
            }
            return null;
        }
    }

    private Method getMethod(Class clazz, String string, Class[] classArray) {
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (Throwable throwable) {
            if (this.verbose) {
                throwable.printStackTrace(this.log);
            }
            return null;
        }
    }

    private static String[] shift(String[] stringArray, int n) {
        String[] stringArray2 = new String[stringArray.length - n];
        System.arraycopy(stringArray, n, stringArray2, 0, stringArray2.length);
        return stringArray2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

