/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.interview.WizPrint;
import com.sun.javatest.ExcludeList;
import com.sun.javatest.Keywords;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.report.HTMLReport;
import com.sun.javatest.report.HTMLSection;
import com.sun.javatest.report.Report;
import com.sun.javatest.report.ReportWriter;
import com.sun.javatest.report.StringArrayComparator;
import com.sun.javatest.util.StringArray;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;

class ConfigSection
extends HTMLSection {
    ConfigSection(HTMLReport hTMLReport, Report.Settings settings, File file) {
        super(HTMLSection.i18n.getString("config.title"), settings, file, hTMLReport);
    }

    void writeContents(ReportWriter reportWriter) throws IOException {
        super.writeContents(reportWriter);
        if (this.settings.isQuestionLogEnabled()) {
            reportWriter.startTag("ul");
            reportWriter.startTag("li");
            reportWriter.writeLink(HTMLReport.files[2], HTMLSection.i18n.getString("config.confInterview"));
            reportWriter.endTag("li");
            reportWriter.endTag("ul");
        }
        if (this.settings.isStdEnabled()) {
            reportWriter.startTag("ul");
            reportWriter.startTag("li");
            reportWriter.writeLink("#" + HTMLReport.anchors[0], HTMLSection.i18n.getString("config.selectValue"));
            reportWriter.endTag("li");
            if (this.settings.isEnvEnabled()) {
                reportWriter.startTag("li");
                reportWriter.writeLink("#" + HTMLReport.anchors[1], HTMLSection.i18n.getString("config.execValue"));
                reportWriter.endTag("li");
            }
            reportWriter.startTag("li");
            reportWriter.writeLink("#" + HTMLReport.anchors[2], HTMLSection.i18n.getString("config.locValue"));
            reportWriter.endTag("li");
            reportWriter.endTag("ul");
        }
    }

    void writeSummary(ReportWriter reportWriter) throws IOException {
        super.writeSummary(reportWriter);
        reportWriter.startTag("table");
        reportWriter.writeAttr("border", 1);
        reportWriter.startTag("tr");
        reportWriter.writeTH(HTMLSection.i18n.getString("config.testSuite"), "row");
        reportWriter.startTag("td");
        TestSuite testSuite = this.settings.ip.getTestSuite();
        if (testSuite != null) {
            reportWriter.writeLink(testSuite.getRoot());
        } else {
            reportWriter.write(HTMLSection.i18n.getString("config.noTestSuite"));
        }
        reportWriter.endTag("td");
        reportWriter.endTag("tr");
        reportWriter.endTag("table");
        if (this.settings.isStdEnabled()) {
            this.writeStdValSummary(reportWriter);
        }
        if (this.settings.isEnvEnabled()) {
            this.writeExecutionSummary(reportWriter);
        }
        this.writeLocationSummary(reportWriter);
    }

    void writeExtraFiles() throws IOException {
        if (this.settings.isQuestionLogEnabled()) {
            this.writeConfigInterview();
        }
        if (this.settings.isEnvEnabled()) {
            this.writeEnvironment();
        }
        if (this.settings.isStdEnabled()) {
            this.writeExcludeList();
        }
    }

    private void writeStdValSummary(ReportWriter reportWriter) throws IOException {
        Object object;
        String[] stringArray;
        reportWriter.startTag("h3");
        reportWriter.writeLinkDestination(HTMLReport.anchors[0], HTMLSection.i18n.getString("config.selectValue"));
        reportWriter.endTag("h3");
        reportWriter.startTag("table");
        reportWriter.writeAttr("border", 1);
        TestSuite testSuite = this.settings.ip.getTestSuite();
        String[] stringArray2 = this.settings.ip.getTests();
        reportWriter.startTag("tr");
        reportWriter.writeTH(HTMLSection.i18n.getString("config.tests.hdr"), "row");
        reportWriter.startTag("td");
        if (stringArray2 != null && stringArray2.length > 0) {
            for (int i = 0; i < stringArray2.length; ++i) {
                if (i > 0) {
                    reportWriter.startTag("br");
                }
                stringArray = new File(testSuite.getTestsDir(), stringArray2[i]);
                reportWriter.writeLink((File)stringArray, stringArray2[i]);
            }
        } else {
            reportWriter.write(HTMLSection.i18n.getString("config.tests.all"));
        }
        reportWriter.endTag("td");
        reportWriter.endTag("tr");
        reportWriter.startTag("tr");
        reportWriter.writeTH(HTMLSection.i18n.getString("config.previous.hdr"), "row");
        boolean[] blArray = this.settings.ip.getPriorStatusValues();
        if (blArray != null) {
            stringArray = new String[]{HTMLSection.i18n.getString("config.status.passed"), HTMLSection.i18n.getString("config.status.failed"), HTMLSection.i18n.getString("config.status.error"), HTMLSection.i18n.getString("config.status.notRun")};
            object = new StringBuffer();
            for (int i = 0; i < blArray.length; ++i) {
                if (!blArray[i]) continue;
                if (((StringBuffer)object).length() > 0) {
                    ((StringBuffer)object).append(" or ");
                }
                ((StringBuffer)object).append(stringArray[i]);
            }
            reportWriter.writeTD(((StringBuffer)object).toString());
        } else {
            reportWriter.writeTD(HTMLSection.i18n.getString("config.previous.none"));
        }
        reportWriter.endTag("tr");
        reportWriter.startTag("tr");
        reportWriter.writeTH(HTMLSection.i18n.getString("config.excludeTests"), "row");
        reportWriter.startTag("td");
        stringArray = this.settings.ip.getExcludeList();
        if (stringArray != null) {
            reportWriter.writeI18N("config.entries", new Object[]{new Integer(stringArray.size())});
            object = this.settings.ip.getExcludeListParameters();
            File[] fileArray = null;
            if (object instanceof Parameters.MutableExcludeListParameters) {
                fileArray = ((Parameters.MutableExcludeListParameters)object).getExcludeFiles();
            }
            if (fileArray != null && fileArray.length > 0) {
                for (int i = 0; i < fileArray.length; ++i) {
                    reportWriter.startTag("br");
                    reportWriter.writeLink(HTMLReport.files[4], fileArray[i].getPath());
                }
            }
        } else {
            reportWriter.write(HTMLSection.i18n.getString("config.jtx.nofiles"));
        }
        reportWriter.endTag("td");
        reportWriter.endTag("tr");
        int n = this.settings.ip.getConcurrency();
        reportWriter.startTag("tr");
        reportWriter.writeTH(HTMLSection.i18n.getString("config.concurrency"), "row");
        reportWriter.startTag("td");
        reportWriter.write(Integer.toString(n));
        reportWriter.endTag("td");
        reportWriter.endTag("tr");
        float f = this.settings.ip.getTimeoutFactor();
        reportWriter.startTag("tr");
        reportWriter.writeTH(HTMLSection.i18n.getString("config.timeOut"), "row");
        reportWriter.startTag("td");
        reportWriter.write(NumberFormat.getInstance().format(f));
        reportWriter.endTag("td");
        reportWriter.endTag("tr");
        reportWriter.startTag("tr");
        reportWriter.writeTH(HTMLSection.i18n.getString("config.keywords.hdr"), "row");
        Keywords keywords = this.settings.ip.getKeywords();
        if (keywords != null) {
            reportWriter.writeTD(this.settings.ip.getKeywords().toString());
        } else {
            reportWriter.writeTD(HTMLSection.i18n.getString("config.keywords.none"));
        }
        reportWriter.endTag("tr");
        reportWriter.endTag("table");
    }

    private void writeExecutionSummary(ReportWriter reportWriter) throws IOException {
        TestEnvironment testEnvironment;
        String string;
        Object object;
        reportWriter.startTag("h3");
        reportWriter.writeLinkDestination(HTMLReport.anchors[1], HTMLSection.i18n.getString("config.execValue"));
        reportWriter.endTag("h3");
        reportWriter.startTag("table");
        reportWriter.writeAttr("border", 1);
        File[] fileArray = null;
        if (this.settings.isQuestionLogEnabled()) {
            reportWriter.startTag("tr");
            reportWriter.writeTH(HTMLSection.i18n.getString("config.configInterview"), "row");
            reportWriter.startTag("td");
            object = this.settings.ip.getName();
            if (object == null) {
                reportWriter.writeLink(HTMLReport.files[2], HTMLSection.i18n.getString("config.confInterview"));
            } else {
                reportWriter.writeLink(HTMLReport.files[2], (String)object);
            }
            if (!this.settings.ip.isValid()) {
                reportWriter.writeWarning(HTMLSection.i18n.getString("config.intIncomplete"));
            }
            reportWriter.endTag("td");
            reportWriter.endTag("tr");
        }
        if ((object = this.settings.ip.getEnvParameters()) != null && object instanceof Parameters.LegacyEnvParameters && (fileArray = ((Parameters.LegacyEnvParameters)object).getEnvFiles()) != null) {
            reportWriter.startTag("tr");
            reportWriter.writeTH(HTMLSection.i18n.getString("config.envFiles"), "row");
            reportWriter.startTag("td");
            for (int i = 0; i < fileArray.length; ++i) {
                reportWriter.writeLink(new File(fileArray[i].getPath()));
                reportWriter.startTag("br");
            }
            reportWriter.endTag("td");
            reportWriter.endTag("tr");
        }
        String string2 = string = (testEnvironment = this.settings.ip.getEnv()) != null ? testEnvironment.getName() : null;
        if (string != null && string.length() > 0) {
            reportWriter.startTag("tr");
            reportWriter.writeTH(HTMLSection.i18n.getString("config.env"), "row");
            reportWriter.startTag("td");
            reportWriter.writeLink(HTMLReport.files[3], string);
            reportWriter.endTag("td");
            reportWriter.endTag("tr");
        }
        reportWriter.endTag("table");
    }

    private void writeLocationSummary(ReportWriter reportWriter) throws IOException {
        WorkDirectory workDirectory = this.settings.ip.getWorkDirectory();
        reportWriter.startTag("h3");
        reportWriter.writeLinkDestination(HTMLReport.anchors[2], HTMLSection.i18n.getString("config.locValue"));
        reportWriter.endTag("h3");
        reportWriter.startTag("table");
        reportWriter.writeAttr("border", 1);
        reportWriter.startTag("tr");
        reportWriter.writeTH(HTMLSection.i18n.getString("config.wd"), "row");
        reportWriter.startTag("td");
        reportWriter.writeLink(workDirectory.getRoot());
        reportWriter.endTag("td");
        reportWriter.endTag("tr");
        reportWriter.startTag("tr");
        reportWriter.writeTH(HTMLSection.i18n.getString("config.rd"), "row");
        reportWriter.startTag("td");
        reportWriter.writeLink(this.reportDir);
        reportWriter.endTag("td");
        reportWriter.endTag("tr");
        reportWriter.endTag("table");
    }

    private void writeConfigInterview() throws IOException {
        WizPrint wizPrint = new WizPrint(this.settings.ip);
        wizPrint.setShowResponses(true);
        wizPrint.write(this.openWriter(2));
    }

    private void writeEnvironment() throws IOException {
        String[] stringArray;
        Object object;
        TestEnvironment testEnvironment = this.settings.ip.getEnv();
        String string = testEnvironment != null ? testEnvironment.getName() : null;
        ReportWriter reportWriter = this.openAuxFile(3, HTMLSection.i18n.getString("config.env.title", string), HTMLSection.i18n);
        if (testEnvironment == null) {
            reportWriter.write(HTMLSection.i18n.getString("config.noEnv"));
            return;
        }
        try {
            object = testEnvironment.lookup(HTMLSection.i18n.getString("config.desc"));
            if (object != null) {
                reportWriter.startTag("h2");
                reportWriter.write(StringArray.join((String[])object));
                reportWriter.endTag("h2");
            }
        }
        catch (TestEnvironment.Fault fault) {
            reportWriter.write(HTMLSection.i18n.getString("config.testEnv.err"));
        }
        object = new TreeSet(new StringArrayComparator());
        Iterator iterator = testEnvironment.elements().iterator();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            String[] stringArray2 = new String[]{stringArray.getKey(), stringArray.getValue()};
            object.add(stringArray2);
        }
        reportWriter.startTag("table");
        reportWriter.writeAttr("border", 1);
        iterator = object.iterator();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            reportWriter.startTag("tr");
            for (int i = 0; i < stringArray.length; ++i) {
                reportWriter.startTag("td");
                reportWriter.write(stringArray[i]);
                reportWriter.endTag("td");
            }
            reportWriter.endTag("tr");
        }
        reportWriter.endTag("table");
        reportWriter.close();
    }

    private void writeExcludeList() throws IOException {
        ReportWriter reportWriter = this.openAuxFile(4, HTMLSection.i18n.getString("config.excludedTests"), HTMLSection.i18n);
        ExcludeList excludeList = this.settings.ip.getExcludeList();
        if (excludeList == null || excludeList.size() == 0) {
            reportWriter.writeI18N("config.excl.none");
        } else {
            TreeSet treeSet = new TreeSet(new ExcludeListEntryComparator());
            Iterator iterator = excludeList.getIterator(false);
            while (iterator.hasNext()) {
                treeSet.add(iterator.next());
            }
            reportWriter.startTag("table");
            reportWriter.writeAttr("border", 1);
            reportWriter.startTag("tr");
            reportWriter.startTag("th");
            reportWriter.writeI18N("config.excl.name");
            reportWriter.endTag("th");
            reportWriter.startTag("th");
            reportWriter.writeI18N("config.excl.testcase");
            reportWriter.endTag("th");
            reportWriter.startTag("th");
            reportWriter.writeI18N("config.excl.bugids");
            reportWriter.endTag("th");
            reportWriter.startTag("th");
            reportWriter.writeI18N("config.excl.platforms");
            reportWriter.endTag("th");
            reportWriter.startTag("th");
            reportWriter.writeI18N("config.excl.synopsis");
            reportWriter.endTag("th");
            reportWriter.endTag("tr");
            iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                ExcludeList.Entry entry = (ExcludeList.Entry)iterator.next();
                reportWriter.startTag("tr");
                this.writeTD(reportWriter, entry.getRelativeURL());
                this.writeTD(reportWriter, entry.getTestCases());
                reportWriter.startTag("td");
                String[] stringArray = entry.getBugIdStrings();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (i > 0) {
                        reportWriter.write(" ");
                    }
                    reportWriter.write(stringArray[i]);
                }
                reportWriter.endTag("td");
                this.writeTD(reportWriter, StringArray.join(entry.getPlatforms()));
                this.writeTD(reportWriter, entry.getSynopsis());
                reportWriter.endTag("tr");
            }
            reportWriter.endTag("table");
        }
        reportWriter.newLine();
        reportWriter.close();
    }

    private void writeTD(ReportWriter reportWriter, String string) throws IOException {
        reportWriter.startTag("td");
        if (string == null || string.length() == 0) {
            reportWriter.writeEntity("&nbsp;");
        } else {
            reportWriter.write(string);
        }
        reportWriter.endTag("td");
    }

    private static class ExcludeListEntryComparator
    implements Comparator {
        private ExcludeListEntryComparator() {
        }

        public int compare(Object object, Object object2) {
            ExcludeList.Entry entry = (ExcludeList.Entry)object;
            ExcludeList.Entry entry2 = (ExcludeList.Entry)object2;
            int n = ExcludeListEntryComparator.compare(entry.getRelativeURL(), entry2.getRelativeURL());
            if (n == 0) {
                n = ExcludeListEntryComparator.compare(entry.getTestCases(), entry2.getTestCases());
            }
            return n;
        }

        private static int compare(String[] stringArray, String[] stringArray2) {
            int n = stringArray == null ? 0 : stringArray.length;
            int n2 = stringArray2 == null ? 0 : stringArray2.length;
            for (int i = 0; i < Math.min(n, n2); ++i) {
                int n3 = ExcludeListEntryComparator.compare(stringArray[i], stringArray2[i]);
                if (n3 == 0) continue;
                return n3;
            }
            return n < n2 ? -1 : (n == n2 ? 0 : 1);
        }

        private static int compare(String string, String string2) {
            return string == null && string2 == null ? 0 : (string == null ? -1 : (string2 == null ? 1 : string.compareTo(string2)));
        }
    }
}

