/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.JavaTestError;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.report.Report;
import com.sun.javatest.report.ReportFormat;
import com.sun.javatest.report.TestResultsByFileComparator;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.TextWriter;
import java.io.File;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.TreeSet;

class PlainTextReport
implements ReportFormat {
    private static final String[] files = new String[]{"summary.txt"};
    private static final int SMRY_TXT = 0;
    private I18NResourceBundle i18n;
    private BackupPolicy backupPolicy;

    PlainTextReport(I18NResourceBundle i18NResourceBundle) {
        this.i18n = i18NResourceBundle;
    }

    public static String[] getReportFilenames() {
        return files;
    }

    public static String[] getFilenamesUsed() {
        return files;
    }

    public void write(Report.Settings settings, File file) throws IOException {
        Object object;
        TestResultTable testResultTable = settings.ip.getWorkDirectory().getTestResultTable();
        this.backupPolicy = settings.isBackupsEnabled() ? BackupPolicy.simpleBackups(settings.backups) : BackupPolicy.noBackups();
        File[] fileArray = settings.getInitialFiles();
        TreeSet<Object> treeSet = new TreeSet<Object>(new TestResultsByFileComparator());
        int n = 0;
        Iterator iterator = null;
        try {
            iterator = fileArray == null ? testResultTable.getIterator(new TestFilter[]{settings.filter}) : testResultTable.getIterator(fileArray, new TestFilter[]{settings.filter});
        }
        catch (TestResultTable.Fault fault) {
            throw new JavaTestError(this.i18n.getString("report.testResult.err"));
        }
        while (iterator.hasNext()) {
            object = (TestResult)iterator.next();
            n = Math.max(n, ((TestResult)object).getTestName().length());
            treeSet.add(object);
        }
        object = new TextWriter(this.openWriter(file, files[0]));
        iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            TestResult testResult = (TestResult)iterator.next();
            String string = testResult.getTestName();
            ((TextWriter)object).print(string);
            for (int i = string.length(); i < n; ++i) {
                ((TextWriter)object).print(" ");
            }
            ((TextWriter)object).print("  ");
            ((TextWriter)object).println(testResult.getStatus().toString());
        }
        ((FilterWriter)object).close();
    }

    private Writer openWriter(File file, String string) throws IOException {
        return this.backupPolicy.backupAndOpenWriter(new File(file, string));
    }
}

