/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.JavaTestError;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.report.HTMLReport;
import com.sun.javatest.report.HTMLSection;
import com.sun.javatest.report.Report;
import com.sun.javatest.report.ReportWriter;
import com.sun.javatest.report.TestResultsByStatusAndTitleComparator;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

class ResultSection
extends HTMLSection {
    private File workDirRoot;
    private TestResultTable resultTable;
    private File[] initFiles;
    private TestFilter[] paramFilters;
    private SortedSet[] lists;
    private int totalFound;
    private final int[] fileCodes = new int[]{5, 6, 7, 8};
    private final String[] headings = new String[]{HTMLSection.i18n.getString("result.heading.passed"), HTMLSection.i18n.getString("result.heading.failed"), HTMLSection.i18n.getString("result.heading.errors"), HTMLSection.i18n.getString("result.heading.notRun")};

    ResultSection(HTMLReport hTMLReport, Report.Settings settings, File file) {
        super(HTMLSection.i18n.getString("result.title"), settings, file, hTMLReport);
        TestResultTable.TreeIterator treeIterator;
        Object object;
        String string;
        String string2;
        this.workDirRoot = settings.ip.getWorkDirectory().getRoot();
        try {
            string2 = this.workDirRoot.getCanonicalPath();
            string = this.reportDir.getCanonicalPath();
        }
        catch (IOException iOException) {
            string2 = this.workDirRoot.getPath();
            string = this.reportDir.getPath();
        }
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        if (string.startsWith(string2)) {
            File file2;
            object = new StringBuffer();
            try {
                for (file2 = this.reportDir; file2 != null && !file2.getCanonicalPath().equals(this.workDirRoot.getCanonicalPath()); file2 = file2.getParentFile()) {
                    ((StringBuffer)object).append("../");
                }
            }
            catch (IOException iOException) {
                file2 = null;
            }
            if (file2 != null) {
                this.workDirRoot = new File(((StringBuffer)object).toString());
            }
        }
        this.resultTable = settings.ip.getWorkDirectory().getTestResultTable();
        this.initFiles = settings.getInitialFiles();
        this.lists = new SortedSet[4];
        for (int i = 0; i < this.lists.length; ++i) {
            this.lists[i] = new TreeSet(new TestResultsByStatusAndTitleComparator());
        }
        try {
            object = null;
            object = settings.filter == null ? new TestFilter[]{} : new TestFilter[]{settings.filter};
            treeIterator = this.initFiles == null ? this.resultTable.getIterator((TestFilter[])object) : this.resultTable.getIterator(this.initFiles, (TestFilter[])object);
        }
        catch (TestResultTable.Fault fault) {
            throw new JavaTestError(HTMLSection.i18n.getString("result.testResult.err"));
        }
        while (treeIterator.hasNext()) {
            object = (TestResult)treeIterator.next();
            Status status = ((TestResult)object).getStatus();
            SortedSet sortedSet = this.lists[status == null ? 3 : status.getType()];
            sortedSet.add(object);
            ++this.totalFound;
        }
    }

    void writeSummary(ReportWriter reportWriter) throws IOException {
        super.writeSummary(reportWriter);
        reportWriter.startTag("table");
        reportWriter.writeAttr("border", 1);
        for (int i = 0; i < this.lists.length; ++i) {
            String string = HTMLReport.files[this.fileCodes[i]];
            SortedSet sortedSet = this.lists[i];
            int n = sortedSet.size();
            if (n <= 0) continue;
            reportWriter.startTag("tr");
            reportWriter.writeTH(this.headings[i], "row");
            reportWriter.startTag("td");
            if (this.settings.isStateFileEnabled(i)) {
                reportWriter.writeLink(string, Integer.toString(n));
            } else {
                reportWriter.write(Integer.toString(n));
            }
            reportWriter.endTag("td");
            reportWriter.endTag("tr");
        }
        reportWriter.startTag("tr");
        reportWriter.writeTH(HTMLSection.i18n.getString("result.total"), "row");
        reportWriter.writeTD(Integer.toString(this.totalFound));
        reportWriter.endTag("tr");
        reportWriter.endTag("table");
    }

    void writeExtraFiles() throws IOException {
        this.writeStatusFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStatusFiles() throws IOException {
        for (int i = 0; i < this.lists.length; ++i) {
            if (!this.settings.isStateFileEnabled(i)) continue;
            ReportWriter reportWriter = this.openAuxFile(this.fileCodes[i], this.headings[i], HTMLSection.i18n);
            reportWriter.write(HTMLSection.i18n.getString("result.groupByStatus"));
            try {
                SortedSet sortedSet = this.lists[i];
                if (sortedSet.size() <= 0) continue;
                boolean bl = false;
                String string = null;
                Iterator iterator = sortedSet.iterator();
                while (iterator.hasNext()) {
                    String string2;
                    Object object;
                    TestResult testResult = (TestResult)iterator.next();
                    try {
                        object = testResult.getDescription();
                        string2 = ((TestDescription)object).getTitle();
                    }
                    catch (TestResult.Fault fault) {
                        string2 = null;
                    }
                    object = testResult.getStatus();
                    if (!((Status)object).getReason().equals(string)) {
                        string = ((Status)object).getReason();
                        if (bl) {
                            bl = false;
                            reportWriter.endTag("ul");
                            reportWriter.newLine();
                        }
                        reportWriter.startTag("h4");
                        reportWriter.write(string.length() == 0 ? HTMLSection.i18n.getString("result.noReason") : string);
                        reportWriter.endTag("h4");
                        reportWriter.newLine();
                    }
                    if (!bl) {
                        bl = true;
                        reportWriter.startTag("ul");
                    }
                    reportWriter.startTag("li");
                    String string3 = testResult.getWorkRelativePath();
                    File file = new File(this.workDirRoot, string3.replace('/', File.separatorChar));
                    String string4 = testResult.getTestName();
                    if (file == null || ((Status)object).getType() == 3) {
                        reportWriter.write(string4);
                    } else {
                        reportWriter.writeLink(file, string4);
                    }
                    if (string2 != null) {
                        reportWriter.write(": " + string2);
                    }
                    reportWriter.newLine();
                }
                if (!bl) continue;
                bl = false;
                reportWriter.endTag("ul");
                continue;
            }
            finally {
                reportWriter.close();
            }
        }
    }
}

