/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.interview.Interview;
import com.sun.interview.NullQuestion;
import com.sun.interview.Question;
import com.sun.javatest.FileParameters;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.tool.CommandManager;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class ConfigManager
extends CommandManager {
    private static Map commandFactory;
    private static I18NResourceBundle i18n;
    static /* synthetic */ Class class$com$sun$javatest$tool$ConfigManager;

    public HelpTree.Node getHelp() {
        Object[] objectArray = new Object[]{ConcurrencyCommand.getName(), ConfigCommand.getName(), EnvCommand.getName(), EnvFilesCommand.getNames(), ExcludeListCommand.getName(), KeywordsCommand.getName(), OpenCommand.getName(), ParamsCommand.getHelp(), PriorStatusCommand.getName(), SetCommand.getName(), TestsCommand.getName(), TestSuiteCommand.getNames(), TimeoutFactorCommand.getName(), WorkDirectoryCommand.getNames(), WriteConfigCommand.getName()};
        return this.getHelp(i18n, "cnfg", objectArray);
    }

    HelpTree.Node getHelp(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object instanceof HelpTree.Node) {
                vector.add(object);
                continue;
            }
            if (object instanceof String) {
                vector.add(new HelpTree.Node(i18NResourceBundle, string + "." + object));
                continue;
            }
            if (object instanceof String[]) {
                String[] stringArray = (String[])object;
                for (int j = 0; j < stringArray.length; ++j) {
                    vector.add(new HelpTree.Node(i18NResourceBundle, string + "." + stringArray[j]));
                }
                continue;
            }
            throw new IllegalArgumentException();
        }
        Object[] objectArray2 = new HelpTree.Node[vector.size()];
        vector.copyInto(objectArray2);
        return new HelpTree.Node(i18NResourceBundle, string, (HelpTree.Node[])objectArray2);
    }

    public boolean parseCommand(String string, ListIterator listIterator, CommandContext commandContext) throws Command.Fault {
        if (ConfigManager.isMatch(string, ConcurrencyCommand.getName())) {
            commandContext.addCommand(new ConcurrencyCommand(listIterator));
            return true;
        }
        if (ConfigManager.isMatch(string, ConfigCommand.getName())) {
            commandContext.addCommand(new ConfigCommand(listIterator));
            return true;
        }
        if (ConfigManager.isMatch(string, EnvCommand.getName())) {
            commandContext.addCommand(new EnvCommand(listIterator));
            return true;
        }
        if (ConfigManager.isMatch(string, EnvFilesCommand.getNames())) {
            commandContext.addCommand(new EnvFilesCommand(listIterator));
            return true;
        }
        if (ConfigManager.isMatch(string, ExcludeListCommand.getName())) {
            commandContext.addCommand(new ExcludeListCommand(listIterator));
            return true;
        }
        if (ConfigManager.isMatch(string, OpenCommand.getName())) {
            commandContext.addCommand(new OpenCommand(listIterator));
            return true;
        }
        if (ConfigManager.isMatch(string, KeywordsCommand.getName())) {
            commandContext.addCommand(new KeywordsCommand(listIterator));
            return true;
        }
        if (ConfigManager.isMatch(string, ParamsCommand.getName())) {
            commandContext.addCommand(new ParamsCommand(listIterator));
            return true;
        }
        if (ConfigManager.isMatch(string, PriorStatusCommand.getName())) {
            commandContext.addCommand(new PriorStatusCommand(listIterator));
            return true;
        }
        if (ConfigManager.isMatch(string, SetCommand.getName())) {
            commandContext.addCommand(new SetCommand(listIterator));
            return true;
        }
        if (ConfigManager.isMatch(string, TestsCommand.getName())) {
            commandContext.addCommand(new TestsCommand(listIterator));
            return true;
        }
        if (ConfigManager.isMatch(string, TestSuiteCommand.getNames())) {
            commandContext.addCommand(new TestSuiteCommand(listIterator));
            return true;
        }
        if (ConfigManager.isMatch(string, TimeoutFactorCommand.getName())) {
            commandContext.addCommand(new TimeoutFactorCommand(listIterator));
            return true;
        }
        if (ConfigManager.isMatch(string, WorkDirectoryCommand.getNames())) {
            commandContext.addCommand(new WorkDirectoryCommand(listIterator));
            return true;
        }
        if (ConfigManager.isMatch(string, WriteConfigCommand.getName())) {
            commandContext.addCommand(new WriteConfigCommand(listIterator));
            return true;
        }
        return false;
    }

    static Command getOpenCommand(File file) throws Command.Fault {
        return new OpenCommand(file);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$tool$ConfigManager == null ? (class$com$sun$javatest$tool$ConfigManager = ConfigManager.class$("com.sun.javatest.tool.ConfigManager")) : class$com$sun$javatest$tool$ConfigManager);
    }

    private static class WorkDirectoryCommand
    extends Command {
        private File path;
        private boolean createFlag;
        private boolean overwriteFlag;

        static String[] getNames() {
            return new String[]{"workdirectory", "workdir", "wd"};
        }

        WorkDirectoryCommand(ListIterator listIterator) throws Command.Fault {
            super(WorkDirectoryCommand.getNames()[0]);
            while (listIterator.hasNext()) {
                String string = this.nextArg(listIterator);
                if (string.equalsIgnoreCase("-create")) {
                    this.createFlag = true;
                    continue;
                }
                if (string.equalsIgnoreCase("-overwrite")) {
                    this.createFlag = true;
                    this.overwriteFlag = true;
                    continue;
                }
                if (string.startsWith("-")) {
                    throw (Command)this.new Command.Fault(i18n, "cnfg.wd.badArg", string);
                }
                this.path = new File(string);
                return;
            }
            throw new Command.Fault(i18n, "cnfg.wd.missingArg");
        }

        WorkDirectoryCommand(File file) {
            super(file.getPath());
            this.path = file;
        }

        public void run(CommandContext commandContext) throws Command.Fault {
            if (!this.createFlag) {
                if (!this.path.exists()) {
                    throw (Command)this.new Command.Fault(i18n, "cnfg.wd.cantFindWorkDir", this.path);
                }
                if (!WorkDirectory.isWorkDirectory(this.path) && !WorkDirectory.isEmptyDirectory(this.path)) {
                    throw (Command)this.new Command.Fault(i18n, "cnfg.wd.notAWorkDirectory", this.path);
                }
            }
            if (this.overwriteFlag) {
                this.remove(this.path);
                if (this.path.exists()) {
                    throw (Command)this.new Command.Fault(i18n, "cnfg.wd.cantRemoveWorkDir", this.path);
                }
            }
            try {
                commandContext.setWorkDirectory(this.path, this.createFlag);
            }
            catch (CommandContext.Fault fault) {
                throw new Command.Fault(fault);
            }
        }

        private void remove(File file) {
            if (file.exists()) {
                if (file.isDirectory()) {
                    File[] fileArray = file.listFiles();
                    for (int i = 0; i < fileArray.length; ++i) {
                        this.remove(fileArray[i]);
                    }
                    String[] stringArray = file.list();
                    if (stringArray != null && stringArray.length > 0) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            String string = stringArray[i];
                            if (!string.startsWith(".nfs")) continue;
                            File file2 = new File(file, string);
                            File file3 = new File(file.getParentFile(), string);
                            boolean bl = file2.renameTo(file3);
                        }
                    }
                }
                file.delete();
            }
        }
    }

    private static class TimeoutFactorCommand
    extends Command {
        private float value;

        static String getName() {
            return "timeoutfactor";
        }

        TimeoutFactorCommand(ListIterator listIterator) throws Command.Fault {
            super(TimeoutFactorCommand.getName());
            ParsePosition parsePosition;
            if (!listIterator.hasNext()) {
                throw new Command.Fault(i18n, "cnfg.tf.missingArg");
            }
            String string = this.nextArg(listIterator);
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            Number number = numberFormat.parse(string, parsePosition = new ParsePosition(0));
            if (number != null && parsePosition.getIndex() == string.length()) {
                this.value = number.floatValue();
                if (this.value < 0.1f || this.value > 100.0f) {
                    throw (Command)this.new Command.Fault(i18n, "cnfg.tf.badRange", new Object[]{string, new Float(0.1f), new Float(100.0f)});
                }
            } else {
                throw (Command)this.new Command.Fault(i18n, "cnfg.tf.badValue", string);
            }
        }

        public void run(CommandContext commandContext) throws Command.Fault {
            InterviewParameters interviewParameters = this.getConfig(commandContext);
            if (!(interviewParameters.getTimeoutFactorParameters() instanceof Parameters.MutableTimeoutFactorParameters)) {
                throw new Command.Fault(i18n, "cnfg.tf.notEditable");
            }
            Parameters.MutableTimeoutFactorParameters mutableTimeoutFactorParameters = (Parameters.MutableTimeoutFactorParameters)interviewParameters.getTimeoutFactorParameters();
            mutableTimeoutFactorParameters.setTimeoutFactor(this.value);
        }
    }

    private static class TestSuiteCommand
    extends Command {
        private File path;

        static String[] getNames() {
            return new String[]{"testsuite", "ts"};
        }

        TestSuiteCommand(ListIterator listIterator) throws Command.Fault {
            super(TestSuiteCommand.getNames()[0]);
            if (!listIterator.hasNext()) {
                throw new Command.Fault(i18n, "cnfg.ts.missingArg");
            }
            this.path = new File(this.nextArg(listIterator));
        }

        TestSuiteCommand(File file) {
            super(file.getPath());
            this.path = file;
        }

        public void run(CommandContext commandContext) throws Command.Fault {
            if (!this.path.exists()) {
                throw (Command)this.new Command.Fault(i18n, "cnfg.ts.cantFindTestSuite", this.path);
            }
            if (!TestSuite.isTestSuite(this.path)) {
                throw (Command)this.new Command.Fault(i18n, "cnfg.ts.notATestSuite", this.path);
            }
            try {
                commandContext.setTestSuite(this.path);
            }
            catch (CommandContext.Fault fault) {
                throw new Command.Fault(fault);
            }
        }
    }

    private static class TestsCommand
    extends Command {
        private String[] tests;

        static String getName() {
            return "tests";
        }

        TestsCommand(ListIterator listIterator) throws Command.Fault {
            super(TestsCommand.getName());
            Vector<String> vector = new Vector<String>();
            while (listIterator.hasNext()) {
                String string = this.nextArg(listIterator);
                if (string.startsWith("-")) {
                    this.putbackArg(listIterator);
                    break;
                }
                vector.add(string);
            }
            if (vector.size() == 0) {
                throw new Command.Fault(i18n, "cnfg.tests.noTests");
            }
            this.tests = new String[vector.size()];
            vector.toArray(this.tests);
        }

        public void run(CommandContext commandContext) throws Command.Fault {
            InterviewParameters interviewParameters = this.getConfig(commandContext);
            if (!(interviewParameters.getTestsParameters() instanceof Parameters.MutableTestsParameters)) {
                throw new Command.Fault(i18n, "cnfg.tests.notEditable");
            }
            Parameters.MutableTestsParameters mutableTestsParameters = (Parameters.MutableTestsParameters)interviewParameters.getTestsParameters();
            mutableTestsParameters.setTestsMode(2);
            mutableTestsParameters.setSpecifiedTests(this.tests);
        }
    }

    private static class SetCommand
    extends Command {
        private File file;
        private String tag;
        private String value;

        static String getName() {
            return "set";
        }

        SetCommand(ListIterator listIterator) throws Command.Fault {
            super(SetCommand.getName());
            if (!listIterator.hasNext()) {
                throw new Command.Fault(i18n, "cnfg.set.insufficientArgs");
            }
            String string = this.nextArg(listIterator);
            if (string.equals("-f") || string.equals("-file")) {
                if (!listIterator.hasNext()) {
                    throw new Command.Fault(i18n, "cnfg.set.insufficientArgs");
                }
                this.file = new File(this.nextArg(listIterator));
            } else {
                this.tag = string;
                if (!listIterator.hasNext()) {
                    throw new Command.Fault(i18n, "cnfg.set.insufficientArgs");
                }
                this.value = this.nextArg(listIterator);
            }
        }

        public void run(CommandContext commandContext) throws Command.Fault {
            InterviewParameters interviewParameters = this.getConfig(commandContext);
            Question[] questionArray = interviewParameters.getPath();
            if (this.file != null) {
                Map map = this.loadFile(this.file);
                for (int i = 0; i < questionArray.length; ++i) {
                    Question question = questionArray[i];
                    String string = (String)map.get(question.getTag());
                    if (string == null) continue;
                    this.setValue(question, string);
                    questionArray = interviewParameters.getPath();
                }
            } else {
                for (int i = 0; i < questionArray.length; ++i) {
                    Question question = questionArray[i];
                    if (!question.getTag().equals(this.tag)) continue;
                    this.setValue(question, this.value);
                    return;
                }
                throw (Command)this.new Command.Fault(i18n, "cnfg.set.tagNotFound", new Object[]{this.tag, SetCommand.getPathTrace(questionArray)});
            }
        }

        private void setValue(Question question, String string) throws Command.Fault {
            try {
                question.setValue(string);
            }
            catch (Interview.Fault fault) {
                throw (Command)this.new Command.Fault(i18n, "cnfg.set.cantSetValue", new Object[]{question.getTag(), string, fault.getMessage()});
            }
        }

        private static String getPathTrace(Question[] questionArray) {
            String string = System.getProperty("line.separator");
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < questionArray.length; ++i) {
                Question question = questionArray[i];
                stringBuffer.append(question.getTag());
                if (!(question instanceof NullQuestion)) {
                    String string2 = question.getStringValue();
                    stringBuffer.append(" (");
                    if (string2 == null) {
                        stringBuffer.append("null");
                    } else if (string2.length() < 32) {
                        stringBuffer.append(string2);
                    } else {
                        stringBuffer.append(string2.substring(0, 32));
                        stringBuffer.append("...");
                    }
                    stringBuffer.append(")");
                }
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }

        private Map loadFile(File file) throws Command.Fault {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                Properties properties = new Properties();
                properties.load(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
                return properties;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw (Command)this.new Command.Fault(i18n, "cnfg.set.cantFindFile", file);
            }
            catch (IOException iOException) {
                throw (Command)this.new Command.Fault(i18n, "cnfg.set.cantReadFile", new Object[]{file, iOException.getMessage()});
            }
        }
    }

    private static class PriorStatusCommand
    extends Command {
        private boolean[] values;

        static String getName() {
            return "priorStatus";
        }

        PriorStatusCommand(ListIterator listIterator) throws Command.Fault {
            super(PriorStatusCommand.getName());
            if (!listIterator.hasNext()) {
                throw new Command.Fault(i18n, "cnfg.status.missingArg");
            }
            String string = this.nextArg(listIterator);
            String[] stringArray = PriorStatusCommand.split(string.toLowerCase());
            boolean bl = false;
            this.values = new boolean[4];
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    if (string2.startsWith("pass")) {
                        bl = true;
                        this.values[0] = true;
                        continue;
                    }
                    if (string2.startsWith("fail")) {
                        bl = true;
                        this.values[1] = true;
                        continue;
                    }
                    if (string2.startsWith("error")) {
                        bl = true;
                        this.values[2] = true;
                        continue;
                    }
                    if (string2.startsWith("notrun")) {
                        bl = true;
                        this.values[3] = true;
                        continue;
                    }
                    throw (Command)this.new Command.Fault(i18n, "cnfg.status.badArg", string2);
                }
            }
            if (!bl) {
                throw new Command.Fault(i18n, "cnfg.status.noValues");
            }
        }

        public void run(CommandContext commandContext) throws Command.Fault {
            InterviewParameters interviewParameters = this.getConfig(commandContext);
            if (!(interviewParameters.getPriorStatusParameters() instanceof Parameters.MutablePriorStatusParameters)) {
                throw new Command.Fault(i18n, "cnfg.status.notEditable");
            }
            Parameters.MutablePriorStatusParameters mutablePriorStatusParameters = (Parameters.MutablePriorStatusParameters)interviewParameters.getPriorStatusParameters();
            mutablePriorStatusParameters.setPriorStatusMode(2);
            mutablePriorStatusParameters.setMatchPriorStatusValues(this.values);
        }

        private static String[] split(String string) {
            if (string == null) {
                return null;
            }
            Vector<String> vector = new Vector<String>();
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (Character.isLetterOrDigit(string.charAt(i))) {
                    if (n != -1) continue;
                    n = i;
                    continue;
                }
                if (n != -1) {
                    vector.addElement(string.substring(n, i));
                }
                n = -1;
            }
            if (n != -1) {
                vector.addElement(string.substring(n));
            }
            if (vector.size() == 0) {
                return null;
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
    }

    private static class ParamsCommand
    extends ParamsBaseCommand {
        private FileParameters params;

        static String getName() {
            return "params";
        }

        static HelpTree.Node getHelp() {
            String[] stringArray = new String[]{"testSuite", "t", "keywords", "status", "exclude", "envfile", "env", "conc", "timeout", "report", "r", "workdir", "w"};
            return new HelpTree.Node(i18n, "cnfg.params", stringArray);
        }

        ParamsCommand(ListIterator listIterator) throws Command.Fault {
            super(ParamsCommand.getName());
            Vector<String> vector = new Vector<String>();
            while (listIterator.hasNext()) {
                vector.add(this.nextArg(listIterator));
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            try {
                this.params = new FileParameters((String[])objectArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (Command)this.new Command.Fault(i18n, "cnfg.params.badValue", illegalArgumentException.getMessage());
            }
            if (!this.params.isValid()) {
                throw (Command)this.new Command.Fault(i18n, "cnfg.params.badValue", this.params.getErrorMessage());
            }
        }

        public void run(CommandContext commandContext) throws Command.Fault {
            this.setParameters(commandContext, this.params);
        }
    }

    private static class ParamFileCommand
    extends ParamsBaseCommand {
        private File path;

        ParamFileCommand(File file) {
            super(file.getPath());
            this.path = file;
        }

        public void run(CommandContext commandContext) throws Command.Fault {
            try {
                FileParameters fileParameters = new FileParameters(this.path);
                if (!fileParameters.isValid()) {
                    throw (Command)this.new Command.Fault(i18n, "cnfg.params.badParameterFile", new Object[]{this.path, fileParameters.getErrorMessage()});
                }
                this.setParameters(commandContext, fileParameters);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw (Command)this.new Command.Fault(i18n, "cnfg.params.cantFindFile", this.path);
            }
            catch (IOException iOException) {
                throw (Command)this.new Command.Fault(i18n, "cnfg.params.cantReadFile", new Object[]{this.path, iOException});
            }
        }
    }

    private static abstract class ParamsBaseCommand
    extends Command {
        ParamsBaseCommand(String string) {
            super(string);
        }

        protected void setParameters(CommandContext commandContext, FileParameters fileParameters) throws Command.Fault {
            try {
                commandContext.setTestSuite(fileParameters.getTestSuite());
                if (fileParameters.getWorkDirectory() != null) {
                    commandContext.setWorkDirectory(fileParameters.getWorkDirectory());
                }
                this.getConfig(commandContext).load(fileParameters);
                File file = fileParameters.getReportDir();
                if (file == null) {
                    File file2 = new File("reports", "report");
                    file = commandContext.getWorkDirectory().getFile(file2.getPath());
                }
                commandContext.setAutoRunReportDir(file);
            }
            catch (TestSuite.Fault fault) {
                throw (Command)this.new Command.Fault(i18n, "cnfg.cantSetParameters", fault.getMessage());
            }
            catch (CommandContext.Fault fault) {
                throw new Command.Fault(fault);
            }
        }
    }

    private static class KeywordsCommand
    extends Command {
        private String expr;

        static String getName() {
            return "keywords";
        }

        KeywordsCommand(ListIterator listIterator) throws Command.Fault {
            super(KeywordsCommand.getName());
            if (!listIterator.hasNext()) {
                throw new Command.Fault(i18n, "cnfg.keywords.missingArg");
            }
            this.expr = this.nextArg(listIterator);
        }

        public void run(CommandContext commandContext) throws Command.Fault {
            InterviewParameters interviewParameters = this.getConfig(commandContext);
            if (interviewParameters.getKeywordsParameters() instanceof Parameters.MutableKeywordsParameters) {
                Parameters.MutableKeywordsParameters mutableKeywordsParameters = (Parameters.MutableKeywordsParameters)interviewParameters.getKeywordsParameters();
                if (this.expr == null) {
                    mutableKeywordsParameters.setKeywordsMode(1);
                } else {
                    mutableKeywordsParameters.setKeywordsMode(2);
                    mutableKeywordsParameters.setMatchKeywords(3, this.expr);
                }
            } else {
                throw new Command.Fault(i18n, "cnfg.keywords.notEditable");
            }
        }
    }

    private static class OpenCommand
    extends Command {
        private Command cmdForFile;

        static String getName() {
            return "open";
        }

        OpenCommand(File file) throws Command.Fault {
            super(file.getPath());
            this.cmdForFile = this.getCommandForFile(file);
        }

        OpenCommand(ListIterator listIterator) throws Command.Fault {
            super(OpenCommand.getName());
            if (!listIterator.hasNext()) {
                throw new Command.Fault(i18n, "cnfg.open.missingArg");
            }
            String string = this.nextArg(listIterator);
            this.cmdForFile = this.getCommandForFile(new File(string));
        }

        public void run(CommandContext commandContext) throws Command.Fault {
            this.cmdForFile.run(commandContext);
        }

        Command getCommandForFile(File file) throws Command.Fault {
            if (!file.exists()) {
                throw (Command)this.new Command.Fault(i18n, "cnfg.open.cantFindFile", file);
            }
            if (TestSuite.isTestSuite(file)) {
                return new TestSuiteCommand(file);
            }
            if (WorkDirectory.isWorkDirectory(file)) {
                return new WorkDirectoryCommand(file);
            }
            if (FileParameters.isParameterFile(file)) {
                return new ParamFileCommand(file);
            }
            if (InterviewParameters.isInterviewFile(file)) {
                return new ConfigCommand(file);
            }
            if (file.getPath().endsWith(".jte")) {
                throw (Command)this.new Command.Fault(i18n, "cnfg.open.cantOpenJTE", file);
            }
            if (file.getPath().endsWith(".jtt")) {
                throw (Command)this.new Command.Fault(i18n, "cnfg.open.cantOpenJTT", file);
            }
            if (file.getPath().endsWith(".jtx")) {
                throw (Command)this.new Command.Fault(i18n, "cnfg.open.cantOpenJTX", file);
            }
            throw (Command)this.new Command.Fault(i18n, "cnfg.open.unknownFileType", file);
        }
    }

    private static class ExcludeListCommand
    extends Command {
        private File[] files;

        static String getName() {
            return "excludeList";
        }

        ExcludeListCommand(ListIterator listIterator) throws Command.Fault {
            super(ExcludeListCommand.getName());
            Vector<File> vector = new Vector<File>();
            while (listIterator.hasNext()) {
                String string = this.nextArg(listIterator);
                if (string.startsWith("-")) {
                    this.putbackArg(listIterator);
                    break;
                }
                vector.add(new File(string));
            }
            if (vector.size() == 0) {
                throw new Command.Fault(i18n, "cnfg.excl.noFiles");
            }
            this.files = new File[vector.size()];
            vector.toArray(this.files);
        }

        public void run(CommandContext commandContext) throws Command.Fault {
            InterviewParameters interviewParameters = this.getConfig(commandContext);
            if (!(interviewParameters.getExcludeListParameters() instanceof Parameters.MutableExcludeListParameters)) {
                throw new Command.Fault(i18n, "cnfg.excl.notEditable");
            }
            Parameters.MutableExcludeListParameters mutableExcludeListParameters = (Parameters.MutableExcludeListParameters)interviewParameters.getExcludeListParameters();
            mutableExcludeListParameters.setExcludeMode(4);
            mutableExcludeListParameters.setCustomExcludeFiles(this.files);
        }
    }

    private static class EnvFilesCommand
    extends Command {
        private File[] files;

        static String[] getNames() {
            return new String[]{"envfile", "envfiles"};
        }

        EnvFilesCommand(ListIterator listIterator) throws Command.Fault {
            super(EnvFilesCommand.getNames()[0]);
            Vector<File> vector = new Vector<File>();
            while (listIterator.hasNext()) {
                String string = this.nextArg(listIterator);
                if (string.startsWith("-")) {
                    this.putbackArg(listIterator);
                    break;
                }
                vector.add(new File(string));
            }
            if (vector.size() == 0) {
                throw new Command.Fault(i18n, "cnfg.envFiles.noFiles");
            }
            this.files = new File[vector.size()];
            vector.toArray(this.files);
        }

        public void run(CommandContext commandContext) throws Command.Fault {
            InterviewParameters interviewParameters = this.getConfig(commandContext);
            if (!(interviewParameters.getEnvParameters() instanceof Parameters.LegacyEnvParameters)) {
                throw new Command.Fault(i18n, "cnfg.envFiles.notEditable");
            }
            Parameters.LegacyEnvParameters legacyEnvParameters = (Parameters.LegacyEnvParameters)interviewParameters.getEnvParameters();
            legacyEnvParameters.setEnvFiles(this.files);
        }
    }

    private static class EnvCommand
    extends Command {
        private String name;

        static String getName() {
            return "env";
        }

        EnvCommand(ListIterator listIterator) throws Command.Fault {
            super(EnvCommand.getName());
            if (!listIterator.hasNext()) {
                throw new Command.Fault(i18n, "cnfg.env.missingArg");
            }
            this.name = this.nextArg(listIterator);
        }

        public void run(CommandContext commandContext) throws Command.Fault {
            InterviewParameters interviewParameters = this.getConfig(commandContext);
            if (!(interviewParameters.getEnvParameters() instanceof Parameters.LegacyEnvParameters)) {
                throw new Command.Fault(i18n, "cnfg.env.notEditable");
            }
            Parameters.LegacyEnvParameters legacyEnvParameters = (Parameters.LegacyEnvParameters)interviewParameters.getEnvParameters();
            legacyEnvParameters.setEnvName(this.name);
        }
    }

    private static class WriteConfigCommand
    extends Command {
        private File path;

        static String getName() {
            return "writeConfig";
        }

        WriteConfigCommand(ListIterator listIterator) throws Command.Fault {
            super(WriteConfigCommand.getName());
            if (!listIterator.hasNext()) {
                throw new Command.Fault(i18n, "cnfg.conf.missingArg");
            }
            this.path = new File(this.nextArg(listIterator));
        }

        WriteConfigCommand(File file) {
            super(file.getPath());
            this.path = file;
        }

        public void run(CommandContext commandContext) throws Command.Fault {
            try {
                InterviewParameters interviewParameters = this.getConfig(commandContext);
                interviewParameters.saveAs(this.path, true, true);
            }
            catch (IOException iOException) {
                if (!this.path.canWrite()) {
                    throw (Command)this.new Command.Fault(i18n, "cnfg.writeConfig.cantWrite", this.path.getPath());
                }
                throw (Command)this.new Command.Fault(i18n, "cnfg.writeConfig.writeErr", new Object[]{this.path, iOException});
            }
            catch (Interview.Fault fault) {
                throw (Command)this.new Command.Fault(i18n, "cnfg.writeConfig.badConfig", new Object[]{this.path, fault.getMessage()});
            }
        }
    }

    private static class ConfigCommand
    extends Command {
        private File path;

        static String getName() {
            return "config";
        }

        ConfigCommand(ListIterator listIterator) throws Command.Fault {
            super(ConfigCommand.getName());
            if (!listIterator.hasNext()) {
                throw new Command.Fault(i18n, "cnfg.conf.missingArg");
            }
            this.path = new File(this.nextArg(listIterator));
        }

        ConfigCommand(File file) {
            super(file.getPath());
            this.path = file;
        }

        public void run(CommandContext commandContext) throws Command.Fault {
            try {
                commandContext.setConfig(this.path);
                commandContext.setAutoRunReportDir(null);
            }
            catch (CommandContext.Fault fault) {
                throw new Command.Fault(fault);
            }
        }
    }

    private static class ConcurrencyCommand
    extends Command {
        private int value;

        static String getName() {
            return "concurrency";
        }

        ConcurrencyCommand(ListIterator listIterator) throws Command.Fault {
            super(ConcurrencyCommand.getName());
            ParsePosition parsePosition;
            if (!listIterator.hasNext()) {
                throw new Command.Fault(i18n, "cnfg.conc.missingArg");
            }
            String string = this.nextArg(listIterator);
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            Number number = numberFormat.parse(string, parsePosition = new ParsePosition(0));
            if (number != null && parsePosition.getIndex() == string.length()) {
                this.value = number.intValue();
                if (this.value < 1 || this.value > 50) {
                    throw (Command)this.new Command.Fault(i18n, "cnfg.conc.badRange", new Object[]{string, new Integer(1), new Integer(50)});
                }
            } else {
                throw (Command)this.new Command.Fault(i18n, "cnfg.conc.badValue", string);
            }
        }

        public void run(CommandContext commandContext) throws Command.Fault {
            InterviewParameters interviewParameters = this.getConfig(commandContext);
            if (!(interviewParameters.getConcurrencyParameters() instanceof Parameters.MutableConcurrencyParameters)) {
                throw new Command.Fault(i18n, "cnfg.conc.notEditable");
            }
            Parameters.MutableConcurrencyParameters mutableConcurrencyParameters = (Parameters.MutableConcurrencyParameters)interviewParameters.getConcurrencyParameters();
            mutableConcurrencyParameters.setConcurrency(this.value);
        }
    }
}

