/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.JavaTestSecurityManager;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.tool.CommandManager;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Properties;

public class EnvironmentManager
extends CommandManager {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$tool$ConfigManager == null ? (class$com$sun$javatest$tool$ConfigManager = EnvironmentManager.class$("com.sun.javatest.tool.ConfigManager")) : class$com$sun$javatest$tool$ConfigManager);
    static /* synthetic */ Class class$com$sun$javatest$tool$ConfigManager;

    EnvironmentManager() {
        TestEnvironment.clearDefaultPropTables();
        String[] stringArray = new String[]{"user.dir", "user.home"};
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            hashMap.put(string, System.getProperty(string));
        }
        TestEnvironment.addDefaultPropTable(i18n.getString("env.def.sysProps"), hashMap);
    }

    public HelpTree.Node getHelp() {
        String[] stringArray = new String[]{"EsysProps", "EnameVar"};
        return new HelpTree.Node(i18n, "env", stringArray);
    }

    public boolean parseCommand(String string, ListIterator listIterator, CommandContext commandContext) throws Command.Fault {
        if (string.equalsIgnoreCase("EsysProps")) {
            commandContext.addCommand(new ESysPropsCommand());
            return true;
        }
        if (string.startsWith("E") && string.indexOf(61) > 0) {
            int n = string.indexOf(61);
            String string2 = string.substring(1, n).trim();
            String string3 = string.substring(n + 1).trim();
            commandContext.addCommand(new ENameValueCommand(string2, string3));
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ESysPropsCommand
    extends Command {
        ESysPropsCommand() {
            super("EsysProps");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(CommandContext commandContext) throws Command.Fault {
            try {
                Properties properties;
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager instanceof JavaTestSecurityManager) {
                    boolean bl = ((JavaTestSecurityManager)securityManager).setAllowPropertiesAccess(true);
                    try {
                        properties = System.getProperties();
                    }
                    finally {
                        ((JavaTestSecurityManager)securityManager).setAllowPropertiesAccess(bl);
                    }
                } else {
                    properties = System.getProperties();
                }
                TestEnvironment.addDefaultPropTable(i18n.getString("env.def.sysProps"), properties);
            }
            catch (SecurityException securityException) {
                throw (Command)this.new Command.Fault(i18n, "env.cantAccessSysProps", securityException);
            }
        }
    }

    private class ENameValueCommand
    extends Command {
        private String name;
        private String value;

        ENameValueCommand(String string, String string2) {
            super("E" + string + "=" + string2);
            this.name = string;
            this.value = string2;
        }

        public void run(CommandContext commandContext) throws Command.Fault {
            HashMap<String, String> hashMap = new HashMap<String, String>(1);
            hashMap.put(this.name, this.value);
            TestEnvironment.addDefaultPropTable(i18n.getString("env.def.cmdLine"), hashMap);
        }
    }
}

