/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.WorkDirectory;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class FileHistory {
    private WeakReference workDirRef;
    private String name;
    private File historyFile;
    private long historyFileLastModified;
    private Vector entries;
    public static String FILE = "file";
    private static WeakHashMap cache;
    private static final String FILE_HISTORY = "fileHistory";
    private static I18NResourceBundle i18n;
    static /* synthetic */ Class class$com$sun$javatest$tool$FileHistory;

    public static FileHistory getFileHistory(WorkDirectory workDirectory, String string) {
        FileHistory fileHistory;
        HashMap<String, FileHistory> hashMap;
        if (cache == null) {
            cache = new WeakHashMap(8);
        }
        if ((hashMap = (HashMap<String, FileHistory>)cache.get(workDirectory)) == null) {
            hashMap = new HashMap<String, FileHistory>(8);
            cache.put(workDirectory, hashMap);
        }
        if ((fileHistory = (FileHistory)hashMap.get(string)) == null) {
            fileHistory = new FileHistory(workDirectory, string);
            hashMap.put(string, fileHistory);
        }
        return fileHistory;
    }

    public void add(File file) {
        this.ensureEntriesUpToDate();
        file = file.getAbsoluteFile();
        this.entries.remove(file);
        this.entries.add(0, file);
        this.writeEntries();
    }

    public File[] getRecentEntries(int n) {
        this.ensureEntriesUpToDate();
        Vector<File> vector = new Vector<File>();
        for (int i = 0; i < this.entries.size() && vector.size() < n; ++i) {
            File file = (File)this.entries.elementAt(i);
            if (!file.exists()) continue;
            vector.add(file);
        }
        Object[] objectArray = new File[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public File getLatestEntry() {
        this.ensureEntriesUpToDate();
        for (int i = 0; i < this.entries.size(); ++i) {
            File file = (File)this.entries.elementAt(i);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    private FileHistory(WorkDirectory workDirectory, String string) {
        this.workDirRef = new WeakReference<WorkDirectory>(workDirectory);
        this.name = string;
        this.historyFile = workDirectory.getSystemFile(string);
    }

    private void ensureEntriesUpToDate() {
        if (this.entries == null || this.historyFile.lastModified() > this.historyFileLastModified) {
            this.readEntries();
        }
    }

    private void readEntries() {
        if (this.entries == null) {
            this.entries = new Vector();
        } else {
            this.entries.clear();
        }
        if (this.historyFile.exists()) {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(this.historyFile));
                while ((string = bufferedReader.readLine()) != null) {
                    String string2 = string.trim();
                    if (string2.length() == 0 || string2.startsWith("#")) continue;
                    this.entries.add(new File(string2));
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                WorkDirectory workDirectory = (WorkDirectory)this.workDirRef.get();
                workDirectory.log(i18n, "fh.cantRead", new Object[]{this.name, iOException});
            }
            this.historyFileLastModified = this.historyFile.lastModified();
        }
    }

    private void writeEntries() {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.historyFile));
            bufferedWriter.write("# Configuration File History");
            bufferedWriter.newLine();
            bufferedWriter.write("# written at " + new Date());
            bufferedWriter.newLine();
            for (int i = 0; i < this.entries.size(); ++i) {
                bufferedWriter.write(this.entries.elementAt(i).toString());
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            WorkDirectory workDirectory = (WorkDirectory)this.workDirRef.get();
            workDirectory.log(i18n, "fh.cantWrite", new Object[]{this.name, iOException});
        }
        this.historyFileLastModified = this.historyFile.lastModified();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$tool$FileHistory == null ? (class$com$sun$javatest$tool$FileHistory = FileHistory.class$("com.sun.javatest.tool.FileHistory")) : class$com$sun$javatest$tool$FileHistory);
    }

    public static class Listener
    implements MenuListener {
        private FileHistory history;
        private int offset;
        private ActionListener clientListener;

        public Listener(ActionListener actionListener) {
            this(null, -1, actionListener);
        }

        public Listener(int n, ActionListener actionListener) {
            this(null, n, actionListener);
        }

        public Listener(FileHistory fileHistory, int n, ActionListener actionListener) {
            this.history = fileHistory;
            this.offset = n;
            this.clientListener = actionListener;
        }

        public FileHistory getFileHistory() {
            return this.history;
        }

        public void setFileHistory(FileHistory fileHistory) {
            this.history = fileHistory;
        }

        public void menuSelected(MenuEvent menuEvent) {
            File[] fileArray;
            JMenu jMenu = (JMenu)menuEvent.getSource();
            File[] fileArray2 = fileArray = this.history == null ? null : this.history.getRecentEntries(5);
            if (fileArray == null || fileArray.length == 0) {
                JMenuItem jMenuItem = new JMenuItem(i18n.getString("fh.empty"));
                jMenuItem.putClientProperty(FileHistory.FILE_HISTORY, this);
                jMenuItem.setEnabled(false);
                if (this.offset < 0) {
                    jMenu.add(jMenuItem);
                } else {
                    jMenu.insert(jMenuItem, this.offset);
                }
            } else {
                for (int i = 0; i < fileArray.length; ++i) {
                    JMenuItem jMenuItem = new JMenuItem(i + " " + fileArray[i].getPath());
                    jMenuItem.setActionCommand(fileArray[i].getPath());
                    jMenuItem.addActionListener(this.clientListener);
                    jMenuItem.putClientProperty(FILE, fileArray[i]);
                    jMenuItem.putClientProperty(FileHistory.FILE_HISTORY, this);
                    jMenuItem.setMnemonic(48 + i);
                    if (this.offset < 0) {
                        jMenu.add(jMenuItem);
                        continue;
                    }
                    jMenu.insert(jMenuItem, this.offset + i);
                }
            }
        }

        public void menuDeselected(MenuEvent menuEvent) {
            this.removeDynamicEntries((JMenu)menuEvent.getSource());
        }

        public void menuCanceled(MenuEvent menuEvent) {
            this.removeDynamicEntries((JMenu)menuEvent.getSource());
        }

        private void removeDynamicEntries(JMenu jMenu) {
            for (int i = jMenu.getItemCount() - 1; i >= 0; --i) {
                JMenuItem jMenuItem = jMenu.getItem(i);
                if (jMenuItem == null || jMenuItem.getClientProperty(FileHistory.FILE_HISTORY) != this) continue;
                jMenu.remove(jMenuItem);
            }
        }
    }
}

