/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.help.JHelpContentViewer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

class FocusMonitor {
    private Action activateAction = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            FocusMonitor.this.setVisible(true);
        }
    };
    private Action reportAction = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            FocusMonitor.this.report();
        }
    };
    private KeyStroke activateKey;
    private KeyStroke reportKey;
    private String reportFile;
    private JFrame frame;
    private SummaryPanel prevFocusPanel;
    private DetailPanel currFocusPanel;
    private SummaryPanel nextFocusPanel;
    private Component currentComponent;
    private boolean highlighting;
    private boolean savedOpaque;
    private Color savedBackground;
    private static FocusMonitor focusMonitor;
    private static final Color STD_COLOR;
    private static final Color ERR_COLOR;
    private static final Color WARN_COLOR;
    private static final Color HILITE_COLOR;
    private static final String NEWLINE;
    static /* synthetic */ Class class$java$awt$Window;

    public static FocusMonitor access() {
        if (focusMonitor == null) {
            focusMonitor = new FocusMonitor();
        }
        return focusMonitor;
    }

    public void setOptions(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-open")) {
                this.setVisible(true);
                continue;
            }
            if (stringArray[i].equals("-bg")) {
                this.setHighlightEnabled(true);
                continue;
            }
            System.err.println("Warning: bad option for FocusMonitor: " + stringArray[i]);
        }
    }

    public void setActivateKey(String string) {
        this.activateKey = KeyStroke.getKeyStroke(string);
    }

    public void setReportKey(String string) {
        this.reportKey = KeyStroke.getKeyStroke(string);
    }

    public void setReportFile(String string) {
        this.reportFile = string;
    }

    public void monitor(Component component) {
        if (component == null || this.frame != null && (this.frame == component || this.frame.isAncestorOf(component))) {
            return;
        }
        if (this.activateKey != null || this.reportKey != null) {
            JRootPane jRootPane;
            Window window = (Window)(component instanceof Window ? component : SwingUtilities.getAncestorOfClass(class$java$awt$Window == null ? (class$java$awt$Window = FocusMonitor.class$("java.awt.Window")) : class$java$awt$Window, component));
            if (window == null) {
                return;
            }
            if (window instanceof JFrame) {
                jRootPane = ((JFrame)window).getRootPane();
            } else if (window instanceof JDialog) {
                jRootPane = ((JDialog)window).getRootPane();
            } else {
                return;
            }
            if (jRootPane == null) {
                return;
            }
            InputMap inputMap = jRootPane.getInputMap(2);
            inputMap.put(this.activateKey, "focusMonitor.activate");
            inputMap.put(this.reportKey, "focusMonitor.report");
            ActionMap actionMap = jRootPane.getActionMap();
            actionMap.put("focusMonitor.activate", this.activateAction);
            actionMap.put("focusMonitor.report", this.reportAction);
        }
    }

    public void report() {
        try {
            Writer writer = this.reportFile == null ? new OutputStreamWriter(System.out){

                public void close() throws IOException {
                    this.flush();
                }
            } : new BufferedWriter(new FileWriter(this.reportFile, true));
            writer.write("---------------------------------------");
            writer.write(NEWLINE);
            this.report(writer);
            writer.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            if (this.frame == null) {
                this.initGUI();
            }
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            focusMonitor.monitor(keyboardFocusManager.getFocusOwner());
            this.frame.setVisible(true);
            focusMonitor.update();
        } else if (this.frame != null) {
            this.frame.setVisible(false);
        }
    }

    private FocusMonitor() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("focusOwner")) {
                    FocusMonitor.this.update();
                }
            }
        });
    }

    private void deactivate() {
        this.frame.setVisible(false);
        this.frame.dispose();
        this.frame = null;
    }

    private void update() {
        if (this.frame == null || !this.frame.isVisible()) {
            return;
        }
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component component = keyboardFocusManager.getFocusOwner();
        if (component == null || this.frame == component || this.frame.isAncestorOf(component)) {
            this.prevFocusPanel.setEnabled(false);
            this.currFocusPanel.setEnabled(false);
            this.nextFocusPanel.setEnabled(false);
        } else {
            Window window;
            if (this.highlighting) {
                this.setHighlight(this.currentComponent, false);
                this.setHighlight(component, true);
            }
            this.currentComponent = component;
            this.prevFocusPanel.setComponent(this.getPreviousFocus(component));
            this.currFocusPanel.setComponent(component);
            this.nextFocusPanel.setComponent(this.getNextFocus(component));
            for (window = keyboardFocusManager.getFocusedWindow(); window != null && !(window instanceof Frame); window = window.getOwner()) {
            }
            String string = "Focus Monitor";
            if (window instanceof Frame) {
                string = string + " - " + ((Frame)window).getTitle();
            }
            this.frame.setTitle(string);
        }
    }

    private void setHighlightEnabled(boolean bl) {
        if (bl != this.highlighting) {
            this.highlighting = bl;
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component component = keyboardFocusManager.getFocusOwner();
            if (this.frame == null || !this.frame.isAncestorOf(component)) {
                this.setHighlight(component, this.highlighting);
            }
        }
    }

    private void setHighlight(Component component, boolean bl) {
        if (component == null) {
            return;
        }
        if (bl) {
            this.savedOpaque = component.isOpaque();
            this.savedBackground = component.getBackground();
            if (component instanceof JComponent) {
                ((JComponent)component).setOpaque(true);
            }
            component.setBackground(HILITE_COLOR);
        } else {
            if (component instanceof JComponent) {
                ((JComponent)component).setOpaque(this.savedOpaque);
            }
            component.setBackground(this.savedBackground);
        }
    }

    private void report(Writer writer) throws IOException {
        if (this.currFocusPanel == null) {
            System.err.println("focus monitor not open: no component selected");
            return;
        }
        this.currFocusPanel.write(writer);
    }

    private void initGUI() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("View");
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("background");
        jMenu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent menuEvent) {
                jCheckBoxMenuItem.setSelected(FocusMonitor.this.highlighting);
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }

            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        jCheckBoxMenuItem.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                FocusMonitor.this.setHighlightEnabled(jCheckBoxMenuItem.isSelected());
            }
        });
        jMenu.add(jCheckBoxMenuItem);
        jMenuBar.add(jMenu);
        this.prevFocusPanel = new SummaryPanel();
        this.prevFocusPanel.setBorder(BorderFactory.createTitledBorder("previous focus"));
        this.currFocusPanel = new DetailPanel();
        this.currFocusPanel.setBorder(BorderFactory.createTitledBorder("current focus"));
        this.nextFocusPanel = new SummaryPanel();
        this.nextFocusPanel.setBorder(BorderFactory.createTitledBorder("next focus"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.prevFocusPanel, gridBagConstraints);
        gridBagConstraints.insets.top = 10;
        jPanel.add((Component)this.currFocusPanel, gridBagConstraints);
        jPanel.add((Component)this.nextFocusPanel, gridBagConstraints);
        JFrame jFrame = new JFrame("Focus Monitor");
        jFrame.setJMenuBar(jMenuBar);
        jFrame.setContentPane(jPanel);
        jFrame.pack();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                FocusMonitor.this.deactivate();
            }
        });
        this.frame = jFrame;
    }

    private Component getNextFocus(Component component) {
        if (component == null) {
            return null;
        }
        Container container = component.getFocusCycleRootAncestor();
        Component component2 = component;
        while (!(container == null || container.isShowing() && container.isFocusable() && container.isEnabled())) {
            component2 = container;
            container = component2.getFocusCycleRootAncestor();
        }
        if (container == null) {
            return null;
        }
        FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
        Component component3 = focusTraversalPolicy.getComponentAfter(container, component2);
        if (component3 == null) {
            component3 = focusTraversalPolicy.getDefaultComponent(container);
        }
        return component3;
    }

    private Component getPreviousFocus(Component component) {
        if (component == null) {
            return null;
        }
        Container container = component.getFocusCycleRootAncestor();
        Component component2 = component;
        while (!(container == null || container.isShowing() && container.isFocusable() && container.isEnabled())) {
            component2 = container;
            container = component2.getFocusCycleRootAncestor();
        }
        if (container == null) {
            return null;
        }
        FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
        Component component3 = focusTraversalPolicy.getComponentBefore(container, component2);
        if (component3 == null) {
            component3 = focusTraversalPolicy.getDefaultComponent(container);
        }
        return component3;
    }

    private Component getUpFocus(Component component) {
        Container container;
        Container container2;
        if (component == null) {
            return null;
        }
        for (container2 = component.getFocusCycleRootAncestor(); !(container2 == null || container2.isShowing() && container2.isFocusable() && container2.isEnabled()); container2 = container2.getFocusCycleRootAncestor()) {
        }
        if (container2 != null) {
            return container2;
        }
        Container container3 = container = component instanceof Container ? (Container)component : component.getParent();
        while (container != null && !(container instanceof Window)) {
            container = container.getParent();
        }
        if (container == null) {
            return null;
        }
        Component component2 = container.getFocusTraversalPolicy().getDefaultComponent(container);
        return component2;
    }

    private static String getKeysString(Component component, int n) {
        if (component == null) {
            return null;
        }
        Set<AWTKeyStroke> set = component.getFocusTraversalKeys(n);
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<AWTKeyStroke> iterator = set.iterator();
        while (iterator.hasNext()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(iterator.next());
        }
        if (!component.areFocusTraversalKeysSet(n)) {
            stringBuffer.append(" (inherited)");
        }
        return stringBuffer.toString();
    }

    private static String getPath(Component component) {
        StringBuffer stringBuffer = new StringBuffer();
        FocusMonitor.appendPath(stringBuffer, component);
        return stringBuffer.toString();
    }

    private static void appendPath(StringBuffer stringBuffer, Component component) {
        Container container = component.getParent();
        if (container != null) {
            FocusMonitor.appendPath(stringBuffer, container);
        }
        stringBuffer.append('/');
        String string = component.getName();
        if (string == null || string.length() == 0) {
            for (int i = 0; i < container.getComponentCount(); ++i) {
                if (container.getComponent(i) != component) continue;
                stringBuffer.append(i);
                break;
            }
        } else {
            stringBuffer.append(string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        STD_COLOR = Color.black;
        ERR_COLOR = Color.red;
        WARN_COLOR = Color.yellow;
        HILITE_COLOR = new Color(255, 255, 200);
        NEWLINE = System.getProperty("line.separator");
    }

    private class DetailPanel
    extends SummaryPanel {
        private Entry accName;
        private Entry accDesc;
        private Entry toolTip;
        private Entry text;
        private Entry labelFor;
        private Entry mnemonic;
        private Entry fwdKeys;
        private Entry bwdKeys;
        private Entry upKeys;
        private Entry downKeys;

        DetailPanel() {
            this.accName = new Entry("acc. name");
            this.add(this.accName);
            this.accDesc = new Entry("acc. desc");
            this.add(this.accDesc);
            this.toolTip = new Entry("tooltip");
            this.add(this.toolTip);
            this.text = new Entry("text");
            this.add(this.text);
            this.labelFor = new Entry("label for");
            this.add(this.labelFor);
            this.mnemonic = new Entry("mnemonic");
            this.add(this.mnemonic);
            this.fwdKeys = new Entry("> keys");
            this.add(this.fwdKeys);
            this.bwdKeys = new Entry("< keys");
            this.add(this.bwdKeys);
            this.upKeys = new Entry("^ keys");
            this.add(this.upKeys);
            this.downKeys = new Entry("v keys");
            this.add(this.downKeys);
        }

        void setComponent(Component component) {
            AccessibleContext accessibleContext;
            super.setComponent(component);
            AccessibleContext accessibleContext2 = accessibleContext = component == null ? null : component.getAccessibleContext();
            if (accessibleContext == null) {
                this.accName.setText(null, "not accessible");
                this.accDesc.setText(null, "not accessible");
            } else {
                boolean bl = component instanceof JScrollBar;
                String string = accessibleContext.getAccessibleName();
                this.accName.setText(string != null ? string : "no accessible name", string != null || bl);
                String string2 = accessibleContext.getAccessibleDescription();
                this.accDesc.setText(string2 != null ? string2 : "no accessible description", string2 != null || bl);
            }
            if (component != null && component instanceof JComponent) {
                String string = ((JComponent)component).getToolTipText();
                boolean bl = string == null || string.length() == 0;
                boolean bl2 = !bl || component instanceof JTree || component instanceof JEditorPane || component instanceof JHelpContentViewer || component instanceof JList || component instanceof JRootPane || component instanceof JScrollBar || component instanceof JTextComponent && !((JTextComponent)component).isEditable();
                this.toolTip.setText(bl ? "no tooltip" : string, bl2);
            } else {
                this.toolTip.setEnabled(false);
            }
            if (component instanceof JButton) {
                this.text.setText(((JButton)component).getText());
            } else if (component instanceof JLabel) {
                this.text.setText(((JLabel)component).getText());
            } else if (component instanceof JTextComponent) {
                JTextComponent jTextComponent = (JTextComponent)component;
                Document document = jTextComponent.getDocument();
                try {
                    this.text.setText(document.getText(0, Math.min(80, document.getLength())));
                }
                catch (Exception exception) {
                    this.text.setText(null, exception.toString());
                }
            } else {
                this.text.setEnabled(false);
            }
            if (component != null && component instanceof JLabel) {
                this.labelFor.setText(component.getClass().getName() + " " + component.getName());
            } else {
                this.labelFor.setEnabled(false);
            }
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                int n = jLabel.getDisplayedMnemonic();
                boolean bl = n != 0 || jLabel.getLabelFor() == null;
                this.mnemonic.setText(n == 0 ? "no mnemonic" : String.valueOf((char)n), bl);
            } else if (component instanceof JButton) {
                JButton jButton = (JButton)component;
                int n = jButton.getMnemonic();
                String string = jButton.getActionCommand();
                boolean bl = n != 0 || string != null && string.equals("cancel");
                this.mnemonic.setText(n == 0 ? "no mnemonic" : String.valueOf((char)n), bl);
            } else {
                this.mnemonic.setEnabled(false);
            }
            this.fwdKeys.setText(FocusMonitor.getKeysString(component, 0));
            this.bwdKeys.setText(FocusMonitor.getKeysString(component, 1));
            this.upKeys.setText(FocusMonitor.getKeysString(component, 2));
            this.downKeys.setText(FocusMonitor.getKeysString(component, 3));
        }
    }

    private class SummaryPanel
    extends JPanel {
        private Vector entries = new Vector();
        private Entry name;
        private Entry path;
        private Entry type;

        SummaryPanel() {
            this.setName("summary");
            this.setLayout(new GridBagLayout());
            this.type = new Entry("type");
            this.add(this.type);
            this.name = new Entry("name");
            this.add(this.name);
            this.path = new Entry("path");
            this.add(this.path);
        }

        void setComponent(Component component) {
            if (component == null) {
                this.setEnabled(false);
                this.type.setEnabled(false);
                this.name.setEnabled(false);
                this.path.setEnabled(false);
            } else {
                this.setEnabled(true);
                this.type.setText(component.getClass().getName());
                this.name.setText(component.getName(), "no name", STD_COLOR, WARN_COLOR);
                this.path.setText(FocusMonitor.getPath(component));
            }
        }

        void write(Writer writer) throws IOException {
            for (int i = 0; i < this.entries.size(); ++i) {
                Entry entry = (Entry)this.entries.elementAt(i);
                entry.write(writer);
            }
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            for (int i = 0; i < this.entries.size(); ++i) {
                Entry entry = (Entry)this.entries.elementAt(i);
                entry.setParentEnabled(bl);
            }
        }

        protected void add(Entry entry) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.add((Component)entry.label, gridBagConstraints);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridwidth = 0;
            gridBagConstraints2.weightx = 1.0;
            this.add((Component)entry.field, gridBagConstraints2);
            this.entries.add(entry);
        }
    }

    private class Entry {
        JLabel label;
        JTextField field;
        boolean enabled;

        Entry(String string) {
            this.label = new JLabel(string + ": ");
            this.label.setName(string);
            this.field = new JTextField(60);
            this.field.setName(string + ".value");
            this.field.setEditable(false);
            this.label.setLabelFor(this.field);
        }

        void setParentEnabled(boolean bl) {
            this.label.setEnabled(bl && this.enabled);
            this.field.setEnabled(bl && this.enabled);
        }

        void setEnabled(boolean bl) {
            this.enabled = bl;
            this.label.setEnabled(bl);
            this.field.setEnabled(bl);
            this.field.setText("");
        }

        void setText(String string) {
            this.setEnabled(true);
            this.field.setText(string);
            this.field.setForeground(STD_COLOR);
        }

        void setText(String string, boolean bl) {
            this.setText(string, bl, STD_COLOR, ERR_COLOR);
        }

        void setText(String string, boolean bl, Color color, Color color2) {
            this.setEnabled(true);
            this.field.setText(string);
            this.field.setForeground(bl ? color : color2);
        }

        void setText(String string, String string2) {
            if (string == null || string.length() == 0) {
                this.setText(string2, false);
            } else {
                this.setText(string, true);
            }
        }

        void setText(String string, String string2, Color color, Color color2) {
            if (string == null || string.length() == 0) {
                this.setText(string2, false, color, color2);
            } else {
                this.setText(string, true, color, color2);
            }
        }

        void write(Writer writer) throws IOException {
            if (this.field.isEnabled()) {
                writer.write(this.field.getForeground() == ERR_COLOR ? "** " : "   ");
                writer.write(this.label.getText());
                writer.write(this.field.getText());
                writer.write(NEWLINE);
            }
        }
    }
}

