/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class PieChart
extends JComponent {
    private int[] slices;
    private Color[] colors;
    private static final int OFFSETX = 7;
    private static final int OFFSETY = 7;
    private static final float GRAD_ANGLE = 45.0f;
    private static final float MIN_SLICE = 2.0f;

    private PieChart() {
    }

    public PieChart(int[] nArray, Color[] colorArray) {
        this();
        this.setValue(nArray, colorArray);
    }

    public void setValue(int[] nArray, Color[] colorArray) {
        if (nArray.length != colorArray.length) {
            throw new IllegalArgumentException();
        }
        this.colors = colorArray;
        this.slices = nArray;
        this.repaint();
    }

    protected void paintComponent(Graphics graphics) {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
        this.paintPie(graphics2D);
        graphics2D.dispose();
        graphics.drawImage(bufferedImage, 0, 0, null);
        graphics.dispose();
    }

    private void paintPie(Graphics2D graphics2D) {
        int n;
        if (this.isOpaque()) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.slices == null || this.slices.length == 0) {
            return;
        }
        float f = 0.0f;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.slices.length; ++i) {
            f += (float)this.slices[i];
            if (this.slices[i] > this.slices[n3]) {
                n3 = i;
            }
            if (this.slices[i] <= this.slices[n2]) continue;
            n2 = i;
        }
        if (f < 0.1f) {
            return;
        }
        Insets insets = this.getInsets();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n4 = Math.min(this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        float f2 = (float)n4 * 0.8f;
        float f3 = (float)insets.left + 0.1f * ((float)n4 - f2);
        float f4 = (float)insets.top + 0.1f * ((float)n4 - f2);
        if (this.getWidth() <= this.getHeight()) {
            f4 = (float)(this.getHeight() / 2) - 0.5f * f2;
        }
        float f5 = f3 + 7.0f;
        float f6 = f4 + 7.0f;
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, Color.decode("#dddddd"), this.getWidth(), this.getHeight(), this.getBackground());
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(new Ellipse2D.Float(f5, f6, f2 * 0.98f, f2 * 0.98f));
        float[] fArray = new float[this.slices.length];
        for (n = 0; n < this.slices.length; ++n) {
            fArray[n] = this.slices[n] == 0 ? 0.0f : ((float)this.slices[n] == f ? 360.0f : 360.0f * ((float)this.slices[n] / f));
        }
        for (n = 0; n < fArray.length; ++n) {
            if (!(fArray[n] > 0.0f) || !(fArray[n] < 2.0f)) continue;
            fArray[n3] = fArray[n3] - (2.0f - fArray[n]);
            fArray[n] = 2.0f;
        }
        float f7 = 90.0f;
        for (int i = 0; i < this.slices.length; ++i) {
            if (!((double)fArray[i] > 0.0)) continue;
            graphics2D.setPaint(this.colors[i]);
            graphics2D.fill(new Arc2D.Float(f3, f4, f2, f2, f7, -1.0f * fArray[i], 2));
            if (this.colors[i].equals(Color.WHITE)) {
                graphics2D.setPaint(Color.BLACK);
                if (fArray[i] == 360.0f) {
                    graphics2D.draw(new Ellipse2D.Float(f3, f4, f2, f2));
                } else {
                    graphics2D.draw(new Arc2D.Float(f3, f4, f2, f2, f7, -1.0f * fArray[i], 2));
                }
            }
            f7 -= fArray[i];
        }
    }
}

