/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.SortedProperties;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class Preferences {
    private static Preferences theOne;
    private File prefsFile;
    private Properties props;
    private Hashtable observers = new Hashtable();
    private static I18NResourceBundle i18n;
    static /* synthetic */ Class class$com$sun$javatest$tool$Preferences;

    public static Preferences access() {
        if (theOne == null) {
            theOne = new Preferences(Preferences.getDefaultPrefsFile());
        }
        return theOne;
    }

    private static File getDefaultPrefsFile() {
        String string = System.getProperty("javatest.preferences.file");
        if (string == null) {
            File file = new File(System.getProperty("user.home"));
            File file2 = new File(file, ".javatest");
            return new File(file2, "preferences");
        }
        if (!string.equals("NONE")) {
            return new File(string);
        }
        return null;
    }

    private Preferences(File file) {
        this.prefsFile = file;
        SortedProperties sortedProperties = new SortedProperties();
        try {
            if (this.prefsFile != null) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.prefsFile));
                sortedProperties.load(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.props = sortedProperties;
    }

    public synchronized void save() {
        if (this.prefsFile != null) {
            try {
                File file = new File(this.prefsFile.getParent());
                if (!file.exists()) {
                    file.mkdirs();
                }
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.prefsFile));
                this.props.store(bufferedOutputStream, "JavaTest Preferences");
                ((OutputStream)bufferedOutputStream).close();
            }
            catch (IOException iOException) {
                System.err.println(i18n.getString("prefs.cannotSave", iOException));
            }
        }
    }

    public String getPreference(String string) {
        return this.getPreference(string, null);
    }

    public String getPreference(String string, String string2) {
        String string3 = (String)this.props.get(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public void setPreference(String string, String string2) {
        this.props.put(string, string2);
        Enumeration enumeration = this.observers.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string.startsWith(string3)) continue;
            Observer[] observerArray = (Observer[])this.observers.get(string3);
            for (int i = 0; i < observerArray.length; ++i) {
                observerArray[i].updated(string, string2);
            }
        }
    }

    public void addObserver(String string, Observer observer) {
        Object[] objectArray = (Observer[])this.observers.get(string);
        objectArray = objectArray == null ? new Observer[]{observer} : (Observer[])DynamicArray.append(objectArray, observer);
        this.observers.put(string, objectArray);
    }

    public void addObserver(String[] stringArray, Observer observer) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addObserver(stringArray[i], observer);
        }
    }

    public void removeObserver(String string, Observer observer) {
        Object[] objectArray = (Observer[])this.observers.get(string);
        if (objectArray != null) {
            objectArray = (Observer[])DynamicArray.remove(objectArray, observer);
            this.observers.put(string, objectArray);
        }
    }

    public void removeObserver(String[] stringArray, Observer observer) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.removeObserver(stringArray[i], observer);
        }
    }

    public void showDialog(JFrame jFrame, Pane[] paneArray, HelpBroker helpBroker) {
        PrefsDialog prefsDialog = new PrefsDialog(jFrame, paneArray, helpBroker);
        prefsDialog.setVisible(true);
    }

    private void setPreferences(Pane[] paneArray) {
        Map map = new Map(){

            public void clear() {
                throw new UnsupportedOperationException();
            }

            public boolean containsKey(Object object) {
                return Preferences.this.props.containsKey(object);
            }

            public boolean containsValue(Object object) {
                return Preferences.this.props.containsValue(object);
            }

            public Set entrySet() {
                return Preferences.this.props.entrySet();
            }

            public boolean equals(Object object) {
                return Preferences.this.props.equals(object);
            }

            public Object get(Object object) {
                return Preferences.this.props.get(object);
            }

            public int hashCode() {
                return Preferences.this.props.hashCode();
            }

            public boolean isEmpty() {
                return Preferences.this.props.isEmpty();
            }

            public Set keySet() {
                return Preferences.this.props.keySet();
            }

            public Object put(Object object, Object object2) {
                Object object3 = Preferences.this.props.get(object);
                if (object3 == null || !object3.equals(object2)) {
                    Preferences.this.setPreference((String)object, (String)object2);
                }
                return object3;
            }

            public void putAll(Map map) {
                throw new UnsupportedOperationException();
            }

            public Object remove(Object object) {
                throw new UnsupportedOperationException();
            }

            public int size() {
                return Preferences.this.props.size();
            }

            public Collection values() {
                return Preferences.this.props.values();
            }
        };
        for (int i = 0; i < paneArray.length; ++i) {
            paneArray[i].save(map);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$tool$Preferences == null ? (class$com$sun$javatest$tool$Preferences = Preferences.class$("com.sun.javatest.tool.Preferences")) : class$com$sun$javatest$tool$Preferences);
    }

    private class PrefsDialog
    extends JDialog
    implements ActionListener,
    TreeModel,
    TreeSelectionListener,
    WindowListener {
        private int cardNum;
        private JFrame owner;
        private HelpBroker helpBroker;
        private Pane[] panes;
        private UIFactory uif;
        private JPanel main;
        private JPanel deck;
        private JButton okBtn;
        private JButton applyBtn;
        private JButton resetBtn;
        private JButton helpBtn;
        private JTree tree;

        PrefsDialog(JFrame jFrame, Pane[] paneArray, HelpBroker helpBroker) {
            super((Frame)null, true);
            this.owner = jFrame;
            this.panes = paneArray;
            this.helpBroker = helpBroker;
            this.uif = new UIFactory(this.getClass(), helpBroker);
            this.initGUI();
            this.owner.addWindowListener(this);
        }

        public void setVisible(boolean bl) {
            if (bl) {
                for (int i = 0; i < this.panes.length; ++i) {
                    this.panes[i].load(Preferences.this.props);
                }
            }
            super.setVisible(bl);
            if (!bl) {
                this.owner.removeWindowListener(this);
            }
        }

        private void initGUI() {
            this.setName("prefs");
            this.setTitle(this.uif.getI18NString("prefs.title"));
            this.helpBroker.enableHelpKey(this.getRootPane(), "ui.prefs.dialog.csh", null);
            Desktop.addHelpDebugListener(this);
            this.uif.setAccessibleDescription(this, "prefs");
            this.main = this.uif.createPanel("prefs.main", new BorderLayout(), false);
            this.initTree();
            this.initPanes();
            this.initButtons();
            this.setContentPane(this.main);
            Object[] objectArray = new Object[]{this.tree.getModel().getRoot(), this.getChildren(this)[0]};
            this.tree.setSelectionPath(new TreePath(objectArray));
            this.pack();
            this.setLocationRelativeTo(this.owner);
            this.getRootPane().setDefaultButton(this.okBtn);
        }

        private void initTree() {
            this.tree = new JTree(this);
            this.tree.setName("prefs.tree");
            this.tree.addTreeSelectionListener(this);
            this.tree.setEditable(false);
            this.tree.setShowsRootHandles(true);
            this.tree.setRootVisible(false);
            this.uif.setAccessibleInfo(this.tree, "prefs.tree");
            int n = this.uif.getDotsPerInch();
            this.tree.setPreferredSize(new Dimension(2 * n, n));
            this.tree.setVisibleRowCount(10);
            this.tree.setCellRenderer(new DefaultTreeCellRenderer(this){
                private final /* synthetic */ PrefsDialog this$1;
                {
                    this.this$1 = prefsDialog;
                }

                public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                    if (object instanceof Pane) {
                        return super.getTreeCellRendererComponent(jTree, ((Pane)object).getText(), bl, bl2, bl3, n, bl4);
                    }
                    return super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                }
            });
            this.tree.getSelectionModel().setSelectionMode(1);
            JScrollPane jScrollPane = this.uif.createScrollPane(this.tree);
            jScrollPane.setBorder(BorderFactory.createEtchedBorder());
            this.main.add((Component)jScrollPane, "West");
        }

        private void initButtons() {
            Cloneable cloneable;
            int n;
            this.okBtn = this.uif.createButton("prefs.ok", this);
            this.applyBtn = this.uif.createButton("prefs.apply", this);
            this.resetBtn = this.uif.createButton("prefs.reset", this);
            this.helpBtn = this.uif.createHelpButton("prefs.help", "ui.prefs.dialog.csh");
            JButton[] jButtonArray = new JButton[]{this.okBtn, this.applyBtn, this.resetBtn, this.helpBtn};
            Dimension dimension = new Dimension();
            for (n = 0; n < jButtonArray.length; ++n) {
                cloneable = jButtonArray[n].getPreferredSize();
                dimension.width = Math.max(dimension.width, cloneable.width);
                dimension.height = Math.max(dimension.height, cloneable.height);
            }
            for (n = 0; n < jButtonArray.length; ++n) {
                jButtonArray[n].setPreferredSize(dimension);
            }
            JPanel jPanel = this.uif.createPanel("prefs.btns", false);
            jPanel.setLayout(new GridBagLayout());
            cloneable = new GridBagConstraints();
            ((GridBagConstraints)cloneable).anchor = 13;
            ((GridBagConstraints)cloneable).insets.top = 5;
            ((GridBagConstraints)cloneable).insets.bottom = 11;
            ((GridBagConstraints)cloneable).insets.right = 11;
            ((GridBagConstraints)cloneable).weightx = 1.0;
            for (int i = 0; i < jButtonArray.length; ++i) {
                jPanel.add((Component)jButtonArray[i], cloneable);
                ((GridBagConstraints)cloneable).weightx = 0.0;
            }
            this.main.add((Component)jPanel, "South");
        }

        private void initPanes() {
            this.deck = this.uif.createPanel("prefs.deck", new CardLayout(), false);
            this.addAllPanes(this.deck, this.panes);
            int n = this.uif.getDotsPerInch();
            Dimension dimension = new Dimension(3 * n, 2 * n);
            for (int i = 0; i < this.deck.getComponentCount(); ++i) {
                Dimension dimension2 = this.deck.getComponent(i).getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                dimension.height = Math.max(dimension.height, dimension2.height);
            }
            this.deck.setPreferredSize(dimension);
            this.main.add((Component)this.deck, "Center");
        }

        private void addAllPanes(JPanel jPanel, Pane[] paneArray) {
            for (int i = 0; i < paneArray.length; ++i) {
                Pane pane = paneArray[i];
                JPanel jPanel2 = this.uif.createPanel("prefs.card" + this.cardNum++, false);
                jPanel2.setLayout(new BorderLayout());
                JLabel jLabel = new JLabel(pane.getText());
                jLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                jPanel2.add((Component)jLabel, "North");
                pane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                jPanel2.add((Component)this.uif.createScrollPane(pane), "Center");
                jPanel.add((Component)jPanel2, pane.getText());
                if (pane.getChildPanes() == null) continue;
                this.addAllPanes(jPanel, pane.getChildPanes());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.okBtn) {
                Preferences.this.setPreferences(this.panes);
                Preferences.this.save();
                this.setVisible(false);
            } else if (object == this.applyBtn) {
                Preferences.this.setPreferences(this.panes);
                Preferences.this.save();
                this.setVisible(true);
            } else if (object == this.resetBtn) {
                for (int i = 0; i < this.panes.length; ++i) {
                    this.panes[i].load(Preferences.this.props);
                }
            }
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
            if (treePath != null) {
                Pane pane = (Pane)treePath.getLastPathComponent();
                ((CardLayout)this.deck.getLayout()).show(this.deck, pane.getText());
            }
        }

        public Object getChild(Object object, int n) {
            return this.getChildren(object)[n];
        }

        public int getChildCount(Object object) {
            return this.getChildren(object).length;
        }

        public int getIndexOfChild(Object object, Object object2) {
            Pane[] paneArray = this.getChildren(object);
            for (int i = 0; i < paneArray.length; ++i) {
                if (paneArray[i] != object2) continue;
                return i;
            }
            return -1;
        }

        public Object getRoot() {
            return this;
        }

        public boolean isLeaf(Object object) {
            Pane[] paneArray = this.getChildren(object);
            return paneArray == null || paneArray.length == 0;
        }

        public void addTreeModelListener(TreeModelListener treeModelListener) {
        }

        public void removeTreeModelListener(TreeModelListener treeModelListener) {
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
            if (windowEvent.getSource() == this.owner) {
                this.toFront();
            }
        }

        public void windowActivated(WindowEvent windowEvent) {
            if (windowEvent.getSource() == this.owner) {
                this.toFront();
            }
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        private Pane[] getChildren(Object object) {
            return object == this ? this.panes : ((Pane)object).getChildPanes();
        }
    }

    public static abstract class Pane
    extends JPanel {
        protected void setHelp(String string) {
            CSH.setHelpIDString(this, string);
        }

        public abstract String getText();

        public void load(Map map) {
            Pane[] paneArray = this.getChildPanes();
            if (paneArray != null) {
                for (int i = 0; i < paneArray.length; ++i) {
                    paneArray[i].load(map);
                }
            }
        }

        public void save(Map map) {
            Pane[] paneArray = this.getChildPanes();
            if (paneArray != null) {
                for (int i = 0; i < paneArray.length; ++i) {
                    paneArray[i].save(map);
                }
            }
        }

        public Pane[] getChildPanes() {
            return null;
        }
    }

    public static interface Observer {
        public void updated(String var1, String var2);
    }
}

