/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.DeskView;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.PrefixMap;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import javax.help.CSH;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

class TabDeskView
extends DeskView {
    private JFrame mainFrame;
    private JTabbedPane contents;
    private Tool selectedTool;
    private Listener listener = new Listener();
    private Action closeAction = new CloseAction();

    TabDeskView(Desktop desktop) {
        this(desktop, TabDeskView.getDefaultBounds());
    }

    TabDeskView(DeskView deskView) {
        this(deskView.getDesktop(), deskView.getBounds());
        Tool[] toolArray = deskView.getTools();
        Arrays.sort(toolArray, new Comparator(){

            public int compare(Object object, Object object2) {
                Long l = new Long(((Tool)object).getCreationTime());
                Long l2 = new Long(((Tool)object2).getCreationTime());
                return l.compareTo(l2);
            }
        });
        for (int i = 0; i < toolArray.length; ++i) {
            this.addTool(toolArray[i]);
        }
        this.setVisible(deskView.isVisible());
    }

    private TabDeskView(Desktop desktop, Rectangle rectangle) {
        super(desktop);
        this.initMainFrame(rectangle);
        this.uif.setDialogParent(this.mainFrame);
        JDialog.setDefaultLookAndFeelDecorated(false);
    }

    public void dispose() {
        this.mainFrame.setVisible(false);
        this.mainFrame.dispose();
        super.dispose();
    }

    public boolean isVisible() {
        return this.mainFrame.isVisible();
    }

    public void setVisible(boolean bl) {
        Window[] windowArray;
        if (bl == this.mainFrame.isVisible()) {
            return;
        }
        this.mainFrame.setVisible(bl);
        if (bl && (windowArray = this.mainFrame.getOwnedWindows()) != null) {
            for (int i = 0; i < windowArray.length; ++i) {
                windowArray[i].toFront();
            }
        }
    }

    public void addTool(Tool tool) {
        DeskView deskView = tool.getDeskView();
        if (deskView == this) {
            return;
        }
        ToolDialog[] toolDialogArray = tool.getToolDialogs();
        boolean[] blArray = new boolean[toolDialogArray.length];
        for (int i = 0; i < toolDialogArray.length; ++i) {
            blArray[i] = toolDialogArray[i].isVisible();
        }
        if (deskView != null) {
            deskView.removeTool(tool);
        }
        String string = this.getUniqueTabTitle(tool.getShortTitle(), null);
        String string2 = tool.getTitle();
        this.contents.addTab(string, null, tool, string2);
        tool.addObserver(this.listener);
        this.closeAction.setEnabled(true);
        tool.setDeskView(this);
        for (int i = 0; i < toolDialogArray.length; ++i) {
            toolDialogArray[i].initDialog(this, blArray[i]);
        }
    }

    public boolean isEmpty() {
        return this.contents.getComponentCount() == 0;
    }

    public Tool[] getTools() {
        Tool[] toolArray = new Tool[this.contents.getComponentCount()];
        for (int i = 0; i < toolArray.length; ++i) {
            toolArray[i] = (Tool)this.contents.getComponentAt(i);
        }
        return toolArray;
    }

    public void removeTool(Tool tool) {
        tool.removeObserver(this.listener);
        this.contents.removeChangeListener(this.listener);
        this.contents.remove(tool);
        tool.setDeskView(null);
        if (tool == this.selectedTool) {
            this.setSelectedTool((Tool)this.contents.getSelectedComponent());
        } else {
            this.contents.setSelectedComponent(this.selectedTool);
        }
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component component = keyboardFocusManager.getPermanentFocusOwner();
        if (component == null || !component.isShowing()) {
            Container container = this.contents.getTabCount() > 0 ? this.contents : this.mainFrame;
            Container container2 = container.isFocusCycleRoot() ? container : container.getFocusCycleRootAncestor();
            FocusTraversalPolicy focusTraversalPolicy = container2.getFocusTraversalPolicy();
            Container container3 = container.isFocusable() ? container : focusTraversalPolicy.getComponentAfter(container2, container);
            container3.requestFocusInWindow();
        }
        this.contents.addChangeListener(this.listener);
        this.closeAction.setEnabled(this.contents.getTabCount() > 0);
    }

    public Tool getSelectedTool() {
        return this.selectedTool;
    }

    public void setSelectedTool(Tool tool) {
        if (tool == this.selectedTool) {
            return;
        }
        if (this.selectedTool != null) {
            this.removeToolMenuItemsFromFrameMenuBar(this.mainFrame, this.selectedTool);
            this.selectedTool.removeObserver(this.listener);
        }
        this.selectedTool = tool;
        if (this.selectedTool == null) {
            this.mainFrame.setTitle(this.uif.getI18NString("dt.title.txt"));
            CSH.setHelpIDString(this.contents, null);
        } else {
            this.addToolMenuItemsToFrameMenuBar(this.mainFrame, this.selectedTool);
            this.selectedTool.addObserver(this.listener);
            this.mainFrame.setTitle(this.uif.getI18NString("dt.title.tool.txt", this.selectedTool.getTitle()));
            CSH.setHelpIDString(this.contents, CSH.getHelpIDString(this.selectedTool));
            this.contents.setSelectedComponent(this.selectedTool);
        }
    }

    public int getStyle() {
        return 0;
    }

    public JFrame[] getFrames() {
        return new JFrame[]{this.mainFrame};
    }

    public Rectangle getBounds() {
        return this.mainFrame.getBounds();
    }

    public boolean isToolOwnerForDialog(Tool tool, Container container) {
        return container != null && container.getParent() == this.mainFrame;
    }

    public Container createDialog(Tool tool, String string, String string2, JMenuBar jMenuBar, Container container, Rectangle rectangle) {
        UIFactory uIFactory = tool.uif;
        JDialog jDialog = uIFactory.createDialog(string, this.mainFrame, string2, container);
        if (jMenuBar != null) {
            jDialog.setJMenuBar(jMenuBar);
        }
        if (rectangle == null) {
            jDialog.pack();
            jDialog.pack();
            jDialog.setLocationRelativeTo(this.mainFrame);
        } else {
            jDialog.setBounds(rectangle);
        }
        return jDialog;
    }

    protected void saveDesktop(Map map) {
        TabDeskView.saveBounds(this.mainFrame, new PrefixMap(map, "dt"));
        this.saveTools(map);
        int n = this.contents.getSelectedIndex();
        if (n >= 0) {
            map.put("dt.selected", String.valueOf(n));
        }
    }

    protected void restoreDesktop(Map map) {
        TabDeskView.restoreBounds(this.mainFrame, new PrefixMap(map, "dt"));
        this.restoreTools(map);
        try {
            int n;
            String string = (String)map.get("dt.selected");
            if (string != null && 0 <= (n = Integer.parseInt(string)) && n < this.contents.getTabCount()) {
                this.contents.setSelectedIndex(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void initMainFrame(Rectangle rectangle) {
        this.mainFrame = this.createFrame(this.listener, this.closeAction, "tdi.main");
        this.contents = this.uif.createTabbedPane("tdi.desk");
        this.contents.setOpaque(true);
        this.contents.setPreferredSize(new Dimension(rectangle.width, rectangle.height));
        this.contents.setTabPlacement(3);
        this.contents.addChangeListener(this.listener);
        this.contents.addAncestorListener(this.listener);
        this.mainFrame.setContentPane(this.contents);
        if (rectangle == null) {
            this.mainFrame.pack();
            Dimension dimension = this.mainFrame.getSize();
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.mainFrame.setLocation(graphicsEnvironment.getCenterPoint().x - dimension.width / 2, graphicsEnvironment.getCenterPoint().y - dimension.height / 2);
        } else {
            this.mainFrame.setBounds(rectangle);
        }
        this.mainFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TabDeskView.this.getDesktop().checkToolsAndExitIfOK(TabDeskView.this.mainFrame);
            }
        });
    }

    private String getUniqueTabTitle(String string, Component component) {
        int n;
        HashSet<String> hashSet = new HashSet<String>();
        for (n = 0; n < this.contents.getTabCount(); ++n) {
            if (this.contents.getComponentAt(n) == component) continue;
            hashSet.add(this.contents.getTitleAt(n));
        }
        if (hashSet.contains(string)) {
            for (n = 0; n <= hashSet.size(); ++n) {
                String string2 = string + " [" + (n + 2) + "]";
                if (hashSet.contains(string2)) continue;
                return string2;
            }
        }
        return string;
    }

    private class Listener
    implements ActionListener,
    AncestorListener,
    ChangeListener,
    MenuListener,
    Tool.Observer {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            Object object = jMenuItem.getClientProperty(this);
            if (object instanceof Window) {
                ((Window)object).toFront();
            } else if (object instanceof Tool) {
                TabDeskView.this.setSelectedTool((Tool)object);
            }
        }

        public void ancestorAdded(AncestorEvent ancestorEvent) {
            Tool tool = (Tool)TabDeskView.this.contents.getSelectedComponent();
            if (tool != null) {
                TabDeskView.this.addToolMenuItemsToFrameMenuBar(TabDeskView.this.mainFrame, tool);
                tool.addObserver(this);
                TabDeskView.this.mainFrame.setTitle(TabDeskView.this.uif.getI18NString("dt.title.tool.txt", tool.getTitle()));
            }
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            Tool tool = (Tool)TabDeskView.this.contents.getSelectedComponent();
            if (tool != null) {
                tool.removeObserver(this);
            }
            TabDeskView.this.mainFrame.setTitle(TabDeskView.this.uif.getI18NString("dt.title.txt"));
        }

        public void stateChanged(ChangeEvent changeEvent) {
            TabDeskView.this.setSelectedTool((Tool)TabDeskView.this.contents.getSelectedComponent());
        }

        public void menuSelected(MenuEvent menuEvent) {
            Tool[] toolArray = TabDeskView.this.getTools();
            JMenu jMenu = (JMenu)menuEvent.getSource();
            jMenu.removeAll();
            JMenu jMenu2 = TabDeskView.this.getWindowOpenMenu();
            if (jMenu2.getItemCount() > 0) {
                jMenu.add(TabDeskView.this.getWindowOpenMenu());
                jMenu.addSeparator();
            }
            if (toolArray.length == 0) {
                JMenuItem jMenuItem = new JMenuItem(TabDeskView.this.uif.getI18NString("dt.windows.noWindows.mit"));
                jMenuItem.setEnabled(false);
                jMenu.add(jMenuItem);
            } else {
                int n = 0;
                for (int i = 0; i < toolArray.length; ++i) {
                    Tool tool = toolArray[i];
                    this.addMenuItem(jMenu, n++, tool.getTitle(), tool);
                }
                Window[] windowArray = TabDeskView.this.mainFrame.getOwnedWindows();
                for (int i = 0; i < windowArray.length; ++i) {
                    Window window = windowArray[i];
                    if (!(window instanceof JDialog) || !window.isVisible()) continue;
                    this.addMenuItem(jMenu, n++, ((JDialog)window).getTitle(), window);
                }
            }
        }

        private void addMenuItem(JMenu jMenu, int n, String string, Object object) {
            JMenuItem jMenuItem = new JMenuItem(TabDeskView.this.uif.getI18NString("dt.windows.toolX.mit", new Object[]{new Integer(n), string}));
            if (n < 10) {
                jMenuItem.setMnemonic(Character.forDigit(n, 10));
            }
            jMenuItem.addActionListener(this);
            jMenuItem.putClientProperty(this, object);
            jMenu.add(jMenuItem);
        }

        public void menuDeselected(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)menuEvent.getSource();
            jMenu.removeAll();
        }

        public void menuCanceled(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)menuEvent.getSource();
            jMenu.removeAll();
        }

        public void shortTitleChanged(Tool tool, String string) {
            for (int i = 0; i < TabDeskView.this.contents.getTabCount(); ++i) {
                if (TabDeskView.this.contents.getComponentAt(i) != tool) continue;
                String string2 = TabDeskView.this.getUniqueTabTitle(string, tool);
                TabDeskView.this.contents.setTitleAt(i, string2);
                break;
            }
        }

        public void titleChanged(Tool tool, String string) {
            if (tool == TabDeskView.this.contents.getSelectedComponent()) {
                TabDeskView.this.mainFrame.setTitle(TabDeskView.this.uif.getI18NString("dt.title.tool.txt", string));
            }
            for (int i = 0; i < TabDeskView.this.contents.getTabCount(); ++i) {
                if (TabDeskView.this.contents.getComponentAt(i) != tool) continue;
                TabDeskView.this.contents.setToolTipTextAt(i, string);
                break;
            }
        }

        public void toolDisposed(Tool tool) {
        }
    }

    private class CloseAction
    extends ToolAction {
        CloseAction() {
            super(TabDeskView.this.uif, "tdi.file.close");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Tool tool = (Tool)TabDeskView.this.contents.getSelectedComponent();
            if (tool != null && TabDeskView.this.getDesktop().isOKToClose(tool, TabDeskView.this.mainFrame)) {
                TabDeskView.this.removeTool(tool);
                tool.dispose();
            }
        }
    }
}

