/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class VerboseCommand
extends Command {
    public static String DEFAULT = "default";
    private static String MAX = "max";
    private static String QUIET = "quiet";
    private static String DATE = "date";
    private static String NO_PREFIX = "no-";
    private static Map allOptions;
    private HashMap optionValues = new HashMap();
    private static final String CMD = "verbose";
    private static I18NResourceBundle i18n;
    static /* synthetic */ Class class$com$sun$javatest$tool$VerboseCommand;

    public static void addOption(String string, HelpTree.Node node) {
        VerboseCommand.ensureAllOptionsInitialized();
        allOptions.put(string, node);
    }

    private static void ensureAllOptionsInitialized() {
        if (allOptions == null) {
            allOptions = new TreeMap();
            allOptions.put(MAX, new HelpTree.Node(i18n, "verb.max"));
            allOptions.put(QUIET, new HelpTree.Node(i18n, "verb.quiet"));
        }
    }

    VerboseCommand(String string) throws Command.Fault {
        super(string);
        int n = string.indexOf(CMD);
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        String string2 = string.substring(n + CMD.length());
        if (string2.length() == 0) {
            this.optionValues.put(DEFAULT, Boolean.TRUE);
        } else if (string2.charAt(0) == ':') {
            string2 = string2.substring(1);
            this.processOptions(string2);
        } else {
            throw new Command.Fault(i18n, "verb.badOpts");
        }
    }

    private void processOptions(String string) throws Command.Fault {
        VerboseCommand.ensureAllOptionsInitialized();
        String[] stringArray = StringArray.splitList(string, ",");
        if (stringArray == null) {
            throw new Command.Fault(i18n, "verb.noOpts");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl;
            String string2 = stringArray[i];
            if (string2.startsWith(NO_PREFIX)) {
                bl = false;
                string2 = string2.substring(NO_PREFIX.length());
            } else {
                bl = true;
            }
            if (!allOptions.containsKey(string2.toLowerCase())) {
                throw (Command)this.new Command.Fault(i18n, "verb.badOpt", string2);
            }
            this.optionValues.put(string2, new Boolean(bl));
        }
    }

    public void run(CommandContext commandContext) throws Command.Fault {
        Iterator iterator = this.optionValues.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            boolean bl = (Boolean)entry.getValue();
            if (string.equalsIgnoreCase(MAX)) {
                commandContext.setVerboseMax(bl);
                continue;
            }
            if (string.equalsIgnoreCase(QUIET)) {
                commandContext.setVerboseQuiet(bl);
                continue;
            }
            if (string.equalsIgnoreCase(DATE)) {
                commandContext.setVerboseTimestampEnabled(bl);
                continue;
            }
            commandContext.setVerboseOptionValue(string, bl);
        }
    }

    static HelpTree.Node getHelp() {
        VerboseCommand.ensureAllOptionsInitialized();
        HelpTree.Node[] nodeArray = new HelpTree.Node[allOptions.size()];
        int n = 0;
        Iterator iterator = allOptions.values().iterator();
        while (iterator.hasNext()) {
            nodeArray[n++] = (HelpTree.Node)iterator.next();
        }
        return new HelpTree.Node(i18n, "verb", nodeArray);
    }

    static String getName() {
        return CMD;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$tool$VerboseCommand == null ? (class$com$sun$javatest$tool$VerboseCommand = VerboseCommand.class$("com.sun.javatest.tool.VerboseCommand")) : class$com$sun$javatest$tool$VerboseCommand);
    }
}

