/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.WrapWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class HelpTree {
    private Node[] nodes;
    private int nodeIndent = 4;
    private int descriptionIndent = 16;
    private static final int ALL = 1;
    private static final int ANY = 2;
    private static Comparator nodeComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            Node node = (Node)object;
            Node node2 = (Node)object2;
            int n = this.compareStrings(node.name, node2.name);
            return n != 0 ? n : this.compareStrings(node.description, node2.description);
        }

        private int compareStrings(String string, String string2) {
            if (string == null && string2 == null) {
                return 0;
            }
            if (string == null || string2 == null) {
                return string == null ? -1 : 1;
            }
            return string.toLowerCase().compareTo(string2.toLowerCase());
        }
    };

    public HelpTree() {
        this.nodes = new Node[0];
    }

    public HelpTree(Node[] nodeArray) {
        this.nodes = nodeArray;
    }

    public void addNode(Node node) {
        this.nodes = (Node[])DynamicArray.append(this.nodes, node);
    }

    public int getNodeIndent() {
        return this.nodeIndent;
    }

    public void setNodeIndent(int n) {
        this.nodeIndent = n;
    }

    public int getDescriptionIndent() {
        return this.descriptionIndent;
    }

    public void setDescriptionIndent(int n) {
        this.descriptionIndent = n;
    }

    public Selection find(String[] stringArray) {
        Selection selection = this.find(stringArray, 1);
        if (selection == null && stringArray.length > 1) {
            selection = this.find(stringArray, 2);
        }
        return selection;
    }

    public Selection findAll(String[] stringArray) {
        return this.find(stringArray, 1);
    }

    public Selection findAny(String[] stringArray) {
        return this.find(stringArray, 2);
    }

    private Selection find(String[] stringArray, int n) {
        TreeMap<Node, Selection> treeMap = null;
        for (int i = 0; i < this.nodes.length; ++i) {
            Node node = this.nodes[i];
            Selection selection = this.find(node, stringArray, n);
            if (selection == null) continue;
            if (treeMap == null) {
                treeMap = new TreeMap<Node, Selection>(nodeComparator);
            }
            treeMap.put(node, selection);
        }
        return treeMap == null ? null : new Selection(treeMap);
    }

    private Selection find(Node node, String[] stringArray, int n) {
        if (n == 1) {
            if (this.containsAllOf(node.name, stringArray) || this.containsAllOf(node.description, stringArray)) {
                return new Selection(node);
            }
        } else if (n == 2) {
            if (this.containsAnyOf(node.name, stringArray) || this.containsAnyOf(node.description, stringArray)) {
                return new Selection(node);
            }
        } else {
            throw new IllegalArgumentException();
        }
        if (node.children == null) {
            return null;
        }
        TreeMap<Node, Selection> treeMap = null;
        for (int i = 0; i < node.children.length; ++i) {
            Node node2 = node.children[i];
            Selection selection = this.find(node2, stringArray, n);
            if (selection == null) continue;
            if (treeMap == null) {
                treeMap = new TreeMap<Node, Selection>(nodeComparator);
            }
            treeMap.put(node2, selection);
        }
        return treeMap == null ? null : new Selection(node, treeMap);
    }

    public void write(Writer writer) throws IOException {
        WrapWriter wrapWriter = this.getWrapWriter(writer);
        for (int i = 0; i < this.nodes.length; ++i) {
            this.write(wrapWriter, this.nodes[i]);
            wrapWriter.write('\n');
        }
        if (wrapWriter != writer) {
            wrapWriter.flush();
        }
    }

    public void write(Writer writer, Selection selection) throws IOException {
        WrapWriter wrapWriter = this.getWrapWriter(writer);
        this.write(wrapWriter, selection.map);
        if (wrapWriter != writer) {
            wrapWriter.flush();
        }
    }

    public void writeSummary(Writer writer) throws IOException {
        WrapWriter wrapWriter = this.getWrapWriter(writer);
        for (int i = 0; i < this.nodes.length; ++i) {
            this.writeHead(wrapWriter, this.nodes[i]);
        }
        if (wrapWriter != writer) {
            wrapWriter.flush();
        }
    }

    private void write(WrapWriter wrapWriter, Map map) throws IOException {
        int n = wrapWriter.getLeftMargin();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Node node = (Node)entry.getKey();
            Selection selection = (Selection)entry.getValue();
            if (selection.map == null) {
                this.write(wrapWriter, node);
            } else {
                this.writeHead(wrapWriter, node);
                wrapWriter.setLeftMargin(n + this.nodeIndent);
                this.write(wrapWriter, selection.map);
                wrapWriter.setLeftMargin(n);
            }
            if (n != 0) continue;
            wrapWriter.write('\n');
        }
    }

    private void write(WrapWriter wrapWriter, Node node) throws IOException {
        int n = wrapWriter.getLeftMargin();
        this.writeHead(wrapWriter, node);
        Node[] nodeArray = node.children;
        if (nodeArray != null && nodeArray.length > 0) {
            wrapWriter.setLeftMargin(n + this.nodeIndent);
            for (int i = 0; i < nodeArray.length; ++i) {
                this.write(wrapWriter, nodeArray[i]);
            }
        }
        wrapWriter.setLeftMargin(n);
    }

    private void writeHead(WrapWriter wrapWriter, Node node) throws IOException {
        int n = wrapWriter.getLeftMargin();
        String string = node.name;
        String string2 = node.description;
        if (string != null) {
            wrapWriter.write(string);
            wrapWriter.write(' ');
            if (string2 != null) {
                wrapWriter.setLeftMargin(n + this.descriptionIndent);
                if (wrapWriter.getCharsOnLineSoFar() + 2 > wrapWriter.getLeftMargin()) {
                    wrapWriter.write('\n');
                }
                wrapWriter.write(string2);
            }
            wrapWriter.write('\n');
        }
        wrapWriter.setLeftMargin(n);
    }

    private boolean containsAllOf(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.contains(string, stringArray[i])) continue;
            return false;
        }
        return true;
    }

    private boolean containsAnyOf(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.contains(string, stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private boolean contains(String string, String string2) {
        int n = string.toLowerCase().indexOf(string2.toLowerCase());
        if (n == -1) {
            return false;
        }
        int n2 = n + string2.length();
        return !(n != 0 && Character.isLetter(string.charAt(n - 1)) || n2 != string.length() && Character.isLetter(string.charAt(n2)));
    }

    private WrapWriter getWrapWriter(Writer writer) {
        return writer instanceof WrapWriter ? (WrapWriter)writer : new WrapWriter(writer);
    }

    public class Selection {
        private Node node;
        private Map map;

        private Selection(Node node) {
            this(node, (Map)null);
        }

        private Selection(Map map) {
            this(null, map);
        }

        private Selection(Node node, Map map) {
            this.node = node;
            this.map = map;
        }
    }

    public static class Node {
        private String name;
        private String description;
        private Node[] children;

        public Node(String string, String string2) {
            this.name = string;
            this.description = string2;
        }

        public Node(String string, String string2, Node[] nodeArray) {
            this.name = string;
            this.description = string2;
            this.children = nodeArray;
        }

        public Node(I18NResourceBundle i18NResourceBundle, String string) {
            this.name = i18NResourceBundle.getString(string + ".name");
            this.description = i18NResourceBundle.getString(string + ".desc");
        }

        public Node(I18NResourceBundle i18NResourceBundle, String string, Node[] nodeArray) {
            this(i18NResourceBundle, string);
            this.children = nodeArray;
        }

        public Node(I18NResourceBundle i18NResourceBundle, String string, String[] stringArray) {
            this(i18NResourceBundle, string);
            this.children = new Node[stringArray.length];
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i] = new Node(i18NResourceBundle, string + '.' + stringArray[i]);
            }
        }

        public final String getName() {
            return this.name;
        }

        public final String getDescription() {
            return this.description;
        }

        public int getChildCount() {
            return this.children == null ? 0 : this.children.length;
        }

        public Node getChild(int n) {
            if (n >= this.getChildCount()) {
                throw new IllegalArgumentException();
            }
            return this.children[n];
        }
    }
}

