/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class PathClassLoader
extends ClassLoader {
    private File[] path;
    private Hashtable classes = new Hashtable();
    private Hashtable zips = new Hashtable();

    public PathClassLoader(String string) {
        this.path = this.split(string);
    }

    public PathClassLoader(File file, String string) {
        this.path = this.split(string);
        for (int i = 0; i < this.path.length; ++i) {
            File file2 = this.path[i];
            if (file2.isAbsolute()) continue;
            this.path[i] = new File(file, file2.getPath());
        }
    }

    public PathClassLoader(File[] fileArray) {
        this.path = fileArray;
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = (Class)this.classes.get(string);
        if (clazz == null) {
            try {
                clazz = this.findSystemClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = this.locateClass(string);
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private synchronized Class locateClass(String string) throws ClassNotFoundException {
        Class clazz = (Class)this.classes.get(string);
        if (clazz != null) {
            return clazz;
        }
        for (int i = 0; i < this.path.length; ++i) {
            clazz = this.path[i].isDirectory() ? this.locateClassInDir(string, this.path[i]) : this.locateClassInJar(string, this.path[i]);
            if (clazz == null) continue;
            this.classes.put(string, clazz);
            return clazz;
        }
        throw new ClassNotFoundException(string);
    }

    private Class locateClassInDir(String string, File file) throws ClassNotFoundException {
        String string2 = string.replace('.', '/') + ".class";
        try {
            File file2 = new File(file, string2);
            return this.readClass(string, new FileInputStream(file2), (int)file2.length());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private Class locateClassInJar(String string, File file) throws ClassNotFoundException {
        String string2 = string.replace('.', '/') + ".class";
        try {
            ZipEntry zipEntry;
            ZipFile zipFile = (ZipFile)this.zips.get(file);
            if (zipFile == null) {
                zipFile = new ZipFile(file);
                this.zips.put(file, zipFile);
            }
            if ((zipEntry = zipFile.getEntry(string2)) == null) {
                return null;
            }
            return this.readClass(string, zipFile.getInputStream(zipEntry), (int)zipEntry.getSize());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class readClass(String string, InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        try {
            for (int i = 0; i < n; i += inputStream.read(byArray, i, n - i)) {
            }
        }
        finally {
            inputStream.close();
        }
        return this.defineClass(string, byArray, 0, byArray.length);
    }

    private File[] split(String string) {
        char c = File.pathSeparatorChar;
        Vector vector = new Vector();
        int n = 0;
        int n2 = string.indexOf(c);
        while (n2 != -1) {
            this.add(string.substring(n, n2), vector);
            n = n2 + 1;
            n2 = string.indexOf(c, n);
        }
        if (n != string.length()) {
            this.add(string.substring(n), vector);
        }
        Object[] objectArray = new File[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private void add(String string, Vector vector) {
        if (string.length() != 0) {
            vector.addElement(new File(string));
        }
    }
}

