/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import com.sun.javatest.util.Properties;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;

public class PropertyArray {
    private static char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String lineSeparator = System.getProperty("line.separator");
    private String[] dataA;
    private boolean locked;

    public PropertyArray() {
        this.locked = false;
    }

    public PropertyArray(int n) {
        this.locked = false;
    }

    public PropertyArray(Reader reader) throws IOException {
        this.dataA = PropertyArray.load(reader);
        this.locked = true;
    }

    public PropertyArray(Properties properties) {
        this.dataA = PropertyArray.getArray(properties);
        this.locked = true;
    }

    public PropertyArray(String[] stringArray) {
        this.locked = true;
        this.dataA = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.dataA[i] = stringArray[i];
        }
    }

    public static String[] getArray(Properties properties) {
        Enumeration enumeration = properties.elements();
        Enumeration enumeration2 = properties.keys();
        Vector vector = new Vector(properties.size(), 2);
        while (enumeration2.hasMoreElements()) {
            PropertyArray.insert(vector, (String)enumeration2.nextElement(), (String)enumeration.nextElement());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String[] put(String[] stringArray, String string, String string2) {
        Object[] objectArray;
        String string3 = null;
        if (string == null || string2 == null) {
            throw new PropertyArrayError("A key or value was null.  Null keys and values are illegal");
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if (string == null) {
            objectArray = stringArray;
        } else {
            Vector vector = PropertyArray.copyOutOf(stringArray);
            string3 = PropertyArray.insert(vector, string, string2);
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public static String get(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length == 0 || string == null) {
            return null;
        }
        int n = 0;
        int n2 = stringArray.length - 2;
        if (n2 < 0) {
            return null;
        }
        String string2 = stringArray[n2];
        int n3 = string.compareTo(string2);
        if (n3 > 0) {
            return null;
        }
        while (n <= n2) {
            int n4 = n + (n2 - n) / 4 * 2;
            String string3 = stringArray[n4];
            n3 = string.compareTo(string3);
            if (n3 < 0) {
                n2 = n4 - 2;
                continue;
            }
            if (n3 > 0) {
                n = n4 + 2;
                continue;
            }
            return stringArray[n4 + 1];
        }
        return null;
    }

    public static String[] remove(String[] stringArray, String string) {
        Object object;
        Vector vector = PropertyArray.copyOutOf(stringArray);
        int n = 0;
        int n2 = vector.size() - 2;
        int n3 = 0;
        String string2 = null;
        if (n2 < 0) {
            return stringArray;
        }
        String string3 = (String)vector.elementAt(n2);
        int n4 = string.compareTo(string3);
        if (n4 > 0) {
            return stringArray;
        }
        while (n <= n2) {
            n3 = n + (n2 - n) / 4 * 2;
            object = (String)vector.elementAt(n3);
            n4 = string.compareTo((String)object);
            if (n4 < 0) {
                n2 = n3 - 2;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 2;
                continue;
            }
            vector.removeElementAt(n3);
            string2 = (String)vector.elementAt(n3);
            vector.removeElementAt(n3);
            break;
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public static Properties getProperties(String[] stringArray) {
        Properties properties = null;
        if (stringArray == null || stringArray.length == 0) {
            properties = new Properties();
        } else {
            properties = new Properties();
            for (int i = 0; i < stringArray.length; i += 2) {
                properties.put(stringArray[i], stringArray[i + 1]);
            }
        }
        return properties;
    }

    public static void save(String[] stringArray, Writer writer) throws IOException {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            writer.write(stringArray[i]);
            writer.write(61);
            String string = stringArray[i + 1];
            int n = string.length();
            boolean bl = false;
            for (int j = 0; j < n; ++j) {
                char c = string.charAt(j);
                switch (c) {
                    case '\\': {
                        writer.write(92);
                        writer.write(92);
                        break;
                    }
                    case '\t': {
                        writer.write(92);
                        writer.write(116);
                        break;
                    }
                    case '\n': {
                        writer.write(92);
                        writer.write(110);
                        break;
                    }
                    case '\r': {
                        writer.write(92);
                        writer.write(114);
                        break;
                    }
                    default: {
                        if (c < ' ' || c >= '\u007f' || bl && c == ' ') {
                            writer.write(92);
                            writer.write(117);
                            writer.write(PropertyArray.toHex(c >> 12 & 0xF));
                            writer.write(PropertyArray.toHex(c >> 8 & 0xF));
                            writer.write(PropertyArray.toHex(c >> 4 & 0xF));
                            writer.write(PropertyArray.toHex(c >> 0 & 0xF));
                            break;
                        }
                        writer.write(c);
                    }
                }
                bl = false;
            }
            writer.write(lineSeparator);
        }
    }

    public static String[] load(Reader reader) throws IOException {
        Vector vector = new Vector();
        int n = 0;
        n = 10;
        block18: while (true) {
            switch (n) {
                case -1: {
                    break block18;
                }
                case 33: 
                case 35: {
                    while ((n = reader.read()) >= 0 && n != 10 && n != 13) {
                    }
                    continue block18;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    int n2 = 0;
                    while (n != 10 || ++n2 <= 1) {
                        n = reader.read();
                        if (n == 10 || n == 13 || n == 9 || n == 32) continue;
                        continue block18;
                    }
                    break block18;
                }
                default: {
                    StringBuffer stringBuffer = new StringBuffer();
                    while (n >= 0 && n != 61 && n != 58 && n != 32 && n != 9 && n != 10 && n != 13) {
                        stringBuffer.append((char)n);
                        n = reader.read();
                    }
                    while (n == 32 || n == 9) {
                        n = reader.read();
                    }
                    if (n == 61 || n == 58) {
                        n = reader.read();
                    }
                    while (n == 32 || n == 9) {
                        n = reader.read();
                    }
                    StringBuffer stringBuffer2 = new StringBuffer();
                    block24: while (n >= 0 && n != 10 && n != 13) {
                        int n3 = 0;
                        if (n == 92) {
                            n = reader.read();
                            switch (n) {
                                case 13: {
                                    n = reader.read();
                                    if (n != 10 && n != 32 && n != 9) continue block24;
                                }
                                case 10: {
                                    while ((n = reader.read()) == 32 || n == 9) {
                                    }
                                    continue block24;
                                }
                                case 116: {
                                    n = 9;
                                    n3 = reader.read();
                                    break;
                                }
                                case 110: {
                                    n = 10;
                                    n3 = reader.read();
                                    break;
                                }
                                case 114: {
                                    n = 13;
                                    n3 = reader.read();
                                    break;
                                }
                                case 117: {
                                    while ((n = reader.read()) == 117) {
                                    }
                                    int n4 = 0;
                                    block27: for (int i = 0; i < 4; ++i) {
                                        n3 = reader.read();
                                        switch (n) {
                                            case 48: 
                                            case 49: 
                                            case 50: 
                                            case 51: 
                                            case 52: 
                                            case 53: 
                                            case 54: 
                                            case 55: 
                                            case 56: 
                                            case 57: {
                                                n4 = (n4 << 4) + n - 48;
                                                break;
                                            }
                                            case 97: 
                                            case 98: 
                                            case 99: 
                                            case 100: 
                                            case 101: 
                                            case 102: {
                                                n4 = (n4 << 4) + 10 + n - 97;
                                                break;
                                            }
                                            case 65: 
                                            case 66: 
                                            case 67: 
                                            case 68: 
                                            case 69: 
                                            case 70: {
                                                n4 = (n4 << 4) + 10 + n - 65;
                                                break;
                                            }
                                            default: {
                                                break block27;
                                            }
                                        }
                                        n = n3;
                                    }
                                    n = n4;
                                    break;
                                }
                                default: {
                                    n3 = reader.read();
                                    break;
                                }
                            }
                        } else {
                            n3 = reader.read();
                        }
                        stringBuffer2.append((char)n);
                        n = n3;
                    }
                    PropertyArray.insert(vector, stringBuffer.toString(), stringBuffer2.toString());
                    continue block18;
                }
            }
            break;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Enumeration enumerate(final String[] stringArray) {
        return new Enumeration(){
            int pos = 0;

            public boolean hasMoreElements() {
                return stringArray != null && this.pos < stringArray.length;
            }

            public Object nextElement() {
                if (stringArray == null || this.pos >= stringArray.length) {
                    return null;
                }
                String string = stringArray[this.pos];
                this.pos += 2;
                return string;
            }
        };
    }

    public Properties getProperties() {
        return PropertyArray.getProperties(this.dataA);
    }

    public boolean isMutable() {
        return !this.locked;
    }

    public int size() {
        if (this.dataA == null) {
            return 0;
        }
        return this.dataA.length / 2;
    }

    public String get(String string) {
        return PropertyArray.get(this.dataA, string);
    }

    public String[] getArray() {
        if (this.dataA == null || this.dataA.length == 0) {
            return null;
        }
        return PropertyArray.shallowCopy(this.dataA);
    }

    public String put(String string, String string2) {
        String string3 = null;
        if (this.locked) {
            throw new IllegalStateException("PropertyArray is immutable.");
        }
        if (string == null || string2 == null) {
            throw new PropertyArrayError("A key or value was null.  Null keys and values are illegal");
        }
        Vector vector = PropertyArray.copyOutOf(this.dataA);
        string3 = PropertyArray.insert(vector, string, string2);
        this.dataA = new String[vector.size()];
        vector.copyInto(this.dataA);
        return string3;
    }

    public void remove(String string) {
        this.dataA = PropertyArray.remove(this.dataA, string);
    }

    public void save(Writer writer) throws IOException {
        PropertyArray.save(this.dataA, writer);
    }

    private static String insert(Vector vector, String string, String string2) {
        int n = 0;
        int n2 = vector.size() - 2;
        int n3 = 0;
        String string3 = null;
        if (n2 < 0) {
            vector.addElement(string);
            vector.addElement(string2);
            return string3;
        }
        String string4 = (String)vector.elementAt(n2);
        int n4 = string.compareTo(string4);
        if (n4 > 0) {
            vector.addElement(string);
            vector.addElement(string2);
            return null;
        }
        while (n <= n2) {
            n3 = n + (n2 - n) / 4 * 2;
            String string5 = (String)vector.elementAt(n3);
            n4 = string.compareTo(string5);
            if (n4 < 0) {
                n2 = n3 - 2;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 2;
                continue;
            }
            vector.removeElementAt(n3);
            string3 = (String)vector.elementAt(n3);
            vector.removeElementAt(n3);
            break;
        }
        if (n4 > 0) {
            n3 += 2;
        }
        vector.insertElementAt(string, n3);
        vector.insertElementAt(string2, n3 + 1);
        return string3;
    }

    private static Vector copyOutOf(String[] stringArray) {
        Vector<String> vector = null;
        if (stringArray == null) {
            vector = new Vector<String>(0, 2);
        } else {
            vector = new Vector(stringArray.length, 2);
            for (int i = 0; i < stringArray.length; ++i) {
                vector.addElement(stringArray[i]);
            }
        }
        return vector;
    }

    private static String[] shallowCopy(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
        }
        return stringArray2;
    }

    private static char toHex(int n) {
        return hexDigit[n & 0xF];
    }

    public static class PropertyArrayError
    extends Error {
        public PropertyArrayError() {
        }

        public PropertyArrayError(String string) {
            super(string);
        }
    }
}

