/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import java.util.Vector;

public class Timer {
    private static int threadInitNumber;
    private Vector entries = new Vector();
    private boolean acceptingRequests = true;

    public Timer() {
        Thread thread = new Thread(){

            public void run() {
                try {
                    Entry entry;
                    while ((entry = Timer.this.getNextEntry()) != null) {
                        entry.obj.timeout();
                        entry = null;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        thread.setName("Timer" + Timer.nextThreadNum());
        thread.setDaemon(true);
        thread.start();
    }

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Entry requestDelayedCallback(Timeable timeable, long l) {
        try {
            long l2 = System.currentTimeMillis() + l;
            Entry entry = new Entry(timeable, l2);
            for (int i = 0; i < this.entries.size(); ++i) {
                Entry entry2 = (Entry)this.entries.elementAt(i);
                if (entry.expiration >= entry2.expiration) continue;
                this.entries.insertElementAt(entry, i);
                Entry entry3 = entry;
                return entry3;
            }
            this.entries.addElement(entry);
            Entry entry4 = entry;
            return entry4;
        }
        finally {
            this.notify();
        }
    }

    public synchronized void cancel(Entry entry) {
        this.entries.removeElement(entry);
        this.notify();
    }

    public synchronized void finished() {
        this.acceptingRequests = false;
        this.notify();
    }

    private synchronized Entry getNextEntry() throws InterruptedException {
        while (this.acceptingRequests) {
            if (this.entries.size() == 0) {
                this.wait();
                continue;
            }
            long l = System.currentTimeMillis();
            Entry entry = (Entry)this.entries.elementAt(0);
            if (entry.expiration <= l) {
                this.entries.removeElementAt(0);
                return entry;
            }
            this.wait(entry.expiration - l);
            l = System.currentTimeMillis();
        }
        return null;
    }

    public class Entry {
        Timeable obj;
        long expiration;

        Entry(Timeable timeable, long l) {
            this.obj = timeable;
            this.expiration = l;
        }
    }

    public static interface Timeable {
        public void timeout();
    }
}

