/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class XMLWriter {
    private BufferedWriter out;
    private int state;
    private I18NResourceBundle i18n;
    private DateFormat dateFormatter;
    private static final int IN_TAG = 1;
    private static final int IN_BODY = 2;

    public XMLWriter(Writer writer) throws IOException {
        this(writer, "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
    }

    public XMLWriter(Writer writer, String string) throws IOException {
        this.out = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        this.out.write(string);
        this.out.newLine();
    }

    public XMLWriter(Writer writer, I18NResourceBundle i18NResourceBundle) throws IOException {
        this(writer);
        this.i18n = i18NResourceBundle;
    }

    public XMLWriter(Writer writer, String string, I18NResourceBundle i18NResourceBundle) throws IOException {
        this(writer, string);
        this.i18n = i18NResourceBundle;
    }

    public void setI18NResourceBundle(I18NResourceBundle i18NResourceBundle) {
        this.i18n = i18NResourceBundle;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void newLine() throws IOException {
        if (this.state == 1) {
            this.out.write(">");
            this.state = 2;
        }
        this.out.newLine();
    }

    public void startTag(String string) throws IOException {
        if (this.state == 1) {
            this.out.write(">");
            this.state = 2;
        }
        this.out.write("<");
        this.out.write(string);
        this.state = 1;
    }

    public void endTag(String string) throws IOException {
        if (this.state == 1) {
            this.out.write("/>");
            this.state = 2;
        } else {
            this.out.write("</");
            this.out.write(string);
            this.out.write(">");
        }
    }

    public void writeAttr(String string, String string2) throws IOException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.out.write(" ");
        this.out.write(string);
        this.out.write("=");
        this.out.write("\"");
        this.out.write(string2);
        this.out.write("\"");
    }

    public void writeLine(String string) throws IOException {
        this.write(string);
        this.out.newLine();
    }

    public void writeDate(long l) throws IOException {
        this.writeDate(new Date(l));
    }

    public void writeDate(String string, long l) throws IOException {
        this.writeDate(string, new Date(l));
    }

    public void writeDate(Date date) throws IOException {
        if (this.dateFormatter == null) {
            this.dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        }
        this.write(this.dateFormatter.format(date));
    }

    public void writeDate(String string, Date date) throws IOException {
        this.startTag(string);
        this.writeDate(date);
        this.endTag(string);
    }

    public void write(String string) throws IOException {
        int n;
        if (string.length() == 0) {
            return;
        }
        if (this.state == 1) {
            this.out.write(">");
            this.state = 2;
        }
        boolean bl = false;
        for (n = 0; n < string.length() && !bl; ++n) {
            switch (string.charAt(n)) {
                case '&': 
                case '<': 
                case '>': {
                    bl = true;
                }
            }
        }
        if (bl) {
            block9: for (n = 0; n < string.length(); ++n) {
                char c = string.charAt(n);
                switch (c) {
                    case '<': {
                        this.out.write("&lt;");
                        continue block9;
                    }
                    case '>': {
                        this.out.write("&gt;");
                        continue block9;
                    }
                    case '&': {
                        this.out.write("&amp;");
                        continue block9;
                    }
                    default: {
                        this.out.write(c);
                    }
                }
            }
        } else {
            this.out.write(string);
        }
    }

    public void write(I18NResourceBundle i18NResourceBundle, String string) throws IOException {
        this.write(i18NResourceBundle.getString(string));
    }

    public void write(I18NResourceBundle i18NResourceBundle, String string, Object object) throws IOException {
        this.write(i18NResourceBundle.getString(string, object));
    }

    public void write(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) throws IOException {
        this.write(i18NResourceBundle.getString(string, objectArray));
    }

    public void writeI18N(String string) throws IOException {
        this.write(this.i18n.getString(string));
    }

    public void writeI18N(String string, Object object) throws IOException {
        this.write(this.i18n.getString(string, object));
    }

    public void writeI18N(String string, Object[] objectArray) throws IOException {
        this.write(this.i18n.getString(string, objectArray));
    }
}

