/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.diff;

import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestResult;
import com.sun.javatest.diff.DiffReader;
import com.sun.javatest.diff.WorkDirectoryReader;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ReportReader
implements DiffReader {
    private static final String SUMMARY_TXT = "summary.txt";
    private static File UNKNOWN = new File("unknown");
    private File file;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(WorkDirectoryReader.class);

    public static boolean accepts(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.isFile() && file.getName().equals(SUMMARY_TXT)) {
            return true;
        }
        return file.isDirectory() && new File(file, SUMMARY_TXT).exists();
    }

    public ReportReader(File file) {
        this.file = file;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public File getWorkDirectory() {
        return null;
    }

    @Override
    public String getFileType() {
        if (this.file != null && this.file.isDirectory()) {
            return i18n.getString("report.reportDir");
        }
        return i18n.getString("report.reportFile");
    }

    @Override
    public Iterator<TestResult> iterator() {
        return this.readSummary().iterator();
    }

    private List<TestResult> readSummary() {
        ArrayList<TestResult> arrayList = new ArrayList<TestResult>();
        File file = this.getRoot();
        File file2 = this.file.isFile() ? this.file : new File(this.file, SUMMARY_TXT);
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
            while ((string = bufferedReader.readLine()) != null) {
                int n = string.indexOf(32);
                String string2 = string.substring(0, n);
                Status status = Status.parse(string.substring(n).trim());
                TestDescription testDescription = new TestDescription(file, new File(string2), Collections.emptyMap());
                TestResult testResult = new TestResult(testDescription, status);
                arrayList.add(testResult);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return arrayList;
    }

    private File getRoot() {
        return UNKNOWN;
    }
}

