/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.Status;
import com.sun.javatest.TestResult;
import com.sun.javatest.lib.ProcessCommand;
import com.sun.javatest.regtest.Action;
import com.sun.javatest.regtest.BuildAction;
import com.sun.javatest.regtest.ParseException;
import com.sun.javatest.regtest.RegressionScript;
import com.sun.javatest.regtest.StringArray;
import com.sun.javatest.regtest.TestRunException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class AppletAction
extends Action {
    private String manual = "unset";
    private boolean reverseStatus = false;
    private boolean othervm = false;
    private int timeout = -1;
    private String policyFN = null;
    private String secureFN = null;
    private String htmlFN;
    private String clsName;
    private HTMLFileContents htmlFileContents;
    private TestResult.Section section;
    private static Object appletLock = new Object();

    @Override
    public void init(String[][] stringArray, String[] stringArray2, String string, RegressionScript regressionScript) throws ParseException {
        this.script = regressionScript;
        this.reason = string;
        if (stringArray2.length != 1) {
            throw new ParseException("`applet' requires exactly one file argument");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i][0];
            String string3 = stringArray[i][1];
            if (string2.equals("fail")) {
                this.reverseStatus = this.parseFail(string3);
                continue;
            }
            if (string2.equals("timeout")) {
                this.timeout = this.parseTimeout(string3);
                continue;
            }
            if (string2.equals("manual")) {
                this.manual = this.parseAppletManual(string3);
                continue;
            }
            if (string2.equals("othervm")) {
                this.othervm = true;
                continue;
            }
            if (string2.equals("policy")) {
                if (!regressionScript.isJDK11()) {
                    this.policyFN = this.parsePolicy(string3);
                    continue;
                }
                throw new ParseException("Option not allowed using provided test JDK: " + string2);
            }
            if (string2.equals("secure")) {
                if (!regressionScript.isJDK11()) {
                    this.secureFN = this.parseSecure(string3);
                    continue;
                }
                throw new ParseException("Option not allowed using provided test JDK: " + string2);
            }
            throw new ParseException("Bad option for applet: " + string2);
        }
        if (this.manual.equals("unset")) {
            if (this.timeout < 0) {
                this.timeout = regressionScript.getActionTimeout(0);
            }
        } else {
            if (this.timeout >= 0) {
                throw new ParseException("`/manual' disables use of `/timeout'");
            }
            this.timeout = 0;
        }
        if (!this.othervm) {
            if (this.policyFN != null) {
                throw new ParseException("`/policy' requires use of `/othervm'");
            }
            if (this.secureFN != null) {
                throw new ParseException("`/secure' requires use of `/othervm'");
            }
        }
        this.htmlFN = stringArray2[0];
    }

    @Override
    public File[] getSourceFiles() {
        return new File[]{new File(this.script.absTestSrcDir() + FILESEP + this.htmlFN)};
    }

    @Override
    public Status run() throws TestRunException {
        String[] stringArray;
        String[][] stringArray2;
        BuildAction buildAction;
        Status status;
        this.htmlFileContents = new HTMLFileContents(this.htmlFN);
        this.clsName = (String)this.htmlFileContents.getAppletAtts().get("code");
        if (this.clsName.endsWith(".class")) {
            this.clsName = this.clsName.substring(0, this.clsName.lastIndexOf(".class"));
        }
        if (!(status = (buildAction = new BuildAction()).build(stringArray2 = new String[][]{}, stringArray = new String[]{this.clsName}, "Named class compiled on demand", this.script)).isPassed()) {
            return status;
        }
        this.section = this.startAction("applet", this.htmlFN, this.reason);
        status = this.script.isCheck() ? Status.passed("Test description appears acceptable") : this.runOtherJVM();
        this.endAction(status, this.section);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status runOtherJVM() throws TestRunException {
        Status status;
        Object object;
        String[] stringArray;
        String string = this.script.absTestClsDir() + FILESEP + this.clsName + ".jta";
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(this.clsName + "\u0000");
            fileWriter.write(this.script.absTestSrcDir() + "\u0000");
            fileWriter.write(this.script.absTestClsDir() + "\u0000");
            fileWriter.write(this.script.testClassPath() + "\u0000");
            fileWriter.write(this.manual + "\u0000");
            fileWriter.write(this.htmlFileContents.getBody() + "\u0000");
            fileWriter.write(AppletAction.dictionaryToString(this.htmlFileContents.getAppletParams()) + "\u0000");
            fileWriter.write(AppletAction.dictionaryToString(this.htmlFileContents.getAppletAtts()) + "\u0000");
            fileWriter.close();
        }
        catch (IOException iOException) {
            return Status.error("Can't write `applet' argument file");
        }
        catch (SecurityException securityException) {
            return Status.error("Unable to create applet argument file");
        }
        ArrayList<String> arrayList = new ArrayList<String>(6);
        if (this.script.isJDK11()) {
            arrayList.add("CLASSPATH=" + this.script.getJavaTestClassPath() + PATHSEP + this.script.testClassPath());
        }
        arrayList.add(this.script.getJavaProg());
        if (!this.script.isJDK11()) {
            arrayList.add("-classpath");
            arrayList.add(this.script.getJavaTestClassPath() + PATHSEP + this.script.testClassPath());
        }
        List<String> list = this.script.getTestVMOptions();
        arrayList.addAll(list);
        arrayList.add("-Dtest.src=" + this.script.absTestSrcDir());
        arrayList.add("-Dtest.classes=" + this.script.absTestClsDir());
        boolean bl = false;
        for (int i = 0; i < list.size() && !bl; ++i) {
            stringArray = list.get(i);
            if (!stringArray.startsWith("-mx") && !stringArray.startsWith("-Xmx")) continue;
            bl = true;
        }
        if (!bl) {
            arrayList.add("-mx128m");
        }
        if (this.policyFN != null) {
            String string2 = this.addGrantEntry(this.policyFN);
            arrayList.add("-Djava.security.policy==" + string2);
        }
        if (this.secureFN != null) {
            arrayList.add("-Djava.security.manager=" + this.secureFN);
        } else if (this.policyFN != null) {
            arrayList.add("-Djava.security.manager=default");
        }
        arrayList.add("com.sun.javatest.regtest.AppletWrapper");
        arrayList.add(string);
        stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        String[] stringArray2 = this.script.getEnvVars();
        String[] stringArray3 = StringArray.append(stringArray2, stringArray);
        PrintWriter printWriter = this.section.createOutput("System.out");
        PrintWriter printWriter2 = this.section.createOutput("System.err");
        try {
            if (showCmd) {
                this.JTCmd("applet", stringArray3, this.section);
            }
            object = new ProcessCommand();
            ((ProcessCommand)object).setExecDir(this.script.absTestScratchDir());
            ((ProcessCommand)object).setStatusForExit(Status.exitCodes[0], Status.passed("Execution successful"));
            ((ProcessCommand)object).setStatusForExit(Status.exitCodes[1], Status.failed("Execution failed"));
            ((ProcessCommand)object).setDefaultStatus(Status.failed("Unexpected exit from test"));
            Object object2 = appletLock;
            synchronized (object2) {
                if (this.timeout > 0) {
                    this.script.setAlarm(this.timeout * 1000);
                }
                status = ((ProcessCommand)object).run(stringArray3, printWriter2, printWriter);
            }
        }
        finally {
            this.script.setAlarm(0);
            if (printWriter != null) {
                printWriter.close();
            }
            if (printWriter2 != null) {
                printWriter2.close();
            }
        }
        if (!status.isError() && !status.getReason().startsWith("Unexpected exit from test")) {
            int n;
            if (status.getReason().equals("")) {
                boolean bl2 = this.manual.equals("yesno");
                n = this.manual.equals("yesno") || this.manual.equals("done") ? 1 : 0;
                String string3 = bl2 ? ", user evaluated" : "";
                object = n != 0 ? "Manual test" + string3 + ": " : "";
            } else {
                object = "";
            }
            boolean bl3 = status.isPassed();
            n = status.getType();
            if (bl3 && this.reverseStatus) {
                object = (String)object + "Execution passed unexpectedly";
                n = 1;
            } else if (bl3 && !this.reverseStatus) {
                object = (String)object + "Execution successful";
            } else if (!bl3 && this.reverseStatus) {
                object = (String)object + "Execution failed as expected";
                n = 0;
            } else {
                object = (String)object + "Execution failed";
            }
            if (n == 1 && !status.getReason().equals("") && !status.getReason().equals("Execution successful")) {
                object = (String)object + ": " + status.getReason();
            }
            status = new Status(n, (String)object);
        }
        return status;
    }

    private String parseAppletManual(String string) throws ParseException {
        if (string == null) {
            return "novalue";
        }
        if (!string.equals("yesno") && !string.equals("done")) {
            throw new ParseException("Bad value for `manual' option: " + string);
        }
        return string;
    }

    private static String dictionaryToString(Dictionary dictionary) {
        StringBuilder stringBuilder = new StringBuilder();
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuilder.append(string);
            stringBuilder.append("\u001c");
            stringBuilder.append(dictionary.get(string));
            stringBuilder.append("\u001c");
        }
        return stringBuilder.toString();
    }

    private class HTMLFileContents {
        String body;
        Dictionary<String, String> appletParams = new Hashtable<String, String>(1);
        Dictionary<String, String> appletAtts;

        HTMLFileContents(String string) throws TestRunException {
            int[] nArray;
            int[] nArray2;
            String string2;
            Object object;
            StringBuilder stringBuilder = new StringBuilder();
            string = AppletAction.this.script.absTestSrcDir() + Action.FILESEP + string;
            try {
                String string3;
                object = new BufferedReader(new FileReader(string));
                while ((string3 = ((BufferedReader)object).readLine()) != null) {
                    stringBuilder.append(string3);
                    stringBuilder.append(Action.LINESEP);
                }
                ((BufferedReader)object).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new TestRunException("Can't find HTML file: " + string);
            }
            catch (IOException iOException) {
                throw new TestRunException("Problem reading HTML file: " + string);
            }
            object = stringBuilder.toString();
            String string4 = ((String)object).toLowerCase();
            int[] nArray3 = this.getTagPositions((String)object, string4, "body", 0);
            if (nArray3 == null) {
                this.body = object;
                string2 = string4;
            } else {
                nArray2 = this.getTagPositions((String)object, string4, "/body", nArray3[3] - 1);
                if (nArray2 == null) {
                    throw new ParseException("No </body> tag in " + string);
                }
                this.body = ((String)object).substring(nArray3[3], nArray2[0]);
                string2 = string4.substring(nArray3[3], nArray2[0]);
            }
            nArray2 = this.getTagPositions(this.body, string2, "applet", 0);
            if (nArray2 == null) {
                throw new ParseException("No <applet> tag in " + string);
            }
            int[] nArray4 = this.getTagPositions(this.body, string2, "/applet", nArray2[3] - 1);
            if (nArray4 == null) {
                throw new ParseException("No </applet> tag in " + string);
            }
            this.appletAtts = this.attsToDictionary(this.body.substring(nArray2[1], nArray2[2]));
            String[] stringArray = new String[]{"code", "width", "height"};
            for (int i = 0; i < stringArray.length; ++i) {
                if (this.appletAtts.get(stringArray[i]) != null) continue;
                throw new ParseException(string + " missing required attribute " + stringArray[i]);
            }
            if (this.appletAtts.get("archive") != null) {
                throw new ParseException("`archive' not supported in file: " + string);
            }
            String string5 = this.body.substring(nArray2[3], nArray4[0]);
            String string6 = string5.toLowerCase();
            while ((nArray = this.getTagPositions(string5, string6, "param", 0)) != null) {
                Dictionary<String, String> dictionary = this.attsToDictionary(string5.substring(nArray[1], nArray[2]));
                String string7 = dictionary.get("name");
                String string8 = dictionary.get("value");
                if (string7 == null || string8 == null) {
                    throw new ParseException("Missing required name or value for param in <param> tag");
                }
                this.appletParams.put(string7, string8);
            }
        }

        String getBody() {
            return this.body;
        }

        Dictionary getAppletParams() {
            return this.appletParams;
        }

        Dictionary getAppletAtts() {
            return this.appletAtts;
        }

        private int[] getAttPositions(String string) {
            try {
                int n;
                int n2;
                int n3 = 0;
                while (Character.isWhitespace(string.charAt(n3))) {
                    ++n3;
                }
                int n4 = n3;
                while (!Character.isWhitespace((char)(n2 = string.charAt(n4))) && n2 != 61) {
                    ++n4;
                }
                n2 = n4;
                while (Character.isWhitespace(string.charAt(n2))) {
                    ++n2;
                }
                if (string.charAt(n2) != '=') {
                    return null;
                }
                ++n2;
                while (Character.isWhitespace(string.charAt(n2))) {
                    ++n2;
                }
                int n5 = string.length();
                boolean bl = false;
                for (n = n2; n < n5; ++n) {
                    char c = string.charAt(n);
                    if (!bl && Character.isWhitespace(c)) break;
                    if (c == '\"') {
                        boolean bl2 = bl = !bl;
                    }
                    if (c != '\\' || n >= n5 - 1) continue;
                    ++n;
                }
                if (n4 <= n3 || n <= n2) {
                    return null;
                }
                int[] nArray = new int[]{n3, n4, n2, n};
                return nArray;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                return null;
            }
        }

        private int[] getTagPositions(String string, String string2, String string3, int n) {
            int n2 = string2.indexOf("<" + string3, n);
            if (n2 == -1) {
                return null;
            }
            int n3 = string2.indexOf(">", n2);
            if (n3 == -1) {
                return null;
            }
            int[] nArray = new int[]{n2, n2 + string3.length() + 1, n3, n3 + 1};
            return nArray;
        }

        private Dictionary<String, String> attsToDictionary(String string) {
            int[] nArray;
            Hashtable<String, String> hashtable = new Hashtable<String, String>(3);
            while ((nArray = this.getAttPositions(string)) != null) {
                String string2 = string.substring(nArray[2], nArray[3]);
                if (string2.indexOf("\"") == 0 && string2.lastIndexOf("\"") == string2.length() - 1) {
                    string2 = string2.substring(1, string2.length() - 1);
                }
                ((Dictionary)hashtable).put(string.substring(nArray[0], nArray[1]).toLowerCase(), string2);
                string = string.substring(nArray[3]);
            }
            return hashtable;
        }
    }
}

