/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.Script;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestResult;
import com.sun.javatest.regtest.Action;
import com.sun.javatest.regtest.AppletAction;
import com.sun.javatest.regtest.BuildAction;
import com.sun.javatest.regtest.CleanAction;
import com.sun.javatest.regtest.CompileAction;
import com.sun.javatest.regtest.IgnoreAction;
import com.sun.javatest.regtest.IgnoreKind;
import com.sun.javatest.regtest.MainAction;
import com.sun.javatest.regtest.ParseException;
import com.sun.javatest.regtest.RegressionEnvironment;
import com.sun.javatest.regtest.RegressionParameters;
import com.sun.javatest.regtest.ShellAction;
import com.sun.javatest.regtest.StringArray;
import com.sun.javatest.regtest.TestRunException;
import com.sun.javatest.util.Fifo;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class RegressionScript
extends Script {
    private static float cacheJavaTestTimeoutFactor = -1.0f;
    private String cacheRelTestSrcDir;
    private File cacheAbsTestSrcDir;
    private File cacheAbsTestClsDir;
    private File cacheAbsTestScratchDir;
    private File cacheAbsTestResultDir;
    private File cacheAbsTestClsTopDir;
    private String cacheTestClassPath;
    private String cacheTestSourcePath;
    private Map<File, Set<String>> cacheDirContents = new HashMap<File, Set<String>>();
    private File[] cacheJavaSrcPath = null;
    private String[] cacheRelSrcLibList;
    private File[] cacheAbsSrcLibList;
    private File[] cacheAbsClsLibList;
    private String cacheAbsClsLibListStr;
    private String cacheAbsSrcLibListStr;
    private String cacheAbsSrcJarLibListStr;
    static final String WRAPPEREXTN = ".jta";
    private static final String FILESEP = System.getProperty("file.separator");
    private static final String PATHSEP = System.getProperty("path.separator");
    private static final String LINESEP = System.getProperty("line.separator");
    private static final String CANT_INSTANTIATE = "Unable to instantiate: ";
    private static final String NOT_EXT_ACTION = " does not extend Action";
    private static final String ILLEGAL_ACCESS_INIT = "Illegal access to init method: ";
    private static final String BAD_ACTION = "Bad action for script: ";
    private static final String CLEAN_RM_PROB = "Problem deleting file: ";
    private static final String CLEAN_SECMGR_PROB = "Problem deleting scratch directory: ";
    private static final String ADD_BAD_SUBTYPE = "Class must be a subtype of ";
    private static final String PATH_TESTCLASS = "Unable to locate test class directory!?";
    private static final String PATH_SCRATCH_CREATE = "Can't create test scratch directory: ";
    private static final String PATH_JT_CLASS = "Unable to locate JavaTest class directory!?";
    private static final String TEST_SRC = "Test source: ";
    private static final String UNEXPECTED_LOC = "does not reside in: ";
    private static final String CANT_FIND_SRC = "Can't find source file: ";
    private static final String LIB_LIST = " in directory-list: ";
    private static final String CANT_FIND_JDK_VERSION = "Unable to determine JDK under test";
    private static final String UNRECOG_JDK_VERSION = "Unable to recognize JDK under test";
    private static final String PROB_CANT_CANON = "Unable to canonicalize file: ";
    private Map<String, Class<?>> actionTable = new HashMap();
    private TestResult testResult;
    private RegressionEnvironment env;
    private RegressionParameters params;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status run(String[] stringArray, TestDescription testDescription, TestEnvironment testEnvironment) {
        Status status;
        block11: {
            if (!(testEnvironment instanceof RegressionEnvironment)) {
                throw new AssertionError();
            }
            this.env = (RegressionEnvironment)testEnvironment;
            this.params = this.env.params;
            status = Status.passed("OK");
            String string = testDescription.getParameter("run");
            try {
                this.setLibList(testDescription.getParameter("library"));
                Fifo fifo = this.parseActions(string, true);
                this.initScratchDirectory();
                this.testResult = this.getTestResult();
                PrintWriter printWriter = this.testResult.getTestCommentWriter();
                printWriter.println("JDK under test: " + this.getJavaFullVersion());
                if (testDescription.getParameter("error") != null) {
                    status = Status.error(testDescription.getParameter("error"));
                    break block11;
                }
                while (!fifo.isEmpty()) {
                    Action action = (Action)fifo.remove();
                    status = action.run();
                    if (status.getType() == 0) continue;
                    break;
                }
            }
            catch (ParseActionsException parseActionsException) {
                status = Status.error(parseActionsException.getMessage());
            }
            catch (TestRunException testRunException) {
                status = Status.error(testRunException.getMessage());
            }
            finally {
                if (this.params.isRetainEnabled()) {
                    this.retainScratchFiles(status);
                }
            }
        }
        return status;
    }

    public File[] getSourceFiles(TestDescription testDescription) {
        this.td = testDescription;
        try {
            this.setLibList(testDescription.getParameter("library"));
            String string = testDescription.getParameter("run");
            Fifo fifo = this.parseActions(string, false);
            LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
            while (!fifo.isEmpty()) {
                Action action = (Action)fifo.remove();
                File[] fileArray = action.getSourceFiles();
                if (fileArray == null) continue;
                linkedHashSet.addAll(Arrays.asList(fileArray));
            }
            return linkedHashSet.toArray(new File[linkedHashSet.size()]);
        }
        catch (TestRunException testRunException) {
            return new File[0];
        }
        catch (ParseActionsException parseActionsException) {
            throw new Error(parseActionsException);
        }
    }

    public boolean hasEnv() {
        return this.env != null;
    }

    Fifo parseActions(String string, boolean bl) throws ParseActionsException, ParseException {
        Fifo fifo = new Fifo(2);
        String[] stringArray = StringArray.splitTerminator(LINESEP, string);
        this.populateActionTable();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = StringArray.splitWS(stringArray[i]);
            String[] stringArray3 = StringArray.splitSeparator("/", stringArray2[1]);
            String string2 = stringArray3[0];
            String[][] stringArray4 = new String[stringArray3.length - 1][];
            for (int j = 1; j < stringArray3.length; ++j) {
                stringArray4[j - 1] = StringArray.splitEqual(stringArray3[j]);
            }
            String[] stringArray5 = new String[stringArray2.length - 2];
            for (int j = 2; j < stringArray2.length; ++j) {
                stringArray5[j - 2] = stringArray2[j];
            }
            Class<?> clazz = null;
            try {
                clazz = this.actionTable.get(string2);
                if (clazz == null) {
                    if (!bl) continue;
                    throw new ParseActionsException(BAD_ACTION + string2);
                }
                Action action = (Action)clazz.newInstance();
                action.init(stringArray4, stringArray5, this.getReason(stringArray2), this);
                fifo.insert(action);
                continue;
            }
            catch (InstantiationException instantiationException) {
                if (!bl) continue;
                throw new ParseActionsException(CANT_INSTANTIATE + clazz + NOT_EXT_ACTION);
            }
            catch (IllegalAccessException illegalAccessException) {
                if (!bl) continue;
                throw new ParseActionsException(ILLEGAL_ACCESS_INIT + clazz);
            }
        }
        return fifo;
    }

    @Override
    protected int getTestTimeout() {
        return 0;
    }

    protected int getActionTimeout(int n) {
        if (cacheJavaTestTimeoutFactor == -1.0f) {
            try {
                String string;
                String string2 = string = this.env == null ? null : this.env.lookup("javatestTimeoutFactor")[1];
                cacheJavaTestTimeoutFactor = string != null ? Float.parseFloat(string) : 1.0f;
            }
            catch (TestEnvironment.Fault fault) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (n == 0) {
            n = 120;
        }
        return (int)((float)n * cacheJavaTestTimeoutFactor);
    }

    @Override
    protected void setAlarm(int n) {
        super.setAlarm(n);
    }

    private void initScratchDirectory() throws TestRunException {
        File file = this.absTestScratchDir();
        if (file.exists()) {
            if (file.isDirectory()) {
                this.cleanDirectoryContents(file);
                return;
            }
            if (!file.delete()) {
                throw new TestRunException(CLEAN_RM_PROB + file);
            }
        }
        if (!file.mkdirs()) {
            throw new TestRunException(PATH_SCRATCH_CREATE + file);
        }
    }

    private void retainScratchFiles(Status status) {
        File file = this.absTestScratchDir();
        File file2 = this.absTestResultDir();
        if (this.params.getRetainStatus().contains(status.getType())) {
            if (!file.equals(file2)) {
                this.saveFiles(file, file2, null, false);
            }
        } else {
            Pattern pattern = this.params.getRetainFilesPattern();
            if (file.equals(file2) || pattern == null) {
                this.deleteFiles(file2, pattern, false);
            } else if (pattern != null) {
                this.saveFiles(file, file2, pattern, true);
            }
        }
    }

    private void saveFiles(File file, File file2, Pattern pattern, boolean bl) {
        boolean bl2 = file2.exists();
        if (bl2) {
            try {
                this.cleanDirectoryContents(file2);
            }
            catch (TestRunException testRunException) {
                System.err.println("warning: failed to empty " + file2);
            }
        }
        for (File file3 : file.listFiles()) {
            boolean bl3;
            File file4;
            boolean bl4;
            String string = file3.getName();
            if (file3.isDirectory()) {
                File file5 = new File(file2, string);
                this.saveFiles(file3, file5, pattern, bl);
                continue;
            }
            boolean bl5 = bl4 = pattern == null || pattern.matcher(string).matches() == bl;
            if (!bl4) continue;
            if (!bl2) {
                file2.mkdirs();
                bl2 = file2.exists();
            }
            if ((file4 = new File(file2, string)).exists()) {
                file4.delete();
            }
            if (bl3 = file3.renameTo(file4)) continue;
            System.err.println("warning: failed to rename " + file3 + " to " + file4);
        }
    }

    private boolean deleteFiles(File file, Pattern pattern, boolean bl) {
        if (!file.exists()) {
            return true;
        }
        boolean bl2 = true;
        for (File file2 : file.listFiles()) {
            boolean bl3;
            if (file2.isDirectory()) {
                bl2 &= this.deleteFiles(file2, pattern, bl);
                continue;
            }
            boolean bl4 = bl3 = pattern == null || pattern.matcher(file2.getName()).matches() == bl;
            if (bl3) {
                boolean bl5 = file2.delete();
                if (!bl5) {
                    System.err.println("warning: failed to delete " + file2);
                }
                bl2 &= bl5;
                continue;
            }
            bl2 = false;
        }
        if (bl2) {
            bl2 = file.delete();
        }
        return bl2;
    }

    private void cleanDirectoryContents(File file) throws TestRunException {
        File[] fileArray;
        if (file.exists() && (fileArray = file.listFiles()) != null) {
            try {
                for (int i = 0; i < fileArray.length; ++i) {
                    File file2 = fileArray[i];
                    if (file2.isDirectory()) {
                        this.cleanDirectoryContents(file2);
                        File[] fileArray2 = file2.listFiles();
                        if (fileArray2.length > 0) {
                            throw new TestRunException(CLEAN_RM_PROB + file2 + " remaining: " + Arrays.asList(fileArray2));
                        }
                    }
                    if (file2.delete()) continue;
                    throw new TestRunException(CLEAN_RM_PROB + file2);
                }
            }
            catch (SecurityException securityException) {
                throw new TestRunException(CLEAN_SECMGR_PROB + Arrays.asList(fileArray));
            }
        }
    }

    private void populateActionTable() {
        this.addAction("applet", AppletAction.class);
        this.addAction("build", BuildAction.class);
        this.addAction("clean", CleanAction.class);
        this.addAction("compile", CompileAction.class);
        this.addAction("ignore", IgnoreAction.class);
        this.addAction("main", MainAction.class);
        this.addAction("shell", ShellAction.class);
    }

    private void addAction(String string, Class<?> clazz) {
        if (!Action.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(ADD_BAD_SUBTYPE + Action.class.getName());
        }
        this.actionTable.put(string, clazz);
    }

    private static String[] splitRunCmd(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf("\u001c", n)) != -1) {
            arrayList.add(string.substring(n, n2));
            n = n2 + 1;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String getReason(String[] stringArray) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = stringArray[0];
        if (string2.equals("ASSUMED_ACTION")) {
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]).append(" ");
            }
            string = "Assumed action based on file name: run " + stringBuffer;
        } else if (string2.equals("USER_SPECIFIED")) {
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]).append(" ");
            }
            string = "User specified action: run " + stringBuffer;
        } else {
            string = "Unknown";
        }
        return string;
    }

    String[] getEnvVars() {
        return this.params.getEnvVars();
    }

    boolean isCheck() {
        return this.params.isCheck();
    }

    List<String> getTestVMOptions() {
        return this.params.getTestVMOptions();
    }

    List<String> getTestToolVMOptions() {
        return this.params.getTestToolVMOptions();
    }

    List<String> getTestCompilerOptions() {
        return this.params.getTestCompilerOptions();
    }

    IgnoreKind getIgnoreKind() {
        return this.params.getIgnoreKind();
    }

    private String relTestSrcDir() {
        if (this.cacheRelTestSrcDir == null) {
            String string = this.td.getRootRelativeFile().getParent();
            this.cacheRelTestSrcDir = string == null ? "" : string;
        }
        return this.cacheRelTestSrcDir;
    }

    File absTestSrcDir() {
        if (this.cacheAbsTestSrcDir == null) {
            this.cacheAbsTestSrcDir = this.td.getFile().getParentFile();
        }
        return this.cacheAbsTestSrcDir;
    }

    File absTestClsDir() throws TestClassException {
        if (this.cacheAbsTestClsDir == null) {
            File file;
            String string = this.relTestSrcDir();
            try {
                String[] stringArray = this.env.lookup("testClassDir");
                if (stringArray == null || stringArray.length != 1) {
                    throw new TestClassException(PATH_TESTCLASS);
                }
                file = new File(stringArray[0], string);
                if (!file.exists()) {
                    file.mkdirs();
                }
            }
            catch (TestEnvironment.Fault fault) {
                throw new TestClassException(PATH_TESTCLASS);
            }
            this.cacheAbsTestClsDir = file;
        }
        try {
            this.cacheAbsTestClsDir = this.cacheAbsTestClsDir.getCanonicalFile();
        }
        catch (IOException iOException) {
            throw new TestClassException(PROB_CANT_CANON + this.cacheAbsTestClsDir);
        }
        return this.cacheAbsTestClsDir;
    }

    File absTestScratchDir() {
        if (this.cacheAbsTestScratchDir == null) {
            this.cacheAbsTestScratchDir = this.params.isRetainEnabled() && this.isOtherJVM() ? this.absTestResultDir() : this.workDir.getFile("scratch");
        }
        return this.cacheAbsTestScratchDir;
    }

    File absTestResultDir() {
        if (this.cacheAbsTestResultDir == null) {
            String string = TestResult.getWorkRelativePath(this.getTestDescription());
            if (string.endsWith(".jtr")) {
                string = string.substring(0, string.length() - 4);
            }
            this.cacheAbsTestResultDir = this.workDir.getFile(string);
        }
        return this.cacheAbsTestResultDir;
    }

    File absTestClsTopDir() throws TestClassException {
        String string = this.absTestClsDir().getPath();
        String string2 = "classes";
        int n = string.lastIndexOf(FILESEP + string2);
        String string3 = string.substring(0, n + string2.length() + 1);
        this.cacheAbsTestClsTopDir = new File(string3);
        return this.cacheAbsTestClsTopDir;
    }

    File absTestClsDestDir(String string) throws TestClassException {
        return this.absTestClsDestDir(new File(string));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    File absTestClsDestDir(File file) throws TestClassException {
        Object object;
        File file2 = null;
        String string = null;
        if (file.isAbsolute()) {
            object = file.getPath();
            String string2 = this.absTestSrcDir().getPath();
            int n = string2.length();
            if (!((String)object).startsWith(string2)) throw new TestClassException(TEST_SRC + (String)object + UNEXPECTED_LOC + string2);
            string = ((String)object).substring(n + 1);
        } else {
            string = file.getPath();
        }
        if (((File)(object = new File(this.absTestSrcDir(), string))).exists()) {
            file2 = this.absTestClsDir();
        } else {
            for (int i = 0; i < this.cacheAbsSrcLibList.length; ++i) {
                File file3 = new File(this.cacheAbsSrcLibList[i], string);
                if (!file3.exists()) continue;
                file2 = new File(this.absTestClsDir(), this.cacheRelSrcLibList[i]);
                break;
            }
        }
        if (file2 != null) return file2;
        throw new TestClassException(CANT_FIND_SRC + file);
    }

    String getStdJavaClassPath() {
        return this.params.getStdJavaClassPath();
    }

    String getStdJDKClassPath() {
        return this.params.getStdJDKClassPath();
    }

    String testClassPath() throws TestClassException {
        if (this.cacheTestClassPath == null) {
            this.cacheTestClassPath = "";
            this.cacheTestClassPath = this.isJDK11() ? this.absTestClsDir() + PATHSEP + this.absTestSrcDir() + PATHSEP + this.absClsLibListStr() + this.getStdJavaClassPath() + this.getStdJDKClassPath() : this.absTestClsDir() + PATHSEP + this.absTestSrcDir() + PATHSEP + this.absClsLibListStr() + this.absSrcJarLibListStr() + this.getStdJDKClassPath();
            String[] stringArray = this.getEnvVars();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith("CPAPPEND")) continue;
                String string = StringArray.splitEqual(stringArray[i])[1];
                string = string.replace('/', File.separatorChar);
                this.cacheTestClassPath = this.cacheTestClassPath + PATHSEP + string;
            }
        }
        return this.cacheTestClassPath;
    }

    String testSourcePath() throws TestRunException {
        if (this.cacheTestSourcePath == null) {
            this.cacheTestSourcePath = this.absTestSrcDir() + PATHSEP + this.absSrcLibListStr() + this.getStdJDKClassPath();
        }
        return this.cacheTestSourcePath;
    }

    private File locateFile(String string, File[] fileArray) throws TestRunException {
        for (int i = 0; i < fileArray.length; ++i) {
            Object object;
            File file = fileArray[i];
            if (string.indexOf(FILESEP) == -1) {
                object = this.cacheDirContents.get(file);
                if (object == null) {
                    String[] stringArray = file.list();
                    object = new HashSet<String>(1);
                    if (stringArray != null) {
                        object.addAll(Arrays.asList(stringArray));
                    }
                    this.cacheDirContents.put(file, (Set<String>)object);
                }
                if (!object.contains(string)) continue;
                return new File(file, string);
            }
            object = new File(file, string);
            if (!((File)object).exists()) continue;
            return object;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < fileArray.length; ++i) {
            stringBuilder.append(fileArray[i]).append(" ");
        }
        throw new TestRunException(CANT_FIND_SRC + string + LIB_LIST + stringBuilder);
    }

    File locateJavaSrc(String string) throws TestRunException {
        if (this.cacheJavaSrcPath == null) {
            this.cacheJavaSrcPath = new File[this.cacheAbsSrcLibList.length + 1];
            this.cacheJavaSrcPath[0] = this.absTestSrcDir();
            System.arraycopy(this.cacheAbsSrcLibList, 0, this.cacheJavaSrcPath, 1, this.cacheAbsSrcLibList.length);
        }
        return this.locateFile(string, this.cacheJavaSrcPath);
    }

    File locateJavaCls(String string) throws TestRunException {
        String string2 = this.locateJavaSrc(string).getName();
        File file = new File(this.absTestClsDir(), string2.substring(0, string2.length() - ".java".length()) + ".class");
        return file;
    }

    File locateJavaClsDir(String string) throws TestRunException {
        return this.locateJavaCls(string).getParentFile();
    }

    private void setLibList(String string) throws TestClassException {
        if (this.cacheAbsSrcLibList == null || this.cacheAbsClsLibList == null) {
            int n;
            this.cacheRelSrcLibList = StringArray.splitWS(string);
            this.cacheAbsSrcLibList = new File[this.cacheRelSrcLibList.length];
            for (n = 0; n < this.cacheRelSrcLibList.length; ++n) {
                this.cacheAbsSrcLibList[n] = new File(this.absTestSrcDir(), this.cacheRelSrcLibList[n]);
            }
            if (this.hasEnv()) {
                this.cacheAbsClsLibList = new File[this.cacheRelSrcLibList.length];
                for (n = 0; n < this.cacheRelSrcLibList.length; ++n) {
                    this.cacheAbsClsLibList[n] = new File(this.absTestClsDir(), this.cacheRelSrcLibList[n]);
                }
            }
        }
    }

    String absClsLibListStr() throws TestClassException {
        if (this.cacheAbsClsLibListStr == null) {
            this.cacheAbsClsLibListStr = "";
            for (int i = 0; i < this.cacheAbsClsLibList.length; ++i) {
                File file = new File(this.absTestClsDir(), this.cacheRelSrcLibList[i]);
                this.cacheAbsClsLibListStr = this.cacheAbsClsLibListStr + file.getPath() + PATHSEP;
            }
        }
        return this.cacheAbsClsLibListStr;
    }

    String absSrcLibListStr() {
        if (this.cacheAbsSrcLibListStr == null) {
            this.cacheAbsSrcLibListStr = "";
            for (int i = 0; i < this.cacheAbsSrcLibList.length; ++i) {
                File file = this.cacheAbsSrcLibList[i];
                this.cacheAbsSrcLibListStr = this.cacheAbsSrcLibListStr + file + PATHSEP;
            }
        }
        return this.cacheAbsSrcLibListStr;
    }

    String absSrcJarLibListStr() {
        if (this.cacheAbsSrcJarLibListStr == null) {
            this.cacheAbsSrcJarLibListStr = "";
            for (int i = 0; i < this.cacheAbsSrcLibList.length; ++i) {
                File file = this.cacheAbsSrcLibList[i];
                if (!file.getName().endsWith(".jar") || !file.exists()) continue;
                this.cacheAbsSrcJarLibListStr = this.cacheAbsSrcJarLibListStr + file + PATHSEP;
            }
        }
        return this.cacheAbsSrcJarLibListStr;
    }

    String getJavaTestClassPath() {
        return this.params.getJavaTestClassPath();
    }

    String getJDK() {
        return this.params.getJDK().getPath();
    }

    boolean isOtherJVM() {
        return this.params.isOtherJVM();
    }

    String getJavaProg() {
        return this.params.getJDK().getJavaProg().getPath();
    }

    String getJavacProg() {
        return this.params.getJDK().getJavacProg().getPath();
    }

    String getJavaFullVersion() {
        return this.params.getJavaFullVersion();
    }

    String javaVersion() {
        return this.params.getJavaVersion();
    }

    boolean isJDK11() {
        return this.javaVersion().equals("1.1");
    }

    boolean isJDK12() {
        return this.javaVersion().equals("1.2");
    }

    boolean isJDK13() {
        return this.javaVersion().equals("1.3");
    }

    public static class TestClassException
    extends TestRunException {
        public TestClassException(String string) {
            super("Test Class Exception: " + string);
        }
    }

    static class ParseActionsException
    extends Exception {
        ParseActionsException(String string) {
            super(string);
        }
    }
}

