/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.TestFinder;
import com.sun.javatest.finder.HTMLCommentStream;
import com.sun.javatest.finder.ShScriptCommentStream;
import com.sun.javatest.finder.TagTestFinder;
import com.sun.javatest.regtest.ParseException;
import com.sun.javatest.regtest.StringArray;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class RegressionTestFinder
extends TagTestFinder {
    private static final String LINESEP = System.getProperty("line.separator");
    private static final String[] excludeNames = new String[]{"SCCS", "Codemgr_wsdata", ".hg", "RCS", ".svn", "DeletedFiles", "DELETED-FILES", "deleted_files", "TemporarilyRemoved"};
    protected static final String PARSE_TAG_BAD = "Invalid tag: ";
    protected static final String PARSE_BUG_EMPTY = "No value provided for `@bug'";
    protected static final String PARSE_BUG_BAD_LEN = "Unexpected length for bugid: ";
    protected static final String PARSE_BUG_NON_DIGIT = "Non-digit found in bugid: ";
    protected static final String PARSE_KEY_EMPTY = "No value provided for `@key'";
    protected static final String PARSE_KEY_BAD = "Invalid key: ";
    protected static final String PARSE_LIB_EMPTY = "No value provided for `@library'";
    protected static final String PARSE_LIB_AFTER_RUN = "`@library' must appear before first `@run'";
    private static final boolean allowLocalKeys = Boolean.parseBoolean(System.getProperty("javatest.regtest.allowLocalKeys", "true"));
    private Set<String> rootValidKeys;
    private ValidTagNames validTagNames;
    private ValidKeysTable validKeysTable;
    private boolean checkBugID;

    public RegressionTestFinder(Set<String> set, boolean bl) {
        this.rootValidKeys = set;
        this.checkBugID = bl;
        this.validTagNames = new ValidTagNames(set != null);
        this.exclude(excludeNames);
        this.addExtension(".sh", ShScriptCommentStream.class);
        this.addExtension(".html", HTMLCommentStream.class);
    }

    @Override
    protected void setRoot(File file) throws TestFinder.Fault {
        file = this.canon(file);
        super.setRoot(file);
        this.validKeysTable = new ValidKeysTable(file, this.rootValidKeys);
    }

    @Override
    protected void scanFile(File file) {
        if (file.getName().startsWith(",")) {
            return;
        }
        super.scanFile(file);
    }

    private File canon(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file.getAbsoluteFile();
        }
    }

    @Override
    protected Map<String, String> normalize(Map map) {
        return this.normalize0(map);
    }

    private Map<String, String> normalize0(Map<String, String> map) {
        String string;
        String string2;
        File file = this.getCurrentFile();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string3 = file.getName();
        String string4 = string3.substring(0, string3.lastIndexOf("."));
        hashMap.put("title", " ");
        hashMap.put("source", string3);
        if (string3.endsWith(".sh")) {
            hashMap.put("run", "ASSUMED_ACTION shell " + string3 + LINESEP);
        } else if (string3.endsWith(".java")) {
            hashMap.put("run", "ASSUMED_ACTION main " + string4 + LINESEP);
        } else {
            hashMap.put("run", "ASSUMED_ACTION applet " + string3 + LINESEP);
        }
        for (Map.Entry<String, String> object2 : map.entrySet()) {
            block22: {
                string2 = object2.getKey();
                string = object2.getValue();
                if (string2.equals("summary")) {
                    string2 = "title";
                    int string5 = 0;
                    while ((string5 = string.indexOf(".", string5)) != -1 && string5 + 1 != string.length()) {
                        switch (string.charAt(string5 + 1)) {
                            case '\b': 
                            case '\t': 
                            case '\n': 
                            case '\f': 
                            case '\r': 
                            case ' ': {
                                string = string.substring(0, string5);
                                break block22;
                            }
                            default: {
                                ++string5;
                                break;
                            }
                        }
                    }
                } else if (string2.equals("bug") || string2.equals("key")) {
                    string2 = "keywords";
                    String string6 = (String)hashMap.get("keywords");
                    if (string6 != null) {
                        string = string6 + " " + string;
                    }
                } else if (string2.equals("test")) {
                    string2 = "keywords";
                    String string5 = (String)hashMap.get("keywords");
                    string = string5 != null ? string5 + " regtest" : "regtest";
                }
            }
            hashMap.put(string2, string);
        }
        String string6 = (String)hashMap.get("run");
        string2 = (String)hashMap.get("keywords");
        string = "";
        Object object3 = "othervm";
        if (string6.indexOf("othervm") != -1) {
            string = string + "othervm ";
        }
        object3 = "manual";
        if (string6.indexOf("manual") != -1) {
            string = string + "manual ";
        }
        object3 = "shell";
        if (string6.indexOf("shell") != -1) {
            string = string + "shell ";
        }
        object3 = "ignore";
        if (string6.indexOf("ignore") != -1) {
            string = string + "ignore ";
        }
        if (!string.equals("")) {
            if (string2 == null) {
                hashMap.put("keywords", string.trim());
            } else {
                hashMap.put("keywords", string2 + " " + string.trim());
            }
        }
        return hashMap;
    }

    @Override
    protected void processEntry(Map map, String string, String string2) {
        Map map2 = map;
        File file = this.getCurrentFile();
        if (string.startsWith("(#)")) {
            return;
        }
        if (string.startsWith("compile") || string.startsWith("clean") || string.startsWith("build") || string.startsWith("ignore")) {
            string2 = string + " " + string2;
            string = "run";
        }
        try {
            if (!this.validTagNames.isValid(string)) {
                throw new ParseException(PARSE_TAG_BAD + string);
            }
            if (string.equals("run")) {
                string2 = this.parseRun(map2, string2);
            } else if (string.equals("bug")) {
                string2 = this.parseBug(map2, string2);
            } else if (string.equals("key")) {
                string2 = this.parseKey(map2, string2);
            } else if (string.equals("library")) {
                string2 = this.parseLibrary(map2, string2);
            }
        }
        catch (ParseException parseException) {
            string = "error";
            string2 = parseException.getMessage();
        }
        super.processEntry(map2, string, string2);
    }

    private String parseRun(Map<String, String> map, String string) throws ParseException {
        String string2 = map.get("run");
        if (string2 == null) {
            return "USER_SPECIFIED " + string + LINESEP;
        }
        return string2 + "USER_SPECIFIED" + " " + string + LINESEP;
    }

    private String parseBug(Map<String, String> map, String string) throws ParseException {
        StringBuilder stringBuilder = new StringBuilder();
        if (string.trim().length() != 0) {
            String[] stringArray = StringArray.splitWS(string);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (this.checkBugID) {
                    if (string2.length() != 7) {
                        throw new ParseException(PARSE_BUG_BAD_LEN + string2);
                    }
                    if (!this.isDigitString(string2)) {
                        throw new ParseException(PARSE_BUG_NON_DIGIT + string2);
                    }
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append("bug").append(string2);
            }
        } else {
            throw new ParseException(PARSE_BUG_EMPTY);
        }
        return stringBuilder.toString();
    }

    private String parseKey(Map<String, String> map, String string) throws ParseException {
        Set<String> set = this.validKeysTable.getValidKeys(this.getCurrentFile());
        if (string.trim().length() != 0) {
            String[] stringArray = StringArray.splitWS(string);
            for (int i = 0; i < stringArray.length; ++i) {
                if (set.contains(stringArray[i])) continue;
                throw new ParseException(PARSE_KEY_BAD + stringArray[i]);
            }
            return StringArray.join(stringArray, " ");
        }
        throw new ParseException(PARSE_KEY_EMPTY);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String parseLibrary(Map map, String string) throws ParseException {
        String string2 = "";
        if (map.get("run") != null) throw new ParseException(PARSE_LIB_AFTER_RUN);
        if (string.trim().length() == 0) throw new ParseException(PARSE_LIB_EMPTY);
        String string3 = (String)map.get("library");
        string2 = string3 != null ? string + " " + string3 : string;
        return string2.trim();
    }

    private boolean isDigitString(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static class ValidKeysTable {
        private CacheEntry lastCacheEntry;
        private CacheEntry rootCacheEntry;

        ValidKeysTable(File file, Set<String> set) {
            this.rootCacheEntry = new CacheEntry(file, set);
        }

        synchronized Set<String> getValidKeys(File file) {
            if (!allowLocalKeys) {
                return this.rootCacheEntry.keys;
            }
            File file2 = file.getParentFile();
            if (this.lastCacheEntry == null || !this.lastCacheEntry.dir.equals(file2)) {
                this.lastCacheEntry = this.getCacheEntry(file2);
            }
            return this.lastCacheEntry.keys;
        }

        private CacheEntry getCacheEntry(File file) {
            CacheEntry cacheEntry;
            if (file.equals(this.rootCacheEntry.dir)) {
                return this.rootCacheEntry;
            }
            CacheEntry cacheEntry2 = this.getCacheEntry(file.getParentFile());
            CacheEntry cacheEntry3 = cacheEntry = cacheEntry2.children == null ? null : cacheEntry2.children.get(file.getName());
            if (cacheEntry == null) {
                cacheEntry = new CacheEntry(file, ValidKeysTable.getLocalKeys(file, cacheEntry2.keys));
                cacheEntry2.children = Collections.singletonMap(file.getName(), cacheEntry);
            }
            return cacheEntry;
        }

        private static Set<String> getLocalKeys(File file, Set<String> set) {
            File file2 = new File(file, "TEST.properties");
            if (file2.canRead()) {
                try {
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
                    Properties properties = new Properties();
                    properties.load(bufferedInputStream);
                    bufferedInputStream.close();
                    String string = properties.getProperty("keys");
                    if (string != null && string.trim().length() > 0) {
                        HashSet<String> hashSet = new HashSet<String>(set);
                        hashSet.addAll(Arrays.asList(StringArray.splitWS(string)));
                        return hashSet;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return set;
        }

        private static class CacheEntry {
            File dir;
            Set<String> keys;
            Map<String, CacheEntry> children;

            CacheEntry(File file, Set<String> set) {
                file.getClass();
                this.dir = file;
                this.keys = set;
            }
        }
    }

    private static class ValidTagNames {
        private Set<String> validTags = new HashSet<String>(29);

        public ValidTagNames(boolean bl) {
            this.populate(bl);
        }

        public boolean isValid(String string) {
            return this.validTags.contains(string);
        }

        private void add(String string) {
            this.validTags.add(string);
        }

        private void populate(boolean bl) {
            this.add("test");
            this.add("bug");
            this.add("summary");
            this.add("author");
            this.add("library");
            this.add("clean");
            this.add("compile");
            this.add("ignore");
            this.add("run");
            this.add("build");
            if (bl) {
                this.add("key");
            }
        }
    }
}

