/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.diff;

import com.sun.javatest.TestResult;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.diff.DiffReader;
import com.sun.javatest.diff.HTMLReporter;
import com.sun.javatest.diff.Help;
import com.sun.javatest.diff.MultiMap;
import com.sun.javatest.diff.ReportReader;
import com.sun.javatest.diff.Reporter;
import com.sun.javatest.diff.SimpleReporter;
import com.sun.javatest.diff.StatusComparator;
import com.sun.javatest.diff.WorkDirectoryReader;
import com.sun.javatest.regtest.AntOptionDecoder;
import com.sun.javatest.regtest.BadArgs;
import com.sun.javatest.regtest.Option;
import com.sun.javatest.regtest.OptionDecoder;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;

public class Main {
    private static final String OUTPUT = "output";
    private static final String DOC = "doc";
    private static final String MAIN = "main";
    Option[] options = new Option[]{new Option(Option.ArgType.OLD, "output", "o", new String[]{"o"}){

        @Override
        public void process(String string, String string2) {
            Main.this.outFile = new File(string2);
        }
    }, new Option(Option.ArgType.OLD, "output", "title", new String[]{"title"}){

        @Override
        public void process(String string, String string2) {
            Main.this.title = string2;
        }
    }, new Option(Option.ArgType.REST, "doc", "help", new String[]{"h", "help", "usage"}){

        @Override
        public void process(String string, String string2) {
            if (Main.this.help == null) {
                Main.this.help = new Help(Main.this.options);
            }
            Main.this.help.setCommandLineHelpQuery(string2);
        }
    }, new Option(Option.ArgType.NONE, "doc", "help", new String[]{"version"}){

        @Override
        public void process(String string, String string2) {
            if (Main.this.help == null) {
                Main.this.help = new Help(Main.this.options);
            }
            Main.this.help.setVersionFlag(true);
        }
    }, new Option(Option.ArgType.FILE, "main", null, new String[0]){

        @Override
        public void process(String string, String string2) {
            File file = new File(string2);
            Main.this.fileArgs.add(file);
        }
    }};
    private PrintWriter out;
    private PrintWriter err;
    private Comparator<TestResult> comparator;
    private Reporter reporter;
    private String format;
    private String title;
    private File outFile;
    private List<File> fileArgs = new ArrayList<File>();
    private Help help;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Main.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        PrintWriter printWriter = new PrintWriter(System.out, true);
        PrintWriter printWriter2 = new PrintWriter(System.err, true);
        Main main = new Main(printWriter, printWriter2);
        try {
            boolean bl;
            try {
                bl = main.run(stringArray);
            }
            finally {
                printWriter.flush();
            }
            if (!bl) {
                Main.exit(1);
            }
        }
        catch (Fault fault) {
            printWriter2.println(i18n.getString("main.error", fault.getMessage()));
            Main.exit(2);
        }
        catch (BadArgs badArgs) {
            printWriter2.println(i18n.getString("main.badArgs", badArgs.getMessage()));
            new Help(main.options).showCommandLineHelp(printWriter);
            Main.exit(2);
        }
        catch (InterruptedException interruptedException) {
            printWriter2.println(i18n.getString("main.interrupted"));
            Main.exit(2);
        }
        catch (Exception exception) {
            printWriter2.println(i18n.getString("main.unexpectedException"));
            exception.printStackTrace();
            Main.exit(3);
        }
    }

    public Main() {
        this(new PrintWriter(System.out, true), new PrintWriter(System.err, true));
    }

    public Main(PrintWriter printWriter, PrintWriter printWriter2) {
        this.out = printWriter;
        this.err = printWriter2;
    }

    public final boolean run(String[] stringArray) throws BadArgs, Fault, InterruptedException {
        new OptionDecoder(this.options).decodeArgs(stringArray);
        return this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean run() throws Fault, InterruptedException {
        if (this.fileArgs.size() == 0 && this.help == null) {
            this.help = new Help(this.options);
            this.help.setCommandLineHelpQuery(null);
        }
        if (this.help != null) {
            this.help.show(this.out);
            return true;
        }
        ArrayList<DiffReader> arrayList = new ArrayList<DiffReader>();
        for (File serializable : this.fileArgs) {
            arrayList.add(this.open(serializable));
        }
        PrintWriter printWriter = this.out;
        if (this.outFile != null) {
            try {
                this.out = new PrintWriter(new BufferedWriter(new FileWriter(this.outFile)));
            }
            catch (IOException iOException) {
                throw new Fault(i18n, "main.cantOpenFile", this.outFile, iOException);
            }
        }
        try {
            this.initComparator();
            this.initReporter();
            this.reporter.setTitle(this.title);
            this.reporter.setComparator(this.comparator);
            this.reporter.setReaders(arrayList);
            ArrayList<int[]> arrayList2 = new ArrayList<int[]>();
            MultiMap<String, TestResult> multiMap = new MultiMap<String, TestResult>();
            for (DiffReader diffReader : arrayList) {
                int n = multiMap.add(diffReader.getFile().getPath());
                int[] nArray = new int[4];
                for (TestResult testResult : diffReader) {
                    multiMap.add(n, testResult.getTestName(), testResult);
                    int n2 = testResult.getStatus().getType();
                    nArray[n2] = nArray[n2] + 1;
                }
                arrayList2.add(nArray);
            }
            this.reporter.setTestCounts(arrayList2);
            try {
                this.reporter.write(multiMap);
            }
            catch (IOException bl) {
                throw new Fault(i18n, "main.ioError", bl);
            }
            boolean bl = this.reporter.diffs == 0;
            return bl;
        }
        finally {
            if (this.out != printWriter) {
                this.out.close();
                this.out = printWriter;
            }
        }
    }

    private void initFormat() {
        String string;
        int n;
        if (this.format == null && this.outFile != null && (n = (string = this.outFile.getName()).lastIndexOf(".")) != -1) {
            this.format = string.substring(n + 1).toLowerCase();
        }
    }

    private void initReporter() throws Fault {
        if (this.reporter == null) {
            try {
                this.initFormat();
                if (this.format != null && this.format.equals("html")) {
                    this.reporter = new HTMLReporter(this.out);
                }
                if (this.reporter == null) {
                    this.reporter = new SimpleReporter(System.out);
                }
            }
            catch (IOException iOException) {
                throw new Fault(i18n, "main.cantOpenReport", iOException);
            }
        }
    }

    private void initComparator() {
        if (this.comparator == null) {
            this.comparator = new StatusComparator();
        }
    }

    private DiffReader open(File file) throws Fault {
        if (!file.exists()) {
            throw new Fault(i18n, "main.cantFindFile", file);
        }
        try {
            if (WorkDirectoryReader.accepts(file)) {
                return new WorkDirectoryReader(file);
            }
            if (ReportReader.accepts(file)) {
                return new ReportReader(file);
            }
            throw new Fault(i18n, "main.unrecognizedFile", file);
        }
        catch (TestSuite.Fault fault) {
            throw new Fault(i18n, "main.cantOpenFile", file, fault);
        }
        catch (WorkDirectory.Fault fault) {
            throw new Fault(i18n, "main.cantOpenFile", file, fault);
        }
        catch (IOException iOException) {
            throw new Fault(i18n, "main.cantOpenFile", file, iOException);
        }
    }

    private static void exit(int n) {
        System.exit(n);
    }

    public static class Ant
    extends MatchingTask {
        private Main m = new Main();
        private File outFile;
        private String title;
        private boolean failOnError = true;
        private String resultProperty;
        private List<Commandline.Argument> args = new ArrayList<Commandline.Argument>();

        public void setOutFile(File file) {
            this.outFile = file;
        }

        public void setTitle(String string) {
            this.title = string;
        }

        public void setResultProperty(String string) {
            this.resultProperty = string;
        }

        public void setFailOnError(boolean bl) {
            this.failOnError = bl;
        }

        public void addArg(Commandline.Argument argument) {
            this.args.add(argument);
        }

        public void execute() {
            try {
                AntOptionDecoder antOptionDecoder = new AntOptionDecoder(this.m.options);
                antOptionDecoder.process("outFile", this.outFile);
                antOptionDecoder.process("title", this.title);
                if (this.args.size() > 0) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (Commandline.Argument argument : this.args) {
                        arrayList.addAll(Arrays.asList(argument.getParts()));
                    }
                    antOptionDecoder.decodeArgs(arrayList);
                }
                boolean bl = this.m.run();
                if (this.resultProperty != null) {
                    Project project = this.getProject();
                    project.setProperty(this.resultProperty, String.valueOf(bl ? 0 : 1));
                }
                if (this.failOnError && !bl) {
                    throw new BuildException(i18n.getString("main.diffsFound"));
                }
            }
            catch (BadArgs badArgs) {
                throw new BuildException(badArgs.getMessage(), (Throwable)badArgs);
            }
            catch (Fault fault) {
                throw new BuildException(fault.getMessage(), (Throwable)fault);
            }
            catch (InterruptedException interruptedException) {
                throw new BuildException(i18n.getString("main.interrupted"), (Throwable)interruptedException);
            }
        }
    }

    public static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18NResourceBundle, String string, Object ... objectArray) {
            super(i18NResourceBundle.getString(string, objectArray));
        }
    }
}

