/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.Status;
import com.sun.javatest.TestResult;
import com.sun.javatest.regtest.ParseException;
import com.sun.javatest.regtest.RegressionScript;
import com.sun.javatest.regtest.RegressionSecurityManager;
import com.sun.javatest.regtest.StringArray;
import com.sun.javatest.regtest.TestRunException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;

public abstract class Action {
    protected static final String FILESEP = System.getProperty("file.separator");
    protected static final String LINESEP = System.getProperty("line.separator");
    protected static final String PATHSEP = System.getProperty("path.separator");
    protected static final String JAVAHOME = System.getProperty("java.home");
    protected static final String EXECQUOTE = System.getProperty("os.name").startsWith("Windows") ? "\"" : "";
    protected static final String REASON_ASSUMED_ACTION = "ASSUMED_ACTION";
    protected static final String REASON_USER_SPECIFIED = "USER_SPECIFIED";
    protected static final String REASON_ASSUMED_BUILD = "ASSUMED_BUILD";
    protected static final String REASON_FILE_TOO_OLD = "FILE_OUT_OF_DATE";
    protected static final String SREASON_ASSUMED_ACTION = "Assumed action based on file name: run ";
    protected static final String SREASON_USER_SPECIFIED = "User specified action: run ";
    protected static final String SREASON_ASSUMED_BUILD = "Named class compiled on demand";
    protected static final String SREASON_FILE_TOO_OLD = ".class file out of date or does not exist";
    protected static final String PARSE_TIMEOUT_NONE = "No timeout value";
    protected static final String PARSE_TIMEOUT_BAD_INT = "Bad integer specification: ";
    protected static final String PARSE_FAIL_UEXPECT = "Unexpected value for `fail': ";
    protected static final String PARSE_BAD_OPT_JDK = "Option not allowed using provided test JDK: ";
    protected static final String PARSE_NO_POLICY_NAME = "No policy file name";
    protected static final String PARSE_CANT_FIND_POLICY = "Can't find policy file: ";
    protected static final String PARSE_NO_SECURE_NAME = "No security manager file name";
    protected static final String PARSE_POLICY_OTHERVM = "`/policy' requires use of `/othervm'";
    protected static final String PARSE_SECURE_OTHERVM = "`/secure' requires use of `/othervm'";
    protected static final String PARSE_TIMEOUT_MANUAL = "`/manual' disables use of `/timeout'";
    protected static final String POLICY_WRITE_PROB = "Problems writing new policy file: ";
    protected static final String POLICY_SM_PROB = "Unable to create new policy file: ";
    protected static final String LOG_COMMAND = "command: ";
    protected static final String LOG_RESULT = " result: ";
    protected static final String LOG_JT_COMMAND = "JavaTest command: ";
    protected static final String LOG_REASON = "reason: ";
    protected static final String LOG_ELAPSED_TIME = "elapsed time (seconds): ";
    protected static final String EXEC_FAIL = "Execution failed";
    protected static final String EXEC_FAIL_EXPECT = "Execution failed as expected";
    protected static final String EXEC_PASS = "Execution successful";
    protected static final String EXEC_PASS_UNEXPECT = "Execution passed unexpectedly";
    protected static final String EXEC_ERROR_CLEANUP = "Error while cleaning up threads after test";
    protected static final String CHECK_PASS = "Test description appears acceptable";
    protected static final String UNEXPECT_SYS_EXIT = "Unexpected exit from test";
    protected static final String CANT_FIND_SRC = "Can't file source file: ";
    protected static final String APPLET_ONE_ARG_REQ = "`applet' requires exactly one file argument";
    protected static final String APPLET_BAD_VAL_MANUAL = "Bad value for `manual' option: ";
    protected static final String APPLET_BAD_OPT = "Bad option for applet: ";
    protected static final String APPLET_CANT_FIND_HTML = "Can't find HTML file: ";
    protected static final String APPLET_HTML_READ_PROB = "Problem reading HTML file: ";
    protected static final String APPLET_MISS_ENDBODY = "No </body> tag in ";
    protected static final String APPLET_MISS_APPLET = "No <applet> tag in ";
    protected static final String APPLET_MISS_ENDAPPLET = "No </applet> tag in ";
    protected static final String APPLET_MISS_REQ_ATTRIB = " missing required attribute ";
    protected static final String APPLET_ARCHIVE_USUPP = "`archive' not supported in file: ";
    protected static final String APPLET_MISS_REQ_PARAM = "Missing required name or value for param in <param> tag";
    protected static final String APPLET_CANT_WRITE_ARGS = "Can't write `applet' argument file";
    protected static final String APPLET_SECMGR_FILEOPS = "Unable to create applet argument file";
    protected static final String APPLET_USER_EVAL = ", user evaluated";
    protected static final String APPLET_MANUAL_TEST = "Manual test";
    protected static final String BUILD_UNEXPECT_OPT = "Unexpected options for `build'";
    protected static final String BUILD_NO_CLASSNAME = "No classname(s) provided for `build'";
    protected static final String BUILD_BAD_CLASSNAME = "Bad classname provided for `build': ";
    protected static final String BUILD_NO_COMP_NEED = "No need to compile: ";
    protected static final String BUILD_UP_TO_DATE = "All files up to date";
    protected static final String BUILD_SUCC = "Build successful";
    protected static final String BUILD_LIB_LIST = " in directory-list: ";
    protected static final String CLEAN_SUCC = "Clean successful";
    protected static final String CLEAN_UNEXPECT_OPT = "Unexpected option(s) for `clean'";
    protected static final String CLEAN_NO_CLASSNAME = "No classname(s) provided for `clean'";
    protected static final String CLEAN_BAD_CLASSNAME = "Bad classname provided for `clean': ";
    protected static final String CLEAN_RM_FAILED = "`clean' unable to delete file: ";
    protected static final String CLEAN_SECMGR_PROB = "Problem deleting directory contents: ";
    protected static final String COMPILE_NO_CLASSNAME = "No classname provided for `compile'";
    protected static final String COMPILE_NO_DOT_JAVA = "No classname ending with `.java' found";
    protected static final String COMPILE_BAD_OPT = "Bad option for compile: ";
    protected static final String COMPILE_OPT_DISALLOW = "Compile option not allowed: ";
    protected static final String COMPILE_NO_REF_NAME = "No reference file name";
    protected static final String COMPILE_CANT_FIND_REF = "Can't find reference file: ";
    protected static final String COMPILE_GOLD_FAIL = "Output does not match reference file: ";
    protected static final String COMPILE_GOLD_LINE = ", line ";
    protected static final String COMPILE_GOLD_READ_PROB = "Problem reading reference file: ";
    protected static final String COMPILE_PASS_UNEXPECT = "Compilation passed unexpectedly";
    protected static final String COMPILE_PASS = "Compilation successful";
    protected static final String COMPILE_FAIL_EXPECT = "Compilation failed as expected";
    protected static final String COMPILE_FAIL = "Compilation failed";
    protected static final String IGNORE_UNEXPECT_OPTS = "Unexpected option(s) for `ignore'";
    protected static final String IGNORE_TEST_IGNORED = "Test ignored";
    protected static final String IGNORE_TEST_IGNORED_C = "Test ignored: ";
    protected static final String IGNORE_TEST_SUPPRESSED = "@ignore suppressed by command line option";
    protected static final String IGNORE_TEST_SUPPRESSED_C = "@ignore suppressed by command line option: ";
    protected static final String MAIN_NO_CLASSNAME = "No class provided for `main'";
    protected static final String MAIN_MANUAL_NO_VAL = "Arguments to `manual' option not supported: ";
    protected static final String MAIN_BAD_OPT = "Bad option for main: ";
    protected static final String MAIN_CANT_FIND_SECURE = "Can't find security manager file name: ";
    protected static final String MAIN_BAD_OPT_JDK = "Option not allowed using provided test JDK: ";
    protected static final String MAIN_NO_POLICY_NAME = "No policy file name";
    protected static final String MAIN_CANT_FIND_POLICY = "Can't find policy file: ";
    protected static final String MAIN_POLICY_OTHERVM = "`/policy' requires use of `/othervm'";
    protected static final String MAIN_NO_SECURE_NAME = "No security manager file name";
    protected static final String MAIN_SECURE_OTHERVM = "`/secure' requires use of `/othervm'";
    protected static final String MAIN_UNEXPECT_VMOPT = ": vm option(s) found, need to specify /othervm";
    protected static final String MAIN_POLICY_WRITE_PROB = "Problems writing new policy file: ";
    protected static final String MAIN_POLICY_SM_PROB = "Unable to create new policy file: ";
    protected static final String MAIN_CANT_WRITE_ARGS = "Can't write `main' argument file";
    protected static final String MAIN_SECMGR_FILEOPS = "Unable to create `main' argument file";
    protected static final String MAIN_SECMGR_BAD = "JavaTest not running its own security manager";
    protected static final String MAIN_THREAD_INTR = "Thread interrupted: ";
    protected static final String MAIN_THREW_EXCEPT = "`main' threw exception: ";
    protected static final String MAIN_CANT_LOAD_TEST = "Can't load test: ";
    protected static final String MAIN_CANT_FIND_MAIN = "Can't find `main' method";
    protected static final String SHELL_NO_SCRIPT_NAME = "No script name provided for `shell'";
    protected static final String SHELL_MANUAL_NO_VAL = "Arguments to `manual' option not supported: ";
    protected static final String SHELL_BAD_OPTION = "Bad option for shell: ";
    private long startTime;
    protected String reason;
    protected RegressionScript script;
    protected static final boolean showCmd = Boolean.getBoolean("javatest.regtest.showCmd");

    public abstract void init(String[][] var1, String[] var2, String var3, RegressionScript var4) throws ParseException;

    public abstract Status run() throws TestRunException;

    public File[] getSourceFiles() {
        return null;
    }

    protected int parseTimeout(String string) throws ParseException {
        if (string == null) {
            throw new ParseException(PARSE_TIMEOUT_NONE);
        }
        try {
            return this.script.getActionTimeout(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(PARSE_TIMEOUT_BAD_INT + string);
        }
    }

    protected boolean parseFail(String string) throws ParseException {
        if (string != null) {
            throw new ParseException(PARSE_FAIL_UEXPECT + string);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String addGrantEntry(String string) throws TestRunException {
        File file = new File(this.script.absTestScratchDir(), new File(string).getName() + "_new");
        try {
            FileWriter fileWriter = new FileWriter(file);
            try {
                Object object;
                fileWriter.write("// The following grant entries were added by JavaTest.  Do not edit." + LINESEP);
                fileWriter.write("grant {" + LINESEP);
                fileWriter.write("    permission java.io.FilePermission \"" + this.script.absTestClsTopDir().getPath().replace('\\' + FILESEP, "{/}") + "${/}-\"" + ", \"read\";" + LINESEP);
                fileWriter.write("};" + LINESEP);
                String[] stringArray = StringArray.splitSeparator(PATHSEP, this.script.getJavaTestClassPath());
                for (int i = 0; i < stringArray.length; ++i) {
                    object = new File(stringArray[i]);
                    fileWriter.write("grant codebase \"" + ((File)object).toURL() + "\" {" + LINESEP);
                    fileWriter.write("    permission java.security.AllPermission;" + LINESEP);
                    fileWriter.write("};" + LINESEP);
                }
                fileWriter.write(LINESEP);
                fileWriter.write("// original policy file:" + LINESEP);
                fileWriter.write("// " + string + LINESEP);
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                try {
                    while ((object = bufferedReader.readLine()) != null) {
                        fileWriter.write((String)object + LINESEP);
                    }
                }
                finally {
                    bufferedReader.close();
                }
                bufferedReader.close();
            }
            finally {
                fileWriter.close();
            }
        }
        catch (IOException iOException) {
            throw new TestRunException("Problems writing new policy file: " + file.toString());
        }
        catch (SecurityException securityException) {
            throw new TestRunException("Unable to create new policy file: " + file.toString());
        }
        return file.toString();
    }

    protected String parsePolicy(String string) throws ParseException {
        if (string == null || string.equals("")) {
            throw new ParseException("No policy file name");
        }
        File file = new File(this.script.absTestSrcDir(), string);
        if (!file.exists()) {
            throw new ParseException("Can't find policy file: " + file);
        }
        return file.toString();
    }

    protected String parseSecure(String string) throws ParseException {
        if (string == null || string.equals("")) {
            throw new ParseException("No security manager file name");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Status redirectOutput(PrintStream printStream, PrintStream printStream2) {
        Action action = this;
        synchronized (action) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager instanceof RegressionSecurityManager) {
                boolean bl = ((RegressionSecurityManager)securityManager).setAllowSetIO(true);
                System.setOut(printStream);
                System.setErr(printStream2);
                ((RegressionSecurityManager)securityManager).setAllowSetIO(bl);
            }
        }
        return Status.passed("OK");
    }

    protected TestResult.Section startAction(String string, String[] stringArray, String string2) {
        this.startTime = new Date().getTime();
        return this.startAction(string, StringArray.join(stringArray, " "), string2);
    }

    protected TestResult.Section startAction(String string, String string2, String string3) {
        TestResult.Section section = this.script.getTestResult().createSection(string);
        PrintWriter printWriter = section.getMessageWriter();
        String string4 = LOG_COMMAND + string + " " + string2;
        printWriter.println(string4);
        printWriter.println(LOG_REASON + string3);
        this.startTime = new Date().getTime();
        return section;
    }

    protected void endAction(Status status, TestResult.Section section) {
        long l = new Date().getTime() - this.startTime;
        PrintWriter printWriter = section.getMessageWriter();
        printWriter.println(LOG_ELAPSED_TIME + (double)l / 1000.0);
        section.setStatus(status);
    }

    protected void JTCmd(String string, String[] stringArray, TestResult.Section section) {
        PrintWriter printWriter = section.getMessageWriter();
        printWriter.println(LOG_JT_COMMAND + string);
        for (int i = 0; i < stringArray.length; ++i) {
            printWriter.print("'" + stringArray[i] + "' ");
        }
        printWriter.println();
    }

    String[] quoteBackslash(String[] stringArray) {
        String string = "\\";
        String[] stringArray2 = new String[stringArray.length];
        if (System.getProperty("file.separator").equals(string)) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                StringBuffer stringBuffer = new StringBuffer();
                for (int j = 0; j < string2.length(); ++j) {
                    String string3 = String.valueOf(string2.charAt(j));
                    stringBuffer.append(string3);
                    if (!string3.equals(string)) continue;
                    stringBuffer.append(string3);
                }
                stringArray2[i] = stringBuffer.toString();
            }
        } else {
            stringArray2 = stringArray;
        }
        return stringArray2;
    }

    String singleQuoteString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("'").append(string).append("'");
        return stringBuffer.toString();
    }
}

