/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.JavaTestSecurityManager;
import com.sun.javatest.Status;
import com.sun.javatest.TestResult;
import com.sun.javatest.lib.ProcessCommand;
import com.sun.javatest.regtest.Action;
import com.sun.javatest.regtest.BuildAction;
import com.sun.javatest.regtest.ParseException;
import com.sun.javatest.regtest.RegressionScript;
import com.sun.javatest.regtest.RegressionSecurityManager;
import com.sun.javatest.regtest.StringArray;
import com.sun.javatest.regtest.TestRunException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;

public class MainAction
extends Action {
    private static Hashtable savedSystemProperties;
    private String javaArgs = "";
    private String mainArgs = "";
    private String buildFN = null;
    private String policyFN = null;
    private String secureFN = null;
    private boolean reverseStatus = false;
    private boolean othervm = false;
    private int timeout = -1;
    private String manual = "unset";
    private TestResult.Section section;

    @Override
    public void init(String[][] stringArray, String[] stringArray2, String string, RegressionScript regressionScript) throws ParseException {
        int n;
        this.script = regressionScript;
        this.reason = string;
        if (stringArray2.length == 0) {
            throw new ParseException("No class provided for `main'");
        }
        for (n = 0; n < stringArray.length; ++n) {
            String string2 = stringArray[n][0];
            String string3 = stringArray[n][1];
            if (string2.equals("fail")) {
                this.reverseStatus = this.parseFail(string3);
                continue;
            }
            if (string2.equals("manual")) {
                this.manual = this.parseMainManual(string3);
                continue;
            }
            if (string2.equals("timeout")) {
                this.timeout = this.parseTimeout(string3);
                continue;
            }
            if (string2.equals("othervm")) {
                this.othervm = true;
                continue;
            }
            if (string2.equals("policy")) {
                if (!regressionScript.hasEnv() || !regressionScript.isJDK11()) {
                    this.policyFN = this.parsePolicy(string3);
                    continue;
                }
                throw new ParseException("Option not allowed using provided test JDK: " + string2);
            }
            if (string2.equals("secure")) {
                if (!regressionScript.hasEnv() || !regressionScript.isJDK11()) {
                    this.secureFN = this.parseSecure(string3);
                    continue;
                }
                throw new ParseException("Option not allowed using provided test JDK: " + string2);
            }
            throw new ParseException("Bad option for main: " + string2);
        }
        if (this.manual.equals("unset")) {
            if (this.timeout < 0) {
                this.timeout = regressionScript.getActionTimeout(0);
            }
        } else {
            if (this.timeout >= 0) {
                throw new ParseException("`/manual' disables use of `/timeout'");
            }
            this.timeout = 0;
        }
        n = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            if (this.buildFN == null) {
                if (stringArray2[i].startsWith("-")) {
                    this.javaArgs = this.javaArgs + " " + stringArray2[i];
                    if (!stringArray2[i].equals("-cp") && !stringArray2[i].equals("-classpath") || i + 1 >= stringArray2.length) continue;
                    this.javaArgs = this.javaArgs + " " + stringArray2[++i];
                    continue;
                }
                this.buildFN = stringArray2[i];
                n = i + 1;
                continue;
            }
            this.mainArgs = this.mainArgs == "" ? stringArray2[i] : this.mainArgs + " " + stringArray2[i];
        }
        if (this.buildFN == null) {
            throw new ParseException("No class provided for `main'");
        }
        if (!this.othervm) {
            if (!this.javaArgs.equals("")) {
                throw new ParseException(this.javaArgs + ": vm option(s) found, need to specify /othervm");
            }
            if (this.policyFN != null) {
                throw new ParseException("`/policy' requires use of `/othervm'");
            }
            if (this.secureFN != null) {
                throw new ParseException("`/secure' requires use of `/othervm'");
            }
        }
    }

    @Override
    public File[] getSourceFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (this.buildFN != null) {
            String[][] stringArray = new String[][]{};
            String[] stringArray2 = new String[]{this.buildFN.replace(File.separatorChar, '.')};
            try {
                BuildAction buildAction = new BuildAction();
                buildAction.init(stringArray, stringArray2, "Named class compiled on demand", this.script);
                arrayList.addAll(Arrays.asList(buildAction.getSourceFiles()));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (this.policyFN != null) {
            arrayList.add(new File(this.policyFN));
        }
        if (this.secureFN != null) {
            arrayList.add(new File(this.secureFN));
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    @Override
    public Status run() throws TestRunException {
        BuildAction buildAction = new BuildAction();
        String[][] stringArray = new String[][]{};
        String[] stringArray2 = new String[]{this.buildFN.replace(File.separatorChar, '.')};
        Status status = buildAction.build(stringArray, stringArray2, "Named class compiled on demand", this.script);
        if (!status.isPassed()) {
            return status;
        }
        this.section = this.startAction("main", this.javaArgs + this.buildFN + this.mainArgs, this.reason);
        status = this.script.isCheck() ? Status.passed("Test description appears acceptable") : (this.othervm || this.script.isOtherJVM() ? this.runOtherJVM() : this.runSameJVM());
        this.endAction(status, this.section);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status runOtherJVM() throws TestRunException {
        Status status;
        String string = this.script.absTestClsDir() + FILESEP + this.buildFN + ".jta";
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(this.buildFN + "\u0000");
            fileWriter.write((this.mainArgs == null ? "" : this.mainArgs) + "\u0000");
            fileWriter.close();
        }
        catch (IOException iOException) {
            return Status.error("Can't write `main' argument file");
        }
        catch (SecurityException securityException) {
            return Status.error("Unable to create `main' argument file");
        }
        ArrayList<String> arrayList = new ArrayList<String>(6);
        arrayList.add("CLASSPATH=" + this.script.getJavaTestClassPath() + PATHSEP + this.script.testClassPath());
        arrayList.add(this.script.getJavaProg());
        List<String> list = this.script.getTestVMOptions();
        arrayList.addAll(list);
        arrayList.add("-Dtest.src=" + this.script.absTestSrcDir());
        arrayList.add("-Dtest.classes=" + this.script.absTestClsDir());
        if (this.policyFN != null) {
            String string2 = this.addGrantEntry(this.policyFN);
            arrayList.add("-Djava.security.policy==" + string2);
        }
        if (this.secureFN != null) {
            arrayList.add("-Djava.security.manager=" + this.secureFN);
        } else if (this.policyFN != null) {
            arrayList.add("-Djava.security.manager=default");
        }
        String[] stringArray = StringArray.splitWS(this.javaArgs);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        arrayList.add("com.sun.javatest.regtest.MainWrapper");
        arrayList.add(string);
        String[] stringArray2 = StringArray.splitWS(this.mainArgs);
        for (int i = 0; i < stringArray2.length; ++i) {
            arrayList.add(stringArray2[i]);
        }
        String[] stringArray3 = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray3[i] = (String)arrayList.get(i);
        }
        String[] stringArray4 = this.script.getEnvVars();
        String[] stringArray5 = StringArray.append(stringArray4, stringArray3);
        PrintWriter printWriter = this.section.createOutput("System.out");
        PrintWriter printWriter2 = this.section.createOutput("System.err");
        try {
            if (showCmd) {
                this.JTCmd("main", stringArray5, this.section);
            }
            ProcessCommand processCommand = new ProcessCommand();
            processCommand.setExecDir(this.script.absTestScratchDir());
            processCommand.setStatusForExit(Status.exitCodes[0], Status.passed("Execution successful"));
            processCommand.setStatusForExit(Status.exitCodes[1], Status.failed("Execution failed"));
            processCommand.setDefaultStatus(Status.failed("Unexpected exit from test"));
            if (this.timeout > 0) {
                this.script.setAlarm(this.timeout * 1000);
            }
            status = processCommand.run(stringArray5, printWriter2, printWriter);
        }
        finally {
            this.script.setAlarm(0);
            if (printWriter != null) {
                printWriter.close();
            }
            if (printWriter2 != null) {
                printWriter2.close();
            }
        }
        if (!status.isError() && !status.getReason().startsWith("Unexpected exit from test")) {
            String string3;
            boolean bl = status.isPassed();
            int n = status.getType();
            if (bl && this.reverseStatus) {
                string3 = "Execution passed unexpectedly";
                n = 1;
            } else if (bl && !this.reverseStatus) {
                string3 = "Execution successful";
            } else if (!bl && this.reverseStatus) {
                string3 = "Execution failed as expected";
                n = 0;
            } else {
                string3 = "Execution failed";
            }
            if (n == 1 && !status.getReason().equals("") && !status.getReason().equals("Execution successful")) {
                string3 = string3 + ": " + status.getReason();
            }
            status = new Status(n, string3);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status runSameJVM() throws TestRunException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Status status;
        Object object6;
        Object object7;
        Object object8 = this;
        synchronized (object8) {
            object7 = System.getSecurityManager();
            if (object7 instanceof RegressionSecurityManager) {
                ((RegressionSecurityManager)object7).setAllowPropertiesAccess(true);
                object6 = System.getProperties();
                if (savedSystemProperties == null) {
                    savedSystemProperties = MainAction.copyProperties((Properties)object6);
                }
                ((Properties)object6).put("test.src", this.script.absTestSrcDir().getPath());
                ((Properties)object6).put("test.classes", this.script.absTestClsDir().getPath());
                System.setProperties((Properties)object6);
                ((RegressionSecurityManager)object7).resetPropertiesAccessed();
            }
        }
        object8 = new ByteArrayOutputStream();
        object7 = new ByteArrayOutputStream();
        object6 = new PrintStream((OutputStream)object8);
        PrintStream printStream = new PrintStream((OutputStream)object7);
        PrintStream printStream2 = System.out;
        PrintStream printStream3 = System.err;
        try {
            Throwable throwable;
            SameVMThread sameVMThread;
            SameVMThreadGroup sameVMThreadGroup;
            block47: {
                status = Status.passed("Execution successful");
                Object object9 = StringArray.splitSeparator(PATHSEP, this.script.testClassPath());
                object5 = new ArrayList<URL>();
                for (int i = 0; i < ((String[])object9).length; ++i) {
                    object4 = object9[i];
                    if (((String)object4).length() <= 0) continue;
                    try {
                        object5.add(new File((String)object4).toURL());
                        continue;
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                object3 = new URLClassLoader(object5.toArray(new URL[object5.size()]));
                object4 = ((ClassLoader)object3).loadClass(this.buildFN);
                object2 = new Class[]{String[].class};
                object = ((Class)object4).getMethod("main", (Class<?>)object2);
                String[] stringArray = StringArray.splitWS(this.mainArgs);
                Object[] objectArray = new Object[]{stringArray};
                Status status2 = this.redirectOutput((PrintStream)object6, printStream);
                if (!status2.isPassed()) {
                    Status status3 = status2;
                    return status3;
                }
                sameVMThreadGroup = new SameVMThreadGroup();
                sameVMThread = new SameVMThread((Method)object, objectArray, printStream);
                Thread thread = new Thread(sameVMThreadGroup, sameVMThread, "SameVMThread");
                throwable = null;
                thread.start();
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    if (!thread.isInterrupted() || sameVMThreadGroup.uncaughtThrowable != null) break block47;
                    throwable = interruptedException;
                    status = Status.error("Thread interrupted: " + interruptedException.getMessage());
                }
            }
            sameVMThreadGroup.cleanup();
            if ((sameVMThread.t != null || sameVMThreadGroup.uncaughtThrowable != null) && throwable == null) {
                throwable = sameVMThread.t == null ? sameVMThreadGroup.uncaughtThrowable : sameVMThread.t;
                status = Status.failed("`main' threw exception: " + throwable.toString());
            }
            if (status.getReason().endsWith("java.lang.SecurityException: System.exit() forbidden by JavaTest")) {
                status = Status.failed("Unexpected exit from test");
            } else {
                String string;
                boolean bl = status.isPassed();
                int n = status.getType();
                if (!sameVMThreadGroup.cleanupOK) {
                    string = "Error while cleaning up threads after test";
                    n = 2;
                } else if (bl && this.reverseStatus) {
                    string = "Execution passed unexpectedly";
                    n = 1;
                } else if (bl && !this.reverseStatus) {
                    string = "Execution successful";
                } else if (!bl && this.reverseStatus) {
                    string = "Execution failed as expected";
                    n = 0;
                } else {
                    string = "Execution failed";
                }
                if (n == 1 && status.getReason() != null && !status.getReason().equals("Execution successful")) {
                    string = string + ": " + status.getReason();
                }
                status = new Status(n, string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace(new PrintWriter(printStream, true));
            printStream.println();
            printStream.println("JavaTest Message: main() method must be in a public class named");
            printStream.println("JavaTest Message: " + this.buildFN + " in file " + this.buildFN + ".java");
            printStream.println();
            status = Status.error("Can't load test: " + classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace(new PrintWriter(printStream, true));
            printStream.println();
            printStream.println("JavaTest Message: main() method must be in a public class named");
            printStream.println("JavaTest Message: " + this.buildFN + " in file " + this.buildFN + ".java");
            printStream.println();
            status = Status.error("Can't find `main' method");
        }
        finally {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager instanceof RegressionSecurityManager) {
                object5 = (RegressionSecurityManager)securityManager;
                if (((RegressionSecurityManager)object5).isPropertiesAccessed()) {
                    System.setProperties(MainAction.newProperties(savedSystemProperties));
                }
                ((JavaTestSecurityManager)object5).setAllowPropertiesAccess(false);
            }
            if (!((Status)(object5 = this.redirectOutput(printStream2, printStream3))).isPassed()) {
                return object5;
            }
            ((PrintStream)object6).close();
            printStream.close();
            object3 = ((ByteArrayOutputStream)object8).toString();
            object4 = ((ByteArrayOutputStream)object7).toString();
            object2 = this.section.createOutput("System.out");
            object = this.section.createOutput("System.err");
            try {
                ((PrintWriter)object2).write((String)object3);
                ((PrintWriter)object).write((String)object4);
            }
            finally {
                if (object2 != null) {
                    ((PrintWriter)object2).close();
                }
                if (object != null) {
                    ((PrintWriter)object).close();
                }
            }
        }
        return status;
    }

    private String parseMainManual(String string) throws ParseException {
        if (string != null) {
            throw new ParseException("Arguments to `manual' option not supported: " + string);
        }
        string = "novalue";
        return string;
    }

    private static Hashtable<Object, Object> copyProperties(Properties properties) {
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            hashtable.put(obj, properties.get(obj));
        }
        return hashtable;
    }

    private static Properties newProperties(Hashtable<?, ?> hashtable) {
        Properties properties = new Properties();
        Enumeration<?> enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            properties.put(obj, hashtable.get(obj));
        }
        return properties;
    }

    static class SameVMThreadGroup
    extends ThreadGroup {
        private boolean cleanMode = false;
        Throwable uncaughtThrowable = null;
        Thread uncaughtThread = null;
        boolean cleanupOK = false;

        SameVMThreadGroup() {
            super("SameVMThreadGroup");
        }

        @Override
        public synchronized void uncaughtException(Thread thread, Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                return;
            }
            if (this.uncaughtThrowable == null && !this.cleanMode) {
                this.uncaughtThrowable = throwable;
                this.uncaughtThread = thread;
            }
            this.cleanup();
        }

        private void cleanup() {
            this.cleanMode = true;
            long l = System.nanoTime();
            block2: for (int i = 1; i <= 4; ++i) {
                long l2 = l + (long)i * 30000L * 1000000L;
                List<Thread> list = this.liveThreads();
                if (list.isEmpty()) {
                    this.cleanupOK = true;
                    return;
                }
                for (Thread thread : list) {
                    thread.interrupt();
                }
                for (Thread thread : list) {
                    long l3 = (l2 - System.nanoTime()) / 1000000L;
                    if (l3 <= 0L) continue block2;
                    try {
                        thread.join(l3);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.cleanupOK = this.liveThreads().isEmpty();
        }

        private List<Thread> liveThreads() {
            int n = this.activeCount() + 1;
            while (true) {
                Thread[] threadArray;
                int n2;
                if ((n2 = this.enumerate(threadArray = new Thread[n])) < threadArray.length) {
                    ArrayList<Thread> arrayList = new ArrayList<Thread>(n2);
                    for (int i = 0; i < n2; ++i) {
                        Thread thread = threadArray[i];
                        if (!thread.isAlive() || thread == Thread.currentThread() || thread.isDaemon()) continue;
                        arrayList.add(thread);
                    }
                    return arrayList;
                }
                n *= 2;
            }
        }
    }

    class SameVMThread
    extends Thread {
        public Object result;
        private Method method;
        private Object[] runArgs;
        private PrintStream psErr;
        Throwable t = null;

        public SameVMThread(Method method, Object[] objectArray, PrintStream printStream) {
            this.method = method;
            this.runArgs = objectArray;
            this.psErr = printStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (MainAction.this.timeout > 0) {
                    MainAction.this.script.setAlarm(MainAction.this.timeout * 1000);
                }
                this.result = this.method.invoke(null, this.runArgs);
                System.err.println();
                System.err.println("JavaTest Message:  Test complete.");
                System.err.println();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.getTargetException().printStackTrace(new PrintWriter(this.psErr, true));
                this.t = invocationTargetException.getTargetException();
                System.err.println();
                System.err.println("JavaTest Message: Test threw exception: " + this.t.getClass().getName());
                System.err.println("JavaTest Message: shutting down test");
                System.err.println();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace(new PrintWriter(this.psErr, true));
                this.t = illegalAccessException;
                System.err.println();
                System.err.println("JavaTest Message: Verify that the class defining the test is");
                System.err.println("JavaTest Message: declared public (test invoked via reflection)");
                System.err.println();
            }
            finally {
                MainAction.this.script.setAlarm(0);
            }
        }
    }
}

