/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.Harness;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestResult;
import com.sun.javatest.regtest.Verbose;
import java.io.PrintWriter;

public class RegressionObserver
implements Harness.Observer {
    private static final String VERBOSE_TEST_SEP = "--------------------------------------------------";
    private static final String LINESEP = System.getProperty("line.separator");
    private Verbose verbose;
    private PrintWriter out;
    private PrintWriter err;
    private boolean doneSeparator;

    RegressionObserver(Verbose verbose, PrintWriter printWriter, PrintWriter printWriter2) {
        this.verbose = verbose;
        this.out = printWriter;
        this.err = printWriter2;
    }

    @Override
    public void startingTestRun(Parameters parameters) {
    }

    @Override
    public void stoppingTestRun() {
    }

    @Override
    public void finishedTesting() {
    }

    @Override
    public void finishedTestRun(boolean bl) {
    }

    @Override
    public synchronized void startingTest(TestResult testResult) {
        if (this.verbose == Verbose.DEFAULT) {
            try {
                TestDescription testDescription = testResult.getDescription();
                this.out.println("runner starting test: " + testDescription.getRootRelativeURL());
            }
            catch (TestResult.Fault fault) {
                fault.printStackTrace();
            }
        }
    }

    @Override
    public synchronized void finishedTest(TestResult testResult) {
        Verbose.Mode mode;
        switch (testResult.getStatus().getType()) {
            case 0: {
                mode = this.verbose.passMode;
                break;
            }
            case 1: {
                mode = this.verbose.failMode;
                break;
            }
            case 2: {
                mode = this.verbose.errorMode;
                break;
            }
            default: {
                mode = Verbose.Mode.NONE;
            }
        }
        switch (mode) {
            case NONE: {
                break;
            }
            case DEFAULT: {
                try {
                    TestDescription testDescription = testResult.getDescription();
                    if (this.verbose.time) {
                        this.printElapsedTimes(testResult);
                    }
                    this.out.println("runner finished test: " + testDescription.getRootRelativeURL());
                    this.out.println(testResult.getStatus());
                }
                catch (TestResult.Fault fault) {
                    fault.printStackTrace();
                }
                break;
            }
            case SUMMARY: {
                this.printSummary(testResult, this.verbose.time);
                break;
            }
            case BRIEF: {
                this.printBriefOutput(testResult, this.verbose.time);
                break;
            }
            case FULL: {
                this.printFullOutput(testResult);
            }
        }
    }

    private void printSummary(TestResult testResult, boolean bl) {
        try {
            TestDescription testDescription = testResult.getDescription();
            String string = testResult.getStatus().isPassed() ? "Passed: " : (testResult.getStatus().isFailed() ? "FAILED: " : (testResult.getStatus().isError() ? "Error:  " : "Unexpected status: "));
            string = string + testDescription.getRootRelativeURL();
            this.out.println(string);
            if (bl) {
                this.printElapsedTimes(testResult);
            }
        }
        catch (TestResult.Fault fault) {
            fault.printStackTrace();
        }
    }

    private void printBriefOutput(TestResult testResult, boolean bl) {
        if (!this.doneSeparator) {
            this.out.println(VERBOSE_TEST_SEP);
            this.doneSeparator = true;
        }
        try {
            TestDescription testDescription = testResult.getDescription();
            this.out.println("TEST: " + testDescription.getRootRelativeURL());
            if (bl) {
                this.printElapsedTimes(testResult);
            }
            this.out.println("TEST RESULT: " + testResult.getStatus());
        }
        catch (TestResult.Fault fault) {
            fault.printStackTrace();
        }
        this.out.println(VERBOSE_TEST_SEP);
    }

    private void printFullOutput(TestResult testResult) {
        if (!this.doneSeparator) {
            this.out.println(VERBOSE_TEST_SEP);
            this.doneSeparator = true;
        }
        try {
            TestDescription testDescription = testResult.getDescription();
            this.out.println("TEST: " + testDescription.getRootRelativeURL());
            this.out.println(this.getTestJDK(testResult));
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 1; i < testResult.getSectionCount(); ++i) {
                TestResult.Section section = testResult.getSection(i);
                stringBuffer.append(LINESEP);
                stringBuffer.append("ACTION: ").append(section.getTitle());
                stringBuffer.append(" -- ").append(section.getStatus()).append(LINESEP);
                stringBuffer.append("REASON: ").append(this.getReason(section)).append(LINESEP);
                stringBuffer.append("TIME:   ").append(this.getElapsedTime(section));
                stringBuffer.append(" seconds").append(LINESEP);
                String[] stringArray = section.getOutputNames();
                for (int j = 0; j < stringArray.length; ++j) {
                    String string = stringArray[j];
                    String string2 = section.getOutput(string);
                    if (string.equals("System.out")) {
                        stringBuffer.append("STDOUT:" + LINESEP + string2);
                        continue;
                    }
                    if (string.equals("System.err")) {
                        stringBuffer.append("STDERR:" + LINESEP + string2);
                        continue;
                    }
                    stringBuffer.append(string + ":" + LINESEP + string2);
                }
            }
            this.out.println(stringBuffer.toString());
            this.out.println("TEST RESULT: " + testResult.getStatus());
            this.out.println(VERBOSE_TEST_SEP);
        }
        catch (TestResult.Fault fault) {
            fault.printStackTrace();
        }
    }

    private void printElapsedTimes(TestResult testResult) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            for (int i = 1; i < testResult.getSectionCount(); ++i) {
                TestResult.Section section = testResult.getSection(i);
                stringBuffer.append("  ").append(section.getTitle()).append(": ");
                stringBuffer.append(this.getElapsedTime(section)).append(" seconds").append(LINESEP);
            }
            this.out.print(stringBuffer.toString());
        }
        catch (TestResult.ReloadFault reloadFault) {
            reloadFault.printStackTrace();
        }
    }

    private String getReason(TestResult.Section section) {
        String string = section.getOutput("messages");
        int n = string.indexOf("reason: ") + "reason: ".length();
        int n2 = string.indexOf(LINESEP, n);
        return string.substring(n, n2);
    }

    private String getElapsedTime(TestResult.Section section) {
        String string = section.getOutput("messages");
        int n = string.indexOf("elapsed time (seconds): ") + "elapsed time (seconds): ".length();
        int n2 = string.indexOf(LINESEP, n);
        return string.substring(n, n2);
    }

    private String getTestJDK(TestResult testResult) {
        try {
            TestResult.Section section = testResult.getSection(0);
            String string = section.getOutput("messages");
            int n = string.indexOf("JDK under test: ");
            if (n >= 0) {
                return string.substring(n, string.length() - 1);
            }
        }
        catch (TestResult.ReloadFault reloadFault) {
            reloadFault.printStackTrace();
        }
        return "???";
    }

    public synchronized void report(String string) {
    }

    public synchronized void report(String[] stringArray) {
    }

    @Override
    public synchronized void error(String string) {
        this.err.println("Error: " + string);
    }

    public synchronized void error(String[] stringArray) {
        this.err.println("Error:");
        for (int i = 0; i < stringArray.length; ++i) {
            this.err.println(stringArray[i]);
        }
    }
}

