/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.JavaTestSecurityManager;
import java.security.Permission;
import java.util.PropertyPermission;

public class RegressionSecurityManager
extends JavaTestSecurityManager {
    private static boolean allowExec = true;
    private boolean propertiesAccessed;
    private static boolean allowSetIO = false;
    private static boolean verbose = Boolean.getBoolean("javatest.security.verbose");

    public static void install() {
        block4: {
            try {
                if (Boolean.getBoolean("javatest.security.noSecurityManager")) {
                    System.err.println();
                    System.err.println("     ---- WARNING -----");
                    System.err.println();
                    System.err.println("JavaTest did not install its own Security Manager");
                    System.err.println("because the property javatest.security.noSecurityManager was set.");
                    System.err.println("This is not a fatal error, but it may affect the");
                    System.err.println("execution of sameJVM tests");
                    System.err.println();
                } else {
                    System.setSecurityManager(new RegressionSecurityManager());
                }
            }
            catch (SecurityException securityException) {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager instanceof JavaTestSecurityManager) break block4;
                System.err.println();
                System.err.println("     ---- WARNING -----");
                System.err.println();
                System.err.println("JavaTest could not install its own Security Manager");
                System.err.println("because of the following exception:");
                System.err.println("     " + securityException);
                System.err.println("This is not a fatal error, but it may affect the");
                System.err.println("execution of sameJVM tests");
                System.err.println();
            }
        }
    }

    @Override
    public void checkExec(String string) {
        if (!allowExec) {
            if (verbose) {
                System.err.println(this.getClass().getName() + ": subprocess creation forbidden");
                new Throwable().printStackTrace();
            }
            throw new SecurityException("Subprocess creation forbidden by JavaTest");
        }
    }

    public boolean setAllowExec(boolean bl) {
        boolean bl2 = allowExec;
        allowExec = bl;
        return bl2;
    }

    @Override
    public void checkPermission(Permission permission) {
        if (permission instanceof RuntimePermission) {
            if (permission.getName().equals("setIO")) {
                if (!allowSetIO) {
                    super.checkPermission(new RuntimePermission("setIO"));
                }
            } else if (permission.getName().equals("exitVM")) {
                this.checkExit(0);
            } else if (permission.getName().equals("createSecurityManager")) {
                super.checkPermission(new RuntimePermission("createSecurityManager"));
            }
        } else if (permission instanceof PropertyPermission && ((PropertyPermission)permission).getActions().equals("read,write")) {
            this.checkPropertiesAccess();
        }
    }

    @Override
    public synchronized void checkPropertiesAccess() {
        super.checkPropertiesAccess();
        this.propertiesAccessed = true;
    }

    boolean isPropertiesAccessed() {
        return this.propertiesAccessed;
    }

    void resetPropertiesAccessed() {
        this.propertiesAccessed = false;
    }

    public boolean setAllowSetIO(boolean bl) {
        boolean bl2 = allowSetIO;
        allowSetIO = bl;
        return bl2;
    }
}

