/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.Status;
import com.sun.javatest.TestResult;
import com.sun.javatest.lib.ProcessCommand;
import com.sun.javatest.regtest.Action;
import com.sun.javatest.regtest.ParseException;
import com.sun.javatest.regtest.RegressionScript;
import com.sun.javatest.regtest.StringArray;
import com.sun.javatest.regtest.TestRunException;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class ShellAction
extends Action {
    private static final String sep = ShellAction.getSeparator();
    private String shellFN;
    private List<String> shellArgs;
    private boolean reverseStatus = false;
    private int timeout = -1;
    private String manual = "unset";
    private TestResult.Section section;

    @Override
    public void init(String[][] stringArray, String[] stringArray2, String string, RegressionScript regressionScript) throws ParseException {
        this.script = regressionScript;
        this.reason = string;
        if (stringArray2.length == 0) {
            throw new ParseException("No script name provided for `shell'");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i][0];
            String string3 = stringArray[i][1];
            if (string2.equals("fail")) {
                this.reverseStatus = this.parseFail(string3);
                continue;
            }
            if (string2.equals("timeout")) {
                this.timeout = this.parseTimeout(string3);
                continue;
            }
            if (string2.equals("manual")) {
                this.manual = this.parseShellManual(string3);
                continue;
            }
            throw new ParseException("Bad option for shell: " + string2);
        }
        if (this.manual.equals("unset")) {
            if (this.timeout < 0) {
                this.timeout = regressionScript.getActionTimeout(0);
            }
        } else {
            if (this.timeout >= 0) {
                throw new ParseException("`/manual' disables use of `/timeout'");
            }
            this.timeout = 0;
        }
        this.shellFN = stringArray2[0];
        this.shellArgs = new ArrayList<String>();
        StringBuilder stringBuilder = null;
        for (int i = 1; i < stringArray2.length; ++i) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(stringArray2[i]);
            } else {
                stringBuilder.append(" ").append(stringArray2[i]);
            }
            if (!ShellAction.isEvenQuotes(stringBuilder)) continue;
            this.shellArgs.add(stringBuilder.toString().replace("'", ""));
            stringBuilder = null;
        }
        if (stringBuilder != null) {
            this.shellArgs.add(stringBuilder.toString());
        }
    }

    private static boolean isEvenQuotes(StringBuilder stringBuilder) {
        int n = 0;
        for (int i = 0; i < stringBuilder.length(); ++i) {
            if (stringBuilder.charAt(i) != '\'') continue;
            ++n;
        }
        return n % 2 == 0;
    }

    @Override
    public File[] getSourceFiles() {
        return new File[]{new File(this.script.absTestSrcDir(), this.shellFN)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status run() throws TestRunException {
        Status status;
        this.section = this.startAction("shell", this.shellFN + " " + this.shellArgs, this.reason);
        File file = new File(this.script.absTestSrcDir(), this.shellFN);
        if (!file.exists()) {
            throw new TestRunException("Can't file source file: " + file);
        }
        if (this.script.isCheck()) {
            status = Status.passed("Test description appears acceptable");
        } else {
            String string;
            String[] stringArray = this.script.getEnvVars();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(this.fixupSep(stringArray[i]));
            }
            arrayList.add("TESTSRC=" + this.fixupSep(this.script.absTestSrcDir()));
            arrayList.add("TESTCLASSES=" + this.fixupSep(this.script.absTestClsDir()));
            arrayList.add("TESTJAVA=" + this.fixupSep(this.script.getJDK()));
            List<String> list = this.script.getTestVMOptions();
            arrayList.add("TESTVMOPTS=" + this.fixupSep(StringArray.join(list.toArray(new String[list.size()]), " ")));
            List<String> list2 = this.script.getTestToolVMOptions();
            arrayList.add("TESTTOOLVMOPTS=" + this.fixupSep(StringArray.join(list2.toArray(new String[list2.size()]), " ")));
            List<String> list3 = this.script.getTestCompilerOptions();
            arrayList.add("TESTJAVACOPTS=" + this.fixupSep(StringArray.join(list3.toArray(new String[list3.size()]), " ")));
            arrayList.add("sh");
            arrayList.add(file.getPath());
            arrayList.addAll(this.shellArgs);
            String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
            PrintWriter printWriter = this.section.createOutput("System.out");
            PrintWriter printWriter2 = this.section.createOutput("System.err");
            try {
                if (showCmd) {
                    this.JTCmd("shell", stringArray2, this.section);
                }
                ProcessCommand processCommand = new ProcessCommand();
                processCommand.setExecDir(this.script.absTestScratchDir());
                if (this.timeout > 0) {
                    this.script.setAlarm(this.timeout * 1000);
                }
                status = processCommand.run(stringArray2, printWriter2, printWriter);
            }
            finally {
                this.script.setAlarm(0);
                if (printWriter != null) {
                    printWriter.close();
                }
                if (printWriter2 != null) {
                    printWriter2.close();
                }
            }
            boolean bl = status.isPassed();
            int n = status.getType();
            if (bl && this.reverseStatus) {
                string = "Execution passed unexpectedly";
                n = 1;
            } else if (bl && !this.reverseStatus) {
                string = "Execution successful";
            } else if (!bl && this.reverseStatus) {
                string = "Execution failed as expected";
                n = 0;
            } else {
                string = "Execution failed";
            }
            if (n == 1) {
                string = string + ": " + status.getReason();
            }
            status = new Status(n, string);
        }
        this.endAction(status, this.section);
        return status;
    }

    private String fixupSep(File file) {
        return this.fixupSep(file.getPath());
    }

    private String fixupSep(String string) {
        return sep == null ? string : string.replace(File.separator, sep);
    }

    private static String getSeparator() {
        return File.separatorChar == '\\' ? System.getProperty("javatest.shell.separator", "/") : null;
    }

    private String parseShellManual(String string) throws ParseException {
        if (string != null) {
            throw new ParseException("Arguments to `manual' option not supported: " + string);
        }
        string = "novalue";
        return string;
    }
}

