/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.regtest.StringArray;
import java.util.Arrays;
import java.util.HashSet;

public class Verbose {
    public static final Verbose DEFAULT = new Verbose(Mode.DEFAULT);
    public static final Verbose SUMMARY = new Verbose(Mode.SUMMARY);
    public static final Verbose ALL = new Verbose(Mode.FULL);
    public static final Verbose PASS = new Verbose(Mode.FULL, Mode.BRIEF, Mode.BRIEF);
    public static final Verbose FAIL = new Verbose(Mode.BRIEF, Mode.FULL, Mode.BRIEF);
    public static final Verbose ERROR = new Verbose(Mode.BRIEF, Mode.BRIEF, Mode.FULL);
    public static final Verbose TIME = new Verbose(Mode.SUMMARY, true);
    final Mode passMode;
    final Mode failMode;
    final Mode errorMode;
    final boolean time;

    static String[] values() {
        return new String[]{"default", "summary", "all", "pass", "fail", "error", "nopass", "time"};
    }

    static Verbose decode(String string) {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(StringArray.splitSeparator(",", string)));
        boolean bl = hashSet.contains("default");
        boolean bl2 = hashSet.contains("summary");
        boolean bl3 = hashSet.contains("all");
        boolean bl4 = hashSet.contains("pass");
        boolean bl5 = hashSet.contains("fail");
        boolean bl6 = hashSet.contains("error");
        boolean bl7 = hashSet.contains("nopass");
        boolean bl8 = hashSet.contains("time");
        if (bl) {
            if (bl2 || bl3 || bl4 || bl5 || bl6 || bl7) {
                throw new IllegalArgumentException(string);
            }
            return new Verbose(Mode.DEFAULT, bl8);
        }
        if (bl2 || bl3 || bl4 || bl5 || bl6 || bl7) {
            Mode mode;
            if (bl4 && bl7) {
                throw new IllegalArgumentException(string);
            }
            Mode mode2 = mode = bl2 ? Mode.SUMMARY : Mode.BRIEF;
            return new Verbose(bl7 ? Mode.NONE : (bl3 || bl4 ? Mode.FULL : mode), bl3 || bl5 ? Mode.FULL : mode, bl3 || bl6 ? Mode.FULL : mode, bl8);
        }
        return bl8 ? TIME : DEFAULT;
    }

    private static Mode check(Mode mode, Mode mode2) {
        if (mode2 == null) {
            throw new NullPointerException();
        }
        if (mode == null || mode == mode2) {
            return mode2;
        }
        return mode2;
    }

    Verbose(Mode mode) {
        this(mode, false);
    }

    Verbose(Mode mode, boolean bl) {
        this(mode, mode, mode, bl);
    }

    Verbose(Mode mode, Mode mode2, Mode mode3) {
        this(mode, mode2, mode3, false);
    }

    Verbose(Mode mode, Mode mode2, Mode mode3, boolean bl) {
        this.passMode = mode;
        this.failMode = mode2;
        this.errorMode = mode3;
        this.time = bl;
    }

    public String toString() {
        return "Verbose[p=" + (Object)((Object)this.passMode) + ",f=" + (Object)((Object)this.failMode) + ",e=" + (Object)((Object)this.errorMode) + ",t=" + this.time + "]";
    }

    public static enum Mode {
        NONE,
        DEFAULT,
        SUMMARY,
        BRIEF,
        FULL;

    }
}

