/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class ChoiceArrayQuestion
extends Question {
    private String[] choices;
    private String[] displayChoices;
    protected boolean[] value;
    private boolean[] defaultValue;

    protected ChoiceArrayQuestion(Interview interview, String string) {
        super(interview, string);
    }

    protected ChoiceArrayQuestion(Interview interview, String string, String[] stringArray) {
        super(interview, string);
        this.setChoices(stringArray, stringArray);
    }

    protected void setChoices(String[] stringArray) {
        this.setChoices(stringArray, stringArray);
    }

    protected void setChoices(String[] stringArray, boolean bl) {
        this.setChoices(stringArray, bl ? null : stringArray);
    }

    protected void setChoices(String[] stringArray, String[] stringArray2) {
        int n;
        if (stringArray == null) {
            throw new NullPointerException();
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] != null) continue;
            throw new NullPointerException();
        }
        if (stringArray2 != null) {
            if (stringArray.length != stringArray2.length) {
                throw new IllegalArgumentException();
            }
            for (n = 0; n < stringArray2.length; ++n) {
                if (stringArray2[n] != null) continue;
                throw new NullPointerException();
            }
        }
        this.choices = stringArray;
        this.displayChoices = stringArray2;
        this.value = new boolean[stringArray.length];
        if (this.defaultValue != null && this.defaultValue.length != stringArray.length) {
            this.defaultValue = null;
        }
    }

    public String[] getChoices() {
        return this.choices;
    }

    public String[] getDisplayChoices() {
        if (this.displayChoices == null) {
            ResourceBundle resourceBundle = this.interview.getResourceBundle();
            if (resourceBundle == null) {
                return this.choices;
            }
            this.displayChoices = new String[this.choices.length];
            for (int i = 0; i < this.choices.length; ++i) {
                String string = this.choices[i];
                String string2 = this.key + "." + string;
                try {
                    this.displayChoices[i] = string == null ? null : resourceBundle.getString(string2);
                    continue;
                }
                catch (MissingResourceException missingResourceException) {
                    System.err.println("WARNING: missing resource " + string2);
                    this.displayChoices[i] = string;
                }
            }
        }
        return this.displayChoices;
    }

    public boolean[] getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(boolean[] blArray) {
        this.defaultValue = blArray;
    }

    public boolean[] getValue() {
        if (this.value == null) {
            throw new IllegalStateException();
        }
        boolean[] blArray = null;
        if (this.value != null) {
            blArray = new boolean[this.value.length];
            for (int i = 0; i < this.value.length; ++i) {
                blArray[i] = this.value[i];
            }
        }
        return blArray;
    }

    public boolean[] getValueOnPath() throws Interview.NotOnPathFault {
        this.interview.verifyPathContains(this);
        return this.getValue();
    }

    public String getStringValue() {
        if (this.value == null) {
            return "";
        }
        if (this.value.length != this.choices.length) {
            throw new IllegalStateException();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.value != null) {
            for (int i = 0; i < this.value.length; ++i) {
                if (!this.value[i]) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(this.choices[i].replace(' ', '_'));
            }
        }
        return stringBuffer.toString();
    }

    public void setValue(String string) {
        if (this.choices == null) {
            return;
        }
        boolean[] blArray = new boolean[this.choices.length];
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (ChoiceArrayQuestion.white(string.charAt(i))) {
                if (n != -1) {
                    this.set(blArray, string.substring(n, i));
                }
                n = -1;
                continue;
            }
            if (n != -1) continue;
            n = i;
        }
        if (n != -1) {
            this.set(blArray, string.substring(n));
        }
        this.setValue(blArray);
    }

    public boolean isValueValid() {
        return true;
    }

    public boolean isValueAlwaysValid() {
        return false;
    }

    private void set(boolean[] blArray, String string) {
        for (int i = 0; i < this.choices.length; ++i) {
            if (!string.equals(this.choices[i].replace(' ', '_'))) continue;
            blArray[i] = true;
            return;
        }
    }

    private static boolean white(char c) {
        return c == ' ' || c == '\t' || c == '\n';
    }

    public void setValue(boolean[] blArray) {
        if (this.choices == null) {
            return;
        }
        boolean bl = false;
        if (blArray == null) {
            for (int i = 0; i < this.value.length; ++i) {
                if (!bl) {
                    bl = this.value[i];
                }
                this.value[i] = false;
            }
        } else {
            for (int i = 0; i < Math.min(blArray.length, this.value.length); ++i) {
                if (!bl) {
                    bl = this.value[i] != blArray[i];
                }
                this.value[i] = blArray[i];
            }
        }
        if (bl) {
            this.interview.updatePath(this);
            this.interview.setEdited(true);
        }
    }

    public void clear() {
        this.setValue(this.defaultValue);
    }

    protected void load(Map map) {
        Object v = map.get(this.tag);
        if (v != null && v instanceof String) {
            this.setValue((String)v);
        }
    }

    protected void save(Map map) {
        map.put(this.tag, this.getStringValue());
    }
}

