/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.ResourceBundle;

public abstract class InetAddressQuestion
extends Question {
    public static final int IPv4 = 0;
    public static final int IPv6 = 1;
    protected InetAddress value;
    private String stringValue;
    private transient String newStringValue;
    private InetAddress[] suggestions;
    private InetAddress defaultValue;
    private boolean valid;
    private int type = 0;
    private int style = 0;
    private static final ResourceBundle i18n = Interview.i18n;

    protected InetAddressQuestion(Interview interview, String string) {
        super(interview, string);
        this.clear();
        this.setDefaultValue(this.value);
    }

    protected InetAddressQuestion(Interview interview, String string, int n) {
        super(interview, string);
        this.setType(n);
        this.clear();
        this.setDefaultValue(this.value);
    }

    public int getType() {
        return this.type;
    }

    protected void setType(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException();
        }
        this.type = n;
    }

    public int getStyle() {
        return this.style;
    }

    protected void setStyle(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException();
        }
        this.style = n;
    }

    public InetAddress[] getSuggestions() {
        return this.suggestions;
    }

    public void setSuggestions(InetAddress[] inetAddressArray) {
        if (inetAddressArray != null) {
            for (int i = 1; i < inetAddressArray.length; ++i) {
                if (inetAddressArray[i] != null) continue;
                throw new IllegalArgumentException();
            }
        }
        this.suggestions = inetAddressArray;
    }

    public InetAddress getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(InetAddress inetAddress) {
        this.defaultValue = inetAddress;
    }

    public InetAddress getValue() {
        return this.value;
    }

    public InetAddress getValueOnPath() throws Interview.NotOnPathFault {
        this.interview.verifyPathContains(this);
        return this.getValue();
    }

    public String getStringValue() {
        if (this.stringValue == null && this.value != null) {
            this.stringValue = this.value.getHostAddress();
        }
        return this.stringValue;
    }

    public void setValue(InetAddress inetAddress) {
        InetAddress inetAddress2 = this.value;
        this.value = inetAddress;
        this.stringValue = this.newStringValue;
        this.newStringValue = null;
        boolean bl = this.value == null ? false : (this.valid = this.type == 0 ? this.value instanceof Inet4Address : true);
        if (!InetAddressQuestion.equal(this.value, inetAddress2)) {
            this.interview.updatePath(this);
            this.interview.setEdited(true);
        }
    }

    public boolean isValueValid() {
        return this.valid;
    }

    public boolean isValueAlwaysValid() {
        return false;
    }

    public void setValue(String string) throws Interview.Fault {
        InetAddress inetAddress = this.parse(string);
        this.newStringValue = string;
        this.setValue(inetAddress);
    }

    private InetAddress parse(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = string.length();
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    bl2 = true;
                    continue block8;
                }
                case '.': {
                    bl3 = true;
                    continue block8;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    if (this.type == 0) {
                        return null;
                    }
                    bl = true;
                    continue block8;
                }
                case ':': {
                    if (this.type == 0) {
                        return null;
                    }
                    bl4 = true;
                    continue block8;
                }
                default: {
                    return null;
                }
            }
        }
        if (!(this.type != 1 || bl4 || bl3 && bl2 && !bl)) {
            return null;
        }
        try {
            return InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public void clear() {
        this.setValue(this.defaultValue);
    }

    protected void load(Map map) {
        Object v = map.get(this.tag);
        if (v instanceof InetAddress) {
            this.setValue((InetAddress)v);
        } else if (v instanceof String) {
            try {
                this.setValue((String)v);
            }
            catch (Interview.Fault fault) {
                throw new Error(fault);
            }
        }
    }

    protected void save(Map map) {
        String string = this.getStringValue();
        if (string != null) {
            map.put(this.tag, string);
        }
    }

    protected static boolean equal(InetAddress inetAddress, InetAddress inetAddress2) {
        return inetAddress == null ? inetAddress2 == null : inetAddress.equals(inetAddress2);
    }
}

