/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Map;
import java.util.ResourceBundle;

public abstract class IntQuestion
extends Question {
    protected int value = Integer.MIN_VALUE;
    protected int[] suggestions;
    private int defaultValue = Integer.MIN_VALUE;
    private String stringValue;
    private transient String newStringValue;
    private int min = -2147483647;
    private int max = Integer.MAX_VALUE;
    private int labelStart;
    private int labelIncrement;
    private static final String UNSET = "unset";
    private static final ResourceBundle i18n = Interview.i18n;

    protected IntQuestion(Interview interview, String string) {
        super(interview, string);
        this.clear();
        this.setDefaultValue(this.value);
    }

    protected IntQuestion(Interview interview, String string, int n, int n2) {
        super(interview, string);
        this.setBounds(n, n2);
        this.clear();
        this.setDefaultValue(this.value);
    }

    protected void setBounds(int n, int n2) {
        if (n >= n2) {
            throw new IllegalArgumentException("invalid bounds");
        }
        this.min = n;
        this.max = n2;
    }

    public int getLowerBound() {
        return this.min;
    }

    public int getUpperBound() {
        return this.max;
    }

    public int[] getSuggestions() {
        return this.suggestions;
    }

    public void setSuggestions(int[] nArray) {
        this.suggestions = nArray;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(int n) {
        this.defaultValue = n;
    }

    public boolean isValid() {
        return (this.min == Integer.MIN_VALUE || this.min <= this.value) && this.value <= this.max;
    }

    public int getValue() {
        return this.value;
    }

    public int getValueOnPath() throws Interview.NotOnPathFault {
        this.interview.verifyPathContains(this);
        return this.getValue();
    }

    public String getStringValue() {
        if (this.stringValue == null) {
            if (this.value == Integer.MIN_VALUE) {
                this.stringValue = "";
            } else {
                NumberFormat numberFormat = NumberFormat.getIntegerInstance();
                this.stringValue = numberFormat.format(new Integer(this.value));
            }
        }
        return this.stringValue;
    }

    public void setValue(String string) throws Interview.Fault {
        ParsePosition parsePosition;
        NumberFormat numberFormat;
        Number number;
        if (string != null) {
            string = string.trim();
        }
        int n = string == null || string.length() == 0 ? Integer.MIN_VALUE : ((number = (numberFormat = NumberFormat.getIntegerInstance()).parse(string, parsePosition = new ParsePosition(0))) != null && parsePosition.getIndex() == string.length() ? number.intValue() : Integer.MIN_VALUE);
        this.newStringValue = string;
        this.setValue(n);
    }

    public void setValue(int n) {
        int n2 = this.value;
        this.value = n;
        this.stringValue = this.newStringValue;
        this.newStringValue = null;
        if (this.value != n2) {
            this.interview.updatePath(this);
            this.interview.setEdited(true);
        }
    }

    public boolean isValueValid() {
        return this.isValid();
    }

    public boolean isValueAlwaysValid() {
        return false;
    }

    protected void setLabelHints(int n, int n2) {
        this.labelStart = n;
        this.labelIncrement = n2;
    }

    public int getLabelStartHint() {
        return this.labelStart;
    }

    public int getLabelIncrementHint() {
        return this.labelIncrement;
    }

    public void clear() {
        this.setValue(this.defaultValue);
    }

    protected void load(Map map) {
        Object v = map.get(this.tag);
        if (v == null) {
            this.clear();
        } else if (v instanceof Integer) {
            this.setValue((Integer)v);
        } else if (v instanceof String) {
            try {
                this.setValue((String)v);
            }
            catch (Interview.Fault fault) {
                throw new Error(fault);
            }
        }
    }

    protected void save(Map map) {
        map.put(this.tag, this.getStringValue());
    }
}

