/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Checklist;
import com.sun.interview.ErrorQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.InterviewQuestion;
import com.sun.interview.ListQuestion;
import com.sun.interview.NullQuestion;
import com.sun.interview.Question;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.help.HelpSet;
import javax.help.HelpSetException;

public class Interview {
    public static final int EXPORT_IGNORE_ALL_EXCEPTIONS = 0;
    public static final int EXPORT_IGNORE_RUNTIME_EXCEPTIONS = 1;
    public static final int EXPORT_IGNORE_NO_EXCEPTIONS = 2;
    private static final int EXPORT_NUM_IGNORE_POLICIES = 3;
    private int exportIgnoreExceptionPolicy = 1;
    private Observer[] observers = new Observer[0];
    private static final Object[] empty = new Object[0];
    private final Interview parent;
    private final Interview root;
    private String baseTag;
    private String tag;
    private String title;
    private Question firstQuestion;
    private Vector children = new Vector();
    private Map allQuestions = new HashMap();
    private URL defaultImage;
    private String helpSetName;
    private HelpSet helpSet;
    private String bundleName;
    private ResourceBundle bundle;
    private Path path;
    private int currIndex;
    private InterviewQuestion caller;
    private boolean updateEnabled;
    private boolean edited;
    private Map allMarkers;
    private int semantics = 0;
    static final ResourceBundle i18n = ResourceBundle.getBundle("com.sun.interview.i18n");
    public static final int SEMANTIC_PRE_32 = 0;
    public static final int SEMANTIC_VERSION_32 = 1;
    public static final int SEMANTIC_MAX_VERSION = 1;

    protected Interview(String string) {
        this(null, string);
    }

    protected Interview(Interview interview, String string) {
        this.parent = interview;
        this.setBaseTag(string);
        if (interview == null) {
            this.root = this;
        } else {
            interview.add(this);
            this.root = interview.root;
            this.semantics = interview.getInterviewSemantics();
        }
    }

    public Interview getParent() {
        return this.parent;
    }

    public String getTag() {
        return this.tag;
    }

    protected void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        if (this.title == null) {
            String string = "title";
            this.title = this.getI18NString(string).trim();
        }
        return this.title;
    }

    protected void setDefaultImage(URL uRL) {
        this.defaultImage = uRL;
    }

    public URL getDefaultImage() {
        if (this.defaultImage == null && this.parent != null) {
            return this.parent.getDefaultImage();
        }
        return this.defaultImage;
    }

    protected void setResourceBundle(String string) throws MissingResourceException {
        if (string != this.bundleName) {
            if (string != null) {
                String string2;
                Class<?> clazz = this.getClass();
                ClassLoader classLoader = clazz.getClassLoader();
                if (string.startsWith("/")) {
                    string2 = string.substring(1);
                } else {
                    String string3 = clazz.getName();
                    String string4 = string3.substring(0, string3.lastIndexOf(46));
                    string2 = string4 + "." + string;
                }
                this.bundle = ResourceBundle.getBundle(string2, Locale.getDefault(), classLoader);
            }
            this.bundleName = string;
        }
    }

    public ResourceBundle getResourceBundle() {
        if (this.bundle == null && this.parent != null) {
            return this.parent.getResourceBundle();
        }
        return this.bundle;
    }

    protected void setHelpSet(String string) throws HelpNotFoundFault, BadHelpFault {
        try {
            Object object;
            Object object2;
            String string2;
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            if (string.startsWith("/")) {
                string2 = string.substring(1);
            } else {
                object2 = clazz.getName();
                object = ((String)object2).substring(0, ((String)object2).lastIndexOf(46));
                string2 = ((String)object).replace('.', '/') + "/" + string;
            }
            object2 = HelpSet.findHelpSet(classLoader, string2);
            if (object2 == null) {
                throw new HelpNotFoundFault(i18n, "interview.cantFindHelp", string2);
            }
            object = new HelpSet(classLoader, (URL)object2);
            this.setHelpSet((HelpSet)object);
        }
        catch (HelpSetException helpSetException) {
            throw new BadHelpFault(i18n, "interview.badHelp", helpSetException);
        }
    }

    protected void setHelpSet(HelpSet helpSet) {
        if (this.parent == null) {
            if (this.helpSet == null) {
                Iterator iterator = this.getInterviews().iterator();
                while (iterator.hasNext()) {
                    Interview interview = (Interview)iterator.next();
                    HelpSet helpSet2 = interview.getHelpSet();
                    if (helpSet2 == null) continue;
                    helpSet.add(helpSet2);
                }
            } else {
                Enumeration enumeration = this.helpSet.getHelpSets();
                while (enumeration.hasMoreElements()) {
                    HelpSet helpSet3 = (HelpSet)enumeration.nextElement();
                    this.helpSet.remove(helpSet3);
                    helpSet.add(helpSet3);
                }
            }
        } else {
            Interview interview = this;
            while (interview.parent != null) {
                interview = interview.parent;
            }
            HelpSet helpSet4 = interview.helpSet;
            if (helpSet4 != null) {
                if (this.helpSet != null) {
                    helpSet4.remove(this.helpSet);
                }
                helpSet4.add(helpSet);
            }
        }
        this.helpSet = helpSet;
    }

    public HelpSet getHelpSet() {
        if (this.helpSet == null && this.parent != null) {
            return this.parent.getHelpSet();
        }
        return this.helpSet;
    }

    public void setEdited(boolean bl) {
        Interview interview = this;
        while (interview.parent != null) {
            interview = interview.parent;
        }
        interview.edited = bl;
    }

    public boolean isEdited() {
        Interview interview = this;
        while (interview.parent != null) {
            interview = interview.parent;
        }
        return interview.edited;
    }

    public Question getFirstQuestion() {
        return this.firstQuestion;
    }

    protected void setFirstQuestion(Question question) {
        if (this.path != null) {
            throw new IllegalStateException();
        }
        this.firstQuestion = question;
    }

    public Interview getInterview(String string) throws Fault {
        if (string == null) {
            throw new NullPointerException();
        }
        Interview interview = this.getInterview0(string);
        if (interview != null) {
            return interview;
        }
        throw new Fault(i18n, "interview.cantFindInterview", string);
    }

    private Interview getInterview0(String string) {
        if (string.equals(this.tag)) {
            return this;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            Interview interview = (Interview)this.children.elementAt(i);
            Interview interview2 = interview.getInterview0(string);
            if (interview2 == null) continue;
            return interview2;
        }
        return null;
    }

    private Set getInterviews() {
        HashSet hashSet = new HashSet();
        this.getInterviews0(hashSet);
        return hashSet;
    }

    private void getInterviews0(Set set) {
        set.add(this);
        for (int i = 0; i < this.children.size(); ++i) {
            Interview interview = (Interview)this.children.elementAt(i);
            interview.getInterviews0(set);
        }
    }

    public boolean isFirst(Question question) {
        return question == this.firstQuestion;
    }

    public boolean isLast(Question question) {
        return question instanceof FinalQuestion && question.interview.caller == null;
    }

    public boolean hasNext(Question question) {
        return question.getNext() != null;
    }

    public boolean hasValidNext(Question question) {
        Question question2 = question.getNext();
        return question2 != null && !(question2 instanceof ErrorQuestion);
    }

    public void reset() {
        this.ensurePathInitialized();
        this.updateEnabled = true;
        this.caller = null;
        this.currIndex = 0;
        this.path.clear();
        this.path.addQuestion(this.firstQuestion);
        this.updatePath(this.firstQuestion);
        this.notifyCurrentQuestionChanged(this.firstQuestion);
    }

    private void reset(Question question) {
        this.ensurePathInitialized();
        this.updateEnabled = true;
        this.caller = null;
        this.currIndex = 0;
        this.path.clear();
        this.path.addQuestion(this.firstQuestion);
        this.updatePath(this.firstQuestion);
        if (question == this.firstQuestion || question == null) {
            this.notifyCurrentQuestionChanged(this.firstQuestion);
        } else {
            try {
                this.setCurrentQuestion(question);
            }
            catch (Fault fault) {
                this.notifyCurrentQuestionChanged(this.firstQuestion);
            }
        }
    }

    public void next() throws Fault {
        Question question;
        this.ensurePathInitialized();
        Interview interview = this;
        while (interview.path.questionAt(interview.currIndex) instanceof InterviewQuestion) {
            question = (InterviewQuestion)interview.path.questionAt(interview.currIndex);
            interview = ((InterviewQuestion)question).getTargetInterview();
        }
        ++interview.currIndex;
        while (true) {
            if (interview.currIndex == interview.path.size()) {
                --interview.currIndex;
                throw new Fault(i18n, "interview.noMoreQuestions");
            }
            question = interview.path.questionAt(interview.currIndex);
            if (question instanceof InterviewQuestion) {
                Question question2 = question;
                interview = ((InterviewQuestion)question2).getTargetInterview();
                interview.currIndex = 0;
                continue;
            }
            if (!(question instanceof FinalQuestion) || interview.caller == null) break;
            interview = interview.caller.getInterview();
            ++interview.currIndex;
        }
        question = interview.path.questionAt(interview.currIndex);
        this.notifyCurrentQuestionChanged(question);
    }

    public void prev() throws Fault {
        Question question;
        this.ensurePathInitialized();
        Interview interview = this;
        while (interview.path.questionAt(interview.currIndex) instanceof InterviewQuestion) {
            question = (InterviewQuestion)interview.path.questionAt(interview.currIndex);
            interview = question.getTargetInterview();
        }
        --interview.currIndex;
        while (true) {
            if (interview.currIndex < 0) {
                if (interview.caller == null) {
                    interview.currIndex = 0;
                    throw new Fault(i18n, "interview.noMoreQuestions");
                }
                interview = interview.caller.getInterview();
                --interview.currIndex;
                continue;
            }
            if (interview.path.questionAt(interview.currIndex) instanceof InterviewQuestion) {
                question = (InterviewQuestion)interview.path.questionAt(interview.currIndex);
                interview = question.getTargetInterview();
                interview.currIndex = interview.path.size() - 1;
                continue;
            }
            if (!(interview.path.questionAt(interview.currIndex) instanceof FinalQuestion)) break;
            --interview.currIndex;
        }
        question = interview.path.questionAt(interview.currIndex);
        this.notifyCurrentQuestionChanged(question);
    }

    public void last() throws Fault {
        Question question;
        this.ensurePathInitialized();
        Interview interview = this;
        while (interview.path.questionAt(interview.currIndex) instanceof InterviewQuestion) {
            InterviewQuestion interviewQuestion = (InterviewQuestion)interview.path.questionAt(interview.currIndex);
            interview = interviewQuestion.getTargetInterview();
        }
        int n = interview.currIndex;
        Question question2 = question = interview.path.questionAt(n);
        ++n;
        while (n < interview.path.size()) {
            Question question3 = interview.path.questionAt(n);
            if (question3 instanceof InterviewQuestion) {
                interview = ((InterviewQuestion)question3).getTargetInterview();
                n = 0;
                continue;
            }
            if (question3 instanceof FinalQuestion && interview.caller != null) {
                Interview interview2 = interview.caller.getInterview();
                int n2 = interview2.path.indexOf(interview);
                if (n2 == -1) {
                    throw new IllegalStateException();
                }
                interview = interview2;
                n = n2 + 1;
                continue;
            }
            question2 = question3;
            ++n;
        }
        if (question2 == question) {
            if (!(question2 instanceof FinalQuestion)) {
                throw new Fault(i18n, "interview.noMoreQuestions");
            }
        } else {
            this.setCurrentQuestion(question2);
        }
    }

    public boolean isStarted() {
        Question[] questionArray = this.root.getPath();
        for (int i = 0; i < questionArray.length - 1; ++i) {
            Question question = questionArray[i];
            if (question instanceof NullQuestion) continue;
            return true;
        }
        return false;
    }

    public boolean isFinishable() {
        this.ensurePathInitialized();
        Interview interview = this.root;
        return interview.path.lastQuestion() instanceof FinalQuestion;
    }

    protected boolean isInterviewFinishable() {
        return this.path != null && this.path.lastQuestion() instanceof FinalQuestion;
    }

    public void setCurrentQuestion(Question question) throws Fault {
        if (question == null) {
            throw new NullPointerException();
        }
        if (question == this.getCurrentQuestion()) {
            return;
        }
        boolean bl = this.root.setCurrentQuestion0(question);
        if (!bl) {
            throw new NotOnPathFault(question);
        }
        this.notifyCurrentQuestionChanged(question);
    }

    private boolean setCurrentQuestion0(Question question) {
        this.ensurePathInitialized();
        for (int i = 0; i < this.path.size(); ++i) {
            Question question2 = this.path.questionAt(i);
            if (question2.equals(question)) {
                this.currIndex = i;
                return true;
            }
            if (!(question2 instanceof InterviewQuestion) || !((InterviewQuestion)question2).getTargetInterview().setCurrentQuestion0(question)) continue;
            this.currIndex = i;
            return true;
        }
        return false;
    }

    public Question getCurrentQuestion() {
        this.ensurePathInitialized();
        Interview interview = this.root;
        Question question = interview.path.questionAt(interview.currIndex);
        while (question instanceof InterviewQuestion) {
            interview = ((InterviewQuestion)question).getTargetInterview();
            question = interview.path.questionAt(interview.currIndex);
        }
        return question;
    }

    private void setCurrentQuestionFromPath(Question[] questionArray) {
        this.root.setCurrentQuestionFromPath0(questionArray);
    }

    private void setCurrentQuestionFromPath0(Question[] questionArray) {
        for (int i = questionArray.length - 1; i >= 0; --i) {
            if (!this.setCurrentQuestion0(questionArray[i])) continue;
            this.notifyCurrentQuestionChanged(questionArray[i]);
            return;
        }
    }

    public Question[] getPath() {
        Vector vector = new Vector();
        this.iteratePath0(vector, true, true, true);
        Object[] objectArray = new Question[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Question[] getPathToCurrent() {
        Vector vector = new Vector();
        this.iteratePath0(vector, true, false, true);
        Object[] objectArray = new Question[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Iterator iteratePath(boolean bl) {
        Vector vector = new Vector();
        this.iteratePath0(vector, bl, true, true);
        return vector.iterator();
    }

    public Iterator iteratePathToCurrent(boolean bl) {
        Vector vector = new Vector();
        this.iteratePath0(vector, bl, false, true);
        return vector.iterator();
    }

    private void iteratePath0(List list, boolean bl, boolean bl2, boolean bl3) {
        this.ensurePathInitialized();
        int n = bl2 ? this.path.size() : this.currIndex + 1;
        for (int i = 0; i < n; ++i) {
            Question question = this.path.questionAt(i);
            if (question instanceof InterviewQuestion) {
                if (bl) {
                    ((InterviewQuestion)question).getTargetInterview().iteratePath0(list, true, bl2, false);
                    continue;
                }
                list.add(question);
                continue;
            }
            if (!bl3 && question instanceof FinalQuestion) {
                return;
            }
            list.add(question);
        }
    }

    public void verifyPathContains(Question question) throws NotOnPathFault {
        if (!this.pathContains(question)) {
            throw new NotOnPathFault(question);
        }
    }

    public boolean pathContains(Question question) {
        return this.root.pathContains0(question);
    }

    public boolean pathContains(Interview interview) {
        return this.root.pathContains0(interview);
    }

    private boolean pathContains0(Object object) {
        this.ensurePathInitialized();
        for (int i = 0; i < this.path.size(); ++i) {
            Question question = this.path.questionAt(i);
            if (object == question) {
                return true;
            }
            if (!(question instanceof InterviewQuestion)) continue;
            InterviewQuestion interviewQuestion = (InterviewQuestion)question;
            Interview interview = interviewQuestion.getTargetInterview();
            if (object == interview) {
                return true;
            }
            if (!interview.pathContains0(object)) continue;
            return true;
        }
        return false;
    }

    public Set getQuestions() {
        HashSet hashSet = new HashSet();
        this.getQuestions0(hashSet);
        return hashSet;
    }

    private void getQuestions0(Set set) {
        set.addAll(this.allQuestions.values());
        for (int i = 0; i < this.children.size(); ++i) {
            Interview interview = (Interview)this.children.elementAt(i);
            interview.getQuestions0(set);
        }
    }

    public Map getAllQuestions() {
        HashMap hashMap = new HashMap();
        this.getAllQuestions0(hashMap);
        return hashMap;
    }

    private void getAllQuestions0(Map map) {
        map.putAll(this.allQuestions);
        for (int i = 0; i < this.children.size(); ++i) {
            Interview interview = (Interview)this.children.elementAt(i);
            interview.getAllQuestions0(map);
        }
    }

    public boolean isChecklistEmpty() {
        Iterator iterator = this.iteratePath(true);
        while (iterator.hasNext()) {
            Question question = (Question)iterator.next();
            Checklist.Item[] itemArray = question.getChecklistItems();
            if (itemArray == null || itemArray.length <= 0) continue;
            return false;
        }
        return true;
    }

    public Checklist createChecklist() {
        Checklist checklist = new Checklist();
        Iterator iterator = this.iteratePath(true);
        while (iterator.hasNext()) {
            Question question = (Question)iterator.next();
            Checklist.Item[] itemArray = question.getChecklistItems();
            if (itemArray == null) continue;
            for (int i = 0; i < itemArray.length; ++i) {
                checklist.add(itemArray[i]);
            }
        }
        return checklist;
    }

    public Checklist.Item createChecklistItem(String string, String string2) {
        String string3 = this.getI18NString(string);
        String string4 = this.getI18NString(string2);
        return new Checklist.Item(string3, string4);
    }

    public Checklist.Item createChecklistItem(String string, String string2, Object object) {
        String string3 = this.getI18NString(string);
        String string4 = this.getI18NString(string2, object);
        return new Checklist.Item(string3, string4);
    }

    public Checklist.Item createChecklistItem(String string, String string2, Object[] objectArray) {
        String string3 = this.getI18NString(string);
        String string4 = this.getI18NString(string2, objectArray);
        return new Checklist.Item(string3, string4);
    }

    void addMarker(Question question, String string) {
        HashSet<Question> hashSet;
        if (this.root != this) {
            this.root.addMarker(question, string);
            return;
        }
        if (question == null) {
            throw new NullPointerException();
        }
        if (this.allMarkers == null) {
            this.allMarkers = new HashMap();
        }
        if ((hashSet = (HashSet<Question>)this.allMarkers.get(string)) == null) {
            hashSet = new HashSet<Question>();
            this.allMarkers.put(string, hashSet);
        }
        hashSet.add(question);
    }

    void removeMarker(Question question, String string) {
        if (this.root != this) {
            this.root.removeMarker(question, string);
            return;
        }
        if (question == null) {
            throw new NullPointerException();
        }
        if (this.allMarkers == null) {
            return;
        }
        Set set = (Set)this.allMarkers.get(string);
        if (set == null) {
            return;
        }
        set.remove(question);
        if (set.size() == 0) {
            this.allMarkers.remove(string);
        }
    }

    boolean hasMarker(Question question, String string) {
        if (this.root != this) {
            return this.root.hasMarker(question, string);
        }
        if (question == null) {
            throw new NullPointerException();
        }
        if (this.allMarkers == null) {
            return false;
        }
        Set set = (Set)this.allMarkers.get(string);
        if (set == null) {
            return false;
        }
        return set.contains(question);
    }

    public void removeMarkers(String string) {
        if (this.root != this) {
            this.root.removeMarkers(string);
            return;
        }
        if (this.allMarkers != null) {
            this.allMarkers.remove(string);
        }
    }

    public void removeAllMarkers() {
        if (this.root != this) {
            this.root.removeAllMarkers();
            return;
        }
        this.allMarkers = null;
    }

    public void clearMarkedResponses(String string) {
        if (this.root != this) {
            this.root.clearMarkedResponses(string);
            return;
        }
        if (this.allMarkers == null) {
            return;
        }
        Set set = (Set)this.allMarkers.get(string);
        if (set == null) {
            return;
        }
        this.updateEnabled = false;
        Question question = this.getCurrentQuestion();
        Object object = set.iterator();
        while (object.hasNext()) {
            Question question2 = (Question)object.next();
            question2.clear();
        }
        this.updateEnabled = true;
        this.updatePath(this.firstQuestion);
        object = this.getCurrentQuestion();
        if (object != question) {
            this.notifyCurrentQuestionChanged((Question)object);
        }
    }

    private void loadMarkers(Map map) {
        String string = (String)map.get("MARKERS");
        int n = 0;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.allMarkers = null;
        for (int i = 0; i < n; ++i) {
            String string2 = (String)map.get("MARKERS." + i + ".name");
            String string3 = (String)map.get("MARKERS." + i);
            if (string3 == null) continue;
            this.loadMarkers(string2, string3);
        }
    }

    private void loadMarkers(String string, String string2) {
        int n = -1;
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == '\n') {
                if (n == -1) continue;
                String string3 = string2.substring(n, i).trim();
                this.loadMarker(string, string3);
                n = -1;
                continue;
            }
            if (n != -1) continue;
            n = i;
        }
        if (n != -1) {
            String string4 = string2.substring(n).trim();
            this.loadMarker(string, string4);
        }
    }

    private void loadMarker(String string, String string2) {
        Question question;
        if (string2.length() > 0 && (question = this.lookup(string2)) != null) {
            this.addMarker(question, string);
        }
    }

    private void saveMarkers(Map map) {
        if (this.allMarkers == null) {
            return;
        }
        int n = 0;
        Iterator iterator = this.allMarkers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Set set = (Set)entry.getValue();
            if (string != null) {
                map.put("MARKERS." + n + ".name", string);
            }
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                Question question = (Question)iterator2.next();
                if (stringBuffer.length() > 0) {
                    stringBuffer.append('\n');
                }
                stringBuffer.append(question.getTag());
            }
            map.put("MARKERS." + n, stringBuffer.toString());
            ++n;
        }
        if (n > 0) {
            map.put("MARKERS", String.valueOf(n));
        }
    }

    protected Question callInterview(Interview interview, Question question) {
        return new InterviewQuestion(this, interview, question);
    }

    public void clear() {
        Object object;
        this.updateEnabled = false;
        Iterator iterator = this.allQuestions.values().iterator();
        while (iterator.hasNext()) {
            object = (Question)iterator.next();
            ((Question)object).clear();
        }
        for (int i = 0; i < this.children.size(); ++i) {
            object = (Interview)this.children.elementAt(i);
            ((Interview)object).clear();
        }
        if (this.parent == null) {
            this.reset();
        }
    }

    public void load(Map map) throws Fault {
        this.load(map, true);
    }

    public void load(Map map, boolean bl) throws Fault {
        Object object;
        Iterator iterator;
        if (bl && !Interview.isChecksumValid(map, true)) {
            throw new Fault(i18n, "interview.checksumError");
        }
        if (this.parent == null && (iterator = (String)map.get("INTERVIEW")) != null && !((String)((Object)iterator)).equals(this.getClass().getName())) {
            throw new Fault(i18n, "interview.classMismatch");
        }
        this.updateEnabled = false;
        iterator = this.allQuestions.values().iterator();
        while (iterator.hasNext()) {
            object = (Question)iterator.next();
            ((Question)object).clear();
        }
        iterator = this.allQuestions.values().iterator();
        while (iterator.hasNext()) {
            object = (Question)iterator.next();
            ((Question)object).load(map);
        }
        for (int i = 0; i < this.children.size(); ++i) {
            object = (Interview)this.children.elementAt(i);
            ((Interview)object).load(map, false);
        }
        if (this.parent == null) {
            String string = (String)map.get("QUESTION");
            object = string == null ? null : this.lookup(string);
            this.reset((Question)(object == null ? this.firstQuestion : object));
        }
        this.loadMarkers(map);
    }

    public static boolean isChecksumValid(Map map, boolean bl) {
        try {
            String string = (String)map.get("CHECKSUM");
            if (string == null) {
                return bl;
            }
            return Long.parseLong(string, 16) == Interview.computeChecksum(map);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public void save(Map map) {
        Object object;
        if (this.parent == null) {
            map.put("INTERVIEW", this.getClass().getName());
            map.put("QUESTION", this.getCurrentQuestion().getTag());
            map.put("LOCALE", Locale.getDefault().toString());
        }
        Iterator iterator = this.allQuestions.values().iterator();
        while (iterator.hasNext()) {
            object = (Question)iterator.next();
            try {
                ((Question)object).save(map);
            }
            catch (RuntimeException runtimeException) {
                System.err.println("warning: " + runtimeException.toString());
                System.err.println("while saving value for question " + ((Question)object).getTag() + " in interview " + this.getTag());
            }
        }
        for (int i = 0; i < this.children.size(); ++i) {
            object = (Interview)this.children.elementAt(i);
            ((Interview)object).save(map);
        }
        this.saveMarkers(map);
        map.put("CHECKSUM", Long.toString(Interview.computeChecksum(map), 16));
    }

    private static long computeChecksum(Map map) {
        long l = 0L;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if (string.equals("CHECKSUM")) continue;
            l += Interview.computeChecksum(string) * Interview.computeChecksum(string2);
        }
        return l == Long.MIN_VALUE ? 0L : (l < 0L ? -l : l);
    }

    private static long computeChecksum(String string) {
        if (string == null) {
            return 1L;
        }
        long l = 0L;
        for (int i = 0; i < string.length(); ++i) {
            l = l * 37L + (long)string.charAt(i);
        }
        return l;
    }

    public void export(Map map) {
        Question[] questionArray = this.getPath();
        block11: for (int i = 0; i < questionArray.length; ++i) {
            try {
                questionArray[i].export(map);
                continue;
            }
            catch (RuntimeException runtimeException) {
                switch (this.exportIgnoreExceptionPolicy) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 2: {
                        throw runtimeException;
                    }
                }
                continue;
            }
            catch (Error error) {
                switch (this.exportIgnoreExceptionPolicy) {
                    case 0: {
                        continue block11;
                    }
                    case 1: 
                    case 2: {
                        throw error;
                    }
                }
            }
        }
    }

    public int getExportIgnoreExceptionPolicy() {
        return this.exportIgnoreExceptionPolicy;
    }

    public void setExportIgnoreExceptionPolicy(int n) {
        if (n < 0 || n >= 3) {
            throw new IllegalArgumentException();
        }
        this.exportIgnoreExceptionPolicy = n;
    }

    public synchronized void addObserver(Observer observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        Observer[] observerArray = new Observer[this.observers.length + 1];
        System.arraycopy(this.observers, 0, observerArray, 0, this.observers.length);
        observerArray[this.observers.length] = observer;
        this.observers = observerArray;
    }

    public synchronized void removeObserver(Observer observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this.observers.length; ++i) {
            if (this.observers[i] != observer) continue;
            Observer[] observerArray = new Observer[this.observers.length - 1];
            System.arraycopy(this.observers, 0, observerArray, 0, i);
            System.arraycopy(this.observers, i + 1, observerArray, i, this.observers.length - i - 1);
            this.observers = observerArray;
            return;
        }
    }

    private void notifyCurrentQuestionChanged(Question question) {
        for (int i = 0; i < this.observers.length && question == this.getCurrentQuestion(); ++i) {
            this.observers[i].currentQuestionChanged(question);
        }
    }

    private void notifyPathUpdated() {
        for (int i = 0; i < this.observers.length; ++i) {
            this.observers[i].pathUpdated();
        }
    }

    protected void setBaseTag(String string) {
        this.baseTag = string;
        this.updateTags();
    }

    private void updateTags() {
        Object object;
        this.tag = this.parent == null || this.parent.tag == null ? this.baseTag : (this.baseTag == null ? this.parent.getTag() : this.parent.getTag() + "." + this.baseTag);
        HashMap<String, Question> hashMap = new HashMap<String, Question>();
        Iterator<Object> iterator = this.allQuestions.values().iterator();
        while (iterator.hasNext()) {
            object = (Question)iterator.next();
            ((Question)object).updateTag();
            hashMap.put(((Question)object).getTag(), (Question)object);
        }
        this.allQuestions = hashMap;
        iterator = this.children.iterator();
        while (iterator.hasNext()) {
            object = (Interview)iterator.next();
            super.updateTags();
        }
    }

    void add(Interview interview) {
        this.children.add(interview);
    }

    void add(Question question) {
        String string = question.getTag();
        Question question2 = this.allQuestions.put(string, question);
        if (question2 != null) {
            throw new IllegalArgumentException("duplicate questions for tag: " + string);
        }
    }

    protected void setInterviewSemantics(int n) {
        if (n <= 1) {
            this.semantics = n;
        }
    }

    public int getInterviewSemantics() {
        return this.semantics;
    }

    private void ensurePathInitialized() {
        if (this.path == null) {
            this.path = new Path();
            this.reset();
        }
    }

    private Question lookup(String string) {
        Question question = (Question)this.allQuestions.get(string);
        for (int i = 0; i < this.children.size() && question == null; ++i) {
            Interview interview = (Interview)this.children.elementAt(i);
            question = interview.lookup(string);
        }
        return question;
    }

    private Interview getRoot() {
        return this.root;
    }

    public void updatePath() {
        this.root.updatePath0(this.root.firstQuestion);
    }

    public void updatePath(Question question) {
        this.root.updatePath0(question);
    }

    private void updatePath0(Question question) {
        Interview.ASSERT(this.root == this);
        if (!this.updateEnabled) {
            return;
        }
        if (this.path == null) {
            return;
        }
        if (!this.pathContains(question)) {
            return;
        }
        Question[] questionArray = this.getPathToCurrent();
        this.trimPath(question);
        this.predictPath(question);
        if (!this.pathContains(questionArray[questionArray.length - 1])) {
            this.setCurrentQuestionFromPath(questionArray);
        }
        this.notifyPathUpdated();
    }

    private void trimPath(Question question) {
        Object object = question;
        Interview interview = question.getInterview();
        while (interview != null) {
            Path path = interview.path;
            int n = -1;
            for (int i = 0; i < path.size(); ++i) {
                Question question2 = path.questionAt(i);
                if (question2 != object && (!(question2 instanceof InterviewQuestion) || ((InterviewQuestion)question2).getTargetInterview() != object)) continue;
                n = i;
                break;
            }
            if (n == -1) {
                return;
            }
            path.setSize(n + 1);
            object = interview;
            interview = interview.caller == null ? null : interview.caller.getInterview();
        }
    }

    private void predictPath(Question question) {
        Interview interview = question.getInterview();
        question = this.predictNext(question);
        while (question != null && !this.pathContains(question)) {
            if (question instanceof FinalQuestion) {
                interview.path.addQuestion(question);
                if (interview.caller == null) break;
                question = interview.caller.getNext();
                interview = interview.caller.getInterview();
                continue;
            }
            if (question instanceof InterviewQuestion) {
                InterviewQuestion interviewQuestion = (InterviewQuestion)question;
                Interview interview2 = interviewQuestion.getTargetInterview();
                if (this.pathContains(interview2)) break;
                if (interview2 instanceof ListQuestion.Body) {
                    interview2.caller = interviewQuestion;
                    interview.path.addQuestion(interviewQuestion);
                    question = interview2.path.lastQuestion() instanceof FinalQuestion ? interviewQuestion.getNext() : null;
                    continue;
                }
                interview2.caller = interviewQuestion;
                if (interview2.path == null) {
                    interview2.path = new Path();
                } else {
                    interview2.path.clear();
                }
                interview.path.addQuestion(interviewQuestion);
                interview = interview2;
                question = interview2.firstQuestion;
                continue;
            }
            if (question.isEnabled()) {
                interview.path.addQuestion(question);
            }
            question = this.predictNext(question);
        }
    }

    private Question predictNext(Question question) {
        if (!question.isValueValid()) {
            return null;
        }
        if (question instanceof ListQuestion && question.isEnabled()) {
            Object object;
            ListQuestion listQuestion = (ListQuestion)question;
            if (listQuestion.isEnd()) {
                return question.getNext();
            }
            for (int i = 0; i < listQuestion.getBodyCount(); ++i) {
                object = listQuestion.getBody(i);
                if (((Interview)object).path == null) {
                    ((Interview)object).path = new Path();
                } else {
                    ((Interview)object).path.clear();
                }
                ((Interview)object).path.addQuestion(((Interview)object).firstQuestion);
                ((Interview)object).caller = null;
                super.predictPath(((Interview)object).firstQuestion);
            }
            ListQuestion.Body body = listQuestion.getSelectedBody();
            object = listQuestion.getOther();
            if (body == null) {
                return ((Question)object).getNext();
            }
            Interview interview = listQuestion.getInterview();
            return new InterviewQuestion(interview, body, (Question)object);
        }
        return question.getNext();
    }

    private String getI18NString(String string) {
        return this.getI18NString(string, empty);
    }

    private String getI18NString(String string, Object object) {
        return this.getI18NString(string, new Object[]{object});
    }

    private String getI18NString(String string, Object[] objectArray) {
        Object object;
        try {
            object = this.getResourceBundle();
            if (object != null) {
                return MessageFormat.format(((ResourceBundle)object).getString(string), objectArray);
            }
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("WARNING: missing resource: " + string);
        }
        object = new StringBuffer(string);
        for (int i = 0; i < objectArray.length; ++i) {
            ((StringBuffer)object).append('\n');
            ((StringBuffer)object).append(objectArray.toString());
        }
        return ((StringBuffer)object).toString();
    }

    protected String getResourceString(String string) {
        return this.getResourceString(string, true);
    }

    protected String getResourceString(String string, boolean bl) {
        try {
            String string2 = null;
            if (bl) {
                ResourceBundle resourceBundle;
                if (this.parent != null) {
                    string2 = this.parent.getResourceString(string, bl);
                }
                if (string2 == null && (resourceBundle = this.getResourceBundle()) != null) {
                    string2 = resourceBundle.getString(string);
                }
            } else {
                ResourceBundle resourceBundle = this.getResourceBundle();
                if (resourceBundle != null) {
                    string2 = resourceBundle.getString(string);
                }
                if (string2 == null && this.parent != null) {
                    string2 = this.parent.getResourceString(string, bl);
                }
            }
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private static final void ASSERT(boolean bl) {
        if (!bl) {
            throw new IllegalStateException();
        }
    }

    static class Path {
        private Question[] questions;
        private int numQuestions;

        Path() {
        }

        void addQuestion(Question question) {
            if (this.questions == null) {
                this.questions = new Question[10];
            } else if (this.numQuestions == this.questions.length) {
                Question[] questionArray = new Question[2 * this.questions.length];
                System.arraycopy(this.questions, 0, questionArray, 0, this.questions.length);
                this.questions = questionArray;
            }
            this.questions[this.numQuestions++] = question;
        }

        Question questionAt(int n) throws ArrayIndexOutOfBoundsException {
            if (n < 0 || n >= this.numQuestions) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return this.questions[n];
        }

        Question lastQuestion() {
            return this.questionAt(this.numQuestions - 1);
        }

        int indexOf(Interview interview) {
            for (int i = 0; i < this.numQuestions; ++i) {
                Question question = this.questions[i];
                if (!(question instanceof InterviewQuestion) || ((InterviewQuestion)question).getTargetInterview() != interview) continue;
                return i;
            }
            return -1;
        }

        int size() {
            return this.numQuestions;
        }

        void setSize(int n) {
            if (this.questions != null) {
                if (n > this.questions.length) {
                    Question[] questionArray = new Question[n];
                    System.arraycopy(this.questions, 0, questionArray, 0, this.questions.length);
                    this.questions = questionArray;
                }
                for (int i = n; i < this.numQuestions; ++i) {
                    this.questions[i] = null;
                }
            } else if (n > 0) {
                this.questions = new Question[n];
            }
            this.numQuestions = n;
        }

        void clear() {
            for (int i = 0; i < this.numQuestions; ++i) {
                this.questions[i] = null;
            }
            this.numQuestions = 0;
        }
    }

    public static interface Observer {
        public void currentQuestionChanged(Question var1);

        public void pathUpdated();
    }

    public static class NotOnPathFault
    extends Fault {
        NotOnPathFault(Question question) {
            super(i18n, "interview.questionNotOnPath", question.getTag());
        }
    }

    public static class HelpNotFoundFault
    extends Fault {
        public final String name;

        HelpNotFoundFault(ResourceBundle resourceBundle, String string, String string2) {
            super(resourceBundle, string, string2);
            this.name = string2;
        }
    }

    public static class BadHelpFault
    extends Fault {
        public final HelpSetException exc;

        BadHelpFault(ResourceBundle resourceBundle, String string, HelpSetException helpSetException) {
            super(resourceBundle, string, helpSetException.getMessage());
            this.exc = helpSetException;
        }
    }

    public static class Fault
    extends Exception {
        public Fault(ResourceBundle resourceBundle, String string) {
            super(resourceBundle.getString(string));
        }

        public Fault(ResourceBundle resourceBundle, String string, Object object) {
            super(MessageFormat.format(resourceBundle.getString(string), object));
        }

        public Fault(ResourceBundle resourceBundle, String string, Object[] objectArray) {
            super(MessageFormat.format(resourceBundle.getString(string), objectArray));
        }
    }
}

