/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;

public abstract class ListQuestion
extends Question {
    private final EndQuestion end;
    private final Vector bodies;
    private int value;
    private static final ResourceBundle i18n = Interview.i18n;

    protected ListQuestion(Interview interview, String string) {
        super(interview, string);
        if (this instanceof EndQuestion) {
            this.end = (EndQuestion)this;
            this.bodies = null;
        } else {
            this.end = new EndQuestion(interview, string, this);
            this.bodies = new Vector();
        }
    }

    public abstract Body createBody(int var1);

    public final boolean isEnd() {
        return this instanceof EndQuestion;
    }

    public ListQuestion getOther() {
        return this.end;
    }

    public Body getSelectedBody() {
        if (this.value >= 0 && this.value < this.bodies.size()) {
            return (Body)this.bodies.elementAt(this.value);
        }
        return null;
    }

    public int getValue() {
        return this.value;
    }

    public int getValueOnPath() throws Interview.NotOnPathFault {
        this.interview.verifyPathContains(this);
        return this.getValue();
    }

    public String getStringValue() {
        return String.valueOf(this.value);
    }

    public void setValue(int n) {
        int n2 = this.value;
        this.value = n;
        if (this.normalizeValue(this.value) != this.normalizeValue(n2)) {
            this.interview.updatePath(this);
            this.interview.setEdited(true);
        }
    }

    private int normalizeValue(int n) {
        return n >= 0 && n < this.bodies.size() ? n : -1;
    }

    public void setValue(String string) {
        try {
            if (string != null) {
                this.setValue(Integer.parseInt(string));
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.setValue(-1);
    }

    public boolean isValueValid() {
        return true;
    }

    public boolean isValueAlwaysValid() {
        return false;
    }

    public void clear() {
        this.setValue(Integer.MIN_VALUE);
        this.bodies.setSize(0);
    }

    public String getEndSummary() {
        return this.end.getDefaultSummary();
    }

    public String getEndText() {
        return this.end.getDefaultText();
    }

    public Object[] getEndTextArgs() {
        return this.end.getDefaultTextArgs();
    }

    protected void load(Map map) {
        String string;
        this.bodies.setSize(0);
        String string2 = (String)map.get(this.tag + ".count");
        if (string2 != null && string2.length() > 0) {
            try {
                int n = Integer.parseInt(string2);
                for (int i = 0; i < n; ++i) {
                    this.bodies.add(this.createBody(i));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = (String)map.get(this.tag + ".curr")) == null || string.length() == 0) {
            this.value = 0;
        } else {
            try {
                this.value = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.value = 0;
            }
        }
    }

    protected void save(Map map) {
        map.put(this.tag + ".count", String.valueOf(this.bodies.size()));
        map.put(this.tag + ".curr", String.valueOf(this.value));
    }

    public Body[] getBodies() {
        Object[] objectArray = new Body[this.bodies.size()];
        this.bodies.copyInto(objectArray);
        return objectArray;
    }

    public int getBodyCount() {
        return this.bodies == null ? 0 : this.bodies.size();
    }

    public Body getBody(int n) {
        return (Body)this.bodies.elementAt(n);
    }

    public void setBodies(Body[] bodyArray, int n) {
        Body body = this.getSelectedBody();
        int n2 = this.getIncompleteBodyCount();
        boolean bl = false;
        if (bodyArray.length != this.bodies.size()) {
            this.bodies.setSize(bodyArray.length);
            bl = true;
        }
        for (int i = 0; i < bodyArray.length; ++i) {
            Body body2 = bodyArray[i];
            if (body2 == this.bodies.elementAt(i)) continue;
            body2.setIndex(i);
            this.bodies.setElementAt(body2, i);
            bl = true;
        }
        this.value = n;
        Body body3 = this.getSelectedBody();
        int n3 = this.getIncompleteBodyCount();
        if (body3 != body || n2 == 0 != (n3 == 0)) {
            this.interview.updatePath(this);
        }
        this.interview.setEdited(bl);
    }

    public int getIncompleteBodyCount() {
        int n = 0;
        for (int i = 0; i < this.bodies.size(); ++i) {
            Body body = (Body)this.bodies.elementAt(i);
            if (body.isInterviewFinishable()) continue;
            ++n;
        }
        return n;
    }

    private static class EndQuestion
    extends ListQuestion {
        private ListQuestion head;

        EndQuestion(Interview interview, String string, ListQuestion listQuestion) {
            super(interview, string + ".end");
            this.head = listQuestion;
        }

        public Question getNext() {
            boolean bl = true;
            for (int i = 0; i < this.head.getBodyCount(); ++i) {
                Body body = this.head.getBody(i);
                if (body.isInterviewFinishable()) continue;
                bl = false;
                break;
            }
            return bl ? this.head.getNext() : null;
        }

        public String getSummary() {
            return this.head.getEndSummary();
        }

        String getDefaultSummary() {
            return super.getSummary();
        }

        public String getText() {
            return this.head.getEndText();
        }

        String getDefaultText() {
            return super.getText();
        }

        public Object[] getTextArgs() {
            return this.head.getEndTextArgs();
        }

        Object[] getDefaultTextArgs() {
            return super.getTextArgs();
        }

        public int getValue() {
            return this.head.getValue();
        }

        public String getStringValue() {
            return this.head.getStringValue();
        }

        public void setValue(int n) {
            this.head.setValue(n);
        }

        public void setValue(String string) {
            this.head.setValue(string);
        }

        public Body getSelectedBody() {
            return this.head.getSelectedBody();
        }

        public Body createBody(int n) {
            return this.head.createBody(n);
        }

        public ListQuestion getOther() {
            return this.head;
        }

        public void clear() {
            this.head.clear();
        }

        protected void load(Map map) {
        }

        protected void save(Map map) {
        }

        public Body[] getBodies() {
            return this.head.getBodies();
        }

        public int getBodyCount() {
            return this.head.getBodyCount();
        }

        public Body getBody(int n) {
            return this.head.getBody(n);
        }

        public void setBodies(Body[] bodyArray, int n) {
            this.head.setBodies(bodyArray, n);
        }

        public int getIncompleteBodyCount() {
            return this.head.getIncompleteBodyCount();
        }
    }

    public static abstract class Body
    extends Interview {
        private ListQuestion question;
        private int index;
        private String defaultSummary;

        protected Body(ListQuestion listQuestion, int n) {
            super(listQuestion.getInterview(), listQuestion.getBaseTag() + "." + n);
            this.question = listQuestion;
            this.index = n;
        }

        public abstract String getSummary();

        public int getIndex() {
            return this.index;
        }

        void setIndex(int n) {
            if (n != this.index) {
                this.index = n;
                this.setBaseTag(this.question.getBaseTag() + "." + this.index);
            }
        }

        public String getDefaultSummary() {
            if (this.defaultSummary == null) {
                Object object;
                int n;
                Vector vector = this.question.bodies;
                for (n = 0; n < vector.size(); ++n) {
                    object = (Body)vector.elementAt(n);
                    if (((Body)object).defaultSummary == null || ((Body)object).getSummary() == null || ((Body)object).defaultSummary.equals(((Body)object).getSummary())) continue;
                    ((Body)object).defaultSummary = null;
                }
                for (n = 0; n < vector.size(); ++n) {
                    object = MessageFormat.format(i18n.getString("lp.newValue"), new Integer(n));
                    for (int i = 0; i < vector.size(); ++i) {
                        Body body = (Body)vector.elementAt(i);
                        if (!((String)object).equals(body.defaultSummary)) continue;
                        object = null;
                        break;
                    }
                    if (object == null) continue;
                    this.defaultSummary = object;
                    break;
                }
            }
            return this.defaultSummary;
        }

        public boolean isBodyFinishable() {
            return this.isInterviewFinishable();
        }
    }
}

