/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;

public abstract class TreeQuestion
extends Question {
    private static String[] empty = new String[0];
    private Model model;
    protected String[] value;
    private String[] defaultValue;

    protected TreeQuestion(Interview interview, String string, Model model) {
        super(interview, string);
        this.model = model;
        this.clear();
        this.setDefaultValue(this.value);
    }

    public Model getModel() {
        return this.model;
    }

    public String[] getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String[] stringArray) {
        this.defaultValue = stringArray;
    }

    public String[] getValue() {
        return this.value;
    }

    public String[] getValueOnPath() throws Interview.NotOnPathFault {
        this.interview.verifyPathContains(this);
        return this.getValue();
    }

    public void setValue(String string) {
        this.setValue(TreeQuestion.split(string));
    }

    public void setValue(String[] stringArray) {
        Object[] objectArray;
        if (stringArray == null) {
            objectArray = this.value;
            this.value = null;
        } else {
            objectArray = this.value;
            this.value = stringArray;
        }
        if (!Arrays.equals(this.value, objectArray)) {
            this.interview.updatePath(this);
            this.interview.setEdited(true);
        }
    }

    public void setValue(Object[] objectArray) {
        if (objectArray == null) {
            this.setValue((String[])null);
        }
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = this.model.getPath(objectArray[i]);
        }
    }

    public String getStringValue() {
        return TreeQuestion.join(this.value);
    }

    public boolean isValueValid() {
        return true;
    }

    public boolean isValueAlwaysValid() {
        return false;
    }

    public void clear() {
        this.setValue(this.defaultValue);
    }

    protected void load(Map map) {
        String string = (String)map.get(this.tag);
        this.setValue(string);
    }

    protected void save(Map map) {
        map.put(this.tag, TreeQuestion.join(this.value));
    }

    private static String[] split(String string) {
        if (string == null) {
            return empty;
        }
        Vector<String> vector = new Vector<String>();
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (TreeQuestion.white(string.charAt(i))) {
                if (n != -1) {
                    vector.addElement(string.substring(n, i));
                }
                n = -1;
                continue;
            }
            if (n != -1) continue;
            n = i;
        }
        if (n != -1) {
            vector.addElement(string.substring(n));
        }
        if (vector.size() == 0) {
            return empty;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static String join(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        int n = stringArray.length - 1;
        for (int i = 0; i < stringArray.length; ++i) {
            n += stringArray[i].length();
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append(' ');
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    private static boolean white(char c) {
        return c == ' ' || c == '\t' || c == '\n';
    }

    public static interface Model {
        public Object getRoot();

        public int getChildCount(Object var1);

        public Object getChild(Object var1, int var2);

        public String getName(Object var1);

        public String getPath(Object var1);

        public boolean isLeaf(Object var1);
    }
}

