/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class WizEdit {
    private Interview interview;
    private boolean considerCase = false;
    private boolean word = false;
    private boolean verbose;
    private PrintStream out = System.err;
    private static final ResourceBundle i18n = Interview.i18n;

    public static void main(String[] stringArray) {
        try {
            Interview interview;
            Serializable serializable;
            Object object;
            Object object2;
            Object[] objectArray;
            Vector<String> vector = new Vector<String>();
            File file = null;
            File file2 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-o") && i + 1 < stringArray.length) {
                    file2 = new File(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equals("-e")) {
                    vector.addElement(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].startsWith("-")) {
                    throw new BadArgs(i18n, "edit.badOption", stringArray[i]);
                }
                if (i == stringArray.length - 1 && stringArray[i].endsWith(".jti")) {
                    file = new File(stringArray[i]);
                    continue;
                }
                throw new BadArgs(i18n, "edit.badOption", stringArray[i]);
            }
            if (file == null) {
                throw new BadArgs(i18n, "edit.noInterview");
            }
            try {
                objectArray = new BufferedInputStream(new FileInputStream(file));
                object2 = new Properties();
                ((Properties)object2).load((InputStream)objectArray);
                object = (String)((Properties)object2).get("INTERVIEW");
                if (object == null) {
                    throw new Fault(i18n, "edit.noInterview");
                }
                serializable = Class.forName((String)object);
                interview = (Interview)((Class)serializable).newInstance();
                interview.load((Map)object2, false);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Fault(i18n, "edit.cantFindFile", file);
            }
            catch (IOException iOException) {
                throw new Fault(i18n, "edit.cantReadFile", iOException);
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            object2 = new WizEdit(interview);
            ((WizEdit)object2).edit((String[])objectArray);
            try {
                object = new BufferedOutputStream(new FileOutputStream(file2));
                serializable = new Properties();
                interview.save((Map)((Object)serializable));
                ((Properties)serializable).store((OutputStream)object, "Interview: " + interview.getTitle());
            }
            catch (IOException iOException) {
                throw new Fault(i18n, "edit.cantWriteFile", iOException);
            }
        }
        catch (BadArgs badArgs) {
            System.err.println("Error: " + badArgs.getMessage());
            System.exit(1);
        }
        catch (Interview.Fault fault) {
            System.err.println("Problem reading file: " + fault);
            System.exit(2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Problem reading file: the interview could not be loaded because some classes that are required by the interview were not found on your classpath. The specific exception that occurred was: " + classNotFoundException);
            System.exit(2);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Problem reading file: the interview could not be loaded because some classes that are required by the interview caused access violations. The specific exception that occurred was: " + illegalAccessException);
            System.exit(2);
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Problem reading file: the interview could not be loaded because some classes that are required by the interview could not be instantiated. The specific exception that occurred was: " + instantiationException);
            System.exit(2);
        }
        catch (Fault fault) {
            System.err.println(fault.getMessage());
            System.exit(2);
        }
    }

    public WizEdit(Interview interview) {
        this.interview = interview;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setVerbose(boolean bl, PrintStream printStream) {
        this.verbose = bl;
        this.out = printStream;
    }

    public void edit(String[] stringArray) throws Fault {
        for (int i = 0; i < stringArray.length; ++i) {
            this.edit(stringArray[i]);
        }
    }

    public void edit(String string) throws Fault {
        int n;
        if (string == null || string.length() == 0) {
            throw new Fault(i18n, "edit.nullCmd");
        }
        char c = string.charAt(0);
        int n2 = string.indexOf(c, (n = 0) + 1);
        if (n2 == -1) {
            throw new Fault(i18n, "edit.badCmd", string);
        }
        int n3 = string.indexOf(c, n2 + 1);
        String string2 = string.substring(n + 1, n2);
        String string3 = string.substring(n2 + 1, n3);
        if (string2.length() == 0) {
            throw new Fault(i18n, "edit.badCmd", string);
        }
        Hashtable hashtable = new Hashtable();
        this.interview.save(hashtable);
        Question[] questionArray = this.interview.getPath();
        for (int i = 0; i < questionArray.length; ++i) {
            Question question = questionArray[i];
            try {
                String string4 = (String)hashtable.get(question.getTag());
                if (string4 == null || !string4.equalsIgnoreCase(string2)) continue;
                String string5 = string3;
                question.setValue(string5);
                if (!this.verbose) continue;
                Hashtable hashtable2 = new Hashtable();
                question.save(hashtable2);
                this.out.println("Question:     " + question.getSummary());
                this.out.println("changed from: " + string4);
                this.out.println("          to: " + hashtable2.get(question.getTag()));
                continue;
            }
            catch (Interview.Fault fault) {
                throw new Fault(i18n, "edit.cantSetValue", new Object[]{question.getSummary(), fault.getMessage()});
            }
        }
    }

    private static int match(String string, String string2, boolean bl, boolean bl2) {
        int n = string.length();
        int n2 = string2.length();
        for (int i = 0; i <= n2 - n; ++i) {
            if (!string.regionMatches(!bl, 0, string2, i, n) || bl2 && (!bl2 || i != 0 && !WizEdit.isBoundaryCh(string2.charAt(i - 1)) || i + n != string2.length() && !WizEdit.isBoundaryCh(string2.charAt(i + n)))) continue;
            return i;
        }
        return -1;
    }

    private static boolean isBoundaryCh(char c) {
        return !Character.isUnicodeIdentifierStart(c) && !Character.isUnicodeIdentifierPart(c);
    }

    public static class Fault
    extends Exception {
        Fault(ResourceBundle resourceBundle, String string) {
            super(resourceBundle.getString(string));
        }

        Fault(ResourceBundle resourceBundle, String string, Object object) {
            super(MessageFormat.format(resourceBundle.getString(string), object));
        }

        Fault(ResourceBundle resourceBundle, String string, Object[] objectArray) {
            super(MessageFormat.format(resourceBundle.getString(string), objectArray));
        }
    }

    public static class BadArgs
    extends Exception {
        BadArgs(ResourceBundle resourceBundle, String string) {
            super(resourceBundle.getString(string));
        }

        BadArgs(ResourceBundle resourceBundle, String string, Object object) {
            super(MessageFormat.format(resourceBundle.getString(string), object));
        }

        BadArgs(ResourceBundle resourceBundle, String string, Object[] objectArray) {
            super(MessageFormat.format(resourceBundle.getString(string), objectArray));
        }
    }
}

