/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.wizard.EditableList;
import com.sun.interview.wizard.I18NResourceBundle;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class FileList
extends EditableList {
    private JFileChooser chooser = new JFileChooser();
    private File baseDir;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();
    static /* synthetic */ Class class$java$io$File;

    public FileList(String string, File[] fileArray) {
        super(string, fileArray);
        this.chooser.setName(string + "chsr");
    }

    public void setBaseDirectory(File file) {
        this.baseDir = file;
        if (file == null) {
            file = new File(System.getProperty("user.dir"));
        }
        this.chooser.setCurrentDirectory(file);
    }

    public void addFilter(FileFilter fileFilter) {
        this.chooser.addChoosableFileFilter(fileFilter);
    }

    public void setFileSelectionMode(int n) {
        this.chooser.setFileSelectionMode(n);
    }

    public File[] getFiles() {
        return (File[])this.getItems(class$java$io$File == null ? (class$java$io$File = FileList.class$("java.io.File")) : class$java$io$File);
    }

    protected Object getNewItem() {
        this.chooser.setDialogTitle(i18n.getString("flst.addFile.title"));
        int n = this.chooser.showDialog(this, i18n.getString("flst.addFile.ok"));
        if (n == 0) {
            return this.getBaseRelativeFile(this.chooser.getSelectedFile());
        }
        return null;
    }

    protected Object getNewItem(Object object) {
        File file = (File)object;
        if (!file.isAbsolute() && this.baseDir != null) {
            file = new File(this.baseDir, file.getPath());
        }
        this.chooser.setSelectedFile(file);
        this.chooser.setDialogTitle(i18n.getString("flst.changeFile.title"));
        int n = this.chooser.showDialog(this, i18n.getString("flst.changeFile.ok"));
        if (n == 0) {
            return this.getBaseRelativeFile(this.chooser.getSelectedFile());
        }
        return null;
    }

    private File getBaseRelativeFile(File file) {
        if (this.baseDir == null) {
            return file;
        }
        String string = this.baseDir.getPath();
        if (file.getPath().startsWith(string + File.separatorChar)) {
            return new File(file.getPath().substring(string.length() + 1));
        }
        return file;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

