/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.FloatQuestion;
import com.sun.interview.Question;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.QuestionRenderer;
import com.sun.interview.wizard.TypeInPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;

class FloatQuestionRenderer
implements QuestionRenderer {
    private float lwb;
    private float upb;
    private float resolution;
    private float value;
    private float range;
    private float[] suggs;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();

    FloatQuestionRenderer() {
    }

    public JComponent getQuestionRendererComponent(Question question, ActionListener actionListener) {
        FloatQuestion floatQuestion = (FloatQuestion)question;
        this.lwb = floatQuestion.getLowerBound();
        this.upb = floatQuestion.getUpperBound();
        this.resolution = floatQuestion.getResolution();
        this.value = floatQuestion.getValue();
        this.range = this.upb - this.lwb;
        this.suggs = floatQuestion.getSuggestions();
        return this.createTextField(floatQuestion, actionListener);
    }

    public String getInvalidValueMessage(Question question) {
        return null;
    }

    private JPanel createTextField(FloatQuestion floatQuestion, ActionListener actionListener) {
        JButton jButton;
        String[] stringArray;
        int n = 1;
        while (this.range >= 10.0f) {
            this.range /= 10.0f;
            ++n;
        }
        if (this.lwb < 0.0f) {
            ++n;
        }
        n += 5;
        n = Math.min(n, 20);
        if (this.suggs == null) {
            stringArray = null;
        } else {
            stringArray = new String[this.suggs.length];
            for (int i = 0; i < this.suggs.length; ++i) {
                stringArray[i] = String.valueOf(this.suggs[i]);
            }
        }
        final float f = floatQuestion.getDefaultValue();
        if (Float.isNaN(f)) {
            jButton = null;
        } else {
            jButton = new JButton(i18n.getString("flt.reset.btn"));
            jButton.setName("flt.reset.btn");
            jButton.setMnemonic(i18n.getString("flt.reset.mne").charAt(0));
            jButton.setToolTipText(i18n.getString("flt.reset.tip"));
        }
        final TypeInPanel typeInPanel = new TypeInPanel("flt.field", floatQuestion, n, stringArray, jButton, actionListener);
        if (jButton != null) {
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    NumberFormat numberFormat = NumberFormat.getNumberInstance();
                    typeInPanel.setValue(numberFormat.format(new Double(f)));
                }
            });
        }
        return typeInPanel;
    }

    private JPanel createSlider(final FloatQuestion floatQuestion, ActionListener actionListener) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setName("flt");
        jPanel.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(i18n.getString("flt.sldr.lbl"));
        jLabel.setName("flt.sldr.lbl");
        jLabel.setDisplayedMnemonic(i18n.getString("flt.sldr.mne").charAt(0));
        jLabel.setToolTipText(i18n.getString("flt.sldr.tip"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        int n = (int)((this.upb - this.lwb) / this.resolution);
        int n2 = (int)((this.value - this.lwb) / this.resolution);
        final JSlider jSlider = new JSlider(0, n, n2);
        jSlider.setName("flt");
        jSlider.getAccessibleContext().setAccessibleName(jSlider.getName());
        jSlider.getAccessibleContext().setAccessibleDescription(jSlider.getToolTipText());
        jSlider.setMajorTickSpacing(n / 2);
        jSlider.setMinorTickSpacing(Math.max((int)(1.0f / this.resolution), 1));
        jSlider.setSnapToTicks(true);
        jSlider.setPaintTicks(true);
        float f = floatQuestion.getLabelStartHint();
        float f2 = floatQuestion.getLabelIncrementHint();
        int n3 = (int)((f - this.lwb) / this.resolution);
        int n4 = (int)(f2 / this.resolution);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        for (int i = n3; i < n; i += n4) {
            float f3 = this.lwb + (float)i * this.resolution;
            String string = f3 == (float)((int)f3) ? String.valueOf((int)f3) : String.valueOf(f3);
            hashtable.put(new Integer(i), new JLabel(string));
        }
        jSlider.setLabelTable(hashtable);
        jSlider.setPaintLabels(true);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jSlider, gridBagConstraints);
        Runnable runnable = new Runnable(){

            public void run() {
                int n = jSlider.getValue();
                floatQuestion.setValue(FloatQuestionRenderer.this.lwb + (float)n * FloatQuestionRenderer.this.resolution);
            }
        };
        jPanel.putClientProperty("valueSaver", runnable);
        return jPanel;
    }
}

