/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.Question;
import com.sun.interview.StringQuestion;
import com.sun.interview.wizard.ActionDocListener;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.QuestionRenderer;
import com.sun.interview.wizard.TypeInPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class StringQuestionRenderer
implements QuestionRenderer {
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();

    StringQuestionRenderer() {
    }

    public JComponent getQuestionRendererComponent(Question question, ActionListener actionListener) {
        StringQuestion stringQuestion = (StringQuestion)question;
        String[] stringArray = stringQuestion.getSuggestions();
        int n = stringQuestion.getNominalMaxLength();
        if (n > 80) {
            return this.createTextArea(stringQuestion, actionListener);
        }
        return this.createTypeInPanel(stringQuestion, actionListener);
    }

    public String getInvalidValueMessage(Question question) {
        return null;
    }

    private JPanel createTextArea(final StringQuestion stringQuestion, ActionListener actionListener) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setName("str");
        jPanel.setFocusable(false);
        JLabel jLabel = new JLabel(i18n.getString("str.area.lbl"));
        jLabel.setName("str.area.lbl");
        jLabel.setDisplayedMnemonic(i18n.getString("str.area.mne").charAt(0));
        jLabel.setToolTipText(i18n.getString("str.area.tip"));
        jPanel.add((Component)jLabel, "North");
        final JTextArea jTextArea = new JTextArea(stringQuestion.getValue());
        jTextArea.setName("str");
        jTextArea.setLineWrap(true);
        jTextArea.getDocument().addDocumentListener(new ActionDocListener(jTextArea, actionListener, "edited"));
        jTextArea.setToolTipText(jLabel.getToolTipText());
        jLabel.setLabelFor(jTextArea);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setName("str.sp");
        jScrollPane.setFocusable(false);
        jPanel.add((Component)jScrollPane, "Center");
        Runnable runnable = new Runnable(){

            public void run() {
                stringQuestion.setValue(jTextArea.getText());
            }
        };
        jPanel.putClientProperty("valueSaver", runnable);
        return jPanel;
    }

    private JPanel createTypeInPanel(StringQuestion stringQuestion, ActionListener actionListener) {
        return new TypeInPanel("str", stringQuestion, stringQuestion.getNominalMaxLength(), stringQuestion.getSuggestions(), null, actionListener);
    }
}

